/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.services.lsd;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.services.lsd.AdapterInfo;
import com.ibm.ws.orb.services.lsd.ORB_Server;
import com.ibm.ws.orb.services.lsd.ORB_ServerHelper;
import com.ibm.ws.orb.services.lsd._LocationServiceImplBase;
import com.ibm.ws.orbimpl.services.lsd.IORPrototype;
import com.ibm.ws.orbimpl.services.lsd.UserKeyImpl;
import com.ibm.ws.util.WSThreadLocal;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;

public class LocationServiceImpl
extends _LocationServiceImplBase {
    private static final long serialVersionUID = -4662278121185409699L;
    private ORB orb;
    private IORPrototype lsdPrototype = null;
    private Hashtable servers = new Hashtable();
    private Hashtable adapters = new Hashtable();
    private String serverPath = null;
    private String serverFileName = "IBMLSDActiveServerList.asl";
    private boolean serversReactivated = false;
    private static Class ctxMgrClz = null;
    private static java.lang.Object ctxMgr = null;
    private static Boolean ctxMgrIsCellSecurityEnabled = null;
    private static int securityMinorCodeInvalidSecurityCredentials = 0;
    public static WSThreadLocal threadLocalAvoidLogs = new WSThreadLocal();

    public LocationServiceImpl(ORB oRB) {
        this.orb = oRB;
    }

    protected void init() {
        block5: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "init()");
            }
            try {
                this.serverPath = this.orb.getProperty("com.ibm.ws.orb.services.lsd.StoreActiveServerList");
                String string = this.orb.getProperty("com.ibm.ws.orb.services.lsd.LSDListenerPort");
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "init()", "LSDListenerPort is " + string);
                }
                this.lsdPrototype = new IORPrototype(this.orb, Integer.parseInt(string));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.init", "141", this);
                if (!ORBRas.isTrcLogging) break block5;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "init()", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "init()");
        }
    }

    public byte[] register_server(byte[] byArray, ORB_Server oRB_Server) {
        IOR iOR = null;
        if (this.isCellSecurityEnabled()) {
            try {
                if (((Boolean)this.invokeCtxMgrMethod("callerSubjectIsServerIdentity")).equals(Boolean.FALSE)) {
                    throw new NO_PERMISSION("Caller subject not matching server identity", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception exception) {
                throw new NO_PERMISSION("Failed to verify caller subject", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
            }
        }
        this.reactivateServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "register_server (byte[] orb_uuid, ORB_Server orb_server)");
        }
        if (null != byArray) {
            this.addServer(byArray, oRB_Server);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "register_server (byte[] orb_uuid, ORB_Server orb_server)", "returned from addServer();", (java.lang.Object)this.registrationInfo());
            }
            iOR = this.lsdPrototype.asIOR();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "register_server (byte[] orb_uuid, ORB_Server orb_server)", "LSDPrototype IOR returned:\n" + iOR.stringify());
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "register_server (byte[] orb_uuid, ORB_Server orb_server)");
        }
        return iOR.stringify().getBytes();
    }

    public void unregister_server(byte[] byArray) {
        if (this.isCellSecurityEnabled()) {
            try {
                if (((Boolean)this.invokeCtxMgrMethod("callerSubjectIsServerIdentity")).equals(Boolean.FALSE)) {
                    throw new NO_PERMISSION("Caller subject not matching server identity", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception exception) {
                throw new NO_PERMISSION("Failed to verify caller subject", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
            }
        }
        this.reactivateServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "unregister_server(byte[] orb_uuid)");
        }
        this.removeServer(this.getKey(byArray));
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "unregister_server(byte[] orb_uuid)", "returned from removeServer();", (java.lang.Object)this.registrationInfo());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "unregister_server(byte[] orb_uuid)");
        }
    }

    public boolean register_object_adapters(byte[] byArray, AdapterInfo[] adapterInfoArray) {
        boolean bl = false;
        if (this.isCellSecurityEnabled()) {
            try {
                if (((Boolean)this.invokeCtxMgrMethod("callerSubjectIsServerIdentity")).equals(Boolean.FALSE)) {
                    throw new NO_PERMISSION("Caller subject not matching server identity", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception exception) {
                throw new NO_PERMISSION("Failed to verify caller subject", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
            }
        }
        this.reactivateServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "register_object_adapters (byte[] orb_uuid, AdapterInfo[] adapter_info_seq)");
        }
        bl = this.addAdapter(byArray, adapterInfoArray);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "register_object_adapters (byte[] orb_uuid, AdapterInfo[] adapter_info_seq)", "returned from addAdapter();", (java.lang.Object)this.registrationInfo());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "register_object_adapters (byte[] orb_uuid, AdapterInfo[] adapter_info_seq)");
        }
        return bl;
    }

    public void unregister_object_adapters(byte[] byArray, byte[][] byArray2) {
        int n;
        if (this.isCellSecurityEnabled()) {
            try {
                if (((Boolean)this.invokeCtxMgrMethod("callerSubjectIsServerIdentity")).equals(Boolean.FALSE)) {
                    throw new NO_PERMISSION("Caller subject not matching server identity", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (Exception exception) {
                throw new NO_PERMISSION("Failed to verify caller subject", securityMinorCodeInvalidSecurityCredentials, CompletionStatus.COMPLETED_NO);
            }
        }
        this.reactivateServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "unregister_object_adapters (byte[] orb_uuid, byte[][] adapter_name_seq)");
        }
        Vector vector = this.getKey(byArray);
        for (n = 0; n < byArray2.length; ++n) {
            this.removeAdapter(vector, this.getKey(byArray2[n]));
        }
        for (n = 0; n < byArray2.length; ++n) {
            this.removeAdapter(vector, this.getKey(byArray2[n]));
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "unregister_object_adapters (byte[] orb_uuid, byte[][] adapter_name_seq)", "returned from removeAdapter();", (java.lang.Object)this.registrationInfo());
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "unregister_object_adapters (byte[] orb_uuid, byte[][] adapter_name_seq)");
        }
    }

    public IOR getNextTarget(byte[] byArray) {
        IORPrototype iORPrototype;
        block8: {
            iORPrototype = null;
            Vector vector = null;
            Vector vector2 = null;
            this.reactivateServers();
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "getNextTarget(byte[] objectKey)");
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getNextTarget(byte[] objectKey)", "currently registered servers/adapters", (java.lang.Object)this.registrationInfo());
            }
            try {
                vector2 = this.getServerKey(byArray);
                if (null != vector2) {
                    vector = this.getAdapterKey(byArray);
                    iORPrototype = this.getPrototype(vector2, vector);
                    if (null == iORPrototype) {
                        this.activateAdapters(vector2, vector);
                        iORPrototype = this.getPrototype(vector2, vector);
                        if (iORPrototype == null) {
                            return null;
                        }
                    }
                    break block8;
                }
                return null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.getNextTarget", "473", this);
                if (!ORBRas.isTrcLogging) break block8;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "getNextTarget(byte[] objectKey)", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "getNextTarget(byte[] objectKey)");
        }
        return iORPrototype.asIOR(byArray, "");
    }

    public String registrationInfo() {
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer();
            stringBuffer.append("Server/Adapter registration info:");
            int n = 0;
            try {
                Vector vector = null;
                Hashtable hashtable = null;
                IORPrototype iORPrototype = null;
                Enumeration enumeration = this.servers.keys();
                Enumeration enumeration2 = null;
                Vector vector2 = null;
                while (enumeration.hasMoreElements()) {
                    int n2 = 0;
                    vector = (Vector)enumeration.nextElement();
                    stringBuffer.append("\nServer " + ++n + " Uuid: '");
                    stringBuffer.append(new String(this.getNameFromKey(vector)) + "'");
                    hashtable = (Hashtable)this.adapters.get(vector);
                    if (null != hashtable) {
                        enumeration2 = hashtable.keys();
                        while (enumeration2.hasMoreElements()) {
                            vector2 = (Vector)enumeration2.nextElement();
                            stringBuffer.append("\n\tAdapter " + ++n2 + ": '");
                            stringBuffer.append(new String(this.getNameFromKey(vector2)));
                            stringBuffer.append("' - '");
                            iORPrototype = (IORPrototype)hashtable.get(vector2);
                            stringBuffer.append(iORPrototype.asIOR().stringify() + "'");
                        }
                        continue;
                    }
                    stringBuffer.append("\n\tNo adapters registered");
                }
                stringBuffer.append("\nServers registered: " + n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.registrationInfo", "534", this);
                if (!ORBRas.isTrcLogging) break block5;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "registrationInfo()", exception);
            }
        }
        return stringBuffer.toString();
    }

    private boolean addServer(byte[] byArray, ORB_Server oRB_Server) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "addServer(byte[] serverUuid, ORB_Server orbServer)");
        }
        Vector vector = this.getKey(byArray);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addServer(byte[] serverUuid, ORB_Server orbServer)", "Adding registration for serverKey '" + new String(this.getNameFromKey(vector)) + "'");
        }
        this.removeServer(vector);
        this.servers.put(vector, oRB_Server);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addServer(byte[] serverUuid, ORB_Server orbServer)", "Server registration added for serverKey '" + new String(this.getNameFromKey(vector)) + "'");
        }
        this.saveServers();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "addServer(byte[] serverUuid, ORB_Server orbServer)");
        }
        return true;
    }

    private void removeServer(Vector vector) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "removeServer(Vector serverKey)");
        }
        ORB_Server oRB_Server = (ORB_Server)this.servers.remove(vector);
        this.adapters.remove(vector);
        if (null != oRB_Server) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "removeServer(Vector serverKey)", "Server registration removed for serverKey '" + new String(this.getNameFromKey(vector)) + "'");
            }
            this.saveServers();
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "removeServer(Vector serverKey)");
        }
    }

    private synchronized void saveServers() {
        block7: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "saveServers()");
            }
            try {
                if (null != this.serverPath) {
                    ORB_Server oRB_Server = null;
                    String string = this.serverPath + File.separator + this.serverFileName;
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "saveServers()", "Exporting activie server list", (java.lang.Object)("ASL File: " + string + "\nNo. of active servers:" + this.servers.size()));
                    }
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    CDROutputStream cDROutputStream = ORB.createCDROutputStream((ORB)this.orb);
                    cDROutputStream.write_long(this.servers.size());
                    Enumeration enumeration = this.servers.elements();
                    while (enumeration.hasMoreElements()) {
                        oRB_Server = (ORB_Server)enumeration.nextElement();
                        IOR iOR = this.orb.objectToIOR((Object)oRB_Server);
                        iOR.write(cDROutputStream);
                    }
                    cDROutputStream.writeTo((OutputStream)objectOutputStream);
                    cDROutputStream.close();
                    objectOutputStream.close();
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.saveServers", "698", this);
                if (!ORBRas.isTrcLogging) break block7;
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "saveServers()", "Failed to write active server list to file;");
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "saveServers()", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "saveServers()");
        }
    }

    private IOR[] readServers() {
        IOR[] iORArray = new IOR[]{};
        int n = -1;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "readServers()");
        }
        if (null != this.serverPath) {
            try {
                String string = this.serverPath + File.separator + this.serverFileName;
                if (new File(string).exists()) {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while (objectInputStream.available() > 0) {
                        int n2 = objectInputStream.available();
                        byte[] byArray = new byte[n2];
                        objectInputStream.readFully(byArray, 0, n2);
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)this.orb, (byte[])byteArrayOutputStream.toByteArray(), (int)byteArrayOutputStream.size());
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "Read into ByteArrayOutputStream", (java.lang.Object)("Read total bytes: " + byteArrayOutputStream.size()));
                    }
                    int n3 = cDRInputStream.read_long();
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "Loading active server list", (java.lang.Object)("ASL File: " + string + "\nReported no. of servers: " + n3));
                    }
                    IOR iOR = null;
                    iORArray = new IOR[n3];
                    for (n = 0; n < n3; ++n) {
                        iOR = ORB.createIOR((ORB)this.orb);
                        iOR.read((InputStream)cDRInputStream);
                        iORArray[n] = iOR;
                    }
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "No. of servers successfully loaded: " + n3);
                    }
                    cDRInputStream.close();
                    objectInputStream.close();
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.readServers", "799", this);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "Failed to completely load active server list;");
                    ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "readServers()", exception);
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "readServers()", "No. of servers successfully loaded: " + n);
                }
                IOR[] iORArray2 = new IOR[n];
                for (int i = 0; i < n; ++i) {
                    iORArray2[i] = iORArray[i];
                }
                iORArray = iORArray2;
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "readServers()");
        }
        return iORArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reactivateServers() {
        block15: {
            if (this.serversReactivated) {
                return;
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "reactivateServers()");
            }
            try {
                this.serversReactivated = true;
                ORB_Server oRB_Server = null;
                IOR[] iORArray = this.readServers();
                for (int i = 0; i < iORArray.length; ++i) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "reactivateServers()", "Server " + (i + 1) + ": \n" + iORArray[i].stringify());
                    }
                    Object object = this.orb.IORToObject(iORArray[i]);
                    oRB_Server = ORB_ServerHelper.narrow(object);
                    try {
                        boolean bl = false;
                        try {
                            threadLocalAvoidLogs.set("reactivateServers.ping()");
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "reactivateServers()", "threadLocalAvoidLogs is now set to avoid ffdc logs/messages in WSSSLTransportConnection/WSSSLClientSocketFactoryImpl");
                            }
                            bl = oRB_Server.ping();
                        }
                        finally {
                            threadLocalAvoidLogs.set((java.lang.Object)null);
                            if (ORBRas.isTrcLogging) {
                                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "reactivateServers()", "threadLocalAvoidLogs is now reset");
                            }
                        }
                        if (!bl) continue;
                        oRB_Server.reregistration_required(this, this.lsdPrototype.asIOR().stringify().getBytes());
                        if (!ORBRas.isTrcLogging) continue;
                        ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "reactivateServers()", "Server " + (i + 1) + " still alive, told to reregister");
                        continue;
                    }
                    catch (Exception exception) {
                        String string = iORArray[i].getProfile(0).getHost();
                        int n = iORArray[i].getProfile(0).getPort();
                        FFDCFilter.processException(exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.reactivateServers", "906", this, new java.lang.Object[]{"Failed to contact host/port=" + string + "/" + n});
                        if (!ORBRas.isTrcLogging) continue;
                        ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "reactivateServers()", exception);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.reactivateServers", "918", this);
                if (!ORBRas.isTrcLogging) break block15;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "reactivateServers()", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "reactivateServers()");
        }
    }

    private boolean addAdapter(byte[] byArray, AdapterInfo[] adapterInfoArray) {
        Hashtable<Vector, IORPrototype> hashtable = null;
        Vector vector = this.getKey(byArray);
        Vector vector2 = null;
        boolean bl = false;
        IOR iOR = null;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)");
        }
        for (int i = 0; i < adapterInfoArray.length; ++i) {
            vector2 = this.getKey(adapterInfoArray[i].adapter_name);
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)", "Adding registration for serverKey/AdapterKey '" + new String(this.getNameFromKey(vector)) + "'/'" + new String(this.getNameFromKey(vector2)) + "'");
            this.removeAdapter(vector, vector2);
            hashtable = (Hashtable<Vector, IORPrototype>)this.adapters.get(vector);
            if (hashtable == null) {
                hashtable = new Hashtable<Vector, IORPrototype>();
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)", "IORPrototype:\n" + new String(adapterInfoArray[i].ior_prototype));
            }
            iOR = ORB.createIOR((ORB)this.orb, (String)new String(adapterInfoArray[i].ior_prototype));
            hashtable.put(vector2, new IORPrototype(this.orb, iOR));
            this.adapters.put(vector, hashtable);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)", "Adapter registration added for serverKey/AdapterKey '" + new String(this.getNameFromKey(vector)) + "'/'" + new String(this.getNameFromKey(vector2)) + "'");
            }
            bl = true;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "addAdapter(byte[] orb_uuid, AdapterInfo[] adapterInfo)");
        }
        return bl;
    }

    private void removeAdapter(Vector vector, Vector vector2) {
        IORPrototype iORPrototype;
        Hashtable hashtable;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "removeAdapter(Vector serverKey, Vector adapterKey)");
        }
        if (null != (hashtable = (Hashtable)this.adapters.get(vector)) && null != (iORPrototype = (IORPrototype)hashtable.remove(vector2)) && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "removeAdapter(Vector serverKey, Vector adapterKey)", "Adapter registration removed for serverKey/AdapterKey '" + new String(this.getNameFromKey(vector)) + "'/'" + new String(this.getNameFromKey(vector2)) + "'");
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "removeAdapter(Vector serverKey, Vector adapterKey)");
        }
    }

    private boolean activateAdapters(Vector vector, Vector vector2) {
        byte[] byArray = this.getNameFromKey(vector2);
        ORB_Server oRB_Server = (ORB_Server)this.servers.get(vector);
        if (null != oRB_Server && oRB_Server.ping()) {
            return oRB_Server.activate_object_adapter(byArray);
        }
        return false;
    }

    private Vector getKey(byte[] byArray) {
        Vector<Byte> vector = new Vector<Byte>(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            vector.addElement(new Byte(byArray[i]));
        }
        return vector;
    }

    private Vector getServerKey(byte[] byArray) {
        ObjectKey objectKey = new ObjectKey(byArray);
        byte[] byArray2 = objectKey.getServerUUID();
        if (null != byArray2) {
            return this.getKey(byArray2);
        }
        return null;
    }

    private Vector getAdapterKey(byte[] byArray) {
        byte[] byArray2 = new UserKeyImpl(byArray).getAdapterName();
        if (null != byArray2) {
            return this.getKey(byArray2);
        }
        return null;
    }

    private IORPrototype getPrototype(Vector vector, Vector vector2) {
        IORPrototype iORPrototype = null;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)");
        }
        if (null != vector2) {
            iORPrototype = (IORPrototype)((Hashtable)this.adapters.get(vector)).get(vector2);
        } else {
            Hashtable hashtable = (Hashtable)this.adapters.get(vector);
            if (null != hashtable) {
                Enumeration enumeration;
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)", "Found Adapters");
                }
                if ((enumeration = hashtable.keys()).hasMoreElements()) {
                    vector2 = (Vector)enumeration.nextElement();
                    iORPrototype = (IORPrototype)hashtable.get(vector2);
                }
            } else if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)", "Did not find any adapters");
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)", "ServerKey is " + (null != vector ? vector.toString() : ""), (java.lang.Object)("AdapterKey is " + (null != vector2 ? vector2.toString() : "")));
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "getPrototype(Vector serverKey, Vector adapterKey)");
        }
        return iORPrototype;
    }

    private byte[] getNameFromKey(Vector vector) {
        if (null == vector) {
            return new byte[0];
        }
        Byte[] byteArray = vector.toArray(new Byte[0]);
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return byArray;
    }

    private boolean isCellSecurityEnabled() {
        block4: {
            if (ctxMgrIsCellSecurityEnabled != null) {
                return ctxMgrIsCellSecurityEnabled;
            }
            ctxMgrIsCellSecurityEnabled = false;
            try {
                GenericDeclaration genericDeclaration;
                GenericDeclaration genericDeclaration2;
                if (ctxMgr == null) {
                    genericDeclaration2 = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                    genericDeclaration = ((Class)genericDeclaration2).getMethod("getInstance", null);
                    ctxMgr = ((Method)genericDeclaration).invoke(null, null);
                    ctxMgrClz = Class.forName("com.ibm.ws.security.core.ContextManager");
                }
                genericDeclaration2 = ctxMgrClz.getMethod("isCellSecurityEnabled", null);
                ctxMgrIsCellSecurityEnabled = (Boolean)((Method)genericDeclaration2).invoke(ctxMgr, null);
                genericDeclaration = Class.forName("com.ibm.ISecurityUtilityImpl.SecurityMinorCodes");
                Field field = ((Class)genericDeclaration).getField("INVALID_SECURITY_CREDENTIALS");
                securityMinorCodeInvalidSecurityCredentials = field.getInt(null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.isCellSecurityEnabled", "1242", this);
                if (!ORBRas.isTrcLogging) break block4;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "isCellSecurityEnabled()", exception);
            }
        }
        return ctxMgrIsCellSecurityEnabled;
    }

    private java.lang.Object invokeCtxMgrMethod(String string) {
        java.lang.Object object;
        block7: {
            object = null;
            if (!this.isCellSecurityEnabled()) {
                return null;
            }
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "invokeCtxMgrMethod()");
            }
            try {
                GenericDeclaration genericDeclaration;
                if (ctxMgr == null) {
                    genericDeclaration = Class.forName("com.ibm.ws.security.core.ContextManagerFactory");
                    Method method2 = ((Class)genericDeclaration).getMethod("getInstance", null);
                    ctxMgr = method2.invoke(null, null);
                    ctxMgrClz = Class.forName("com.ibm.ws.security.core.ContextManager");
                }
                genericDeclaration = ctxMgrClz.getMethod(string, null);
                object = ((Method)genericDeclaration).invoke(ctxMgr, null);
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(16L, (java.lang.Object)this, "invokeCtxMgrMethod()", string + "():", object);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.orbimpl.services.lsd.LocationServiceImpl.invokeCtxMgrMethod", "1293", this);
                if (!ORBRas.isTrcLogging) break block7;
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "invokeCtxMgrMethod()", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, (java.lang.Object)this, "invokeCtxMgrMethod()");
        }
        return object;
    }
}

