/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.os400.admin;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSTextFileInputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.httpsvr.access.InstanceInfo;
import com.ibm.as400.httpsvr.gui.AdminSession;
import com.ibm.as400.httpsvr.toolkit.ClientSession;
import com.ibm.ws.os400.admin.CommandRequestHandler;
import com.ibm.ws.os400.admin.IHSCommandException;
import com.ibm.ws.os400.admin.IHSCommandServlet;
import com.ibm.ws.os400.tools.LogKey;
import com.ibm.ws.os400.tools.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommandRequestHandlerImpl
implements CommandRequestHandler {
    public static final String SAIL_RESP_HEADER = "<?xml version=\"1.0\" ?>";
    public static final String SAIL_ERROR_TAG = "SAIL_Error";
    public static final String OK = "AC_OK";
    public static final String OPENFILE_ERROR = "AC_OPENFILE";
    public static final String SAIL_ARG_ERROR = "AC_E_BAD_HTTP_ARG";
    public static final String SERVER_STARTING = "AC_START_RUNNING";
    public static final String SERVER_STOPPING = "AC_STOP_STOPPED";
    public static final String SERVER_RESTARTING = "AC_RESTART_OK";
    public static final String SERVER_START_FAILED = "AC_START_FAILED";
    public static final String SERVER_STOP_FAILED = "AC_STOP_FAILED";
    public static final String SERVER_RESTART_FAILED = "AC_RESTART_FAILED";
    public static final String SAIL_CMD_H = "SAILCmd";
    public static final String SAIL_ARGS_H = "sailArgs";
    public static final String SAIL_ALIAS_H = "Alias";
    public static final String SAIL_INSTANCE_H = "InstallRoot";
    public static final String SAIL_CONFIG_FILE_H = "cfgfile";
    public static final int SAIL_ARGS = 0;
    public static final int SAIL_ALIAS = 1;
    public static final int SAIL_INSTANCE = 2;
    public static final int SAIL_CONFIG_FILE = 3;
    public static final String START = "start";
    public static final String STOP = "stop";
    public static final String RESTART = "restart";
    public static final String STATUS = "status";
    public static final int C2_READY = 0;
    public static final int C2_INFO = 1;
    public static final int C2_WARN = 2;
    public static final int C2_ERROR = 3;
    private static final LogKey _Log = Logger.register((Class)IHSCommandServlet.class);
    private HashMap commandMap = new HashMap();
    private HashMap adminSessionCache = new HashMap();

    public CommandRequestHandlerImpl() {
        try {
            Method[] methodArray = this.getClass().getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method2 = methodArray[i];
                String string = method2.getName().toUpperCase();
                if (string.equalsIgnoreCase("handleRequest") || !Modifier.isPublic(method2.getModifiers())) continue;
                if (_Log.isDebugEnabled()) {
                    Logger.debug((LogKey)_Log, (String)"Addding command to list: ", (Object)string);
                }
                this.commandMap.put(string, method2);
            }
        }
        catch (Throwable throwable) {
            Logger.error((LogKey)_Log, (String)"Unexpected exception while building command list: ", (Object)throwable);
        }
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (_Log.isEntryEnabled()) {
            Logger.entry((LogKey)_Log, (String)"handleRequest");
        }
        String string = null;
        try {
            Method method2;
            string = this.extractRequiredHeader(SAIL_CMD_H, httpServletRequest).toUpperCase();
            Object[] objectArray = new String[4];
            objectArray[0] = this.extractRequiredHeader(SAIL_ARGS_H, httpServletRequest);
            objectArray[2] = this.extractRequiredHeader(SAIL_INSTANCE_H, httpServletRequest);
            objectArray[3] = this.extractRequiredHeader(SAIL_CONFIG_FILE_H, httpServletRequest);
            objectArray[1] = this.extractRequiredHeader(SAIL_ALIAS_H, httpServletRequest);
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"Received SAIL Arguments: ", (Object[])objectArray);
            }
            if ((method2 = (Method)this.commandMap.get(string)) == null) {
                throw new IHSCommandException("Could not find implementation for SAIL command: " + string);
            }
            method2.invoke((Object)this, objectArray, httpServletRequest, httpServletResponse);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IHSCommandException) {
                IHSCommandException iHSCommandException = (IHSCommandException)throwable;
                try {
                    this.printResponseXML(httpServletResponse.getWriter(), 2, string, iHSCommandException.getId(), iHSCommandException.getMessage());
                }
                catch (IOException iOException) {
                    Logger.debug((LogKey)_Log, (String)"IOException while writing error response", (Object)iOException);
                }
            } else {
                Logger.error((LogKey)_Log, (String)"Unexpected error while processing SAIL command:", (Object)throwable);
                this.sendSimpleResponse(httpServletResponse, 500, throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            Logger.error((LogKey)_Log, (String)"Unexpected error while processing SAIL headers:", (Object)throwable);
            this.sendSimpleResponse(httpServletResponse, 500, throwable.getMessage());
        }
        if (_Log.isEntryEnabled()) {
            Logger.exit((LogKey)_Log, (String)"handleRequest");
        }
    }

    public void serverControl(String[] stringArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IHSCommandException {
        String string;
        AdminSession adminSession;
        if (_Log.isEntryEnabled()) {
            Logger.entry((LogKey)_Log, (String)"serverControl");
        }
        if ((adminSession = (AdminSession)this.adminSessionCache.get(string = new AS400().getUserId())) == null) {
            adminSession = new AdminSession();
            adminSession.initialRequestObject(httpServletRequest);
            this.adminSessionCache.put(string, adminSession);
            Logger.debug((LogKey)_Log, (String)("Session created for user: " + string));
        }
        try {
            InstanceInfo instanceInfo;
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)("Web Server Instance name: " + stringArray[1].toUpperCase()));
            }
            if ((instanceInfo = (InstanceInfo)adminSession.getInstanceList().find("h-" + stringArray[1].toUpperCase())) == null) {
                Logger.warn((LogKey)_Log, (String)("Unable to locate instance [" + stringArray[2] + "]"));
                this.printResponseXML(httpServletResponse.getWriter(), 3, "serverControl", "AC_UNKNOWN", "The specified instance [" + stringArray[2] + "] was not found.");
            } else {
                String string2 = stringArray[0];
                if (string2.equalsIgnoreCase(START)) {
                    if (instanceInfo.start((ClientSession)adminSession, false, "")) {
                        this.printResponseXML(httpServletResponse.getWriter(), 0, "serverControl", SERVER_STARTING, "The server was started.");
                    } else {
                        this.printResponseXML(httpServletResponse.getWriter(), 2, "serverControl", SERVER_START_FAILED, "The server could not be started.");
                    }
                } else if (string2.equalsIgnoreCase(STOP)) {
                    if (instanceInfo.stop((ClientSession)adminSession, false)) {
                        this.printResponseXML(httpServletResponse.getWriter(), 0, "serverControl", SERVER_STOPPING, "The server was stopped.");
                    } else {
                        this.printResponseXML(httpServletResponse.getWriter(), 2, "serverControl", SERVER_STOP_FAILED, "The server could not be stopped.");
                    }
                } else if (string2.equalsIgnoreCase(RESTART)) {
                    if (instanceInfo.restart((ClientSession)adminSession, false, "")) {
                        this.printResponseXML(httpServletResponse.getWriter(), 0, "serverControl", SERVER_RESTARTING, "The server was restarted.");
                    } else {
                        this.printResponseXML(httpServletResponse.getWriter(), 2, "serverControl", SERVER_RESTART_FAILED, "The server could not be restarted.");
                    }
                } else if (string2.equalsIgnoreCase(STATUS)) {
                    int n = instanceInfo.getStatus(false);
                    if (n == 0) {
                        this.printResponseXML(httpServletResponse.getWriter(), 0, "serverControl", SERVER_STARTING, "The server is running.");
                    } else if (n == 3) {
                        this.printResponseXML(httpServletResponse.getWriter(), 0, "serverControl", SERVER_STOPPING, "The server is stopped.");
                    } else if (n == 2) {
                        this.printResponseXML(httpServletResponse.getWriter(), 0, "serverControl", SERVER_STOPPING, "The server is stopping.");
                    } else {
                        this.printResponseXML(httpServletResponse.getWriter(), 3, "serverControl", "AC_UNKNOWN", "The server's status could not be determined.");
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new IHSCommandException("Error while writing to output writer.", (Throwable)iOException);
        }
        if (_Log.isEntryEnabled()) {
            Logger.exit((LogKey)_Log, (String)"serverControl");
        }
    }

    public void readFile(String[] stringArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IHSCommandException {
        if (_Log.isEntryEnabled()) {
            Logger.entry((LogKey)_Log, (String)"readFile");
        }
        Object object = null;
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        try {
            Object object2;
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n3 = string2.indexOf(61);
                if (n3 > 0 && n3 < string2.length() - 1) {
                    string = string2.substring(0, n3).trim();
                    object2 = string2.substring(n3 + 1).trim();
                    if (string.equalsIgnoreCase("src")) {
                        object = object2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("linestart")) {
                        n = Integer.parseInt((String)object2);
                        continue;
                    }
                    if (string.equalsIgnoreCase("lineend")) {
                        n2 = Integer.parseInt((String)object2);
                        continue;
                    }
                    Logger.warn((LogKey)_Log, (String)"Unrecognized request argument.", (Object)string, (Object)object2);
                    continue;
                }
                Logger.warn((LogKey)_Log, (String)"Malformed request argument.  Continuing...", (Object)string2);
            }
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"Values are configured as:", (Object[])new Object[]{object, String.valueOf(n), String.valueOf(n2)});
            }
            boolean bl = object != null && ((String)object).equalsIgnoreCase(stringArray[3]);
            File file = new File((String)object);
            if (!bl && !file.exists() && (string = this.getLastErrorOrAccessLog((String)object)) != null) {
                if (_Log.isDebugEnabled()) {
                    Logger.debug((LogKey)_Log, (String)"Found and access_log orerror_log file:", (Object)string);
                }
                object = string;
            }
            int n4 = 0;
            object2 = httpServletResponse.getWriter();
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"Read File, reading file:", (Object)object);
                Logger.debug((LogKey)_Log, (String)("Read File, from line: " + n + " to line: " + n2), (Object)object);
            }
            if (n != 0) {
                n4 = 1;
            }
            AS400 aS400 = new AS400("localhost");
            IFSFile iFSFile = new IFSFile(aS400, (String)object);
            IFSTextFileInputStream iFSTextFileInputStream = new IFSTextFileInputStream(iFSFile);
            if (_Log.isDebugEnabled() && iFSFile != null) {
                Logger.debug((LogKey)_Log, (String)("Read File, ifs file CCSID is: " + iFSFile.getCCSID()));
            }
            String string3 = iFSTextFileInputStream.read(1);
            while (!string3.equals("") && n > n4) {
                if (string3.equals("\n")) {
                    ++n4;
                }
                string3 = iFSTextFileInputStream.read(1);
            }
            do {
                if (string3.equals("\n")) {
                    ++n4;
                }
                ((PrintWriter)object2).print(string3);
            } while (!(string3 = iFSTextFileInputStream.read(1)).equals("") && n4 <= n2);
            iFSTextFileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IHSCommandException(fileNotFoundException.getMessage(), OPENFILE_ERROR, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new IHSCommandException("IOError while reading the file: " + object, OPENFILE_ERROR, (Throwable)iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IHSCommandException("Invalid line number received.", SAIL_ARG_ERROR, (Throwable)numberFormatException);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IHSCommandException("AS400 Security Exception received.", SAIL_ARG_ERROR, (Throwable)aS400SecurityException);
        }
        if (_Log.isEntryEnabled()) {
            Logger.exit((LogKey)_Log, (String)"readFile");
        }
    }

    public void writeFile(String[] stringArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IHSCommandException {
        if (_Log.isEntryEnabled()) {
            Logger.entry((LogKey)_Log, (String)"writeFile");
        }
        try {
            int n;
            String string = stringArray[0];
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            byte[] byArray = new byte[65536];
            AS400 aS400 = new AS400("localhost");
            IFSFile iFSFile = new IFSFile(aS400, string);
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"writeFile", (Object)"Writing File: ", (Object)string);
            }
            int n2 = iFSFile.getCCSID();
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"writeFile", (Object)("File CCSID is: " + n2));
            }
            if (n2 == -1 || n2 == 0) {
                n2 = 819;
            }
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"writeFile: ", (Object)("file.encoding is: " + System.getProperty("file.encoding")));
            }
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"writeFile: ", (Object)"Creating String from request bytes in ISO8859_1");
            }
            IFSTextFileOutputStream iFSTextFileOutputStream = new IFSTextFileOutputStream(aS400, string, n2);
            while ((n = servletInputStream.read(byArray)) > 0) {
                String string2 = new String(byArray, 0, n, "ISO8859_1");
                iFSTextFileOutputStream.write(string2);
            }
            iFSTextFileOutputStream.close();
            this.grantOs400Authorities(stringArray[0], "QTMHHTTP", "*RWX");
            this.printResponseXML(httpServletResponse.getWriter(), 2, "writeFile", OK, "The file has been written");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IHSCommandException((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new IHSCommandException("IOError while writing the stream to a file.", (Throwable)iOException);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IHSCommandException("AS400 Security Exception received.", (Throwable)aS400SecurityException);
        }
        if (_Log.isEntryEnabled()) {
            Logger.exit((LogKey)_Log, (String)"writeFile");
        }
    }

    public void IsHandlerClassLoaded(String[] stringArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (_Log.isEntryEnabled()) {
            Logger.entry((LogKey)_Log, (String)"IsHandlerClassLoaded");
        }
        this.printResponseXML(httpServletResponse.getWriter(), 2, "IsHandlerClassLoaded", OK, "The Handler is loaded");
        if (_Log.isEntryEnabled()) {
            Logger.exit((LogKey)_Log, (String)"IsHandlerClassLoaded");
        }
    }

    public void numberOfLines(String[] stringArray, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IHSCommandException {
        if (_Log.isEntryEnabled()) {
            Logger.entry((LogKey)_Log, (String)"numberOfLines");
        }
        try {
            String string = stringArray[0];
            File file = new File(string);
            String string2 = string;
            if (!file.exists() && (string = this.getLastErrorOrAccessLog(string)) != null) {
                file = new File(string);
            }
            if (string != null && file.isFile()) {
                int n = 0;
                AS400 aS400 = new AS400("localhost");
                IFSFile iFSFile = new IFSFile(aS400, string);
                IFSTextFileInputStream iFSTextFileInputStream = new IFSTextFileInputStream(iFSFile);
                String string3 = iFSTextFileInputStream.read(1);
                if (!string3.equals("")) {
                    n = 1;
                }
                while (!string3.equals("")) {
                    if (string3.equals("\n")) {
                        ++n;
                    }
                    string3 = iFSTextFileInputStream.read(1);
                }
                this.printResponseXML(httpServletResponse.getWriter(), 2, string, OK, String.valueOf(n));
                iFSTextFileInputStream.close();
            } else {
                int n = 0;
                this.printResponseXML(httpServletResponse.getWriter(), 2, string2, OK, String.valueOf(n));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IHSCommandException((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new IHSCommandException("IOError while reading from the file.", (Throwable)iOException);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new IHSCommandException("AS400 Security Exception received.", (Throwable)aS400SecurityException);
        }
        if (_Log.isEntryEnabled()) {
            Logger.exit((LogKey)_Log, (String)"numberOfLines");
        }
    }

    private void printResponseXML(PrintWriter printWriter, int n, String string, String string2, String string3) {
        if (_Log.isDebugEnabled()) {
            Logger.debug((LogKey)_Log, (String)"printResponseXML", (Object[])new Object[]{String.valueOf(n), string, string2, string3});
        }
        printWriter.println(SAIL_RESP_HEADER);
        printWriter.print("<");
        printWriter.print(SAIL_ERROR_TAG);
        printWriter.print(" Severity=\"");
        printWriter.print(n);
        printWriter.print("\" File=\"");
        printWriter.print(string == null ? "" : string);
        printWriter.print("\" ID=\"");
        printWriter.print(string2 == null ? "" : string2);
        printWriter.print("\" Msg=\"");
        printWriter.print(string3 == null ? "" : string3);
        printWriter.print("\" />");
    }

    private String extractRequiredHeader(String string, HttpServletRequest httpServletRequest) throws IHSCommandException {
        String string2 = httpServletRequest.getHeader(string);
        if (string2 == null) {
            throw new IHSCommandException("Unable to extract header from request: [" + string + "]");
        }
        if (_Log.isDebugEnabled()) {
            Logger.debug((LogKey)_Log, (String)"extractRequiredHeader", (Object[])new Object[]{string, string2});
        }
        return string2;
    }

    private void sendSimpleResponse(HttpServletResponse httpServletResponse, int n, String string) {
        block3: {
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"sendSimpleResponse", (Object[])new Object[]{String.valueOf(n), string});
            }
            try {
                httpServletResponse.sendError(n, string);
            }
            catch (IOException iOException) {
                if (!_Log.isDebugEnabled()) break block3;
                Logger.debug((LogKey)_Log, (String)"Error while sending simple response.", (Object)iOException);
            }
        }
    }

    private void grantOs400Authorities(String string, String string2, String string3) {
        try {
            String[] stringArray = new String[]{"system", "CHGAUT", "OBJ('" + string + "')", "USER(" + string2 + ")", "DTAAUT(" + string3 + ")", "OBJAUT(*OBJEXIST *OBJMGT *OBJALTER *OBJREF)"};
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            if (_Log.isDebugEnabled()) {
                Logger.debug((LogKey)_Log, (String)"NON-CRITICAL Exception during plugin file authority configuration:");
            }
            System.out.println("NON-CRITICAL Exception during plugin file authority configuration:");
            exception.printStackTrace();
        }
    }

    private String getLastErrorOrAccessLog(String string) {
        File file = new File(string);
        File file2 = new File(file.getParent());
        String string2 = null;
        if (_Log.isDebugEnabled() && file2 != null) {
            Logger.debug((LogKey)_Log, (String)"List of access_log/error_log files", (Object[])file2.list());
        }
        String string3 = file.getParent();
        String string4 = file.getName();
        if (_Log.isDebugEnabled()) {
            Logger.debug((LogKey)_Log, (String)"getLastErrorOrAccessLog method parent Path:", (Object)string3);
            Logger.debug((LogKey)_Log, (String)"getLastErrorOrAccessLog method file path", (Object)string4);
        }
        if (string4.toLowerCase().indexOf("access_log") != 0) {
            string2 = new String(string4);
        } else if (string4.toLowerCase().indexOf("error_log") != 0) {
            string2 = new String(string4);
        } else {
            return null;
        }
        String[] stringArray = file2.list();
        int n = stringArray.length;
        String string5 = null;
        if (n != 0) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                if (stringArray[n2].toLowerCase().indexOf(string2) != 0) continue;
                string5 = stringArray[n2].toLowerCase();
                break;
            }
            if (string5 != null) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (stringArray[n2].toLowerCase().indexOf(string2) != 0 || stringArray[n2].toLowerCase().compareTo(string5.toLowerCase()) <= 0) continue;
                    string5 = stringArray[n2].toLowerCase();
                }
            }
            if (string5 != null) {
                if (_Log.isDebugEnabled()) {
                    Logger.debug((LogKey)_Log, (String)"getLastErrorOrAccessLog returned file:", (Object)(string3 + File.separator + string5));
                }
                return string3 + File.separator + string5;
            }
            return null;
        }
        return null;
    }
}

