/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class ConfigUtil {
    public static final String ENABLE_RULE_ENGINE_LOOKUP = "perfTuningAdmin.attribute.enabled";
    public static final String ENABLE_TRACE_RESPONSE_LOOKUP = "perfTuningAdmin.attribute.traceResponseEnabled";
    public static final String TRACE_RESPONSE_LEVEL_LOOKUP = "perfTuningAdmin.attribute.traceResponseLevel";
    public static final String ENABLE_FILE_RESPONSE_LOOKUP = "perfTuningAdmin.attribute.fileResponseEnabled";
    public static final String FILE_RESPONSE_LEVEL_LOOKUP = "perfTuningAdmin.attribute.fileResponseLevel";
    public static final String ENABLE_MBEAN_RESPONSE_LOOKUP = "perfTuningAdmin.attribute.mBeanResponseEnabled";
    public static final String MBEAN_RESPONSE_LEVEL_LOOKUP = "perfTuningAdmin.attribute.mBeanResponseLevel";
    public static final String DURATION_LOOKUP = "perfTuningAdmin.attribute.duration";
    public static final String MAX_ALERT_STREAK_LOOKUP = "perfTuningAdmin.attribute.maxAlertStreak";
    public static final String MIN_CPU_LOOKUP = "perfTuning.attName.MinCpuUsageForWorkingSystem";
    public static final String CPU_SATURATED_LOOKUP = "perfTuning.attName.CpuNotSaturated";
    public static final String CALC_INTERVAL_LOOKUP = "perfTuning.attName.CalculationInterval";
    public static final String NUM_CPU_LOOKUP = "perfTuning.attName.numberOfProcessors";
    public static final String REFRESH_ITERATION_LOOKUP = "perfTuning.attName.RefreshIteration";
    public static final String WARNING_LOOKUP = "perfTuning.attName.warnings";
    public static final String PMI_ENABLED_LOOKUP = "perfTuning.attName.noPmi";
    public static final String REINIT_OPERATION_LOOKUP = "perfTuningAdmin.operation.reInit";
    public static final String MEMORYLEAK_STATUS_LOOKUP = "perfTuningAdmin.attribute.memoryLeak.status";
    public static final String MEMORYLEAK_STATUS_ATT = "heapDumpStatus";
    public static final String HEAPDUMP_OPERATION_LOOKUP = "perfTuningAdmin.operation.takeHeapDump";
    public static final String HEAPDUMP_STATUS_LOOKUP = "perfTuningAdmin.attribute.heapDump.status";
    public static final String HEAPDUMP_STATUS_ATT = "heapDumpStatus";
    public static final String HEAPDUMP_FILENAMES_LOOKUP = "perfTuningAdmin.attribute.heapDump.fileNames";
    public static final String HEAPDUMP_FILENAMES_ATT = "heapDumpFileNames";
    public static final String HEAPDUMP_DATA_COLLECTION_ATT = "heapDumpGenerationEnabled";
    public static final String HEAPDUMP_DATA_COLLECTION_LOOKUP = "perfTuningAdmin.attribute.memoryLeakDataCollection";
    public static final String HEAPDUMP_NUMBER_OF_DUMPS_ATT = "heapDumpNumberToBeAttempted";
    public static final String HEAPDUMP_POLICY_ATT = "heapDumpTriggerPolicy";
    public static final String HEAPDUMP_AUTOMATED_DUMPS_APPLICABLE_ATT = "heapDumpAutomatedGenerationApplicable";
    public static final String HEAPDUMP_NUMBER_OF_DUMPS_LOOKUP = "perfTuningAdmin.attribute.heapDump.numberOfDumps";
    public static final String HEAPDUMP_POLICY_LOOKUP = "perfTuningAdmin.attribute.heapDump.heapDumpTriggerPolicy";
    public static final String HEAPDUMP_AUTOMATED_DUMPS_APPLICABLE_LOOKUP = "perfalert.attribute.heapDump.automatedHeapDumpsApplicable";
    public static final String PD_ENABLED_ATT = "pdEnabled";
    public static final String PD_ENABLED_LOOKUP = "pd.attribute.enabled";
    public static final String ENABLE_RULE_ENGINE_ATT = "enabled";
    public static final String ENABLE_TRACE_RESPONSE_ATT = "traceResponseEnabled";
    public static final String TRACE_RESPONSE_LEVEL_ATT = "traceResponseLevel";
    public static final String ENABLE_FILE_RESPONSE_ATT = "fileResponseEnabled";
    public static final String FILE_RESPONSE_LEVEL_ATT = "fileResponseLevel";
    public static final String ENABLE_MBEAN_RESPONSE_ATT = "mBeanResponseEnabled";
    public static final String MBEAN_RESPONSE_LEVEL_ATT = "mBeanResponseLevel";
    public static final String DURATION_ATT = "duration";
    public static final String MAX_ALERT_STREAK_ATT = "maxAlertStreak";
    public static final String MIN_CPU_ATT = "minCpuUsage";
    public static final String CPU_SATURATED_ATT = "cpuSaturated";
    public static final String CALC_INTERVAL_ATT = "calculationInterval";
    public static final String NUM_CPU_ATT = "numberOfProcessors";
    public static final String REFRESH_ITERATION_ATT = "refreshIteration";
    public static final String WARNING_ATT = "warnings";
    public static final String PMI_ENABLED_ATT = "pmiDataAvailable";
    public static final String REINIT_OPERATION = "reInit";
    public static final String SERVER_TYPE = "Server";
    public static final String DATA_TYPE = "_Websphere_Config_Data_Type";
    public static final String DATA_TYPE_WEBCONTAINER = "WebContainer";
    public static final String DATA_TYPE_EJBCONTAINER = "EJBContainer";
    public static final String DATA_TYPE_ORB = "ObjectRequestBroker";
    public static final String WEBCONTAINER_POOL_ATT = "threadPool";
    public static final String WEBCONTAINER_POOL_MIN_ATT = "minimumSize";
    public static final String WEBCONTAINER_POOL_MAX_ATT = "maximumSize";
    public static final String WEBCONTAINER_POOL_GROWABLE_ATT = "isGrowable";
    public static final String WEBCONTAINER_SERVLET_CACHE_ATT = "enableServletCaching";
    public static final String COMPONENT_POOL_ATT = "threadPool";
    public static final String COMPONENT_POOL_MIN_ATT = "minimumSize";
    public static final String COMPONENT_POOL_MAX_ATT = "maximumSize";
    public static final String COMPONENT_POOL_GROWABLE_ATT = "isGrowable";
    public static final String CONTEXT_ATT = "context";
    public static final String JDBC_DATASOURCE_TYPE = "WAS40DataSource";
    public static final String JDBC_CONNECTION_POOL_ATT = "connectionPool";
    public static final String JDBC_MAX_POOL_ATT = "maximumPoolSize";
    public static final String JDBC_MIN_POOL_ATT = "minimumPoolSize";
    public static final String JDBC_STATEMENT_CACHE_ATT = "statementCacheSize";
    public static final String JDBC_JNDI_NAME = "jndiName";
    public static final String JDBC_DATASOURCE_HELPER = "datasourceHelperClassname";
    public static final String J2C_DATASOURCE_TYPE = "DataSource";
    public static final String J2C_CONNECTION_POOL_ATT = "connectionPool";
    public static final String J2C_MAX_POOL_ATT = "maxConnections";
    public static final String J2C_MIN_POOL_ATT = "minConnections";
    public static final String J2C_STATEMENT_CACHE_ATT = "statementCacheSize";
    public static final String J2C_JNDI_NAME = "jndiName";
    public static final String J2C_DATASOURCE_HELPER = "datasourceHelperClassname";
    public static final String DB2_DATASOURCE_HELPER_CLASS = "com.ibm.websphere.rsadapter.DB2DataStoreHelper";
    public static final String DB2_UNIVERSAL_DATASOURCE_HELPER_CLASS = "com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper";
    public static final String SESSION_TYPE = "SessionManager";
    public static final String SESSION_TUNING_ATT = "tuningParams";
    public static final String SESSION_TUNING_OVERFLOW_ATT = "allowOverflow";
    public static final String SESSION_TUNING_MAX_ATT = "maxInMemorySessionCount";
    public static final String SESSION_TUNING_TIMEOUT = "invalidationTimeout";
    public static final String SESSION_PERSISTANCE_ATT = "sessionPersistenceMode";
    public static final String SESSION_PERSISTANCE_MODE_NONE = "NONE";
    public static final String SESSION_PERSISTANCE_MODE_DATABASE = "DATABASE";
    public static final String SESSION_PERSISTANCE_MODE_DATA_REPLICATION = "DATA_REPLICATION";
    public static final String APP_SERVER_TYPE = "ApplicationServer";
    public static final String APP_SERVER_COMPONENTS_ATT = "components";
    public static final String WEB_CONTAINER_SERVICES = "services";
    public static final String SERVICES_ATT = "services";
    public static final String JVM = "JavaVirtualMachine";
    public static final String JVM_INITIAL_HEAP = "initialHeapSize";
    public static final String JVM_MAX_HEAP = "maximumHeapSize";
    public static final String DYNAMIC_CACHE = "DynamicCache";
    public static final String DYNAMIC_CACHE_ENABLED = "enable";
    public static final String DYNAMIC_CACHE_SIZE = "cacheSize";
    private static ObjectName configService;
    private static AdminService adminService;
    private static boolean initialized;
    private static TraceComponent tc;

    public static boolean isWebComponent(AttributeList attributeList) {
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(DATA_TYPE)) continue;
            return ((String)attribute.getValue()).equals(DATA_TYPE_WEBCONTAINER);
        }
        return false;
    }

    public static boolean isOrbService(AttributeList attributeList) {
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(DATA_TYPE)) continue;
            System.out.println("isOrbService trying to match ObjectRequestBroker with " + attribute.getValue());
            if (((String)attribute.getValue()).equals(DATA_TYPE_ORB)) {
                System.out.println("this is a orbService");
                return true;
            }
            System.out.println("not orb " + attribute.getName() + " = " + attribute.getValue());
            return false;
        }
        return false;
    }

    public static ObjectName getConfigServiceObjectName() {
        if (!initialized) {
            ConfigUtil.initialize();
        }
        return configService;
    }

    public static AdminService getAdminService() {
        if (!initialized) {
            ConfigUtil.initialize();
        }
        return adminService;
    }

    public static String[] getAllTypes() {
        if (!initialized) {
            ConfigUtil.initialize();
        }
        try {
            String[] stringArray = (String[])adminService.invoke(configService, "getSupportedConfigObjectTypes", new Object[0], new String[0]);
            return stringArray;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not get all types " + exception.toString());
            exception.printStackTrace();
            return new String[0];
        }
    }

    private static void initialize() {
        Tr.entry(tc, "initialize");
        adminService = AdminServiceFactory.getAdminService();
        try {
            ObjectName objectName = new ObjectName(adminService.getDefaultDomain() + ":type=ConfigService,*");
            Set set = adminService.queryNames(objectName, null);
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                configService = (ObjectName)iterator.next();
            }
            initialized = true;
        }
        catch (Exception exception) {
            Tr.error(tc, "could not get AdminService or find ConfigService " + exception.toString());
            exception.printStackTrace();
            initialized = false;
        }
        Tr.exit(tc, "initialize");
    }

    public static void printMBeanMethods(ObjectName objectName) {
        if (!initialized) {
            ConfigUtil.initialize();
        }
        try {
            MBeanInfo mBeanInfo = adminService.getMBeanInfo(objectName);
            MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
            for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
                System.out.println("Operation : " + mBeanOperationInfoArray[i].getName());
                MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfoArray[i].getSignature();
                for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printAttributeList(Object object) {
        ConfigUtil.printAttributeList(object, "");
    }

    public static void printAttributeList(Object object, String string) {
        if (object instanceof AttributeList) {
            System.out.println(string + "List:>>>");
            Iterator iterator = ((AttributeList)object).iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                ConfigUtil.printAttribute(attribute, string + "   ");
            }
            System.out.println(string + "<<<List");
        } else if (object instanceof Attribute) {
            ConfigUtil.printAttribute(object);
        } else {
            System.out.println(string + "did not know what " + object.getClass().getName() + " was");
        }
    }

    public static void printAllConfigServiceAttributes() {
        try {
            String[] stringArray = ConfigUtil.getAllTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, stringArray[i], null);
                ObjectName[] objectNameArray = configService.queryConfigObjects(null, null, objectName, null);
                for (int j = 0; j < objectNameArray.length; ++j) {
                    boolean bl = true;
                    AttributeList attributeList = configService.getAttributes(null, objectNameArray[j], null, true);
                    if (attributeList == null) continue;
                    ConfigUtil.printAttributeList(attributeList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printAttribute(Object object) {
        ConfigUtil.printAttribute(object, "");
    }

    public static void printAttribute(Object object, String string) {
        if (object instanceof AttributeList) {
            ConfigUtil.printAttributeList(object, string);
        } else if (object instanceof Attribute) {
            System.out.println(string + "attribute : " + ((Attribute)object).getName() + ", type= ");
            Object object2 = ((Attribute)object).getValue();
            if (object2 != null) {
                if (object2 instanceof AttributeList) {
                    System.out.println(string + "   value is a Attributelist ");
                    ConfigUtil.printAttributeList(object2, string + "   ");
                } else if (object2 instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)object2;
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (arrayList.get(i) instanceof Attribute) {
                            ConfigUtil.printAttribute(arrayList.get(i), string + "   ");
                            continue;
                        }
                        if (!(arrayList.get(i) instanceof AttributeList)) continue;
                        ConfigUtil.printAttributeList(arrayList.get(i), string + "   ");
                    }
                } else {
                    System.out.println(string + "   " + object2.getClass().getName() + "   " + object2);
                }
            } else {
                System.out.println(string + "   null");
            }
        } else {
            System.out.println(string + "did not know what " + object.getClass().getName() + " was");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ObjectName getAppServer(String string) {
        try {
            Serializable serializable;
            ConfigService configService = ConfigServiceFactory.getConfigService();
            if (configService == null) {
                serializable = new Exception("ConfigUtil called ConfigServiceFactory.getConfigService(); and NULL was returned ");
                try {
                    configService = ConfigServiceFactory.createConfigService(true, new Properties());
                }
                catch (Exception exception) {
                    throw serializable;
                }
                if (configService == null) {
                    ((Throwable)serializable).printStackTrace();
                    throw serializable;
                }
            }
            if ((serializable = ConfigServiceHelper.createObjectName(null, SERVER_TYPE, null)) == null) {
                Exception exception = new Exception("query on config service for Server returned null");
                exception.printStackTrace();
                throw exception;
            }
            ObjectName[] objectNameArray = configService.queryConfigObjects(null, null, (ObjectName)serializable, null);
            if (objectNameArray == null) {
                Exception exception = new Exception("query on config service for " + serializable + " returned null");
                exception.printStackTrace();
                throw exception;
            }
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string2 = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                if (!string.equals(string2)) continue;
                serializable = objectNameArray[i];
                break;
            }
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, APP_SERVER_TYPE, null);
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(null, (ObjectName)serializable, objectName, null);
            if (objectNameArray2 != null) {
                return objectNameArray2[0];
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getAttributeValueFromArrayList(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Attribute attribute;
            Object e2 = arrayList.get(i);
            if (!(e2 instanceof Attribute) || !(attribute = (Attribute)e2).getName().equals(string)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public static ArrayList getArrayListValue(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Serializable serializable;
            Object e2 = arrayList.get(i);
            if (e2 instanceof Attribute) {
                serializable = (Attribute)e2;
                if (!((Attribute)serializable).getName().equals(string)) continue;
                Object object = ((Attribute)serializable).getValue();
                if (object == null) {
                    return null;
                }
                if (object instanceof ArrayList) {
                    return (ArrayList)object;
                }
                return null;
            }
            if (!(e2 instanceof AttributeList) || (serializable = ConfigUtil.getArrayListValue((ArrayList)e2, string)) == null) continue;
            return serializable;
        }
        return null;
    }

    static {
        initialized = false;
        tc = Tr.register(ConfigUtil.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    }
}

