/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning;

import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.RuleLookup;
import java.util.ArrayList;
import java.util.HashMap;

public class EngineParameters
implements TuningConstants {
    private static String serverType;
    private static HashMap map;
    private static HashMap persistMap;
    private static int numProcessors;
    private static ArrayList paramNames;
    private static String id;
    private static String operatingSystem;

    public static String getId() {
        return id;
    }

    public static void setId(String string) {
        id = string;
    }

    public static int getMaxAlertStreak() {
        Integer n = (Integer)map.get("maxAlertStreak");
        if (n == null) {
            return 3;
        }
        return n;
    }

    public static int getMinCpuUsage() {
        Integer n = (Integer)map.get("minCpuUsage");
        if (n == null) {
            return 50;
        }
        return n;
    }

    public static int getCalcInterval() {
        Integer n = (Integer)map.get("calculationInterval");
        if (n == null) {
            return 60;
        }
        return n;
    }

    public static int getCpuSaturated() {
        Integer n = (Integer)map.get("cpuSaturated");
        if (n == null) {
            return 90;
        }
        return n;
    }

    public static int getNumProcessors() {
        Integer n = (Integer)map.get("numberOfProcessors");
        if (n == null || n == 0) {
            return numProcessors;
        }
        return n;
    }

    public static int getRefreshIteration() {
        Integer n = (Integer)map.get("refreshIteration");
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static HashMap getParamMap() {
        return map;
    }

    public static Object getParam(String string) {
        return map.get(string);
    }

    public static void setParam(String string, Object object) {
        if (!map.containsKey(string)) {
            paramNames.add(string);
        }
        map.put(string, object);
    }

    public static ArrayList getParamNames() {
        return paramNames;
    }

    public static void clearPersistMap() {
        persistMap = new HashMap();
    }

    public static HashMap getPersistMap() {
        return persistMap;
    }

    public static void setPersistParam(String string, Object object) {
        persistMap.put(string, object);
    }

    public static Object getPersistParam(String string) {
        return persistMap.get(string);
    }

    public static void dump() {
        System.out.println("dumping EngineParameters");
        for (int i = 0; i < paramNames.size(); ++i) {
            System.out.println("    " + paramNames.get(i) + "=" + map.get(paramNames.get(i)));
        }
    }

    public static String getProcessType() {
        return serverType;
    }

    public static void setProcessType(String string) throws Exception {
        if (string != null) {
            if (string.equals("ManagedProcess") || string.equals("UnManagedProcess")) {
                serverType = string;
            } else {
                throw new Exception("EngineParameters.setProcessType tried to set prcoess type to  " + string + "which is other than " + "ManagedProcess" + "or " + "UnManagedProcess");
            }
        }
    }

    public static void setCachedValuesFromRuleLookup(RuleLookup ruleLookup) throws Exception {
        EngineParameters.setProcessType(ruleLookup.getProcessType());
        map = (HashMap)ruleLookup.getParamMap().clone();
        persistMap = (HashMap)ruleLookup.getPersistMap().clone();
        paramNames = (ArrayList)ruleLookup.getParamNames().clone();
        EngineParameters.setId(ruleLookup.getId());
    }

    public static String getOS() {
        if (operatingSystem == null && (operatingSystem = System.getProperty("os.name")) != null && (operatingSystem.equalsIgnoreCase("OS/390") || operatingSystem.equalsIgnoreCase("z/OS"))) {
            operatingSystem = "z/OS";
        }
        return operatingSystem;
    }

    static {
        map = new HashMap();
        persistMap = new HashMap();
        numProcessors = Runtime.getRuntime().availableProcessors();
        paramNames = new ArrayList();
        id = "RuleEngine";
        operatingSystem = null;
    }
}

