/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.bundle.CachingTextResourceBundle;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TuningUtil
implements TuningConstants {
    private static HashMap nlsMap = new HashMap();
    private static Locale jvmLocale = Locale.getDefault();
    private static final boolean lazyNLS = true;
    private static boolean preloaded_nls = false;
    private static TraceComponent tc = Tr.register(TuningUtil.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public static ResourceBundle getBundle(Locale locale) {
        try {
            ResourceBundle resourceBundle;
            if (locale == null) {
                locale = jvmLocale;
            }
            if ((resourceBundle = (ResourceBundle)nlsMap.get(locale)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NLS: creating new bundle for locale " + locale + " ***** ");
                }
                resourceBundle = CachingTextResourceBundle.getBundle("com.ibm.ws.performance.tuning.properties.perftuning", locale, Thread.currentThread().getContextClassLoader());
                nlsMap.put(locale, resourceBundle);
            }
            return resourceBundle;
        }
        catch (Exception exception) {
            System.out.println("unexpected exception getting bundle : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public static void preloadNLS() {
        TuningUtil.preloadNLS(Locale.getDefault());
    }

    public static void preloadNLS(Locale locale) {
        block3: {
            try {
                ResourceBundle resourceBundle = TuningUtil.getBundle(locale);
                if (resourceBundle instanceof CachingTextResourceBundle && !preloaded_nls) {
                    String[] stringArray = new String[]{"perfTuning.mbean.notification.updateCachedCalcs.des", "perfTuningAdmin.ruleName.NoRoomForNewSessionRule", "perfTuningAdmin.ruleName.LiveSessionsRule", "perfTuningAdmin.ruleName.SessionSizeRule", "perfTuningAdmin.ruleName.SessionSizeTimeRule", "perfTuningAdmin.ruleName.ServletEngineUnboundedPoolRule", "perfTuningAdmin.ruleName.ServletEnginePoolRule", "perfTuningAdmin.ruleName.OrbUnboundedPoolRule", "perfTuningAdmin.ruleName.OrbPoolRule", "perfTuningAdmin.ruleName.DSPoolMinAndMaxSize", "perfTuningAdmin.ruleName.DSPrepStmtRule", "perfTuningAdmin.ruleName.NoRoomForNewSessionRule", "perfTuningAdmin.ruleName.LiveSessionsRule", "perfTuningAdmin.ruleName.SessionSizeRule", "perfTuningAdmin.ruleName.SessionSizeTimeRule", "perfTuningAdmin.ruleName.ServletEngineUnboundedPoolRule", "perfTuningAdmin.ruleName.ServletEnginePoolRule", "perfTuningAdmin.ruleName.OrbUnboundedPoolRule", "perfTuningAdmin.ruleName.OrbPoolRule", "perfTuningAdmin.ruleName.DSPoolMinAndMaxSize", "perfTuningAdmin.ruleName.DSPrepStmtRule", "perfTuningAdmin.ruleName.JvmHeapSizeGc", "perfTuningAdmin.ruleName.DynaCache", "perfTuningAdmin.ruleName.SessionWithoutPersistenceRule", "perfTuningAdmin.ruleName.config.JvmHeap", "perfTuningAdmin.ruleName.config.WebContainerPool", "perfTuningAdmin.ruleName.config.OrbPool", "perfTuningAdmin.ruleName.config.ConnPool", "perfTuningAdmin.ruleName.config.DynaCache", "perfTuningAdmin.ruleName.NoRoomForNewSessionRule", "perfTuningAdmin.ruleName.LiveSessionsRule", "perfTuningAdmin.ruleName.SessionSizeRule", "perfTuningAdmin.ruleName.SessionSizeTimeRule", "perfTuningAdmin.ruleName.ServletEngineUnboundedPoolRule from laz", "perfTuningAdmin.ruleName.ServletEnginePoolRule", "perfTuningAdmin.ruleName.OrbUnboundedPoolRule", "perfTuningAdmin.ruleName.OrbPoolRule", "perfTuningAdmin.ruleName.DSPoolMinAndMaxSize", "perfTuningAdmin.ruleName.DSPrepStmtRule"};
                    ((CachingTextResourceBundle)resourceBundle).preloadCache(stringArray);
                    preloaded_nls = true;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "exception caught preloading nls : " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static NLS getNLS(Locale locale) {
        NLS nLS;
        if (locale == null) {
            locale = jvmLocale;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NLS: creating new NLS locale " + locale + " ***** ");
        }
        if ((nLS = (NLS)nlsMap.get(locale)) == null) {
            nLS = new NLS("com.ibm.ws.performance.tuning.properties.perftuning", locale, true);
            nlsMap.put(locale, nLS);
        }
        return nLS;
    }

    public static String getNLSString(String string) {
        return TuningUtil.getNLSString(string, jvmLocale);
    }

    public static String getNLSString(String string, Locale locale) {
        return TuningUtil.getNLSString(string, "Error: Message not found for " + string, locale);
    }

    public static String getNLSString(String string, String string2) {
        return TuningUtil.getNLSString(string, string2, jvmLocale);
    }

    public static String getNLSString(String string, String string2, Locale locale) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NLS getting lazy " + string + " ");
        }
        try {
            ResourceBundle resourceBundle = TuningUtil.getBundle(locale);
            String string3 = resourceBundle.getString(string);
            if (string3 != null) {
                return string3;
            }
            if (string2 != null) {
                return string2;
            }
            return "Error: Message not found for " + string;
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return string2;
        }
    }

    public static String getNLSString(String string, Object[] objectArray, String string2) {
        return TuningUtil.getNLSString(string, objectArray, string2, jvmLocale);
    }

    public static String getNLSString(String string, Object[] objectArray, String string2, Locale locale) {
        try {
            ResourceBundle resourceBundle;
            String string3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NLS :getting lazy " + string + " ");
            }
            if ((string3 = (resourceBundle = TuningUtil.getBundle(locale)).getString(string)) != null) {
                return MessageFormat.format(string3, objectArray);
            }
            if (string2 != null) {
                return string2;
            }
            return "Error: Message not found for " + string;
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            if (string2 != null) {
                return string2;
            }
            return "Error: Message not found for " + string;
        }
    }

    public static RuleOutput createGeneralErrorOutput(String string, PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput;
        if (d == -100.0) {
            ruleOutput = new RuleOutput(string, perfDescriptor, 103, new MessageWrapper("perfalert.error"), new MessageWrapper[0], null);
        } else if (d == -103.0) {
            ruleOutput = new RuleOutput(string, perfDescriptor, 108, new MessageWrapper("perfalert.restart"), new MessageWrapper("perfalert.PmiDisabled"), null);
        } else if (d == -102.0) {
            ruleOutput = new RuleOutput(string, perfDescriptor, 102, new MessageWrapper("perfalert.noData", perfDescriptor.getName()), new MessageWrapper[0], null);
        } else if (d == -101.0) {
            ruleOutput = new RuleOutput(string, perfDescriptor, 101, new MessageWrapper("perfalert.noInterval"), new MessageWrapper[0], null);
        } else if (d == 101.0) {
            ruleOutput = new RuleOutput(string, perfDescriptor, 101, new MessageWrapper("perfalert.noProblem"), new MessageWrapper[0], null);
        } else if (d == 107.0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The runRule did not returned a null RuleOutput");
            }
            ruleOutput = new RuleOutput(string, perfDescriptor, 102, new MessageWrapper("perfalert.unknownError"), new MessageWrapper[0], null);
        } else {
            ruleOutput = new RuleOutput(string, perfDescriptor, 102, new MessageWrapper("perfalert.unknownError"), new MessageWrapper[0], null);
        }
        return ruleOutput;
    }

    public static boolean isErrorCode(double d) {
        if (d == -100.0) {
            return true;
        }
        if (d == -101.0) {
            return true;
        }
        if (d == -102.0) {
            return true;
        }
        if (d == -103.0) {
            return true;
        }
        return d < 0.0;
    }

    public static String getNLSString(String string, Object object, String string2) {
        return TuningUtil.getNLSString(string, object, string2, jvmLocale);
    }

    public static String getNLSString(String string, Object object, String string2, Locale locale) {
        Object[] objectArray = new Object[]{object};
        try {
            ResourceBundle resourceBundle = TuningUtil.getBundle(locale);
            String string3 = resourceBundle.getString(string);
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return MessageFormat.format(string2, objectArray);
        }
    }

    public static String getRuleOutputType(int n) {
        if (n == 101) {
            return TuningUtil.getNLSString("perf.tuning.no_problem", "Information");
        }
        if (n == 102) {
            return TuningUtil.getNLSString("perf.tuning.warning", "Warning");
        }
        if (n == 103) {
            return TuningUtil.getNLSString("perf.tuning.problem", "Problem");
        }
        if (n == 104) {
            return TuningUtil.getNLSString("perf.tuning.alert", "Alert");
        }
        if (n == 106) {
            return TuningUtil.getNLSString("perf.tuning.updatedAlert", "Alert");
        }
        if (n == 105) {
            return TuningUtil.getNLSString("perf.tuning.config_alert", "Config");
        }
        if (n == 108) {
            return TuningUtil.getNLSString("perf.tuning.fatal", "Fatal");
        }
        return TuningUtil.getNLSString("perf.tuning.unknown", "Unknown");
    }

    public static String getRuleOutputType(int n, Locale locale) {
        if (n == 101) {
            return TuningUtil.getNLSString("perf.tuning.no_problem", "Information", locale);
        }
        if (n == 102) {
            return TuningUtil.getNLSString("perf.tuning.warning", "Warning", locale);
        }
        if (n == 103) {
            return TuningUtil.getNLSString("perf.tuning.problem", "Problem", locale);
        }
        if (n == 104) {
            return TuningUtil.getNLSString("perf.tuning.alert", "Alert", locale);
        }
        if (n == 106) {
            return TuningUtil.getNLSString("perf.tuning.updatedAlert", "Alert", locale);
        }
        if (n == 105) {
            return TuningUtil.getNLSString("perf.tuning.config_alert", "Config", locale);
        }
        if (n == 108) {
            return TuningUtil.getNLSString("perf.tuning.fatal", "Fatal", locale);
        }
        return TuningUtil.getNLSString("perf.tuning.unknown", "Unknown", locale);
    }

    public static double format(double d) {
        double d2 = Double.parseDouble(TuningUtil.sigDigits(d, 2));
        return d2;
    }

    public static double format(double d, int n) {
        double d2 = Double.parseDouble(TuningUtil.sigDigits(d, n));
        return d2;
    }

    public static String sigDigits(double d, int n) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalSeparatorAlwaysShown(false);
        decimalFormat.setGroupingUsed(false);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        double d2 = 1.0;
        double d3 = Math.abs(d);
        if (d > d2) {
            double d4 = d3;
            int n2 = 0;
            while (d4 > 1.0) {
                d4 /= 10.0;
                ++n2;
            }
            double d5 = Math.pow(10.0, n2 - n);
            double d6 = d / d5;
            d = Math.rint(d6) * d5;
            decimalFormat.setMaximumFractionDigits(0);
        } else {
            int n3 = 0;
            for (d2 = Math.pow(10.0, n - 1); d2 > 1.0 && !(d3 / d2 > 1.0); d2 /= 10.0) {
                ++n3;
            }
            decimalFormat.setMaximumFractionDigits(n3);
        }
        return decimalFormat.format(d);
    }
}

