/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IPersistableCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IDataSourceMBeanSharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRDataSourceConfig;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRServicesConfigCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRServletEngineThreadPoolConfigCalc;
import com.ibm.ws.runtime.service.Repository;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractCalcWriter {
    protected static final TraceComponent tc = Tr.register(AbstractCalcWriter.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void writeConfig(String string, String string2, Repository repository2) {
        IPersistableCalc iPersistableCalc;
        HashMap hashMap;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeConfig", new String[]{string, string2});
        }
        boolean bl = false;
        try {
            RepositoryCache.init(repository2, string, string2);
            RepositoryCache.refreshAll();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while initing/refreshing RepositoryCache", exception);
            }
            bl = true;
            exception.printStackTrace();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing datasource config");
        }
        IDataSourceMBeanSharedCalc iDataSourceMBeanSharedCalc = null;
        try {
            iDataSourceMBeanSharedCalc = CalcCreator.getDataSourceMBeanSharedCalc(string, string2, "thin_client");
            string3 = iDataSourceMBeanSharedCalc.getClass().getName();
            hashMap = iDataSourceMBeanSharedCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting datasource mbean info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing datasource config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing datasource config");
        }
        try {
            iPersistableCalc = CalcCreator.createJdbcDataSourceConfigCalc("thin_client");
            iPersistableCalc.init(string, string2);
            ArrayList arrayList = iDataSourceMBeanSharedCalc.getAllJndiNames();
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            string3 = iPersistableCalc.getClass().getName();
            hashMap = ((ServerRDataSourceConfig)iPersistableCalc).getConfigMap(stringArray);
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting datasource config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing datasource config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing JVM config");
        }
        try {
            iPersistableCalc = CalcCreator.createJvmConfigCalc("thin_client");
            iPersistableCalc.init(string, string2);
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting JVM config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing JVM config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing dynacache config");
        }
        try {
            iPersistableCalc = CalcCreator.createDynamicCacheConfigCalc("thin_client");
            iPersistableCalc.init(string, string2);
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting DynaCache config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing dynacache config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing system config");
        }
        try {
            iPersistableCalc = CalcCreator.getSystemSharedCalc(string, string2, "thin_client");
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting System config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing system config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing threadpool config");
        }
        try {
            iPersistableCalc = CalcCreator.getThreadPoolMBeanSharedCalc(string, string2, "thin_client");
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting Threadpool config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing threadpool config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing session mbean info");
        }
        try {
            iPersistableCalc = CalcCreator.getSessionMBeanSharedCalc(string, string2, "thin_client");
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting session mbean info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing session mbean config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing session config");
        }
        try {
            iPersistableCalc = CalcCreator.getSessionConfigCachedCalc("thin_client", string, string2);
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting session config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing session config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing ORB config");
        }
        try {
            iPersistableCalc = CalcCreator.createOrbConfigCalc("thin_client");
            iPersistableCalc.init(string, string2);
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting ORB config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing ORB config");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing servlet engine config");
        }
        try {
            iPersistableCalc = CalcCreator.createWebAppConfigCalc("thin_client");
            ((ServerRServletEngineThreadPoolConfigCalc)iPersistableCalc).init(string, string2);
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting Servlet engine config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing servlet engine config");
        }
        if (bl) {
            System.out.println("TPV: An error occurred while trying to write the config info, some or all of it has not been written.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - start writing services (trace) config");
        }
        try {
            iPersistableCalc = CalcCreator.createServicesConfigCalc("thin_client");
            ((ServerRServicesConfigCalc)iPersistableCalc).init(string, string2);
            string3 = iPersistableCalc.getClass().getName();
            hashMap = iPersistableCalc.getConfigMap();
            this.writeConfig(string3, hashMap);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "writeConfig - caught Exception while getting services config info", exception);
            }
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "writeConfig - done writing services config");
        }
        if (bl) {
            System.out.println("TPV: An error occurred while trying to write the config info, some or all of it has not been written.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeConfig");
        }
    }

    public abstract void writeConfig(String var1, HashMap var2);
}

