/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.calc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointCalc;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryCalc;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryTimeCalc;
import com.ibm.ws.performance.tuning.calc.ICacheCalc;
import com.ibm.ws.performance.tuning.calc.ICpuCalc;
import com.ibm.ws.performance.tuning.calc.IJvmpiCalc;
import com.ibm.ws.performance.tuning.calc.ILogReadingCalc;
import com.ibm.ws.performance.tuning.calc.IMemoryCalc;
import com.ibm.ws.performance.tuning.calc.IModuleChildDataPointCalc;
import com.ibm.ws.performance.tuning.calc.IRateIncreaseCalc;
import com.ibm.ws.performance.tuning.calc.ISessionCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IDataSourceConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IDynamicCacheConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IJvmConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IOrbThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IServicesConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IServletEngineThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.ISessionConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ICpuSharedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IDataSourceMBeanSharedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISessionMBeanSharedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISharedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISystemSharedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IThreadPoolMBeanSharedCalc;
import com.ibm.ws.performance.tuning.leakProtoType_1.ISummaryPeriodCalc;
import com.ibm.ws.performance.tuning.leakProtoType_1.ServerSummaryPeriodCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerBasicDataPointCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerBasicDataPointHistoryCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerBasicDataPointHistoryTimeCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerCpuCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerMemoryCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerModuleChildDataPointCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.ServerRateIncreaseCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRDataSourceConfig;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRJvmConfigCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerROrbThreadPoolConfigCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRServicesConfigCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRServletEngineThreadPoolConfigCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRSessionConfigCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc.ServerCpuSharedCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc.ServerCpuSharedCalc_ND;
import com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc.ServerDataSourceMBeanCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc.ServerSessionMBeanCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc.ServerThreadPoolMBeanCalc;
import com.ibm.ws.performance.tuning.serverAlert.calc.sharedCalc.SystemMBeanCalc;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelper;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelperFactory;
import com.ibm.ws.security.core.SecurityContext;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CalcCreator
implements TuningConstants {
    private static TraceComponent tc = Tr.register(CalcCreator.class, "PerformanceTuningAdvisor", "com.ibm.ws.performance.tuning.properties.perftuning");
    private static HashMap serverCpuCalcCache = new HashMap();
    private static HashMap serverCpuCalcRequests = new HashMap();
    private static HashMap clientCpuCalcCache = new HashMap();
    private static HashMap clientCpuCalcRequests = new HashMap();
    private static HashMap serverMBeanSharedCalcCache = new HashMap();
    private static final String DATASOURCE_KEY = "DataSource";
    private static final String SESSION_KEY = "Session";
    private static final String THREAD_POOL_KEY = "ThreadPool";
    private static HashMap serverDSConfigCache = new HashMap();
    private static HashMap serverOrbThreadPoolConfigCache = new HashMap();
    private static HashMap serverServletEngineThreadPoolConfigCache = new HashMap();
    private static HashMap serverSessionConfigCache = new HashMap();
    private static HashMap sharedSystemCalcCache = new HashMap();
    private static AdminService as = AdminServiceFactory.getAdminService();
    private static String processType = null;
    private static String nodeAgentName = null;
    private static HashMap logCalcs = new HashMap();

    public static void storePersistedCalcConfigMap(String string, String string2, HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storePersistedCalcConfigMap", new String[]{string, string2});
        }
        String string3 = CalcCreator.persistedCalcKey(string, string2);
        logCalcs.put(string3, hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storePersistedCalcConfigMap");
        }
    }

    private static HashMap getPersistedCalcConfigMap(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPersistedCalcConfigMap", new String[]{string, string2});
        }
        String string3 = CalcCreator.persistedCalcKey(string, string2);
        HashMap hashMap = (HashMap)logCalcs.get(string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPersistedCalcConfigMap - found map: " + (hashMap != null));
        }
        return hashMap;
    }

    private static String persistedCalcKey(String string, String string2) {
        int n = string.lastIndexOf(".");
        String string3 = string;
        if (n > 0) {
            string3 = string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(string2).append("#").append(string3);
        return stringBuffer.toString();
    }

    public static IOrbThreadPoolConfigCachedCalc createOrbConfigCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOrbConfigCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createOrbConfigCalc");
                }
                return (IOrbThreadPoolConfigCachedCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientOrbConfigCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createOrbConfigCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            ServerROrbThreadPoolConfigCalc serverROrbThreadPoolConfigCalc = new ServerROrbThreadPoolConfigCalc();
            if (ruleType.hasLog()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createOrbConfigCalc - has logfile: " + ruleType.getLog());
                }
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), serverROrbThreadPoolConfigCalc.getClass().getName());
                serverROrbThreadPoolConfigCalc.init(ruleType.getLog(), hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createOrbConfigCalc");
            }
            return serverROrbThreadPoolConfigCalc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createOrbConfigCalc - caught exception, returning null");
        }
        return null;
    }

    public static IServletEngineThreadPoolConfigCachedCalc createWebAppConfigCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createWebAppConfigCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createWebAppConfigCalc");
                }
                return (IServletEngineThreadPoolConfigCachedCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientWebAppConfigCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createWebAppConfigCalc - caught Exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            ServerRServletEngineThreadPoolConfigCalc serverRServletEngineThreadPoolConfigCalc = new ServerRServletEngineThreadPoolConfigCalc();
            if (ruleType.hasLog()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createWebAppConfigCalc - has logfile: " + ruleType.getLog());
                }
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), serverRServletEngineThreadPoolConfigCalc.getClass().getName());
                serverRServletEngineThreadPoolConfigCalc.init(ruleType.getLog(), hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createWebAppConfigCalc");
            }
            return serverRServletEngineThreadPoolConfigCalc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createWebAppConfigCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static ISessionConfigCachedCalc createSessionConfigCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSessionConfigCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSessionConfigCalc");
                }
                return (ISessionConfigCachedCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientSessionConfigCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSessionConfigCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            ServerRSessionConfigCalc serverRSessionConfigCalc = new ServerRSessionConfigCalc();
            if (ruleType.hasLog()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createSessionConfigCalc - has logfile: " + ruleType.getLog());
                }
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), serverRSessionConfigCalc.getClass().getName());
                serverRSessionConfigCalc.init(ruleType.getLog(), hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSessionConfigCalc");
            }
            return serverRSessionConfigCalc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSessionConfigCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IDataSourceConfigCachedCalc createJdbcDataSourceConfigCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJdbcDataSourceConfigCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJdbcDataSourceConfigCalc");
                }
                return (IDataSourceConfigCachedCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientDataSourceConfigCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJdbcDataSourceConfigCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            ServerRDataSourceConfig serverRDataSourceConfig = new ServerRDataSourceConfig();
            if (ruleType.hasLog()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "createJdbcDataSourceConfigCalc - has logfile: " + ruleType.getLog());
                }
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), serverRDataSourceConfig.getClass().getName());
                serverRDataSourceConfig.init(ruleType.getLog(), hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createJdbcDataSourceConfigCalc");
            }
            return serverRDataSourceConfig;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJdbcDataSourceConfigCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IMemoryCalc createMemoryCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMemoryCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createMemoryCalc");
                }
                return (IMemoryCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientMemoryCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createMemoryCalc - caught Exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IMemoryCalc iMemoryCalc = (IMemoryCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientMemoryCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createMemoryCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iMemoryCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createMemoryCalc");
                }
                return iMemoryCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createMemoryCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createMemoryCalc");
            }
            return new ServerMemoryCalc();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMemoryCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IModuleChildDataPointCalc createModuleChildDataPointCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModuleChildDataPointCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createModuleChildDataPointCalc");
                }
                return (IModuleChildDataPointCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientModuleChildDataPointCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createModuleChildDataPointCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IModuleChildDataPointCalc iModuleChildDataPointCalc = (IModuleChildDataPointCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientModuleChildDataPointCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "creageModuleChildDataPoingCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iModuleChildDataPointCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createModuleChildDataPointCalc");
                }
                return iModuleChildDataPointCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createModuleChildDataPointCalc - caught exception returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createModuleChildDataPointCalc");
            }
            return new ServerModuleChildDataPointCalc();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModuleChildDataPointCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IBasicDataPointCalc createBasicDataPointCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBasicDataPointCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointCalc");
                }
                return (IBasicDataPointCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientBasicDataPointCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IBasicDataPointCalc iBasicDataPointCalc = (IBasicDataPointCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientBasicDataPointCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createBasicDataPointCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iBasicDataPointCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointCalc");
                }
                return iBasicDataPointCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBasicDataPointCalc");
            }
            return new ServerBasicDataPointCalc();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicDataPointCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IBasicDataPointHistoryCalc createBasicDataPointHistoryCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBasicDataPointHistoryCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointHistoryCalc");
                }
                return (IBasicDataPointHistoryCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientBasicDataPointHistoryCalc").newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IBasicDataPointHistoryCalc iBasicDataPointHistoryCalc = (IBasicDataPointHistoryCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientBasicDataPointHistoryCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createBasicDataPointHistoryCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iBasicDataPointHistoryCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointHistoryCalc");
                }
                return iBasicDataPointHistoryCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointHistoryCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBasicDataPointHistoryCalc");
            }
            return new ServerBasicDataPointHistoryCalc();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicDataPointHistoryCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IBasicDataPointHistoryTimeCalc createBasicDataPointHistoryTimeCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBasicDataPointHistoryTimeCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointHistoryTimeCalc");
                }
                return (IBasicDataPointHistoryTimeCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientBasicDataPointHistoryTimeCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointHistoryTimeCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IBasicDataPointHistoryTimeCalc iBasicDataPointHistoryTimeCalc = (IBasicDataPointHistoryTimeCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientBasicDataPointHistoryTimeCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createBasicDataPointHistoryTimeCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iBasicDataPointHistoryTimeCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointHistoryTimeCalc");
                }
                return iBasicDataPointHistoryTimeCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createBasicDataPointHistoryTimeCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createBasicDataPointHistoryTimeCalc");
            }
            return new ServerBasicDataPointHistoryTimeCalc();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicDataPointHistoryTimeCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IRateIncreaseCalc createRateIncreaseCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRateIncreaseCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createRateIncreaseCalc");
                }
                return (IRateIncreaseCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientRateIncreaseCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createRateIncreaseCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IRateIncreaseCalc iRateIncreaseCalc = (IRateIncreaseCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientRateIncreaseCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createRateIncreaseCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iRateIncreaseCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createRateIncreaseCalc");
                }
                return iRateIncreaseCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createRateIncreaseCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRateIncreaseCalc");
            }
            return new ServerRateIncreaseCalc();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRateIncreaseCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static ISummaryPeriodCalc createSummaryPeriodCalc(String string) {
        if (string.equalsIgnoreCase("client")) {
            try {
                return (ISummaryPeriodCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientSummaryPeriodCalc").newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (string.equalsIgnoreCase("server")) {
            return new ServerSummaryPeriodCalc();
        }
        return null;
    }

    public static ICpuCalc createCpuCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCpuCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCpuCalc");
                }
                return (ICpuCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientCpuCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCpuCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                ICpuCalc iCpuCalc = (ICpuCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientCpuCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createCpuCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iCpuCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCpuCalc");
                }
                return iCpuCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCpuCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createCpuCalc");
            }
            return new ServerCpuCalc();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCpuCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IJvmConfigCachedCalc createJvmConfigCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJvmConfigCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmConfigCalc");
                }
                return (IJvmConfigCachedCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientJVMConfigCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmConfigCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IJvmConfigCachedCalc iJvmConfigCachedCalc = (IJvmConfigCachedCalc)Class.forName("com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRJvmConfigCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createJvmConfigCalc - has logfile: " + ruleType.getLog());
                    }
                    HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), iJvmConfigCachedCalc.getClass().getName());
                    iJvmConfigCachedCalc.init(ruleType.getLog(), hashMap);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmConfigCalc");
                }
                return iJvmConfigCachedCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmConfigCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (string.equalsIgnoreCase("server")) {
            return new ServerRJvmConfigCalc();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJvmConfigCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IServicesConfigCachedCalc createServicesConfigCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServicesConfigCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("thin_client")) {
            try {
                ServerRServicesConfigCalc serverRServicesConfigCalc = new ServerRServicesConfigCalc();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createServicesConfigCalc - has logfile: " + ruleType.getLog());
                    }
                    HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), serverRServicesConfigCalc.getClass().getName());
                    serverRServicesConfigCalc.init(ruleType.getLog(), hashMap);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createServicesConfigCalc");
                }
                return serverRServicesConfigCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createServicesConfigCalc - caught exception, returning null : " + exception.toString());
                    exception.printStackTrace();
                }
                return null;
            }
        }
        if (string.equalsIgnoreCase("server")) {
            return new ServerRServicesConfigCalc();
        }
        return null;
    }

    public static IDynamicCacheConfigCachedCalc createDynamicCacheConfigCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDynamicCacheConfigCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createDynamicCacheConfigCalc");
                }
                return (IDynamicCacheConfigCachedCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientDynamicCacheConfigCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createDynamicCacheConfigCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IDynamicCacheConfigCachedCalc iDynamicCacheConfigCachedCalc = (IDynamicCacheConfigCachedCalc)Class.forName("com.ibm.ws.performance.tuning.serverAlert.calc.config.ServerRDynamicCacheConfigCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createDynamicCacheConfigCalc - has logfile: " + ruleType.getLog());
                    }
                    HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), iDynamicCacheConfigCachedCalc.getClass().getName());
                    iDynamicCacheConfigCachedCalc.init(ruleType.getLog(), hashMap);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createDynamicCacheConfigCalc");
                }
                return iDynamicCacheConfigCachedCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createDynamicCacheConfigCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDynamicCacheConfigCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static ICacheCalc createCacheCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCacheCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCacheCalc");
                }
                return (ICacheCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientCacheCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCacheCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                ICacheCalc iCacheCalc = (ICacheCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientCacheCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createCacheCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iCacheCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCacheCalc");
                }
                return iCacheCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCacheCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCacheCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static IJvmpiCalc createJvmpiCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJvmpiCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmpiCalc");
                }
                return (IJvmpiCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientJvmpiCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmpiCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                IJvmpiCalc iJvmpiCalc = (IJvmpiCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientJvmpiCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createJvmpiCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iJvmpiCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmpiCalc");
                }
                return iJvmpiCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmpiCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("server")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmpiCalc");
                }
                return (IJvmpiCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientJvmpiCalc").newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Could not instantiate the ClientJvmpiCalc");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not instantiate the ClientJvmpiCalc.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createJvmpiCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJvmpiCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static ISessionCalc createSessionCalc(String string) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSessionCalc", string);
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("client")) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSessionCalc");
                }
                return (ISessionCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientSessionCalc").newInstance();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSessionCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            try {
                ISessionCalc iSessionCalc = (ISessionCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientSessionCalc").newInstance();
                if (ruleType.hasLog()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createSessionCalc - has logfile: " + ruleType.getLog());
                    }
                    ((ILogReadingCalc)((Object)iSessionCalc)).setLogName(ruleType.getLog());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSessionCalc");
                }
                return iSessionCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSessionCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSessionCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static void sharedCalcsClearHistory() {
        if (serverCpuCalcCache.size() > 0) {
            Iterator iterator = serverCpuCalcCache.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                ICpuSharedCalc iCpuSharedCalc = (ICpuSharedCalc)serverCpuCalcCache.get(k);
                iCpuSharedCalc.clearHistory();
            }
        }
    }

    public static void updateRPASharedCalcs() {
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        CalcCreator.gcCache(serverCpuCalcCache, serverCpuCalcRequests);
                        CalcCreator.callUpdate(serverMBeanSharedCalcCache);
                        return null;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return null;
                    }
                }
            };
            SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.adminClient", exception);
            exception.printStackTrace();
            return;
        }
    }

    public static void updateSharedCalcs() {
        CalcCreator.gcCache(clientCpuCalcCache, clientCpuCalcRequests);
        CalcCreator.callUpdate(serverMBeanSharedCalcCache);
    }

    private static void callUpdate(HashMap hashMap) {
        if (hashMap.size() > 0) {
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ISharedCalc iSharedCalc = (ISharedCalc)hashMap.get(iterator.next());
                iSharedCalc.update();
            }
        }
    }

    private static void gcCache(HashMap hashMap, HashMap hashMap2) {
        Tr.entry(tc, "gcCache");
        if (hashMap.size() > 0) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                int n = (Integer)hashMap2.get(k);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CaclCreator.gcCache clients : " + n);
                }
                if (n == 0) {
                    iterator.remove();
                    hashMap2.remove(k);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "CaclCreator.gcCache removed : " + (ICpuSharedCalc)hashMap.get(k));
                    continue;
                }
                hashMap2.put(k, new Integer(0));
                ICpuSharedCalc iCpuSharedCalc = (ICpuSharedCalc)hashMap.get(k);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CaclCreator.gcCache myCalc : " + iCpuSharedCalc);
                }
                iCpuSharedCalc.update();
            }
        }
        Tr.exit(tc, "gcCache");
    }

    public static void clearClientCalcCache() {
        clientCpuCalcCache = new HashMap();
    }

    public static IOrbThreadPoolConfigCachedCalc getOrbThreadPoolConfigCachedCalc(String string, String string2, String string3) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOrbThreadPoolConfigCachedCalc", new String[]{string, string2, string3});
        }
        if ((ruleType = new RuleType(string)).hasLog() && ruleType.equalsIgnoreCase("thin_client")) {
            String string4 = ruleType.getLog();
            if (!serverOrbThreadPoolConfigCache.containsKey(string4)) {
                ServerROrbThreadPoolConfigCalc serverROrbThreadPoolConfigCalc = new ServerROrbThreadPoolConfigCalc();
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), serverROrbThreadPoolConfigCalc.getClass().getName());
                serverROrbThreadPoolConfigCalc.init(ruleType.getLog(), hashMap);
                serverOrbThreadPoolConfigCache.put(string4, serverROrbThreadPoolConfigCalc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOrbThreadPoolConfigCachedCalc");
            }
            return (IOrbThreadPoolConfigCachedCalc)serverOrbThreadPoolConfigCache.get(string4);
        }
        if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            String string5 = string2 + string3;
            if (!serverOrbThreadPoolConfigCache.containsKey(string5)) {
                serverOrbThreadPoolConfigCache.put(string5, CalcCreator.createServerOrbThreadPoolConfigCachedCalc(string2, string3));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOrbThreadPoolConfigCachedCalc");
            }
            return (IOrbThreadPoolConfigCachedCalc)serverOrbThreadPoolConfigCache.get(string5);
        }
        if (ruleType.equalsIgnoreCase("client")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOrbThreadPoolConfigCachedCalc - client rule, returning null");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOrbThreadPoolConfigCachedCalc - wrong ruletype, returning null");
        }
        return null;
    }

    private static ServerROrbThreadPoolConfigCalc createServerOrbThreadPoolConfigCachedCalc(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerOrbThreadPoolConfigCachedCalc", new String[]{string, string2});
        }
        ServerROrbThreadPoolConfigCalc serverROrbThreadPoolConfigCalc = new ServerROrbThreadPoolConfigCalc();
        serverROrbThreadPoolConfigCalc.init(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerOrbThreadPoolConfigCachedCalc");
        }
        return serverROrbThreadPoolConfigCalc;
    }

    public static IServletEngineThreadPoolConfigCachedCalc getServletEngineThreadPoolConfigCachedCalc(String string, String string2, String string3) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServletEngineThreadPoolConfigCachedCalc", new String[]{string, string2, string3});
        }
        if ((ruleType = new RuleType(string)).hasLog() && ruleType.equalsIgnoreCase("thin_client")) {
            String string4 = ruleType.getLog();
            if (!serverServletEngineThreadPoolConfigCache.containsKey(string4)) {
                ServerRServletEngineThreadPoolConfigCalc serverRServletEngineThreadPoolConfigCalc = new ServerRServletEngineThreadPoolConfigCalc();
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), serverRServletEngineThreadPoolConfigCalc.getClass().getName());
                serverRServletEngineThreadPoolConfigCalc.init(ruleType.getLog(), hashMap);
                serverServletEngineThreadPoolConfigCache.put(string4, serverRServletEngineThreadPoolConfigCalc);
            }
            return (IServletEngineThreadPoolConfigCachedCalc)serverServletEngineThreadPoolConfigCache.get(string4);
        }
        if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            String string5 = string2 + string3;
            if (!serverServletEngineThreadPoolConfigCache.containsKey(string5)) {
                serverServletEngineThreadPoolConfigCache.put(string5, CalcCreator.createServerServletEngineThreadPoolConfigCalc(string2, string3));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServletEngineThreadPoolConfigCachedCalc");
            }
            return (IServletEngineThreadPoolConfigCachedCalc)serverServletEngineThreadPoolConfigCache.get(string5);
        }
        if (ruleType.equalsIgnoreCase("client")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServletEngineThreadPoolConfigCachedCalc - client rule, returning null");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServletEngineThreadPoolConfigCachedCalc - wrong ruletype, returning null");
        }
        return null;
    }

    private static ServerRServletEngineThreadPoolConfigCalc createServerServletEngineThreadPoolConfigCalc(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerServletEngineThreadPoolConfigCalc", new String[]{string, string2});
        }
        ServerRServletEngineThreadPoolConfigCalc serverRServletEngineThreadPoolConfigCalc = new ServerRServletEngineThreadPoolConfigCalc();
        serverRServletEngineThreadPoolConfigCalc.init(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerServletEngineThreadPoolConfigCalc");
        }
        return serverRServletEngineThreadPoolConfigCalc;
    }

    public static IDataSourceConfigCachedCalc getDataSourceConfigCachedCalc(String string, String string2, String string3) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataSourceConfigCachedCalc", new String[]{string, string2, string3});
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            String string4 = string2 + string3;
            if (!serverDSConfigCache.containsKey(string4)) {
                serverDSConfigCache.put(string4, CalcCreator.createServerDataSourceConfigCachedCalc(string2, string3));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDataSourceConfigCachedCalc");
            }
            return (IDataSourceConfigCachedCalc)serverDSConfigCache.get(string4);
        }
        if (ruleType.equalsIgnoreCase("client")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDataSourceConfigCachedCalc - client rule, returning null");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataSourceConfigCachedCalc - wrong ruletype, returning null");
        }
        return null;
    }

    private static ServerRDataSourceConfig createServerDataSourceConfigCachedCalc(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerDataSourceConfigCachedCalc", new String[]{string, string2});
        }
        ServerRDataSourceConfig serverRDataSourceConfig = new ServerRDataSourceConfig();
        serverRDataSourceConfig.init(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerDataSourceConfigCachedCalc");
        }
        return serverRDataSourceConfig;
    }

    public static ISessionConfigCachedCalc getSessionConfigCachedCalc(String string, String string2, String string3) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionConfigCachedCalc", new String[]{string, string2, string3});
        }
        if ((ruleType = new RuleType(string)).hasLog() && ruleType.equalsIgnoreCase("thin_client")) {
            String string4 = ruleType.getLog();
            if (!serverSessionConfigCache.containsKey(string4)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSessionConfigCachedCalc - has logfile: " + ruleType.getLog());
                }
                ServerRSessionConfigCalc serverRSessionConfigCalc = new ServerRSessionConfigCalc();
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), serverRSessionConfigCalc.getClass().getName());
                serverRSessionConfigCalc.init(ruleType.getLog(), hashMap);
                serverSessionConfigCache.put(ruleType.getLog(), serverRSessionConfigCalc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSessionConfigCachedCalc");
            }
            return (ISessionConfigCachedCalc)serverSessionConfigCache.get(ruleType.getLog());
        }
        if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            String string5 = string2 + string3;
            if (!serverSessionConfigCache.containsKey(string5)) {
                serverSessionConfigCache.put(string5, CalcCreator.createServerSessionConfigCachedCalc(string2, string3));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSessionConfigCachedCalc");
            }
            return (ISessionConfigCachedCalc)serverSessionConfigCache.get(string5);
        }
        if (ruleType.equalsIgnoreCase("client")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSessionConfigCachedCalc - client rule, returning null");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionConfigCachedCalc - wrong ruletype, returning null");
        }
        return null;
    }

    private static ServerRSessionConfigCalc createServerSessionConfigCachedCalc(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSessionConfigCachedCalc", new String[]{string, string2});
        }
        ServerRSessionConfigCalc serverRSessionConfigCalc = new ServerRSessionConfigCalc();
        serverRSessionConfigCalc.init(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSessionConfigCachedCalc");
        }
        return serverRSessionConfigCalc;
    }

    public static ICpuSharedCalc getCpuCachedCalc(String string, String string2, String string3, int n) {
        return CalcCreator.getCpuCachedCalc(string, null, string2, string3, n);
    }

    public static ICpuSharedCalc getCpuCachedCalc(String string, String string2, String string3, String string4, int n) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCpuCachedCalc", new String[]{string, string2, string3, string4});
        }
        if ((ruleType = new RuleType(string)).equalsIgnoreCase("server")) {
            Integer n2 = new Integer(n);
            if (serverCpuCalcRequests.containsKey(n2)) {
                serverCpuCalcRequests.put(n2, new Integer((Integer)serverCpuCalcRequests.get(n2) + 1));
            } else {
                serverCpuCalcRequests.put(n2, new Integer(1));
            }
            ICpuSharedCalc iCpuSharedCalc = (ICpuSharedCalc)serverCpuCalcCache.get(n2);
            if (iCpuSharedCalc == null) {
                iCpuSharedCalc = CalcCreator.createServerCpuCachedCalc(string3, string4, n);
                serverCpuCalcCache.put(n2, iCpuSharedCalc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCpuCachedCalc");
            }
            return iCpuSharedCalc;
        }
        if (ruleType.equalsIgnoreCase("thin_client")) {
            Object object = null;
            object = ruleType.hasLog() ? string2 + "#" + ruleType.getLog() : new Integer(n);
            if (clientCpuCalcRequests.containsKey(object)) {
                clientCpuCalcRequests.put(object, new Integer((Integer)clientCpuCalcRequests.get(object) + 1));
            } else {
                clientCpuCalcRequests.put(object, new Integer(1));
            }
            ICpuSharedCalc iCpuSharedCalc = (ICpuSharedCalc)clientCpuCalcCache.get(object);
            if (iCpuSharedCalc == null) {
                iCpuSharedCalc = CalcCreator.createClientCpuCachedCalc(string2, string3, string4, ruleType.getLog(), n);
                clientCpuCalcCache.put(object, iCpuSharedCalc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCpuCachedCalc");
            }
            return iCpuSharedCalc;
        }
        if (ruleType.equalsIgnoreCase("client")) {
            String string5 = string3 + n;
            ICpuSharedCalc iCpuSharedCalc = null;
            iCpuSharedCalc = (ICpuSharedCalc)clientCpuCalcCache.get(string5);
            if (iCpuSharedCalc == null) {
                try {
                    iCpuSharedCalc = (ICpuSharedCalc)Class.forName("com.ibm.websphere.pmi.ra.advisor.calc.ClientCpuCachedCalcNew").newInstance();
                    iCpuSharedCalc.init(string3, string4, n);
                    clientCpuCalcCache.put(string5, iCpuSharedCalc);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCpuCachedCalc - client rule, caught exception, returning null");
                    }
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCpuCachedCalc");
            }
            return iCpuSharedCalc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCpuCachedCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static ICpuSharedCalc getCpuCachedCalc(String string, String string2, String string3, String string4) {
        return CalcCreator.getCpuCachedCalc(string, string2, string3, string4, EngineParameters.getCalcInterval());
    }

    private static ICpuSharedCalc createServerCpuCachedCalc(String string, String string2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerCpuCachedCalc", new String[]{string, string2});
        }
        ICpuSharedCalc iCpuSharedCalc = null;
        if (EngineParameters.getProcessType().equals("UnManagedProcess")) {
            iCpuSharedCalc = new ServerCpuSharedCalc();
            iCpuSharedCalc.init(string, string2, n);
        } else if (EngineParameters.getProcessType().equals("ManagedProcess")) {
            iCpuSharedCalc = new ServerCpuSharedCalc_ND();
            iCpuSharedCalc.init(string, string2, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerCpuCachedCalc");
        }
        return iCpuSharedCalc;
    }

    private static ICpuSharedCalc createClientCpuCachedCalc(String string, String string2, String string3, String string4, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClientCpuCachedCalc", new String[]{string, string2, string3});
        }
        ICpuSharedCalc iCpuSharedCalc = null;
        if (string4 != null) {
            try {
                iCpuSharedCalc = (ICpuSharedCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientCpuCachedCalc").newInstance();
                iCpuSharedCalc.setUserId(string);
                ((ILogReadingCalc)((Object)iCpuSharedCalc)).setLogName(string4);
                iCpuSharedCalc.init(string2, string3, n);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createClientCpuCachedCalc");
                }
                return iCpuSharedCalc;
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createClientCpuCachedCalc - caught exception, returning null");
                }
                return null;
            }
        }
        if (processType == null) {
            CalcCreator.setProcessType();
        }
        if (processType.equals("NodeAgent")) {
            try {
                iCpuSharedCalc = (ICpuSharedCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientCpuCachedCalc").newInstance();
                iCpuSharedCalc.setUserId(string);
                iCpuSharedCalc.init(string2, nodeAgentName, n);
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createClientCpuCachedCalc - caught exception, returning null");
                }
                return null;
            }
        }
        try {
            iCpuSharedCalc = (ICpuSharedCalc)Class.forName("com.ibm.ws.tpv.advisor.calc.ClientCpuCachedCalc").newInstance();
            iCpuSharedCalc.setUserId(string);
            iCpuSharedCalc.init(string2, string3, n);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createClientCpuCachedCalc - caught exception, returning null");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClientCpuCachedCalc");
        }
        return iCpuSharedCalc;
    }

    public static IDataSourceMBeanSharedCalc getDataSourceMBeanSharedCalc(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataSourceMBeanSharedCalc", new String[]{string, string2, string3});
        }
        RuleType ruleType = new RuleType(string3);
        try {
            if (ruleType.equalsIgnoreCase("client")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataSourceMBeanSharedCalc - client rule, returning null");
                }
                return null;
            }
            if (ruleType.hasLog() && ruleType.equalsIgnoreCase("thin_client")) {
                String string4 = ruleType.getLog() + DATASOURCE_KEY;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDatasourceMBeanSharedCalc - has logfile: " + ruleType.getLog());
                }
                if (!serverMBeanSharedCalcCache.containsKey(string4)) {
                    ServerDataSourceMBeanCalc serverDataSourceMBeanCalc = new ServerDataSourceMBeanCalc();
                    HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), ServerDataSourceMBeanCalc.class.getName());
                    serverDataSourceMBeanCalc.init(ruleType.getLog(), hashMap);
                    serverMBeanSharedCalcCache.put(string4, serverDataSourceMBeanCalc);
                    IDataSourceConfigCachedCalc iDataSourceConfigCachedCalc = CalcCreator.createJdbcDataSourceConfigCalc(string3);
                    serverDataSourceMBeanCalc.setBackUp(iDataSourceConfigCachedCalc);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataSourceMBeanSharedCalc");
                }
                return (IDataSourceMBeanSharedCalc)serverMBeanSharedCalcCache.get(string4);
            }
            if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
                String string5 = string + string2 + DATASOURCE_KEY;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "key :" + string5);
                }
                if (!serverMBeanSharedCalcCache.containsKey(string5)) {
                    ServerDataSourceMBeanCalc serverDataSourceMBeanCalc = new ServerDataSourceMBeanCalc();
                    serverDataSourceMBeanCalc.init(string, string2);
                    IDataSourceConfigCachedCalc iDataSourceConfigCachedCalc = CalcCreator.createJdbcDataSourceConfigCalc(string3);
                    iDataSourceConfigCachedCalc.init(string, string2);
                    serverDataSourceMBeanCalc.setBackUp(iDataSourceConfigCachedCalc);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "newCalc :" + serverDataSourceMBeanCalc);
                    }
                    serverMBeanSharedCalcCache.put(string5, serverDataSourceMBeanCalc);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "dataSourceMBeanSharedCalc :" + serverMBeanSharedCalcCache.get(string5));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDataSourceMBeanSharedCalc");
                }
                return (IDataSourceMBeanSharedCalc)serverMBeanSharedCalcCache.get(string5);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unknown rule, returns null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDataSourceMBeanSharedCalc - wrong ruletype, returning null");
            }
            return null;
        }
        catch (Exception exception) {
            System.out.println("CalcCreator could not getDataSourceMBeanSharedCalc for  " + string + " " + string2 + " " + string3);
            exception.printStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDataSourceMBeanSharedCalc - caught exception, returning null");
            }
            return null;
        }
    }

    public static IThreadPoolMBeanSharedCalc getThreadPoolMBeanSharedCalc(String string, String string2, String string3) {
        RuleType ruleType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPoolMBeanSharedCalc", new String[]{string, string2, string3});
        }
        if ((ruleType = new RuleType(string3)).equalsIgnoreCase("client")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getThreadPoolMBeanSharedCalc - client rule, returning null");
            }
            return null;
        }
        if (ruleType.hasLog() && ruleType.equalsIgnoreCase("thin_client")) {
            String string4 = ruleType.getLog() + THREAD_POOL_KEY;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getThreadPoolMBeanSharedCalc - has logfile: " + ruleType.getLog());
            }
            if (!serverMBeanSharedCalcCache.containsKey(string4)) {
                ServerThreadPoolMBeanCalc serverThreadPoolMBeanCalc = new ServerThreadPoolMBeanCalc();
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), ServerThreadPoolMBeanCalc.class.getName());
                serverThreadPoolMBeanCalc.init(ruleType.getLog(), hashMap);
                serverMBeanSharedCalcCache.put(string4, serverThreadPoolMBeanCalc);
                IServletEngineThreadPoolConfigCachedCalc iServletEngineThreadPoolConfigCachedCalc = CalcCreator.createWebAppConfigCalc(string3);
                IOrbThreadPoolConfigCachedCalc iOrbThreadPoolConfigCachedCalc = CalcCreator.createOrbConfigCalc(string3);
                serverThreadPoolMBeanCalc.setBackUp(iOrbThreadPoolConfigCachedCalc, iServletEngineThreadPoolConfigCachedCalc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getThreadPoolMBeanSharedCalc");
            }
            return (IThreadPoolMBeanSharedCalc)serverMBeanSharedCalcCache.get(string4);
        }
        if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
            String string5 = string + string2 + THREAD_POOL_KEY;
            if (!serverMBeanSharedCalcCache.containsKey(string5)) {
                ServerThreadPoolMBeanCalc serverThreadPoolMBeanCalc = new ServerThreadPoolMBeanCalc();
                serverThreadPoolMBeanCalc.init(string, string2);
                IServletEngineThreadPoolConfigCachedCalc iServletEngineThreadPoolConfigCachedCalc = CalcCreator.createWebAppConfigCalc(string3);
                iServletEngineThreadPoolConfigCachedCalc.init(string, string2);
                IOrbThreadPoolConfigCachedCalc iOrbThreadPoolConfigCachedCalc = CalcCreator.createOrbConfigCalc(string3);
                iOrbThreadPoolConfigCachedCalc.init(string, string2);
                serverThreadPoolMBeanCalc.setBackUp(iOrbThreadPoolConfigCachedCalc, iServletEngineThreadPoolConfigCachedCalc);
                serverMBeanSharedCalcCache.put(string5, serverThreadPoolMBeanCalc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getThreadPoolMBeanSharedCalc");
            }
            return (IThreadPoolMBeanSharedCalc)serverMBeanSharedCalcCache.get(string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPoolMBeanSharedCalc - wrong ruletype, returning null");
        }
        return null;
    }

    public static ISessionMBeanSharedCalc getSessionMBeanSharedCalc(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionMBeanSharedCalc", new String[]{string, string2, string3});
        }
        try {
            RuleType ruleType = new RuleType(string3);
            String string4 = null;
            if (ruleType.equalsIgnoreCase("client")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSessionMBeanSharedCalc - client rule, returning null");
                }
                return null;
            }
            if (ruleType.hasLog() && ruleType.equalsIgnoreCase("thin_client")) {
                string4 = ruleType.getLog() + SESSION_KEY;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSessionMBeanSharedCalc - has logfile: " + ruleType.getLog());
                }
                if (!serverMBeanSharedCalcCache.containsKey(string4)) {
                    ServerSessionMBeanCalc serverSessionMBeanCalc = new ServerSessionMBeanCalc();
                    HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), ServerSessionMBeanCalc.class.getName());
                    serverSessionMBeanCalc.init(ruleType.getLog(), hashMap);
                    serverMBeanSharedCalcCache.put(string4, serverSessionMBeanCalc);
                    ISessionConfigCachedCalc iSessionConfigCachedCalc = CalcCreator.createSessionConfigCalc(string3);
                    serverSessionMBeanCalc.setBackUp(iSessionConfigCachedCalc);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSessionMBeanSharedCalc");
                }
                return (ISessionMBeanSharedCalc)serverMBeanSharedCalcCache.get(string4);
            }
            if (ruleType.equalsIgnoreCase("server") || ruleType.equalsIgnoreCase("thin_client")) {
                string4 = string + string2 + SESSION_KEY;
                if (!serverMBeanSharedCalcCache.containsKey(string4)) {
                    ServerSessionMBeanCalc serverSessionMBeanCalc = new ServerSessionMBeanCalc();
                    serverSessionMBeanCalc.init(string, string2);
                    ISessionConfigCachedCalc iSessionConfigCachedCalc = CalcCreator.createSessionConfigCalc(string3);
                    iSessionConfigCachedCalc.init(string, string2);
                    serverSessionMBeanCalc.setBackUp(iSessionConfigCachedCalc);
                    serverMBeanSharedCalcCache.put(string4, serverSessionMBeanCalc);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSessionMBeanSharedCalc");
                }
                return (ISessionMBeanSharedCalc)serverMBeanSharedCalcCache.get(string4);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSessionMBeanSharedCalc - wrong ruletype, returning null");
            }
            return null;
        }
        catch (Exception exception) {
            System.out.println("CalcCreator could not getSessionMBeanSharedCalc for  " + string + " " + string2 + " " + string3);
            exception.printStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSessionMBeanSharedCalc - caught exception, returning null");
            }
            return null;
        }
    }

    public static ISystemSharedCalc getSystemSharedCalc(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemSharedCalc", new String[]{string, string2, string3});
        }
        RuleType ruleType = new RuleType(string3);
        String string4 = null;
        if (ruleType.hasLog() && ruleType.equalsIgnoreCase("thin_client")) {
            string4 = ruleType.getLog();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getSystemSharedCalc - has logfile: " + ruleType.getLog());
            }
            if (!sharedSystemCalcCache.containsKey(string4)) {
                SystemMBeanCalc systemMBeanCalc = new SystemMBeanCalc();
                HashMap hashMap = CalcCreator.getPersistedCalcConfigMap(ruleType.getLog(), SystemMBeanCalc.class.getName());
                systemMBeanCalc.init(ruleType.getLog(), hashMap);
                sharedSystemCalcCache.put(string4, systemMBeanCalc);
            }
        } else {
            string4 = string + ":" + string2;
            if (!sharedSystemCalcCache.containsKey(string4)) {
                sharedSystemCalcCache.put(string4, CalcCreator.createSystemSharedCalc(string, string2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemSharedCalc");
        }
        return (ISystemSharedCalc)sharedSystemCalcCache.get(string4);
    }

    private static ISystemSharedCalc createSystemSharedCalc(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSystemSharedCalc", new String[]{string, string2});
        }
        SystemMBeanCalc systemMBeanCalc = new SystemMBeanCalc();
        systemMBeanCalc.init(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSystemSharedCalc");
        }
        return systemMBeanCalc;
    }

    private static String setProcessType() {
        try {
            processType = as.getProcessType();
            if (processType == "NodeAgent") {
                nodeAgentName = as.getProcessName();
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Error getting the process type");
        }
        return processType;
    }

    public static void test(String string, String string2) {
        try {
            MBeanJmxHelper mBeanJmxHelper = MBeanJmxHelperFactory.getMBeanJmxHelper(string, string2);
            mBeanJmxHelper.dumpObjectNames();
        }
        catch (Exception exception) {
            System.out.println("testing caught an exception " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static class RuleType {
        private String type = null;
        private String log = null;

        public RuleType(String string) {
            if (string == null) {
                return;
            }
            int n = string.indexOf(35);
            if (n < 0) {
                this.type = string;
                this.log = null;
            } else {
                this.type = string.substring(0, n);
                this.log = string.substring(n + 1);
            }
        }

        public boolean hasLog() {
            return this.log != null;
        }

        public String getType() {
            return this.type;
        }

        public String getLog() {
            return this.log;
        }

        public boolean equalsIgnoreCase(String string) {
            if (this.type == null && string == null) {
                return true;
            }
            if (this.type == null) {
                return false;
            }
            return this.type.equalsIgnoreCase(string);
        }

        public String toString() {
            return "RuleType: type=" + this.type + " log=" + this.log;
        }
    }
}

