/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.calc.cachedCalc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.cachedCalc.ICachedCalc;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelper;
import com.ibm.ws.performance.tuning.serverAlert.util.MBeanJmxHelperFactory;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class AbstractCachedCalc
implements ICachedCalc,
NotificationListener,
NotificationFilter {
    private String node;
    private String server;
    private static transient TraceComponent tc = Tr.register(AbstractCachedCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    protected boolean needToRefresh;
    private transient MBeanJmxHelper jmxHelper;

    public void init(String string, String string2) {
        try {
            Tr.entry(tc, "init");
            this.node = string;
            this.server = string2;
            this.jmxHelper = MBeanJmxHelperFactory.getMBeanJmxHelper(string, string2);
            ObjectName objectName = this.jmxHelper.getRpaNotificationObjectName(this.node, this.server);
            this.needToRefresh = true;
            if (objectName != null) {
                try {
                    this.jmxHelper.addNotification(objectName, this, this, new Object());
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "AbstractCachedCalc could not initialize: " + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "init");
    }

    public boolean isNotificationEnabled(Notification notification) {
        Tr.entry(tc, "isNotificationEnabled");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "    " + this.getClass().getName());
        }
        if (notification.getType() == "UpdateAdvisorCachedCalcsNotificationType") {
            Tr.exit(tc, "isNotificationEnabled - true");
            return true;
        }
        Tr.exit(tc, "isNotificationEnabled - true");
        return false;
    }

    public void handleNotification(Notification notification, Object object) {
        Tr.entry(tc, "handleNotification");
        this.needToRefresh = true;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "   " + this.getClass().getName() + " received notification");
        }
        Tr.exit(tc, "handleNotification");
    }

    public void finalize() {
        block2: {
            Tr.entry(tc, "finalize");
            try {
                this.jmxHelper.removeNotification(this.jmxHelper.getRpaNotificationObjectName(this.node, this.server), this);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "AbstractCachedCalc.finalize could not remove notifciaton : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "finalize");
    }

    public abstract void refreshCache();
}

