/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.leakProtoType_1;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.leakProtoType_1.ICondition;
import com.ibm.ws.performance.tuning.leakProtoType_1.Leaves;
import java.util.ArrayList;
import java.util.Date;

public class DataTree {
    private static TraceComponent tc = Tr.register(DataTree.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    public static final int SUMMARY_MEAN = 0;
    public static final int SUMMARY_MIN = 2;
    public static final int SUMMARY_MAX = 3;
    private static final int PRUNE = 0;
    private static final int SUMMARIZE_UP = 1;
    private static final int SUMMARIZE_DOWN = 2;
    private int maxHeight;
    private int maxLeaves;
    private int[] summaryMechanisms;
    private boolean keepTimes;
    private boolean isCronological;
    private ArrayList[] forest;
    private boolean debug = false;
    private ICondition condition;
    private boolean summarizeUp = true;

    public DataTree(int n, ICondition iCondition, int n2, int n3, int[] nArray, boolean bl, boolean bl2) {
        this.condition = iCondition;
        this.maxHeight = n2;
        this.maxLeaves = n3;
        this.summaryMechanisms = (int[])nArray.clone();
        this.keepTimes = bl;
        this.isCronological = bl2;
        this.forest = new ArrayList[n];
        this.clearData();
    }

    public void setSummaryMech(int n) {
        for (int i = 0; i < this.summaryMechanisms.length; ++i) {
            this.summaryMechanisms[i] = n;
        }
        this.clearData();
    }

    public void setKeepTimes(boolean bl) {
        this.keepTimes = bl;
        this.clearData();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setMaxHeight(int n) {
        this.maxHeight = n;
        this.clearData();
    }

    public void setMaxLeaves(int n) {
        this.maxLeaves = n;
        this.clearData();
    }

    public void clearData() {
        for (int i = 0; i < this.forest.length; ++i) {
            this.forest[i] = new ArrayList();
        }
    }

    public ArrayList[] addData(double[] dArray) throws Exception {
        return this.addData(dArray, 1, false, -1099L, -1099L);
    }

    public ArrayList[] addData(double[] dArray, long l) throws Exception {
        return this.addData(dArray, 1, false, l, l);
    }

    public ArrayList[] addData(double[] dArray, int n, boolean bl, long l, long l2) throws Exception {
        if (n < 1 || n > this.maxHeight) {
            Exception exception = new Exception("DataTree.addData tried to add data at the invalid heigh of " + n + ", the max allowed height is " + this.maxHeight);
            throw exception;
        }
        ArrayList[] arrayListArray = new ArrayList[this.forest.length];
        for (int i = 0; i < this.forest.length; ++i) {
            Leaves leaves;
            arrayListArray[i] = new ArrayList();
            ArrayList arrayList = this.forest[i];
            if (arrayList.size() < n) {
                leaves = new Leaves(n, this.maxLeaves, this.keepTimes, this.isCronological);
                arrayList.add(leaves);
            }
            leaves = (Leaves)arrayList.get(n - 1);
            leaves.addDataPoint(dArray[i], l, l2);
            if (!leaves.isFull()) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "leaves is now full");
            }
            Leaves leaves2 = (Leaves)leaves.clone();
            arrayListArray[i].add(leaves);
        }
        ArrayList[] arrayListArray2 = this.testAndSummarize(arrayListArray);
        return arrayListArray2;
    }

    private ArrayList[] testAndSummarize(ArrayList[] arrayListArray) throws Exception {
        ArrayList[] arrayListArray2 = new ArrayList[arrayListArray.length];
        for (int i = 0; i < arrayListArray.length; ++i) {
            arrayListArray2[i] = new ArrayList();
        }
        ArrayList arrayList = arrayListArray[0];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            int n2;
            Cloneable cloneable;
            Leaves leaves = (Leaves)arrayList.get(i);
            if (leaves.getHeight() == this.maxHeight) {
                this.addCopy(arrayListArray, arrayListArray2, i);
                for (int j = 0; j < arrayListArray.length; ++j) {
                    ((Leaves)arrayListArray[j].get(i)).prune();
                }
                continue;
            }
            double[] dArray = new double[arrayListArray.length];
            for (int j = 0; j < arrayListArray.length; ++j) {
                cloneable = (Leaves)arrayListArray[j].get(i);
                if (this.summaryMechanisms[j] == 2) {
                    dArray[j] = this.summarize_min((Leaves)cloneable);
                    continue;
                }
                if (this.summaryMechanisms[j] == 3) {
                    dArray[j] = this.summarize_max((Leaves)cloneable);
                    continue;
                }
                if (this.summaryMechanisms[j] != 0) continue;
                dArray[j] = this.summarize_mean((Leaves)cloneable);
            }
            ArrayList[] arrayListArray3 = new ArrayList[]{};
            cloneable = new ArrayList();
            for (n2 = 0; n2 < arrayListArray.length; ++n2) {
                ((ArrayList)cloneable).add(arrayListArray[n2].get(i));
            }
            n2 = this.condition.testData(cloneable);
            if (n2 == 1) {
                this.addCopy(arrayListArray, arrayListArray2, i);
                arrayListArray3 = this.addData(dArray, leaves.getHeight() + 1, true, leaves.getStartTime(), leaves.getEndTime());
                for (n = 0; n < arrayListArray.length; ++n) {
                    ((Leaves)arrayListArray[n].get(i)).empty();
                }
            } else if (n2 == 2) {
                long l = ((Leaves)arrayListArray[0].get(i)).getStartTime();
                int n3 = ((Leaves)arrayListArray[0].get(i)).getHeight();
                Date date = new Date(l);
                for (int j = 0; j < arrayListArray.length; ++j) {
                    ((Leaves)arrayListArray[j].get(i)).empty();
                }
                arrayListArray3 = this.addData(dArray, n3, false, l, -1099L);
                ArrayList arrayList2 = arrayListArray3[0];
            } else if (n2 == 0) {
                this.clearData();
            }
            for (n = 0; n < arrayListArray3.length; ++n) {
                arrayListArray2[n].addAll(arrayListArray3[n]);
            }
        }
        return arrayListArray2;
    }

    private void addCopy(ArrayList[] arrayListArray, ArrayList[] arrayListArray2, int n) {
        for (int i = 0; i < arrayListArray.length; ++i) {
            arrayListArray2[i].add(((Leaves)arrayListArray[i].get(n)).clone());
        }
    }

    private double summarize_min(Leaves leaves) {
        double[] dArray = leaves.getDataPoints();
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    private double summarize_max(Leaves leaves) {
        double[] dArray = leaves.getDataPoints();
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    private double summarize_mean(Leaves leaves) {
        double[] dArray = leaves.getDataPoints();
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    private double summarizeDummy(Leaves leaves) {
        double[] dArray = leaves.getDataPoints();
        return dArray[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Sets of data\n");
        for (int i = 0; i < this.forest.length; ++i) {
            stringBuffer.append("DataTree:");
            for (int j = 0; j < this.forest[i].size(); ++j) {
                Leaves leaves = (Leaves)this.forest[i].get(j);
                stringBuffer.append(leaves.toString()).append("\n");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

