/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.leakProtoType_1;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.HeapDumpNotSupportedException;
import com.ibm.websphere.management.exception.HeapDumpOnDiskLimitReachedException;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryTimeCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISystemSharedCalc;
import com.ibm.ws.performance.tuning.leakProtoType_1.ISummaryPeriodCalc;
import com.ibm.ws.performance.tuning.leakProtoType_1.Leaves;
import com.ibm.ws.performance.tuning.leakProtoType_1.MemoryLeakRule;
import com.ibm.ws.performance.tuning.leakProtoType_1.VarableDataCondition;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.serverAlert.AbstractOutputHandler;
import com.ibm.ws.performance.tuning.serverAlert.MBeanNotificationResponse;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class HeapDumpOutputHandler
extends AbstractOutputHandler
implements AlarmListener {
    private boolean isApplicable;
    private static TraceComponent tc = Tr.register(HeapDumpOutputHandler.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    String vendor = "unknown";
    private int numberOfDumps;
    private int dumpCount;
    private Alarm _alarm;
    private int sleepTime;
    private Integer lock;
    private boolean isTakingHeapDumps;
    private ArrayList fileNames;
    private ArrayList manualFileNames;
    private static final String[] jvmModule = new String[]{"jvmRuntimeModule"};
    private static final DataDescriptor jvmDD = new DataDescriptor(jvmModule);
    private static final int JVM_FREE_MEMORY = 2;
    public int policyType;
    public static final String POLICY_TIME = "timeBasedHeapDumpPolicy";
    public static final int POLICY_TIME_TYPE = 1;
    public static final String POLICY_MEMORY = "memoryBasedHeapDumpPolicy";
    public static final int POLICY_MEMORY_TYPE = 2;
    public static final String POLICY_NOTIFICATION = "notificationBasedPolicy";
    public static final int POLICY_NOTIFICATION_TYPE = 3;
    private int heapDifferenceBetweenDumps = 10;
    private boolean selfDisabled;
    private String nodeName;
    private String serverName;
    private RuleOutput ruleOutput;
    private IBasicDataPointHistoryTimeCalc memoryCalc;
    private boolean useAveTrigger = false;
    private ISummaryPeriodCalc summaryCalc;
    private int nextTriggerPoint;
    private int triggerPointHeapSize;
    private int delayTime;
    private MBeanNotificationResponse not;
    private double maxHeap = -102.0;
    private ISystemSharedCalc systemCalc;

    public HeapDumpOutputHandler() {
        this(AdminServiceFactory.getAdminService().getNodeName(), AdminServiceFactory.getAdminService().getProcessName());
    }

    public HeapDumpOutputHandler(String string, String string2) {
        Tr.entry(tc, "HeapDumpOutputHandler");
        this.nodeName = string;
        this.serverName = string2;
        this.numberOfDumps = 1;
        this.dumpCount = 0;
        this.isTakingHeapDumps = false;
        this.lock = new Integer(1);
        this.ruleOutput = null;
        this.fileNames = new ArrayList();
        this.manualFileNames = new ArrayList();
        this.selfDisabled = false;
        this.sleepTime = 30000;
        this.memoryCalc = null;
        this.summaryCalc = null;
        this.setPolicy(3);
        this.isApplicable = this.checkApplicability();
        Tr.exit(tc, "HeapDumpOutputHandler");
    }

    public boolean isApplicable() {
        return this.isApplicable;
    }

    private boolean checkApplicability() {
        Tr.entry(tc, "checkApplicability");
        try {
            Class<?> clazz = Class.forName("com.ibm.jvm.Dump");
            if (clazz != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got com.ibm.jvm.Dump - heap dumps are applicable");
                }
                Tr.exit(tc, "checkApplicability");
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got com.ibm.jvm.Dump - but was null - heap dumps are NOT applicable");
            }
            Tr.exit(tc, "checkApplicability");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caugh class not found exception - heap dumps are NOT applicable");
            }
            Tr.exit(tc, "checkApplicability");
            return false;
        }
    }

    private void initCalcs() {
        if (this.policyType == 2) {
            try {
                if (this.memoryCalc == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "initializing memory calc");
                    }
                    PerfDescriptorImpl perfDescriptorImpl = new PerfDescriptorImpl(this.nodeName, this.serverName, jvmDD);
                    if (this.useAveTrigger) {
                        this.memoryCalc = CalcCreator.createBasicDataPointHistoryTimeCalc("server");
                        this.memoryCalc.init(perfDescriptorImpl, 2);
                    } else {
                        Object object;
                        this.summaryCalc = CalcCreator.createSummaryPeriodCalc("server");
                        PerfDescriptor[] perfDescriptorArray = new PerfDescriptor[2];
                        if (MemoryLeakRule.jvmPD != null) {
                            perfDescriptorArray[0] = MemoryLeakRule.jvmPD;
                            perfDescriptorArray[1] = MemoryLeakRule.jvmPD;
                        } else {
                            object = new PerfDescriptorImpl(this.nodeName, this.serverName, MemoryLeakRule.getJVMDD());
                            perfDescriptorArray[0] = object;
                            perfDescriptorArray[1] = object;
                        }
                        object = new int[]{2, 1};
                        int[] nArray = new int[]{3, 2};
                        VarableDataCondition varableDataCondition = new VarableDataCondition(MemoryLeakRule.minMemoryPercentage);
                        this.summaryCalc.init(perfDescriptorArray, (int[])object, varableDataCondition, 2, MemoryLeakRule.numberLeaves, nArray, false);
                    }
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EXCEPTION caught trying to create memory calc, will disable taking dumps : " + exception.toString());
                    exception.printStackTrace();
                }
                this.stopTakingHeapDumps();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOutput(RuleOutput ruleOutput) {
        Tr.entry(tc, "handleOutput");
        if (!this.isApplicable) {
            block19: {
                if (tc.isDebugEnabled()) {
                    Tr.entry(tc, "this output handler is not applicable for this platform disable");
                }
                try {
                    super.setEnabled(false);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "could not disable : " + exception.toString());
                    exception.printStackTrace();
                }
            }
            return;
        }
        if (!this.passFilterTest(ruleOutput)) {
            return;
        }
        Integer n = this.lock;
        synchronized (n) {
            block20: {
                if (!this.isTakingHeapDumps) {
                    if (this.passAlertLevelTest(ruleOutput)) {
                        Tr.debug(tc, "Received alert will begin taking heap dumps in responce to : " + ruleOutput.toString());
                        this.ruleOutput = ruleOutput;
                        try {
                            this.takeHeapDumps();
                        }
                        catch (HeapDumpOnDiskLimitReachedException heapDumpOnDiskLimitReachedException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "could not handleOutput as the heap dump on disk limit was reached.  Exception caught : " + heapDumpOnDiskLimitReachedException.toString());
                            }
                            break block20;
                        }
                        catch (HeapDumpNotSupportedException heapDumpNotSupportedException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "could not handleOutput as the heap dump was not supported.  Exception caught : " + heapDumpNotSupportedException.toString());
                            }
                            break block20;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Opps No Policy in progress, rule output not alert.  Do nothing");
                    }
                } else {
                    this.ruleOutput = ruleOutput;
                    int n2 = ruleOutput.getOutputType();
                    if (n2 == 106) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "received a canceled alert.  Cancel taking heap dumps");
                        }
                        this.stopTakingHeapDumps();
                    }
                }
            }
        }
        Tr.exit(tc, "handleOutput");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        Tr.entry(tc, "alarm");
        this._alarm = null;
        this.update();
        Integer n = this.lock;
        synchronized (n) {
            if (this.isTakingHeapDumps) {
                this.registerAlarm();
            }
        }
        Tr.exit(tc, "alarm");
    }

    protected synchronized void registerAlarm() {
        Tr.entry(tc, "registerAlarm");
        if (this._alarm == null) {
            if (tc.isDebugEnabled()) {
                Date date = new Date();
                Tr.debug(tc, "HeapDumpOutput Handler registerAlarm registering with alarm at " + date.toString() + " for " + this.sleepTime);
            }
            try {
                this._alarm = AlarmManager.create(this.sleepTime, this);
            }
            catch (Exception exception) {
                Tr.error(tc, "perfalert.couldNotRegister");
                exception.printStackTrace();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "alarm is already registered, will not register again");
        }
        Tr.exit(tc, "registerAlarm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        Tr.entry(tc, "update");
        Integer n = this.lock;
        synchronized (n) {
            if (this.isTakingHeapDumps) {
                Tr.debug(tc, "Heap Dump policy in progress ");
                if (this.policyType == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checking memory policy");
                    }
                    this.checkMemoryTrigger();
                    if (this.useAveTrigger) {
                        if (this.memoryCalc != null) {
                            this.memoryCalc.clear();
                        }
                    } else if (this.summaryCalc != null) {
                        this.summaryCalc.clear();
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "policy is : " + this.getPolicy() + " nothing to do in handleOutput");
                }
            }
        }
        Tr.exit(tc, "update");
    }

    public void setEnabled(boolean bl) throws Exception {
        if (bl && !this.isApplicable) {
            HeapDumpNotSupportedException heapDumpNotSupportedException = new HeapDumpNotSupportedException("Automatic heap dump generation for " + this.vendor + " is not supported", true);
            throw heapDumpNotSupportedException;
        }
        super.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeHeapDumps() throws HeapDumpOnDiskLimitReachedException, HeapDumpNotSupportedException {
        Tr.entry(tc, "takeHeapDumps");
        Integer n = this.lock;
        synchronized (n) {
            block28: {
                if (this.isTakingHeapDumps) {
                    Tr.exit(tc, "takeHeapDumps");
                    return;
                }
                if (!this.isApplicable) {
                    HeapDumpNotSupportedException heapDumpNotSupportedException = new HeapDumpNotSupportedException("Could not take HeapDump as " + this.vendor + " is not supported", true);
                    throw heapDumpNotSupportedException;
                }
                this.isTakingHeapDumps = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "policy type : " + this.policyType + ", " + this.getPolicy());
                }
                if (this.policyType == 2) {
                    this.nextTriggerPoint = -102;
                    this.triggerPointHeapSize = -102;
                    if (this.useAveTrigger) {
                        if (this.memoryCalc == null) {
                            this.initCalcs();
                        }
                        this.memoryCalc.clearHistory();
                    } else {
                        if (this.summaryCalc == null) {
                            this.initCalcs();
                        }
                        this.summaryCalc.clearData();
                    }
                } else if (this.policyType == 1) {
                    // empty if block
                }
                try {
                    this.not.sendHeapDumpProcessNotification(true);
                    String string = this.takeDump();
                    this.fileNames.add(string);
                    ++this.dumpCount;
                    if (this.dumpCount >= this.numberOfDumps) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "reached number of dumps will not register for alarm");
                        }
                        this.stopTakingHeapDumps();
                    } else if (this.policyType == 3) {
                        this.isTakingHeapDumps = false;
                    } else {
                        this.registerAlarm();
                    }
                }
                catch (HeapDumpOnDiskLimitReachedException heapDumpOnDiskLimitReachedException) {
                    block27: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "could not take heap dump will disable the output handler: " + heapDumpOnDiskLimitReachedException.toString());
                        }
                        this.stopTakingHeapDumps();
                        try {
                            super.setEnabled(false);
                            this.selfDisabled = true;
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block27;
                            Tr.debug(tc, "could not disable : " + exception.toString());
                            exception.printStackTrace();
                        }
                    }
                    Tr.exit(tc, "takeHeapDumps");
                    throw heapDumpOnDiskLimitReachedException;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unknown exception caught when taking heap dump : " + exception.toString());
                        exception.printStackTrace();
                    }
                    this.stopTakingHeapDumps();
                    try {
                        super.setEnabled(false);
                        this.selfDisabled = true;
                    }
                    catch (Exception exception2) {
                        if (!tc.isDebugEnabled()) break block28;
                        Tr.debug(tc, "could not disable : " + exception2.toString());
                        exception2.printStackTrace();
                    }
                }
            }
        }
        Tr.exit(tc, "takeHeapDumps");
    }

    private String takeDump() throws HeapDumpOnDiskLimitReachedException, HeapDumpNotSupportedException, Exception {
        Tr.entry(tc, "takeDump");
        if (this.systemCalc == null) {
            this.systemCalc = CalcCreator.getSystemSharedCalc(this.nodeName, this.serverName, "server");
        }
        Tr.exit(tc, "takeDump");
        return this.systemCalc.generateHeapDump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTakingHeapDumps() {
        Tr.entry(tc, "stopTakingHeapDumps");
        Integer n = this.lock;
        synchronized (n) {
            block12: {
                if (this.isTakingHeapDumps) {
                    this.not.sendHeapDumpProcessNotification(false);
                    this.isTakingHeapDumps = false;
                    this.dumpCount = 0;
                    if (this.policyType == 2) {
                        this.nextTriggerPoint = -102;
                        this.triggerPointHeapSize = -102;
                        if (this.useAveTrigger) {
                            if (this.memoryCalc != null) {
                                this.memoryCalc.clearHistory();
                            }
                        } else if (this.summaryCalc != null) {
                            this.summaryCalc.clearData();
                        }
                    }
                }
                try {
                    if (this._alarm != null) {
                        this._alarm.cancel();
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "could not cancel alarm : " + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        Tr.exit(tc, "stopTakingHeapDumps");
    }

    private void setMemoryTriggerPoint(double d, double d2) {
        Tr.entry(tc, "setMemoryTriggerPoint");
        int n = (int)d - this.heapDifferenceBetweenDumps;
        if (n < this.nextTriggerPoint || TuningUtil.isErrorCode(this.nextTriggerPoint)) {
            this.nextTriggerPoint = n;
            this.triggerPointHeapSize = (int)d2;
        } else if ((double)this.triggerPointHeapSize < d2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "heap has expanded so will reset the trigger point");
            }
            this.nextTriggerPoint = n;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting next memory trigger point to : " + this.nextTriggerPoint + ", heap size : " + this.triggerPointHeapSize);
        }
        Tr.exit(tc, "setMemoryTriggerPoint");
    }

    private void checkMemoryTrigger() {
        block32: {
            Object object;
            Object object2;
            double d;
            double d2;
            block31: {
                Tr.entry(tc, "checkMemoryTrigger2");
                d2 = -102.0;
                d = -102.0;
                if (this.useAveTrigger) {
                    d2 = this.memoryCalc.getIntervalAverage();
                } else {
                    try {
                        object2 = this.summaryCalc.getSummaryPeriods();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "printing out summary calc");
                            Tr.debug(tc, this.summaryCalc.toString());
                        }
                        ArrayList arrayList = object2[0];
                        object = object2[1];
                        if (arrayList != null && arrayList.size() >= 1) {
                            Leaves leaves = (Leaves)arrayList.get(0);
                            Leaves leaves2 = (Leaves)((ArrayList)object).get(0);
                            double[] dArray = leaves.getDataPoints();
                            double[] dArray2 = leaves2.getDataPoints();
                            for (int i = 0; i < dArray.length; ++i) {
                                if (!(dArray[i] > d2)) continue;
                                d2 = dArray[i];
                                d = dArray2[i];
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block31;
                        Tr.debug(tc, "Exception caught getting memory for next trigger point : " + exception.toString());
                        exception.printStackTrace();
                    }
                }
            }
            if (TuningUtil.isErrorCode(d2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Interval did not return memory will check back later");
                }
            } else {
                d2 = this.convertToMb(d2);
                d = this.convertToMb(d);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Memory usage is : " + d2 + "Mb, next trigger point is : " + this.nextTriggerPoint + "Mb");
                }
                if (this.maxHeap == -102.0) {
                    object2 = CalcCreator.createJvmConfigCalc("server");
                    object2.init(this.nodeName, this.serverName);
                    this.maxHeap = (int)object2.getMaxHeapSize();
                }
                double d3 = d2 / this.maxHeap;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "currently have : " + d3 + " left of the heap");
                }
                if (d3 < 0.1) {
                    Tr.debug(tc, "too little memory to continue");
                    this.stopTakingHeapDumps();
                    return;
                }
                if (this.nextTriggerPoint == -102 || this.nextTriggerPoint == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting memory trigger point");
                    }
                    this.setMemoryTriggerPoint(d2, d);
                }
                if (d2 < (double)this.nextTriggerPoint) {
                    try {
                        block33: {
                            object = this.takeDump();
                            this.fileNames.add(object);
                            ++this.dumpCount;
                            this.setMemoryTriggerPoint(d2, d);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "I have taken " + this.dumpCount + " of " + this.numberOfDumps + " heap dumps");
                            }
                            if (this.dumpCount < this.numberOfDumps) break block32;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "reached number of dumps, will disable output handler now ");
                            }
                            this.stopTakingHeapDumps();
                            try {
                                super.setEnabled(false);
                            }
                            catch (Exception exception) {
                                if (!tc.isDebugEnabled()) break block33;
                                Tr.debug(tc, "could not disable : " + exception.toString());
                                exception.printStackTrace();
                            }
                        }
                        this.selfDisabled = true;
                    }
                    catch (HeapDumpOnDiskLimitReachedException heapDumpOnDiskLimitReachedException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "heap dump on disk limit reached taking additional heap dumps : " + heapDumpOnDiskLimitReachedException.toString());
                            heapDumpOnDiskLimitReachedException.printStackTrace();
                        }
                        this.stopTakingHeapDumps();
                        try {
                            super.setEnabled(false);
                            this.selfDisabled = true;
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "could not disable : " + exception.toString());
                                exception.printStackTrace();
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "unexpected and unhundled exception caught when taking additional heap dumps : " + exception.toString());
                            exception.printStackTrace();
                        }
                        this.stopTakingHeapDumps();
                        try {
                            super.setEnabled(false);
                            this.selfDisabled = true;
                        }
                        catch (Exception exception2) {
                            if (!tc.isDebugEnabled()) break block32;
                            Tr.debug(tc, "could not disable : " + exception2.toString());
                            exception.printStackTrace();
                        }
                    }
                }
            }
        }
        Tr.exit(tc, "checkMemoryTrigger");
    }

    private double convertToMb(double d) {
        if (TuningUtil.isErrorCode(d)) {
            return d;
        }
        return d / 1024.0;
    }

    public void setNumberOfDumps(int n) {
        Tr.entry(tc, "setNumberOfDumps");
        this.numberOfDumps = n;
        Tr.exit(tc, "setNumberOfDumps");
    }

    public int getNumberOfDumps() {
        return this.numberOfDumps;
    }

    public String getPolicy() {
        if (this.policyType == 2) {
            return POLICY_MEMORY;
        }
        if (this.policyType == 3) {
            return POLICY_NOTIFICATION;
        }
        if (this.policyType == 1) {
            return POLICY_TIME;
        }
        return "Unknown Policy";
    }

    public int getPolicyType() {
        return this.policyType;
    }

    public void setPolicy(String string) throws IllegalArgumentException {
        Tr.entry(tc, "setPolicy");
        if (string.equals(POLICY_MEMORY)) {
            this.setPolicy(2);
        } else if (string.equals(POLICY_NOTIFICATION)) {
            this.setPolicy(3);
        } else if (string.equals(POLICY_TIME)) {
            this.setPolicy(1);
        } else {
            Tr.exit(tc, "setPolicy");
            throw new IllegalArgumentException("unknown policy : " + string + ", must be one of  : " + POLICY_MEMORY + "<" + POLICY_NOTIFICATION + "," + POLICY_TIME);
        }
        Tr.exit(tc, "setPolicy");
    }

    public void setPolicy(int n) {
        Tr.entry(tc, "setPolicy");
        this.policyType = n;
        Tr.exit(tc, "setPolicy");
    }

    public void setDelayTime(int n) {
        this.delayTime = n;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public MessageWrapper[] getCurrentStatus() {
        return this.getCurrentStatus(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public MessageWrapper[] getCurrentStatus(boolean bl) {
        ArrayList<MessageWrapper> arrayList;
        block20: {
            block22: {
                block21: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "getCurrentStatus - verbose " + bl);
                    }
                    arrayList = new ArrayList<MessageWrapper>(7);
                    if (!this.isApplicable) {
                        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{};
                        messageWrapperArray[0] = new MessageWrapper("perfalert.heapDump.exception.notSupported");
                        Tr.exit(tc, "getCurrentStatus");
                        return messageWrapperArray;
                    }
                    if (this.selfDisabled) {
                        arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.selfDisabled"));
                    } else if (this.isEnabled() && bl) {
                        arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.enabled"));
                    } else if (bl) {
                        arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.disabled"));
                    }
                    if (this.dumpCount != 0 || !bl) break block21;
                    arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.noDump"));
                    break block20;
                }
                for (int i = 0; i < this.fileNames.size(); ++i) {
                    arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.heapDumpFile", this.fileNames.get(i)));
                }
                if (!this.isTakingHeapDumps) break block22;
                Integer n = new Integer(this.numberOfDumps - this.dumpCount);
                arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.dumpInProgress", n));
                if (this.policyType == 2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "next memory trigger point is : " + this.nextTriggerPoint);
                    }
                    if (!TuningUtil.isErrorCode(this.nextTriggerPoint)) {
                        n = new Integer(this.nextTriggerPoint);
                        arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.nextDump.memory", n));
                    }
                    break block20;
                } else if (this.policyType == 3) {
                    arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.nextDump.not"));
                    break block20;
                } else if (this.policyType != 1) {
                    // empty if block
                }
                break block20;
            }
            if (bl) {
                arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.noDumpInProgress"));
            }
        }
        for (int i = 0; i < this.manualFileNames.size(); ++i) {
            arrayList.add(new MessageWrapper("perfTuning.heapDumpOutputHandler.heapDumpFile.manual", ((File)this.manualFileNames.get(i)).getAbsolutePath()));
        }
        MessageWrapper[] messageWrapperArray = new MessageWrapper[arrayList.size()];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "printing out current status");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            messageWrapperArray[i] = (MessageWrapper)arrayList.get(i);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "   id:" + messageWrapperArray[i].getId() + ",message:" + messageWrapperArray[i].getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentStatus");
        }
        return messageWrapperArray;
    }

    public ArrayList getHeapDumpFiles() {
        return this.fileNames;
    }

    public ArrayList getManualHeapDumpFiles() {
        return this.manualFileNames;
    }

    public boolean hasGeneratedHeapDumps() {
        Tr.entry(tc, "hasGeneratedHeapDumps");
        if (this.fileNames.size() == 0 && this.manualFileNames.size() == 0) {
            Tr.exit(tc, "hasGeneratedHeapDumps false");
            return false;
        }
        Tr.exit(tc, "hasGeneratedHeapDumps true");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratingHeapDumps() {
        Integer n = this.lock;
        synchronized (n) {
            return this.isTakingHeapDumps;
        }
    }

    public void setNotificationSender(MBeanNotificationResponse mBeanNotificationResponse) {
        this.not = mBeanNotificationResponse;
    }

    public boolean isSelfDisabled() {
        return this.selfDisabled;
    }
}

