/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.leakProtoType_1;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Date;

public class Leaves
implements Cloneable {
    private static TraceComponent tc = Tr.register(Leaves.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private int height;
    private double[] datapoints;
    private int count = 0;
    private boolean keepRegionTimes;
    private long[] minTimes;
    private long startTime;
    private long endTime;
    private boolean isCronological;
    public static final long UNKNOWN_TIME = -1099L;

    public Leaves(int n, int n2, boolean bl, boolean bl2) {
        int n3;
        this.height = n;
        this.datapoints = new double[n2];
        this.isCronological = bl2;
        for (n3 = 0; n3 < this.datapoints.length; ++n3) {
            this.datapoints[n3] = -102.0;
        }
        this.keepRegionTimes = bl;
        if (this.keepRegionTimes) {
            this.minTimes = new long[n2];
            for (n3 = 0; n3 < this.minTimes.length; ++n3) {
                this.minTimes[n3] = -1099L;
            }
            this.startTime = -1099L;
            this.endTime = -1099L;
        }
    }

    public boolean isCronological() {
        return this.isCronological;
    }

    public int getHeight() {
        return this.height;
    }

    public double[] getDataPoints() {
        return this.datapoints;
    }

    public boolean isFull() {
        return this.count == this.datapoints.length;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean getKeepRegionTimes() {
        return this.keepRegionTimes;
    }

    public void addDataPoint(double d, long l, long l2) throws Exception {
        if (this.count < this.datapoints.length) {
            int n = this.count;
            if (!this.isCronological) {
                n = this.datapoints.length - this.count - 1;
            }
            this.datapoints[n] = d;
            if (this.keepRegionTimes) {
                if (l < this.startTime || this.startTime == -1099L) {
                    this.startTime = l;
                }
                if (l2 > this.endTime || this.endTime == -1099L) {
                    this.endTime = l2;
                }
                this.minTimes[n] = l;
            }
            ++this.count;
        } else {
            Exception exception = new Exception("Leaves DataStructure is already full and a new datapoint was added: " + this.toString());
            throw exception;
        }
    }

    public void prune() {
        Tr.entry(tc, "prune");
        for (int i = 1; i < this.count; ++i) {
            this.datapoints[i - 1] = this.datapoints[i];
            if (!this.keepRegionTimes) continue;
            this.minTimes[i - 1] = this.minTimes[i];
        }
        if (this.keepRegionTimes) {
            this.minTimes[this.count - 1] = -1099L;
        }
        this.datapoints[this.count - 1] = -102.0;
        if (this.keepRegionTimes) {
            this.startTime = this.minTimes[0];
        }
        --this.count;
        Tr.exit(tc, "prune");
    }

    public void empty() {
        this.count = 0;
        this.datapoints = new double[this.datapoints.length];
        for (int i = 0; i < this.datapoints.length; ++i) {
            this.datapoints[i] = -102.0;
        }
        this.startTime = -1099L;
        this.endTime = -1099L;
    }

    public Object clone() {
        Leaves leaves = new Leaves(this.height, this.datapoints.length, this.keepRegionTimes, true);
        for (int i = 0; i < this.count; ++i) {
            try {
                long l = -1099L;
                if (this.keepRegionTimes) {
                    l = this.minTimes[i];
                }
                leaves.addDataPoint(this.datapoints[i], l, this.endTime);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return leaves;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("height: " + this.getHeight());
        stringBuffer.append(", startTime: " + this.getStartTime());
        stringBuffer.append(", endTime : " + this.getEndTime());
        if (this.getHeight() == 1) {
            stringBuffer.append("Raw Data:    ");
        } else {
            stringBuffer.append("Region Data from: ");
            if (this.getStartTime() == -1099L) {
                stringBuffer.append(" unknown time ");
            } else {
                stringBuffer.append(new Date(this.getStartTime()));
            }
            stringBuffer.append(" to ");
            if (this.getEndTime() == -1099L) {
                stringBuffer.append(" unknown time ");
            } else {
                stringBuffer.append(new Date(this.getEndTime()));
            }
        }
        stringBuffer.append("\n     ( ");
        for (int i = 0; i < this.datapoints.length; ++i) {
            stringBuffer.append("[");
            if (this.datapoints[i] == -102.0) {
                stringBuffer.append("no_data");
            } else {
                stringBuffer.append(this.datapoints[i]);
                if (this.keepRegionTimes) {
                    Date date = new Date(this.minTimes[i]);
                    stringBuffer.append(" @ ").append(date.getHours()).append(":").append(date.getMinutes()).append(":").append(date.getSeconds());
                }
            }
            stringBuffer.append(" ]");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

