/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.leakProtoType_1;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IJvmConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISystemSharedCalc;
import com.ibm.ws.performance.tuning.leakProtoType_1.ISummaryPeriodCalc;
import com.ibm.ws.performance.tuning.leakProtoType_1.LeakRuleOutput;
import com.ibm.ws.performance.tuning.leakProtoType_1.Leaves;
import com.ibm.ws.performance.tuning.leakProtoType_1.VarableDataCondition;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.serverAlert.ParsedMbeanAttribute;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.system.SystemData;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class MemoryLeakRule
extends AbstractRule {
    private static TraceComponent tc = Tr.register(MemoryLeakRule.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    public static final String HISTORICAL_MODE = "historicalMode";
    public static final String SUMMARY_MECH = "summaryMech";
    public static final String TREE_HEIGHT = "treeHeight";
    public static final String NUMBER_OF_LEAVES = "numberLeaves";
    public static final String MIN_MEMORY_PERCENTAGE = "minMemoryPercentage";
    public static final String KEEP_TIMES = "keepTimes";
    public static final String ANALYZE_EXPANDING_HEAP = "analyzeExpandingHeap";
    public static final String NUMBER_OF_DECREASING_EXCEPTIONS = "numberOfDecreasingExceptions";
    public static final String EXPANDING_FREE_THRESHOLD = "expandingHeapFreeMemoryThreshold";
    public static final String EXPANDING_HEAP_USED_PERCENTAGE = "expandingHeapHeapUsedPercentage";
    public static final int JVM_TOTAL_MEMORY = 1;
    public static final int JVM_FREE_MEMORY = 2;
    public static final int JVM_USED_MEMORY = 3;
    protected static int minMemoryPercentage;
    private int minMemoryMb;
    protected String server;
    protected String node;
    private boolean historicalMode;
    private ArrayList[] historicalPeriods;
    private int testCount;
    private double maxCertainty;
    private int summaryMech;
    private int treeHeight;
    protected static int numberLeaves;
    private boolean keepTimes;
    private int decreasingExceptions;
    protected static PerfDescriptor jvmPD;
    private ISummaryPeriodCalc summaryCalc;
    private IJvmConfigCachedCalc jvmConfigCalc;
    private int maxHeap;
    double fudgeFactor;
    private boolean analyzeExpandingHeap;
    private boolean isISeries;
    private boolean analyzeISeriesUnboundedHeap;
    private int iSeriesMemoryPoolSize;
    private double expandingHeapPct;
    private double expandingFreeThreshold;
    private boolean applicable = true;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        int n;
        this.server = string2;
        this.node = string;
        this.ruleData = ruleData;
        this.testCount = 0;
        HashMap hashMap = ruleData.getParamMap();
        Object v = hashMap.get(SUMMARY_MECH);
        this.summaryMech = v != null ? ((Double)v).intValue() : 3;
        v = hashMap.get(TREE_HEIGHT);
        this.treeHeight = v != null ? ((Double)v).intValue() : 4;
        v = hashMap.get(NUMBER_OF_LEAVES);
        numberLeaves = v != null ? ((Double)v).intValue() : 4;
        v = hashMap.get(MIN_MEMORY_PERCENTAGE);
        minMemoryPercentage = v != null ? ((Double)v).intValue() : 5;
        v = hashMap.get(KEEP_TIMES);
        if (v != null) {
            n = ((Double)v).intValue();
            this.keepTimes = n == 1;
        }
        if ((v = hashMap.get(ANALYZE_EXPANDING_HEAP)) != null) {
            n = ((Double)v).intValue();
            this.analyzeExpandingHeap = n == 1;
        }
        if ((v = hashMap.get(HISTORICAL_MODE)) != null) {
            n = ((Double)v).intValue();
            if (n == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting historical mode to true");
                }
                this.historicalMode = true;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting historical mode to false");
                }
                this.historicalMode = false;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting historical mode to false - no parameter");
            }
            this.historicalMode = false;
            this.maxCertainty = 0.0;
        }
        v = hashMap.get(EXPANDING_FREE_THRESHOLD);
        this.expandingFreeThreshold = v != null ? (double)((Double)v).intValue() : 25.0;
        v = hashMap.get(EXPANDING_HEAP_USED_PERCENTAGE);
        this.expandingHeapPct = v != null ? (double)((Double)v).intValue() : 75.0;
        v = hashMap.get(NUMBER_OF_DECREASING_EXCEPTIONS);
        if (v != null) {
            this.decreasingExceptions = ((Double)v).intValue();
        }
        jvmPD = new PerfDescriptorImpl(string, string2, jvmDD);
        jvmPD.postInit();
        this.summaryCalc = CalcCreator.createSummaryPeriodCalc(this.ruleData.getType());
        VarableDataCondition varableDataCondition = new VarableDataCondition(minMemoryPercentage);
        PerfDescriptor[] perfDescriptorArray = new PerfDescriptor[]{jvmPD, jvmPD};
        int[] nArray = new int[]{2, 1};
        int[] nArray2 = new int[]{this.summaryMech, 2};
        this.summaryCalc.init(perfDescriptorArray, nArray, varableDataCondition, this.treeHeight, numberLeaves, nArray2, this.keepTimes);
        this.jvmConfigCalc = CalcCreator.createJvmConfigCalc(this.ruleData.getType());
        this.jvmConfigCalc.init(string, string2);
        this.maxHeap = (int)this.jvmConfigCalc.getMaxHeapSize();
        this.fudgeFactor = 0.05 * (double)this.maxHeap;
        this.minMemoryMb = minMemoryPercentage * this.maxHeap / 100;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "max Heap in Mb is : " + this.maxHeap);
            Tr.debug(tc, "min memory percentage is : " + minMemoryPercentage);
            Tr.debug(tc, "min memory in Mb is : " + this.minMemoryMb);
        }
        ISystemSharedCalc iSystemSharedCalc = CalcCreator.getSystemSharedCalc(string, string2, this.ruleData.getType());
        String string3 = iSystemSharedCalc.getOperatingSystem();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OS is : " + string3);
        }
        if (string3.equals("OS/400")) {
            this.isISeries = true;
        }
        if (this.isISeries) {
            this.updateISeriesUnboundedHeap();
        }
        this.iSeriesMemoryPoolSize = -102;
        if (this.historicalMode) {
            this.historicalPeriods = new ArrayList[this.treeHeight];
            for (int i = 0; i < this.historicalPeriods.length; ++i) {
                this.historicalPeriods[i] = new ArrayList();
            }
        }
    }

    private void updateISeriesUnboundedHeap() {
        Tr.entry(tc, "updateISeriesUnboundedHeap");
        try {
            if (this.isISeries) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "iSeries - checking effective memory pool size");
                }
                this.iSeriesMemoryPoolSize = SystemData.getPoolLessReserved();
                this.iSeriesMemoryPoolSize /= 1024;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updating iSeriesMemoryPoolSize " + this.iSeriesMemoryPoolSize);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "effective memory pool size: " + this.iSeriesMemoryPoolSize + ", heap : " + this.maxHeap);
                }
                this.analyzeISeriesUnboundedHeap = this.maxHeap > this.iSeriesMemoryPoolSize;
            } else {
                this.analyzeISeriesUnboundedHeap = false;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception caught getting iSeriesMemoryPoolSize : " + exception.toString());
                exception.printStackTrace();
            }
            this.iSeriesMemoryPoolSize = -102;
            this.analyzeISeriesUnboundedHeap = false;
            Tr.exit(tc, "updateISeriesUnboundedHeap - exception");
        }
        Tr.exit(tc, "updateISeriesUnboundedHeap - " + this.analyzeISeriesUnboundedHeap);
    }

    public boolean isApplicable() {
        return this.applicable;
    }

    protected static DataDescriptor getJVMDD() {
        return jvmDD;
    }

    public RuleOutput[] runRule() {
        Tr.entry(tc, "runRule");
        RuleOutput[] ruleOutputArray = new RuleOutput[1];
        try {
            double d = this.summaryCalc.getDoubleValue(1) / 1024.0;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "total memory : " + d + ", maxHeap = " + this.maxHeap + ", fudged max heap : " + ((double)this.maxHeap - this.fudgeFactor) + ", analyzing expanding heap : " + this.analyzeExpandingHeap);
            }
            if (d >= (double)this.maxHeap - this.fudgeFactor || this.analyzeExpandingHeap || this.analyzeISeriesUnboundedHeap) {
                ArrayList[] arrayListArray = this.summaryCalc.getSummaryPeriods();
                ArrayList arrayList = arrayListArray[0];
                ArrayList arrayList2 = arrayListArray[1];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "size of data list :" + arrayList.size() + " heapSizeList : " + arrayList2.size());
                    Tr.debug(tc, "[Robbie TPA testing] DataTree: " + this.summaryCalc.toString());
                }
                if (arrayList != null && arrayList.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "   analyzing " + arrayList.size() + " periods");
                    }
                    int n = arrayList.size();
                    ArrayList<SinglePeriodOutput> arrayList3 = new ArrayList<SinglePeriodOutput>();
                    for (int i = 0; i < n; ++i) {
                        Leaves leaves = (Leaves)arrayList.get(i);
                        Leaves leaves2 = (Leaves)arrayList2.get(i);
                        if (this.isISeries && (leaves2.getHeight() >= 3 || this.iSeriesMemoryPoolSize == -102)) {
                            this.updateISeriesUnboundedHeap();
                        }
                        try {
                            SinglePeriodOutput singlePeriodOutput = null;
                            singlePeriodOutput = this.analyzeISeriesUnboundedHeap ? this.analyzeISeriesUnboundedHeapPeriod(leaves2) : this.analyzePeriod(leaves, leaves2);
                            if (singlePeriodOutput != null && singlePeriodOutput.isConclusive()) {
                                arrayList3.add(singlePeriodOutput);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Single Period Output is not conclusive.  Do not consume period output : " + singlePeriodOutput.toString());
                            continue;
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "unexpected exception analyzing periods : " + exception.toString());
                            exception.printStackTrace();
                        }
                    }
                    SinglePeriodOutput[] singlePeriodOutputArray = new SinglePeriodOutput[arrayList3.size()];
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        singlePeriodOutputArray[i] = (SinglePeriodOutput)arrayList3.get(i);
                    }
                    if (this.historicalMode) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "creating historical output");
                        }
                        ruleOutputArray = this.createHistoricalRuleOutput(singlePeriodOutputArray);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "creating NON historical output");
                        }
                        ruleOutputArray = this.createNonHistoricalRuleOutput(singlePeriodOutputArray);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "   nothing to analyze");
                    }
                    ruleOutputArray = new RuleOutput[]{};
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "   heap size is not equal to the max heap size and rule is not analyzing an expanding heap");
                }
                this.summaryCalc.clearData();
                MessageWrapper messageWrapper = new MessageWrapper("perfalert.memoryLeak.heapNotEqualMax");
                MessageWrapper messageWrapper2 = new MessageWrapper("perfalert.memoryLeak.noProblem");
                ruleOutputArray[0] = new LeakRuleOutput(super.getRuleName(), jvmPD, 101, messageWrapper2, messageWrapper, null);
            }
            this.summaryCalc.clear();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught in RunRule : " + exception.toString());
            }
            exception.printStackTrace();
        }
        Tr.exit(tc, "runRule");
        return ruleOutputArray;
    }

    private RuleOutput[] createHistoricalRuleOutput(SinglePeriodOutput[] singlePeriodOutputArray) {
        return this.createHistoricalRuleOutput(singlePeriodOutputArray, true);
    }

    private RuleOutput[] createHistoricalRuleOutput(SinglePeriodOutput[] singlePeriodOutputArray, boolean bl) {
        boolean bl2;
        int n;
        int n2;
        Object object;
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "createHistoricalRuleOutput");
        }
        ArrayList<MessageWrapper> arrayList = new ArrayList<MessageWrapper>();
        arrayList.add(new MessageWrapper("perfalert.memoryLeak.canceledAlerts"));
        boolean bl3 = false;
        for (n3 = 0; n3 < singlePeriodOutputArray.length; ++n3) {
            object = new CombinedPeriod(singlePeriodOutputArray[n3]);
            n2 = ((CombinedPeriod)object).getIsMemoryLeak() || ((CombinedPeriod)object).getIsMemoryWarning() ? 1 : 0;
            n = ((SinglePeriodOutput)object).getHeight();
            Tr.debug(tc, "Looking at period : " + object);
            for (bl2 = false; bl2 < n - 1; bl2 += 1) {
                ArrayList arrayList2 = this.historicalPeriods[bl2];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking at height : " + (int)(bl2 ? 1 : 0));
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    try {
                        CombinedPeriod combinedPeriod = (CombinedPeriod)arrayList2.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "comparing " + combinedPeriod + ", with " + object);
                        }
                        if (((CombinedPeriod)object).contains(combinedPeriod)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "   contained");
                            }
                            arrayList2.remove(combinedPeriod);
                            --i;
                            if (n2 != 0) {
                                ((CombinedPeriod)object).combine(combinedPeriod);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "   created new combined list : " + object);
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "   not a leak discard contained period");
                            }
                            bl3 = true;
                            arrayList.add(combinedPeriod.getMessageWrapper());
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "   not contained");
                        continue;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Exception caught : " + exception.toString());
                        exception.printStackTrace();
                    }
                }
            }
            Tr.debug(tc, "Modified period is now " + object);
            if (n2 != 0) {
                if (n >= this.treeHeight && this.historicalPeriods[this.treeHeight - 1].size() >= numberLeaves) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tree height is full, removing old value");
                    }
                    this.historicalPeriods[n - 1].remove(0);
                }
                this.historicalPeriods[n - 1].add(object);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "not adding period as this is not a leak");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Printing out historical periods");
            for (n3 = 0; n3 < this.historicalPeriods.length; ++n3) {
                object = this.historicalPeriods[n3];
                Tr.debug(tc, "   height = " + (n3 + 1));
                for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                    Tr.debug(tc, "           " + ((ArrayList)object).get(n2));
                }
            }
        }
        ArrayList<MessageWrapper> arrayList3 = new ArrayList<MessageWrapper>();
        object = new ArrayList();
        ArrayList<MessageWrapper> arrayList4 = new ArrayList<MessageWrapper>();
        arrayList4.add(new MessageWrapper("perfalert.memoryLeak.leakWarnings"));
        n = 0;
        bl2 = false;
        boolean bl4 = false;
        double d = this.calculateCertainty();
        boolean bl5 = false;
        if (bl) {
            if (bl3) {
                this.maxCertainty = d;
            } else if (d > this.maxCertainty) {
                this.maxCertainty = d;
                bl5 = true;
            }
        } else {
            bl5 = true;
        }
        for (int i = 0; i < this.historicalPeriods.length; ++i) {
            ArrayList arrayList5 = this.historicalPeriods[i];
            for (int j = 0; j < arrayList5.size(); ++j) {
                CombinedPeriod combinedPeriod = (CombinedPeriod)arrayList5.get(j);
                if (combinedPeriod.getIsMemoryLeak()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "classified as a memory leak");
                    }
                    if (bl5) {
                        bl2 = true;
                        arrayList3.add(combinedPeriod.getMessageWrapper());
                        continue;
                    }
                    bl4 = true;
                    arrayList4.add(combinedPeriod.getMessageWrapper());
                    continue;
                }
                if (!combinedPeriod.getIsMemoryWarning()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "classified as a warning");
                }
                if (bl5) {
                    n = 1;
                    ((ArrayList)object).add(combinedPeriod.getMessageWrapper());
                    continue;
                }
                bl4 = true;
                arrayList4.add(combinedPeriod.getMessageWrapper());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "   creating alert, certainty : " + d + " , maxCertainty : " + this.maxCertainty);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "createHistoricalRuleOutput");
        }
        return this.createRuleOutput(bl2, arrayList3, n != 0, (ArrayList)object, bl4, arrayList4, bl3, arrayList);
    }

    private double calculateCertainty() {
        double d = 0.0;
        ArrayList arrayList = this.historicalPeriods[0];
        if (arrayList.size() > 0) {
            return this.historicalPeriods.length;
        }
        for (int i = this.historicalPeriods.length - 1; i >= 0; --i) {
            arrayList = this.historicalPeriods[i];
            for (int j = 0; j < arrayList.size(); ++j) {
                double d2;
                CombinedPeriod combinedPeriod = (CombinedPeriod)arrayList.get(j);
                if (combinedPeriod.getIsMemoryLeak()) {
                    if (!((double)combinedPeriod.getHeight() > d)) continue;
                    return combinedPeriod.getHeight();
                }
                if (!combinedPeriod.getIsMemoryWarning() || !((d2 = 0.5 * (double)combinedPeriod.getHeight()) > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    private RuleOutput[] createRuleOutput(boolean bl, ArrayList arrayList, boolean bl2, ArrayList arrayList2, boolean bl3, ArrayList arrayList3, boolean bl4, ArrayList arrayList4) {
        RuleOutput[] ruleOutputArray = new RuleOutput[1];
        if (bl) {
            int n;
            MessageWrapper[] messageWrapperArray;
            if (bl2) {
                messageWrapperArray = new MessageWrapper[arrayList.size() + arrayList2.size()];
                for (n = 0; n < arrayList.size(); ++n) {
                    messageWrapperArray[n] = (MessageWrapper)arrayList.get(n);
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    messageWrapperArray[n] = (MessageWrapper)arrayList2.get(i);
                    ++n;
                }
            } else {
                messageWrapperArray = new MessageWrapper[arrayList.size() + arrayList2.size()];
                for (n = 0; n < arrayList.size(); ++n) {
                    messageWrapperArray[n] = (MessageWrapper)arrayList.get(n);
                }
            }
            MessageWrapper messageWrapper = new MessageWrapper("perfalert.memoryLeak.memoryLeakDetected");
            ruleOutputArray[0] = new LeakRuleOutput(super.getRuleName(), jvmPD, 104, messageWrapper, messageWrapperArray, null);
        } else if (bl2) {
            MessageWrapper[] messageWrapperArray = new MessageWrapper[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                messageWrapperArray[i] = (MessageWrapper)arrayList2.get(i);
            }
            MessageWrapper messageWrapper = new MessageWrapper("perfalert.memoryLeak.memoryLeakWarning");
            ruleOutputArray[0] = new LeakRuleOutput(super.getRuleName(), jvmPD, 104, messageWrapper, messageWrapperArray, null);
        } else if (bl3) {
            MessageWrapper[] messageWrapperArray = new MessageWrapper[arrayList3.size()];
            for (int i = 0; i < arrayList3.size(); ++i) {
                messageWrapperArray[i] = (MessageWrapper)arrayList3.get(i);
            }
            MessageWrapper messageWrapper = new MessageWrapper("perfalert.memoryLeak.warning");
            ruleOutputArray[0] = new LeakRuleOutput(super.getRuleName(), jvmPD, 102, messageWrapper, messageWrapperArray, null);
        } else if (bl4) {
            MessageWrapper[] messageWrapperArray = new MessageWrapper[arrayList4.size()];
            for (int i = 0; i < arrayList4.size(); ++i) {
                messageWrapperArray[i] = (MessageWrapper)arrayList4.get(i);
            }
            MessageWrapper messageWrapper = new MessageWrapper("perfalert.memoryLeak.canceled");
            ruleOutputArray[0] = new LeakRuleOutput(super.getRuleName(), jvmPD, 106, messageWrapper, messageWrapperArray, null);
        } else {
            MessageWrapper[] messageWrapperArray = new MessageWrapper[]{};
            MessageWrapper messageWrapper = new MessageWrapper("perfalert.memoryLeak.noProblem");
            ruleOutputArray[0] = new LeakRuleOutput(super.getRuleName(), jvmPD, 101, messageWrapper, messageWrapperArray, null);
        }
        return ruleOutputArray;
    }

    private RuleOutput[] createNonHistoricalRuleOutput(SinglePeriodOutput[] singlePeriodOutputArray) {
        ArrayList<MessageWrapper> arrayList = new ArrayList<MessageWrapper>();
        arrayList.add(new MessageWrapper("perfalert.memoryLeak.analyzingPeriods", new Integer(singlePeriodOutputArray.length)));
        ArrayList<MessageWrapper> arrayList2 = new ArrayList<MessageWrapper>();
        arrayList2.add(new MessageWrapper("perfalert.memoryLeak.leakWarnings"));
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < singlePeriodOutputArray.length; ++i) {
            SinglePeriodOutput singlePeriodOutput = singlePeriodOutputArray[i];
            bl = bl || singlePeriodOutput.getIsMemoryLeak();
            boolean bl3 = bl2 = bl2 || singlePeriodOutput.getIsMemoryWarning();
            if (singlePeriodOutput.getIsMemoryWarning()) {
                arrayList2.add(singlePeriodOutput.getMessageWrapper());
                continue;
            }
            if (!singlePeriodOutput.getIsMemoryLeak()) continue;
            arrayList.add(singlePeriodOutput.getMessageWrapper());
        }
        return this.createRuleOutput(bl, arrayList, bl2, arrayList2, false, null, false, null);
    }

    private SinglePeriodOutput analyzeISeriesUnboundedHeapPeriod(Leaves leaves) throws Exception {
        Tr.entry(tc, "analyzeISeriesUnboundedHeapPeriod");
        Date[] dateArray = null;
        if (this.keepTimes) {
            dateArray = new Date[]{new Date(leaves.getStartTime()), new Date(leaves.getEndTime())};
        } else {
            Tr.debug(tc, "not keeping region times");
        }
        double[] dArray = leaves.getDataPoints();
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] / 1024.0;
        }
        double d = 100 - minMemoryPercentage;
        int n = (int)((d /= 100.0) * (double)this.iSeriesMemoryPoolSize);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "minMemoryPercentage : " + minMemoryPercentage);
            Tr.debug(tc, "iSeriesMemoryPoolSize : " + this.iSeriesMemoryPoolSize);
            Tr.debug(tc, "factor : " + d);
            Tr.debug(tc, "critical memory value is : " + n);
        }
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            int n3 = (int)dArray[i];
            if (n3 > n) {
                bl = true;
            }
            if (n3 > n2) {
                n2 = n3;
            } else if (bl) {
                bl2 = false;
                break;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "heap : " + n3 + ",has exceeded:" + bl + ",nonDecreasing:" + bl2);
        }
        Object[] objectArray = new Object[]{new Integer(this.iSeriesMemoryPoolSize), new Integer(n2), SystemData.getPoolName(), dateArray[0], dateArray[1]};
        if (bl && bl2) {
            MessageWrapper messageWrapper = new MessageWrapper("perfalert.memoryLeak.unboundedHeap.memoryLeakDetected", objectArray);
            Tr.exit(tc, "analyzeISeriesUnboundedHeapPeriod - leak");
            return new SinglePeriodOutput(true, messageWrapper, false, bl2, true, dateArray[0], dateArray[1], leaves.getHeight());
        }
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.memoryLeak.unboundedHeap.noProblem", objectArray);
        Tr.exit(tc, "analyzeISeriesUnboundedHeapPeriod - no problem");
        return new SinglePeriodOutput(false, messageWrapper, false, bl2, true, dateArray[0], dateArray[1], leaves.getHeight());
    }

    private SinglePeriodOutput analyzePeriod(Leaves leaves, Leaves leaves2) {
        Object object;
        int n;
        boolean bl;
        Tr.entry(tc, "analyzePeriod");
        Object[] objectArray = null;
        if (this.keepTimes) {
            objectArray = new Date[]{new Date(leaves.getStartTime()), new Date(leaves.getEndTime())};
        } else {
            Tr.debug(tc, "not keeping region times");
        }
        double[] dArray = leaves.getDataPoints();
        double[] dArray2 = leaves2.getDataPoints();
        for (bl = false; bl < dArray.length; bl += 1) {
            dArray2[bl] = dArray2[bl] / 1024.0;
            dArray[bl] = dArray[bl] / 1024.0;
            dArray[bl] = Math.rint(dArray[bl] / dArray2[bl] * 100.0);
            dArray2[bl] = Math.rint(dArray2[bl]);
        }
        bl = !(dArray2[0] < (double)this.maxHeap - this.fudgeFactor);
        boolean bl2 = true;
        for (n = 1; n < dArray2.length; ++n) {
            if (dArray2[n] < (double)this.maxHeap - this.fudgeFactor) {
                bl = false;
            }
            if (dArray2[n] == dArray2[n - 1]) continue;
            bl2 = false;
        }
        n = 0;
        MessageWrapper messageWrapper = null;
        boolean bl3 = true;
        if (!bl && !this.analyzeExpandingHeap) {
            messageWrapper = this.keepTimes ? new MessageWrapper("perfalert.memoryLeak.heapNotEqualMax.withTime", objectArray) : new MessageWrapper("perfalert.memoryLeak.heapNotEqualMax");
        } else if (bl) {
            if (this.isSummarizedData(leaves) && this.testDataDecreasing(dArray)) {
                n = 1;
                messageWrapper = this.keepTimes ? new MessageWrapper("perfalert.memoryLeak.memoryDecreasing.withTime", objectArray) : new MessageWrapper("perfalert.memoryLeak.memoryDecreasing");
            } else if (this.testDataCritical(dArray)) {
                n = 1;
                messageWrapper = this.keepTimes ? new MessageWrapper("perfalert.memoryLeak.notEnoughMemory.withTime", objectArray) : new MessageWrapper("perfalert.memoryLeak.notEnoughMemory");
            } else if (this.isSummarizedData(leaves) && this.testDataEndsBelow(dArray, minMemoryPercentage)) {
                n = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This result is not conclusive as the data is summarized and ends below the critical value");
                }
                bl3 = false;
                messageWrapper = this.keepTimes ? new MessageWrapper("perfalert.memoryLeak.memoryStable.withTime", objectArray) : new MessageWrapper("perfalert.memoryLeak.memoryStable");
            } else {
                n = 0;
                messageWrapper = this.keepTimes ? new MessageWrapper("perfalert.memoryLeak.memoryStable.withTime", objectArray) : new MessageWrapper("perfalert.memoryLeak.memoryStable");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "heap size is not consistantly the max - check that it is not consistantly increasing");
            }
            if (this.isSummarizedData(leaves) && this.heapIncreasingAndCritical(dArray, dArray2)) {
                n = 1;
                messageWrapper = this.keepTimes ? new MessageWrapper("perfalert.memoryLeak.uncheckedExpandingHeap.withTime", objectArray) : new MessageWrapper("perfalert.memoryLeak.uncheckedExpandingHeap");
            } else {
                n = 0;
                messageWrapper = this.keepTimes ? new MessageWrapper("perfalert.memoryLeak.memoryStable.withTime", objectArray) : new MessageWrapper("perfalert.memoryLeak.memoryStable");
            }
        }
        if (tc.isDebugEnabled()) {
            int n2;
            Tr.debug(tc, "Analyzing period: ");
            if (this.keepTimes) {
                Tr.debug(tc, "    from:        " + ((Date)objectArray[0]).toString());
            }
            if (this.keepTimes) {
                Tr.debug(tc, "    to:          " + ((Date)objectArray[1]).toString());
            }
            Tr.debug(tc, "    summaryHeight:" + leaves.getHeight());
            Tr.debug(tc, "    isMemoryLeak:" + (n != 0));
            Tr.debug(tc, "    symptom:     " + messageWrapper.getMessage());
            Tr.debug(tc, "    heapSizeMaxed:" + bl);
            Tr.debug(tc, "    heapConsistant:" + bl2);
            Tr.debug(tc, "    conclusive:" + bl3);
            object = new StringBuffer("    data:    ");
            for (n2 = 0; n2 < dArray.length; ++n2) {
                ((StringBuffer)object).append("     " + dArray[n2]);
            }
            Tr.debug(tc, ((StringBuffer)object).toString());
            object = new StringBuffer("    heap:    ");
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                ((StringBuffer)object).append("     " + dArray2[n2]);
            }
            Tr.debug(tc, ((StringBuffer)object).toString());
        }
        object = new SinglePeriodOutput(bl3, n != 0, messageWrapper, bl, bl2, false, (Date)objectArray[0], (Date)objectArray[1], leaves.getHeight());
        Tr.exit(tc, "analyzePeriod");
        return object;
    }

    private boolean heapIncreasingAndCritical(double[] dArray, double[] dArray2) {
        Tr.entry(tc, "heapIncreasingAndCritical");
        double d = dArray2[dArray2.length - 1] / (double)this.maxHeap * 100.0;
        if (d > this.expandingHeapPct) {
            boolean bl = false;
            for (int i = 0; i < dArray2.length; ++i) {
                double d2;
                if (i > 0) {
                    if (dArray2[i] <= (double)this.maxHeap - this.fudgeFactor) {
                        if (dArray2[i] <= dArray2[i - 1]) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Heap is not expanding");
                            }
                            Tr.exit(tc, "heapIncreasingAndCritical - false");
                            return false;
                        }
                    } else {
                        if (bl && dArray[i] > dArray[i - 1]) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Heap Maxed and data not strickly decreasing once maxed");
                            }
                            Tr.exit(tc, "heapIncreasingAndCritical - false");
                            return false;
                        }
                        bl = true;
                    }
                }
                if (!((d2 = dArray[i] / dArray2[i] * 100.0) > this.expandingFreeThreshold)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expanding free memory is not within the threshold.  Free : " + d2);
                }
                Tr.exit(tc, "heapIncreasingAndCritical - false");
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expanding heap is critical and will soon run out");
            }
            Tr.exit(tc, "heapIncreasingAndCritical - true");
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "pctUsed " + d + "of the heap is not within threshold of maxheap " + this.maxHeap);
        }
        Tr.exit(tc, "heapIncreasingAndCritical - false");
        return false;
    }

    private boolean testDataDecreasing(double[] dArray) {
        int n = 0;
        int n2 = 1;
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i] >= dArray[i - n2] && dArray[i] > (double)minMemoryPercentage) {
                ++n2;
                if (++n <= this.decreasingExceptions) continue;
                return false;
            }
            n2 = 1;
        }
        return true;
    }

    private boolean testDataEndsBelow(double[] dArray, double d) {
        return dArray[dArray.length - 1] < d;
    }

    private boolean testDataBelowValue(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            return false;
        }
        return true;
    }

    private boolean testDataCritical(double[] dArray) {
        return this.testDataBelowValue(dArray, minMemoryPercentage);
    }

    private boolean isSummarizedData(Leaves leaves) {
        return leaves.getHeight() != 1;
    }

    public static HashMap getStaticAttributeHashMap() {
        Tr.entry(tc, "getStaticAttributeHashMap");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            ParsedMbeanAttribute parsedMbeanAttribute = new ParsedMbeanAttribute(MIN_MEMORY_PERCENTAGE);
            parsedMbeanAttribute.setBasicDescription("When the amount of free memory in the heap is too small the JVM spends too much time garbage collecting");
            parsedMbeanAttribute.setDesLookup("perfTuningAdmin.attribute.rule.minMemoryPercentage.des");
            parsedMbeanAttribute.setParamId(MIN_MEMORY_PERCENTAGE);
            parsedMbeanAttribute.setLevel("advanced");
            parsedMbeanAttribute.setName("Minimum required percentage of the heap that is free");
            parsedMbeanAttribute.setNameLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.minMemoryPercentage");
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("perfTuningAdmin.attribute.rule.minMemoryPercentage.option.3", "3.0");
            hashMap2.put("perfTuningAdmin.attribute.rule.minMemoryPercentage.option.5", "5.0");
            hashMap2.put("perfTuningAdmin.attribute.rule.minMemoryPercentage.option.7", "7.0");
            hashMap2.put("perfTuningAdmin.attribute.rule.minMemoryPercentage.option.10", "10.0");
            hashMap2.put("perfTuningAdmin.attribute.rule.minMemoryPercentage.option.15", "15.0");
            hashMap2.put("perfTuningAdmin.attribute.rule.minMemoryPercentage.option.20", "20.0");
            parsedMbeanAttribute.setOptions(hashMap2);
            parsedMbeanAttribute.setType("java.lang.Double");
            parsedMbeanAttribute.setIsAdvice(false);
            hashMap.put(MIN_MEMORY_PERCENTAGE, parsedMbeanAttribute.getAdvancedDescription());
            ParsedMbeanAttribute parsedMbeanAttribute2 = new ParsedMbeanAttribute(SUMMARY_MECH);
            parsedMbeanAttribute2.setBasicDescription("The method by which data is summarized before the raw data is discarded");
            parsedMbeanAttribute2.setDesLookup("perfTuningAdmin.attribute.rule.summaryMech.des");
            parsedMbeanAttribute2.setParamId(SUMMARY_MECH);
            parsedMbeanAttribute2.setLevel("advanced");
            parsedMbeanAttribute2.setName("Summary Mechanism");
            parsedMbeanAttribute2.setNameLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.summaryMech");
            hashMap2 = new HashMap();
            hashMap2.put("perfTuningAdmin.attribute.rule.summaryMech.option.min", "2.0");
            hashMap2.put("perfTuningAdmin.attribute.rule.summaryMech.option.mean", "0.0");
            hashMap2.put("perfTuningAdmin.attribute.rule.summaryMech.option.max", "3.0");
            parsedMbeanAttribute2.setOptions(hashMap2);
            parsedMbeanAttribute2.setType("java.lang.Double");
            parsedMbeanAttribute2.setIsAdvice(false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding attribute : " + parsedMbeanAttribute2.toString());
            }
            hashMap.put(SUMMARY_MECH, parsedMbeanAttribute2.getAdvancedDescription());
            parsedMbeanAttribute2 = new ParsedMbeanAttribute(TREE_HEIGHT);
            parsedMbeanAttribute2.setBasicDescription("Number of summary periods");
            parsedMbeanAttribute2.setDesLookup("perfTuningAdmin.attribute.rule.treeHeight.des");
            parsedMbeanAttribute2.setParamId(TREE_HEIGHT);
            parsedMbeanAttribute2.setLevel("advanced");
            parsedMbeanAttribute2.setName("Number of summaries");
            parsedMbeanAttribute2.setNameLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.treeHeight");
            hashMap2 = new HashMap();
            hashMap2.put("perfTuningAdmin.attribute.3", "3.0");
            hashMap2.put("perfTuningAdmin.attribute.4", "4.0");
            hashMap2.put("perfTuningAdmin.attribute.5", "5.0");
            hashMap2.put("perfTuningAdmin.attribute.10", "10.0");
            parsedMbeanAttribute2.setOptions(hashMap2);
            parsedMbeanAttribute2.setType("java.lang.Double");
            parsedMbeanAttribute2.setIsAdvice(false);
            hashMap.put(TREE_HEIGHT, parsedMbeanAttribute2.getAdvancedDescription());
            parsedMbeanAttribute2 = new ParsedMbeanAttribute(NUMBER_OF_LEAVES);
            parsedMbeanAttribute2.setBasicDescription("The number of raw and summarized data points.  Once x number of data points is reached the data is summarized and discarded.  This number will also determine the number of datapoints available for trend analysis of summarized data");
            parsedMbeanAttribute2.setDesLookup("perfTuningAdmin.attribute.rule.numberLeaves.des");
            parsedMbeanAttribute2.setParamId(NUMBER_OF_LEAVES);
            parsedMbeanAttribute2.setLevel("advanced");
            parsedMbeanAttribute2.setName("Number of raw data points");
            parsedMbeanAttribute2.setNameLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.numberLeaves");
            hashMap2 = new HashMap();
            hashMap2.put("perfTuningAdmin.attribute.5", "5.0");
            hashMap2.put("perfTuningAdmin.attribute.6", "6.0");
            hashMap2.put("perfTuningAdmin.attribute.7", "7.0");
            hashMap2.put("perfTuningAdmin.attribute.8", "8.0");
            hashMap2.put("perfTuningAdmin.attribute.9", "9.0");
            hashMap2.put("perfTuningAdmin.attribute.10", "10.0");
            hashMap2.put("perfTuningAdmin.attribute.15", "15.0");
            hashMap2.put("perfTuningAdmin.attribute.20", "20.0");
            parsedMbeanAttribute2.setOptions(hashMap2);
            parsedMbeanAttribute2.setType("java.lang.Double");
            parsedMbeanAttribute2.setIsAdvice(false);
            hashMap.put(NUMBER_OF_LEAVES, parsedMbeanAttribute2.getAdvancedDescription());
            parsedMbeanAttribute2 = new ParsedMbeanAttribute(ANALYZE_EXPANDING_HEAP);
            parsedMbeanAttribute2.setBasicDescription("Whether or not to analyze memory trends when the heap is still expanding");
            parsedMbeanAttribute2.setDesLookup("perfTuningAdmin.attribute.rule.analyzeExpandingHeap.des");
            parsedMbeanAttribute2.setParamId(ANALYZE_EXPANDING_HEAP);
            parsedMbeanAttribute2.setLevel("advanced");
            parsedMbeanAttribute2.setName("Number of raw data points");
            parsedMbeanAttribute2.setNameLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.analyzeExpandingHeap");
            hashMap2 = new HashMap();
            hashMap2.put("perfTuningAdmin.attribute.true", "1.0");
            hashMap2.put("perfTuningAdmin.attribute.false", "0.0");
            parsedMbeanAttribute2.setOptions(hashMap2);
            parsedMbeanAttribute2.setType("java.lang.Double");
            parsedMbeanAttribute2.setIsAdvice(false);
            hashMap.put(ANALYZE_EXPANDING_HEAP, parsedMbeanAttribute2.getAdvancedDescription());
            parsedMbeanAttribute2 = new ParsedMbeanAttribute(HISTORICAL_MODE);
            parsedMbeanAttribute2.setBasicDescription("Whether or not to take previous diagnosis into account when determining the output for the memory leak rule");
            parsedMbeanAttribute2.setDesLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.historicalMode.des");
            parsedMbeanAttribute2.setParamId(HISTORICAL_MODE);
            parsedMbeanAttribute2.setLevel("advanced");
            parsedMbeanAttribute2.setName("Historical Mode");
            parsedMbeanAttribute2.setNameLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.historicalMode.des");
            hashMap2 = new HashMap();
            hashMap2.put("perfTuningAdmin.attribute.true", "1.0");
            hashMap2.put("perfTuningAdmin.attribute.false", "0.0");
            parsedMbeanAttribute2.setOptions(hashMap2);
            parsedMbeanAttribute2.setType("java.lang.Double");
            parsedMbeanAttribute2.setIsAdvice(false);
            hashMap.put(HISTORICAL_MODE, parsedMbeanAttribute2.getAdvancedDescription());
            parsedMbeanAttribute2 = new ParsedMbeanAttribute(KEEP_TIMES);
            parsedMbeanAttribute2.setBasicDescription("Whether or not to keep track of the time that data points are collected.  This helps in determine memory causes but increases the cost of data collection");
            parsedMbeanAttribute2.setDesLookup("perfTuningAdmin.attribute.rule.keepTimes.des");
            parsedMbeanAttribute2.setParamId(KEEP_TIMES);
            parsedMbeanAttribute2.setLevel("advanced");
            parsedMbeanAttribute2.setName("Keep time statistics");
            parsedMbeanAttribute2.setNameLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.keepTimes");
            hashMap2 = new HashMap();
            hashMap2.put("perfTuningAdmin.attribute.true", "1.0");
            hashMap2.put("perfTuningAdmin.attribute.false", "0.0");
            parsedMbeanAttribute2.setOptions(hashMap2);
            parsedMbeanAttribute2.setType("java.lang.Double");
            parsedMbeanAttribute2.setIsAdvice(false);
            hashMap.put(KEEP_TIMES, parsedMbeanAttribute2.getAdvancedDescription());
            parsedMbeanAttribute2 = new ParsedMbeanAttribute(NUMBER_OF_DECREASING_EXCEPTIONS);
            parsedMbeanAttribute2.setBasicDescription("The number of data points which are allowed to fail a trend test and in order for a set of datapoints to pass that test");
            parsedMbeanAttribute2.setDesLookup("perfTuningAdmin.attribute.rule.numberOfDecreasingExceptions.des");
            parsedMbeanAttribute2.setParamId(NUMBER_OF_DECREASING_EXCEPTIONS);
            parsedMbeanAttribute2.setLevel("advanced");
            parsedMbeanAttribute2.setName("Number of decreasing exceptions");
            parsedMbeanAttribute2.setNameLookup("perfTuningAdmin.attribute.rule.MemoryLeakRule.numberOfDecreasingExceptions");
            hashMap2 = new HashMap();
            hashMap2.put("perfTuningAdmin.attribute.1", "5.0");
            hashMap2.put("perfTuningAdmin.attribute.2", "2.0");
            hashMap2.put("perfTuningAdmin.attribute.3", "3.0");
            hashMap2.put("perfTuningAdmin.attribute.4", "4.0");
            parsedMbeanAttribute2.setOptions(hashMap2);
            parsedMbeanAttribute2.setType("java.lang.Double");
            parsedMbeanAttribute2.setIsAdvice(false);
            hashMap.put(NUMBER_OF_DECREASING_EXCEPTIONS, parsedMbeanAttribute2.getAdvancedDescription());
        }
        catch (Exception exception) {
            Tr.error(tc, "Exception caught : " + exception.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "getStaticAttributeHashMap");
        return hashMap;
    }

    public HashMap getAttributeInfo() {
        HashMap hashMap = new HashMap();
        String string = this.ruleData.getRuleID();
        HashMap hashMap2 = MemoryLeakRule.getStaticAttributeHashMap();
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            hashMap.put(k, (String)hashMap2.get(k) + '#' + "ID" + ':' + string);
        }
        return hashMap;
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setting " + string + ":" + d);
        }
        if (string.equals(MIN_MEMORY_PERCENTAGE)) {
            minMemoryPercentage = d.intValue();
            this.minMemoryMb = minMemoryPercentage * this.maxHeap / 100;
        } else if (string.equals(HISTORICAL_MODE)) {
            this.historicalMode = d == 1.0;
        } else if (string.equals(SUMMARY_MECH)) {
            this.summaryMech = d.intValue();
            this.summaryCalc.setSummaryMech(this.summaryMech);
        } else if (string.equals(TREE_HEIGHT)) {
            this.treeHeight = d.intValue();
            this.summaryCalc.setMaxHeight(this.treeHeight);
            if (this.historicalMode) {
                int n;
                int n2 = this.treeHeight > this.historicalPeriods.length ? this.treeHeight : this.historicalPeriods.length;
                ArrayList[] arrayListArray = new ArrayList[this.treeHeight];
                for (n = 0; n < n2; ++n) {
                    arrayListArray[n] = this.historicalPeriods[n];
                }
                for (n = n2; n < arrayListArray.length; ++n) {
                    arrayListArray[n] = new ArrayList();
                }
                this.historicalPeriods = arrayListArray;
            }
        } else if (string.equals(NUMBER_OF_LEAVES)) {
            numberLeaves = d.intValue();
            this.summaryCalc.setMaxLeaves(numberLeaves);
        } else if (string.equals(MIN_MEMORY_PERCENTAGE)) {
            minMemoryPercentage = d.intValue();
        } else if (string.equals(KEEP_TIMES)) {
            if (d != null) {
                int n = d.intValue();
                this.keepTimes = n == 1;
            }
        } else if (string.equals(ANALYZE_EXPANDING_HEAP)) {
            if (d != null) {
                int n = d.intValue();
                this.analyzeExpandingHeap = n == 1;
            }
        } else if (string.equals(HISTORICAL_MODE)) {
            if (d != null) {
                int n = d.intValue();
                this.historicalMode = n == 1;
                this.maxCertainty = 0.0;
            }
        } else if (string.equals(NUMBER_OF_DECREASING_EXCEPTIONS)) {
            if (d != null) {
                this.decreasingExceptions = d.intValue();
            }
        } else if (string.equals(EXPANDING_FREE_THRESHOLD)) {
            if (d != null) {
                this.expandingFreeThreshold = d.intValue();
            }
        } else if (string.equals(EXPANDING_HEAP_USED_PERCENTAGE) && d != null) {
            this.expandingHeapPct = d.intValue();
        }
    }

    public DiagnosticEvent[] selfDiagnostic(String string) {
        Tr.entry(tc, "selfDiagnostic");
        RuleOutput[] ruleOutputArray = this.createHistoricalRuleOutput(new SinglePeriodOutput[0], false);
        if (!this.isEnabled()) {
            HashMap<String, DiagnosticTypedValue> hashMap = new HashMap<String, DiagnosticTypedValue>();
            DiagnosticTypedValue diagnosticTypedValue = new DiagnosticTypedValue(false, "perfalert.memoryLeak.noProblemNoBlank");
            hashMap.put("memoryLeak-leakDetected", diagnosticTypedValue);
            diagnosticTypedValue = new DiagnosticTypedValue(false, "perfalert.selfDiagnostic.available");
            hashMap.put("diagnosticAvailable", diagnosticTypedValue);
            DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[]{DiagnosticEventFactory.createDiagnosticEvent(string, "selfDiagnostic", 10, this.getClass().getName(), "selfDiagnostic", "com.ibm.ws.performance.tuning.properties.perftuning", "perfalert.selfDiagnostic.memoryLeakRule.disabled", new Object[0], hashMap)};
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "returning : " + diagnosticEventArray[0]);
            }
            return diagnosticEventArray;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got current status,  " + ruleOutputArray.length + " rule outputs");
        }
        DiagnosticEvent[] diagnosticEventArray = new DiagnosticEvent[ruleOutputArray.length];
        for (int i = 0; i < ruleOutputArray.length; ++i) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "   ruleoutput : " + ruleOutputArray[i]);
                }
                RuleOutput ruleOutput = ruleOutputArray[i];
                HashMap<String, DiagnosticTypedValue> hashMap = new HashMap<String, DiagnosticTypedValue>();
                DiagnosticTypedValue diagnosticTypedValue = null;
                diagnosticTypedValue = ruleOutput.getOutputType() == 104 ? new DiagnosticTypedValue(true, "perfalert.memoryLeak.memoryLeakDetectedNoBlank") : new DiagnosticTypedValue(false, "perfalert.memoryLeak.noProblemNoBlank");
                hashMap.put("memoryLeak-leakDetected", diagnosticTypedValue);
                if (ruleOutput.getOutputType() == 106) {
                    diagnosticTypedValue = new DiagnosticTypedValue(true, "perfalert.memoryLeak.canceledNoBlank");
                    hashMap.put("memoryLeak-cancelPreviousLeakDetection", diagnosticTypedValue);
                }
                String[] stringArray = ruleOutput.getSymptoms();
                ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                for (int j = 0; j < stringArray.length; ++j) {
                    arrayList.add(stringArray[j]);
                }
                DiagnosticTypedValue.addCollectionToHashMap(hashMap, "memoryLeak-symptom", arrayList, "perftuningAdmin.symptom.des");
                if (ruleOutput.getOutputType() < 103) {
                    diagnosticEventArray[i] = DiagnosticEventFactory.createDiagnosticEvent(string, "selfDiagnostic", 10, this.getClass().getName(), "selfDiagnostic", "com.ibm.ws.performance.tuning.properties.perftuning", ruleOutput.getMessageId(), ruleOutput.getMessageArgs(), hashMap);
                    continue;
                }
                diagnosticEventArray[i] = DiagnosticEventFactory.createDiagnosticEvent(string, "selfDiagnostic", 50, this.getClass().getName(), "selfDiagnostic", "com.ibm.ws.performance.tuning.properties.perftuning", ruleOutput.getMessageId(), ruleOutput.getMessageArgs(), hashMap);
                continue;
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "caught exception converting RuleOutput to DiagnosticEvent " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "selfDiagnostic");
        return diagnosticEventArray;
    }

    public class CombinedPeriod
    extends SinglePeriodOutput {
        private int alertCount;
        private int warningCount;

        public CombinedPeriod(SinglePeriodOutput singlePeriodOutput) {
            super(singlePeriodOutput.isMemoryLeak, singlePeriodOutput.message, singlePeriodOutput.heapSizeEqualMax, singlePeriodOutput.heapSizeConsistant, singlePeriodOutput.unboundedHeap, singlePeriodOutput.start, singlePeriodOutput.end, singlePeriodOutput.height);
            this.alertCount = 0;
            this.warningCount = 0;
            if (super.getIsMemoryLeak()) {
                ++this.alertCount;
            }
            if (super.getIsMemoryWarning()) {
                ++this.warningCount;
            }
        }

        public int getNumberAlerts() {
            return this.alertCount;
        }

        public int getNumberWarnings() {
            return this.warningCount;
        }

        public boolean getIsMemoryWarning() {
            return this.warningCount > 0;
        }

        public boolean getIsMemoryLeak() {
            return this.alertCount > 0;
        }

        public boolean contains(SinglePeriodOutput singlePeriodOutput) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "contains");
            }
            if (this.height <= singlePeriodOutput.getHeight()) {
                Tr.exit(tc, "contains false due to summary height");
                return false;
            }
            if (this.start.compareTo(singlePeriodOutput.getStartTime()) <= 0 && this.end.compareTo(singlePeriodOutput.getEndTime()) >= 0) {
                Tr.exit(tc, "contains true");
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "contains false");
            }
            return false;
        }

        public void combine(SinglePeriodOutput singlePeriodOutput) throws Exception {
            Tr.entry(tc, "combine");
            if (!this.contains(singlePeriodOutput)) {
                throw new Exception("New Period " + singlePeriodOutput + " is not containable within current period " + this.toString());
            }
            if (singlePeriodOutput.getIsMemoryLeak()) {
                ++this.alertCount;
                this.isMemoryLeak = true;
            }
            if (singlePeriodOutput.getIsMemoryWarning()) {
                ++this.warningCount;
            }
            Tr.exit(tc, "combine");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append("Alert Count : ").append(this.alertCount);
            stringBuffer.append("Warning Count : ").append(this.warningCount);
            return stringBuffer.toString();
        }
    }

    class SinglePeriodOutput {
        protected boolean conclusive;
        protected boolean isMemoryLeak;
        protected MessageWrapper message;
        protected boolean heapSizeEqualMax;
        protected boolean heapSizeConsistant;
        protected boolean unboundedHeap;
        protected int height;
        protected Date start;
        protected Date end;

        public SinglePeriodOutput(boolean bl, MessageWrapper messageWrapper, boolean bl2, boolean bl3, boolean bl4, Date date, Date date2, int n) {
            this(true, bl, messageWrapper, bl2, bl3, bl4, date, date2, n);
        }

        public SinglePeriodOutput(boolean bl, boolean bl2, MessageWrapper messageWrapper, boolean bl3, boolean bl4, boolean bl5, Date date, Date date2, int n) {
            this.conclusive = bl;
            this.isMemoryLeak = bl2;
            this.message = messageWrapper;
            this.heapSizeConsistant = bl4;
            this.heapSizeEqualMax = bl3;
            this.unboundedHeap = bl5;
            this.start = date;
            this.end = date2;
            this.height = n;
        }

        public boolean isConclusive() {
            return this.conclusive;
        }

        public void setConclusive(boolean bl) {
            this.conclusive = bl;
        }

        public int getHeight() {
            return this.height;
        }

        public Date getStartTime() {
            return this.start;
        }

        public Date getEndTime() {
            return this.end;
        }

        public void setUnboundedHeap(boolean bl) {
            this.unboundedHeap = bl;
        }

        public boolean getUnboundedHeap() {
            return this.unboundedHeap;
        }

        public void setIsMemoryLeak(boolean bl) {
            this.isMemoryLeak = true;
        }

        public boolean getIsMemoryWarning() {
            return this.isMemoryLeak && !this.getIsMemoryLeak();
        }

        public boolean getIsMemoryLeak() {
            return this.isMemoryLeak && this.heapSizeEqualMax && this.heapSizeConsistant || this.unboundedHeap && this.isMemoryLeak;
        }

        public void setMessage(String string) {
            this.message = new MessageWrapper(string);
        }

        public String getMessageString() {
            return this.message.getMessage();
        }

        public MessageWrapper getMessageWrapper() {
            return this.message;
        }

        public String getMessageId() {
            return this.message.getId();
        }

        public boolean getHeapSizeEqualMax() {
            return this.heapSizeEqualMax;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getIsMemoryLeak()) {
                stringBuffer.append("MEMORY LEAK.");
            } else if (this.getIsMemoryWarning()) {
                stringBuffer.append("MEMORY WARNING.");
            } else {
                stringBuffer.append("NO LEAK.");
            }
            stringBuffer.append("From ").append(this.start.toString()).append(" to ").append(this.end.toString()).append(".");
            stringBuffer.append("Height : ").append(this.height);
            stringBuffer.append("Message : ").append(this.getMessageString());
            stringBuffer.append("isMemoryLeak: ").append(this.isMemoryLeak).append(",heapSizeEqualMax : ").append(this.heapSizeEqualMax).append(",heapSizeConsistant : ").append(this.heapSizeConsistant);
            stringBuffer.append("unboundedHeap : ").append(this.unboundedHeap);
            return stringBuffer.toString();
        }
    }
}

