/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.leakProtoType_1;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointCalc;
import com.ibm.ws.performance.tuning.leakProtoType_1.DataTree;
import com.ibm.ws.performance.tuning.leakProtoType_1.ICondition;
import com.ibm.ws.performance.tuning.leakProtoType_1.ISummaryPeriodCalc;
import java.util.ArrayList;
import java.util.Date;

public class ServerSummaryPeriodCalc
implements ISummaryPeriodCalc {
    private static TraceComponent tc = Tr.register(ServerSummaryPeriodCalc.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private DataTree dataTree;
    private boolean updateDataTree;
    private ArrayList[] periodCache;
    private boolean keepTimes;
    private IBasicDataPointCalc[] calcs;

    public void setUserId(String string) {
    }

    public void init(PerfDescriptor[] perfDescriptorArray, int[] nArray, ICondition iCondition, int n, int n2, int[] nArray2, boolean bl) {
        int n3;
        this.calcs = new IBasicDataPointCalc[perfDescriptorArray.length];
        for (n3 = 0; n3 < perfDescriptorArray.length; ++n3) {
            this.calcs[n3] = CalcCreator.createBasicDataPointCalc("server");
            this.calcs[n3].init(perfDescriptorArray[n3], nArray[n3]);
        }
        this.keepTimes = bl;
        this.dataTree = new DataTree(this.calcs.length, iCondition, n, n2, nArray2, bl, true);
        this.periodCache = new ArrayList[this.calcs.length];
        for (n3 = 0; n3 < this.periodCache.length; ++n3) {
            this.periodCache[n3] = new ArrayList();
        }
        this.updateDataTree = true;
    }

    public void setSummaryMech(int n) {
        this.dataTree.setSummaryMech(n);
    }

    public void setKeepTimes(boolean bl) {
        this.keepTimes = bl;
        this.dataTree.setKeepTimes(bl);
    }

    public void setDebug(boolean bl) {
        this.dataTree.setDebug(bl);
    }

    public void setMaxHeight(int n) {
        this.dataTree.setMaxHeight(n);
    }

    public void setMaxLeaves(int n) {
        this.dataTree.setMaxHeight(n);
    }

    public void clearData() {
        this.dataTree.clearData();
    }

    public ArrayList[] getSummaryPeriods() throws Exception {
        if (this.updateDataTree) {
            this.updateDataTree();
            this.updateDataTree = false;
        }
        return this.periodCache;
    }

    private void updateDataTree() throws Exception {
        double[] dArray = new double[this.calcs.length];
        boolean bl = true;
        for (int i = 0; i < this.calcs.length; ++i) {
            dArray[i] = this.calcs[i].getDoubleValue();
            if (!TuningUtil.isErrorCode(dArray[i])) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateDataTree " + this.calcs[i].getPD().toString() + " returned invalid data");
            }
            bl = false;
            this.clearData();
            this.updateDataTree = true;
            return;
        }
        if (this.keepTimes) {
            Date date = new Date();
            this.periodCache = this.dataTree.addData(dArray, date.getTime());
        } else {
            this.periodCache = this.dataTree.addData(dArray);
        }
        this.updateDataTree = false;
    }

    public void clear() {
        int n;
        for (n = 0; n < this.calcs.length; ++n) {
            this.calcs[n].clear();
        }
        this.periodCache = new ArrayList[this.calcs.length];
        for (n = 0; n < this.periodCache.length; ++n) {
            this.periodCache[n] = new ArrayList();
        }
        this.updateDataTree = true;
    }

    public String toString() {
        return this.dataTree.toString();
    }

    public double getDoubleValue(int n) {
        return this.calcs[n].getDoubleValue();
    }

    public double[] getDoubleValues() {
        double[] dArray = new double[this.calcs.length];
        for (int i = 0; i < this.calcs.length; ++i) {
            dArray[i] = this.calcs[i].getDoubleValue();
        }
        return dArray;
    }
}

