/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.rule.IRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.rule.SuggestedConfig;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import java.text.NumberFormat;
import java.util.HashMap;

public abstract class AbstractRule
implements IRule,
TuningConstants {
    protected RuleData ruleData;
    protected String userId;
    protected String logName;
    protected static final String[] jvmModule = new String[]{"jvmRuntimeModule"};
    protected static final String[] connPoolModule = new String[]{"connectionPoolModule"};
    protected static final String[] orbPoolModule = new String[]{"threadPoolModule", "ORB.thread.pool"};
    protected static final String[] sePoolModule = new String[]{"threadPoolModule", "Servlet.Engine.Transports"};
    protected static final String[] seSessionModule = new String[]{"servletSessionsModule"};
    protected static final String[] j2cModule = new String[]{"j2cModule"};
    protected static final String[] systemModule = new String[]{"systemModule"};
    protected static final DataDescriptor jvmDD = new DataDescriptor(jvmModule);
    protected static final DataDescriptor connPoolDD = new DataDescriptor(connPoolModule);
    protected static final DataDescriptor orbPoolDD = new DataDescriptor(orbPoolModule);
    protected static final DataDescriptor sePoolDD = new DataDescriptor(sePoolModule);
    protected static final DataDescriptor seSessionDD = new DataDescriptor(seSessionModule);
    protected static final DataDescriptor j2cDD = new DataDescriptor(j2cModule);
    protected static final DataDescriptor systemDD = new DataDescriptor(systemModule);

    public abstract void init(String var1, String var2, RuleData var3);

    public abstract void init(String var1, String var2, String var3, RuleData var4);

    public abstract RuleOutput[] runRule();

    protected String checkAppendLog(String string) {
        if (this.logName == null) {
            return string;
        }
        return string + '#' + this.logName;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setParam(String string, Double d) {
        this.ruleData.setParam(string, d);
    }

    public String getRuleId() {
        return this.ruleData.getRuleID();
    }

    public String[] getParamNames() {
        return this.ruleData.getParamNames();
    }

    public Double getParam(String string) {
        return this.ruleData.getParam(string);
    }

    public boolean isEnabled() {
        return this.ruleData.getEnabled();
    }

    public void setEnabled(boolean bl) {
        this.ruleData.setEnabled(bl);
        if (!bl) {
            this.clearHistory();
        }
    }

    public RuleOutput createExceptionOutput(String string, PerfDescriptor perfDescriptor, int n, MessageWrapper messageWrapper, MessageWrapper[] messageWrapperArray, SuggestedConfig[] suggestedConfigArray) {
        return new RuleOutput(string, perfDescriptor, n, messageWrapper, messageWrapperArray, suggestedConfigArray);
    }

    public RuleOutput createGeneralErrorOutput(String string, PerfDescriptor perfDescriptor, double d) {
        return TuningUtil.createGeneralErrorOutput(string, perfDescriptor, d);
    }

    protected double roundDown(double d, double d2) {
        double d3 = d % d2;
        return d - d3;
    }

    protected double roundUp(double d, double d2) {
        double d3 = d2 - d % d2;
        return d + d3;
    }

    public boolean isApplicable() {
        return true;
    }

    public String trimDecimal(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(Math.abs(d) > 0.1 ? 3 : (Math.abs(d) < 1.0E-4 ? 8 : 5));
        return numberFormat.format(d);
    }

    public double format(double d) {
        return TuningUtil.format(d);
    }

    public static double format(double d, int n) {
        return TuningUtil.format(d, n);
    }

    public String sigDigits(double d, int n) {
        return TuningUtil.sigDigits(d, n);
    }

    public String getRuleNameLookup() {
        return this.ruleData.getNameKey();
    }

    public String getRuleName() {
        return this.ruleData.getName();
    }

    public HashMap getAttributeInfo() {
        return new HashMap();
    }

    public void clearHistory() {
    }

    public DiagnosticEvent[] selfDiagnostic(String string) {
        return new DiagnosticEvent[0];
    }
}

