/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IModuleChildDataPointCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ICpuSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractSessionRule
extends AbstractRule {
    private static TraceComponent tc = Tr.register(AbstractSessionRule.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    protected HashMap map;
    protected String ruleName;
    protected String node;
    protected String server;
    protected ICpuSharedCalc cpuCalc;
    protected IModuleChildDataPointCalc dpCalc;
    protected HashMap attributeMap;
    protected PerfDescriptor pd;
    protected HashMap ddMap;
    protected ArrayList dds;
    private int counter;
    protected String ruleType;

    public void init(String string, String string2, RuleData ruleData) {
        Tr.entry(tc, "init");
        this.ruleData = ruleData;
        this.node = string;
        this.server = string2;
        this.ruleType = ruleData.getType();
        this.ruleName = ruleData.getName();
        this.map = ruleData.getParamMap();
        this.counter = EngineParameters.getRefreshIteration() - 1;
        this.pd = new PerfDescriptorImpl(string, string2, seSessionDD);
        this.pd.postInit();
        if (this.pd == null) {
            // empty if block
        }
        this.cpuCalc = CalcCreator.getCpuCachedCalc(this.checkAppendLog(this.ruleType), this.userId, string, string2);
        this.dpCalc = CalcCreator.createModuleChildDataPointCalc(this.checkAppendLog(this.ruleType));
        this.dpCalc.setUserId(this.userId);
        this.dpCalc.init(this.pd);
        this.dds = new ArrayList();
        this.ddMap = new HashMap();
        Tr.exit(tc, "init");
    }

    protected void createTmpCalcArrays(int n) {
    }

    protected void createCalcObjectsInTmpArray(PerfDescriptor perfDescriptor, int n, boolean bl, int n2) {
    }

    protected void updateCalcArrayWithTmpArray() {
    }

    protected void checkInterval() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Tr.entry(tc, "checkInterval");
        ++this.counter;
        if (this.counter == EngineParameters.getRefreshIteration()) {
            this.counter = EngineParameters.getRefreshIteration() - 1;
            this.dds = this.dpCalc.getDataPoints();
            this.createTmpCalcArrays(this.dds.size());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   there are : " + this.dds.size() + " datapoints ");
            }
            for (int i = 0; i < this.dds.size(); ++i) {
                PerfDescriptor perfDescriptor = (PerfDescriptor)this.dds.get(i);
                perfDescriptor.postInit();
                if (perfDescriptor == null) {
                    // empty if block
                }
                String[] stringArray = perfDescriptor.getDataDescriptor().getPath();
                String string = new String();
                for (int j = 0; j < stringArray.length; ++j) {
                    string = string + "->" + stringArray[j];
                }
                if (this.ddMap.containsKey(string)) {
                    Integer n = (Integer)this.ddMap.get(string);
                    hashMap.put(string, new Integer(i));
                    this.createCalcObjectsInTmpArray(perfDescriptor, i, false, n);
                    continue;
                }
                hashMap.put(string, new Integer(i));
                this.createCalcObjectsInTmpArray(perfDescriptor, i, true, -1);
            }
            this.ddMap = hashMap;
            this.updateCalcArrayWithTmpArray();
        }
        Tr.exit(tc, "checkInterval");
    }

    public void setParam(String string, Double d) {
        super.setParam(string, d);
    }

    public HashMap getAttributeInfo() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
        }
        return this.attributeMap;
    }

    protected boolean isWorkingSystem() {
        return this.cpuCalc.getCurrentUsage() > (double)EngineParameters.getMinCpuUsage();
    }
}

