/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.ICacheCalc;
import com.ibm.ws.performance.tuning.calc.IModuleChildDataPointCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import java.util.ArrayList;
import java.util.HashMap;

public class CacheRuleStateless
extends AbstractRule {
    private ICacheCalc cacheCalc;
    private String server;
    private String node;
    private RuleData data;
    private String ruleType;
    private PerfDescriptor cachePD;
    private PerfDescriptor templPD;
    private PerfDescriptor nodeServerPD;
    private static final String[] dynaCacheModule = new String[]{"cacheModule"};
    private IModuleChildDataPointCalc dynaCacheModulePD;
    private PerfDescriptor dynaCachePD;
    protected static final String SIZE_LOWER_BOUND_PERCENTAGE = "SzLowerBoundPercent";
    protected double szLowerBoundPercent;
    private static TraceComponent tc = Tr.register(CacheRuleStateless.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void init(String string, String string2, RuleData ruleData) {
        this.server = string2;
        this.node = string;
        this.nodeServerPD = new PerfDescriptorImpl(string, string2, null);
        this.ruleData = ruleData;
        this.ruleType = this.ruleData.getType();
        this.szLowerBoundPercent = ruleData.getParam(SIZE_LOWER_BOUND_PERCENTAGE);
        this.dynaCacheModulePD = CalcCreator.createModuleChildDataPointCalc(this.checkAppendLog(this.ruleType));
        this.dynaCacheModulePD.setUserId(this.userId);
        this.cacheCalc = CalcCreator.createCacheCalc(this.checkAppendLog(this.ruleData.getType()));
        this.cacheCalc.setUserId(this.userId);
        this.cacheCalc.init(string, string2);
    }

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public RuleOutput[] runRule() {
        RuleOutput[] ruleOutputArray;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runRule ");
            }
            Object var1_1 = null;
            ruleOutputArray = null;
            try {
                this.dynaCachePD = new PerfDescriptorImpl(this.node, this.server, new DataDescriptor(dynaCacheModule));
                this.dynaCacheModulePD.init(this.dynaCachePD);
                ArrayList arrayList = this.dynaCacheModulePD.getDataPoints();
                ruleOutputArray = new RuleOutput[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    PerfDescriptor perfDescriptor = (PerfDescriptor)arrayList.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "fullName : " + perfDescriptor.getFullName());
                        Tr.debug(tc, "moduleName : " + perfDescriptor.getModuleName());
                        Tr.debug(tc, "name : " + perfDescriptor.getName());
                        Tr.debug(tc, "path : " + perfDescriptor.getPath());
                    }
                    if (perfDescriptor.getName().startsWith("Servlet: ")) {
                        ruleOutputArray[i] = this.runRule0(perfDescriptor.getName(), "Servlet");
                        continue;
                    }
                    if (!perfDescriptor.getName().startsWith("Object: ")) continue;
                    ruleOutputArray[i] = this.runRule0(perfDescriptor.getName(), "Object");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.performance.turning.rule.CacheRuleStateless.runRule", "196", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, " Exception when getting the Dynacache instances: " + exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runRule");
        }
        return ruleOutputArray;
    }

    private RuleOutput runRule0(String string, String string2) {
        long l;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runRule0 ");
        }
        this.cacheCalc.clear();
        this.cacheCalc.getPerfDescriptors(string, string2);
        PerfDescriptor perfDescriptor = this.cacheCalc.getCachePD();
        long l2 = this.cacheCalc.getMaxInMemoryCacheSize();
        if (TuningUtil.isErrorCode(l2)) {
            return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, l2);
        }
        long l3 = this.cacheCalc.getInMemoryCacheSize();
        if (TuningUtil.isErrorCode(l3)) {
            return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, l3);
        }
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        if (string2.equals("Servlet")) {
            object = this.cacheCalc.getTemplatePerfDescriptors();
            if (object == null) {
                return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, -102.0);
            }
            for (int i = 0; i < ((PerfDescriptor[])object).length; ++i) {
                l = this.cacheCalc.getRequestsFromClient(object[i]);
                if (TuningUtil.isErrorCode(l)) {
                    return this.createGeneralErrorOutput(this.ruleData.getName(), object[i], l);
                }
                l4 += l;
                l = this.cacheCalc.getRequestsFromJvm(object[i]);
                if (TuningUtil.isErrorCode(l)) {
                    return this.createGeneralErrorOutput(this.ruleData.getName(), object[i], l);
                }
                l4 += l;
                l = this.cacheCalc.getHitsInMemory(object[i]);
                if (TuningUtil.isErrorCode(l)) {
                    return this.createGeneralErrorOutput(this.ruleData.getName(), object[i], l);
                }
                l5 += l;
                l = this.cacheCalc.getMisses(object[i]);
                if (TuningUtil.isErrorCode(l)) {
                    return this.createGeneralErrorOutput(this.ruleData.getName(), object[i], l);
                }
                l6 += l;
                l = this.cacheCalc.getLruInvalidations(object[i]);
                if (TuningUtil.isErrorCode(l)) {
                    return this.createGeneralErrorOutput(this.ruleData.getName(), object[i], l);
                }
                l7 += l;
            }
        } else {
            object = this.cacheCalc.getObjectCachePD();
            if (object == null) {
                return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, -102.0);
            }
            l = this.cacheCalc.getRequestsFromClient((PerfDescriptor)object);
            if (TuningUtil.isErrorCode(l)) {
                return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, l);
            }
            l4 += l;
            l = this.cacheCalc.getRequestsFromJvm((PerfDescriptor)object);
            if (TuningUtil.isErrorCode(l)) {
                return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, l);
            }
            l4 += l;
            l = this.cacheCalc.getHitsInMemory((PerfDescriptor)object);
            if (TuningUtil.isErrorCode(l)) {
                return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, l);
            }
            l5 += l;
            l = this.cacheCalc.getMisses((PerfDescriptor)object);
            if (TuningUtil.isErrorCode(l)) {
                return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, l);
            }
            l6 += l;
            l = this.cacheCalc.getLruInvalidations((PerfDescriptor)object);
            if (TuningUtil.isErrorCode(l)) {
                return this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptor, l);
            }
            l7 += l;
        }
        if (l7 == 0L) {
            return this.noProblemEntries();
        }
        l = l4 - l7;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "[CacheRuleStateless] cachesize: " + l2 + "  reqs: " + l4 + "  discards: " + l7);
            Tr.debug(tc, "[CacheRuleStateless] hits: " + l5 + "  misses: " + l6 + "  ratio: " + (double)l5 / (double)l6);
        }
        if (l != 0L) {
            double d = this.format(l2 * l4 / l);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "[CacheRuleStateless] ideal_size: " + d);
            }
            if (d > (double)l2 && l6 != 0L) {
                double d2 = CacheRuleStateless.format((double)l5 / (double)l6, 3);
                return this.increaseEntriesAlert(d, l2, d2, l7, string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "runRule");
        }
        return this.noProblemEntries();
    }

    private double snapToIncrement(double d) {
        return 100.0 * Math.ceil(d / 100.0);
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (string.equals(SIZE_LOWER_BOUND_PERCENTAGE)) {
            double d2 = d;
            if (d2 >= 0.0 & d2 < 1.0) {
                this.szLowerBoundPercent = d2;
            } else {
                throw new IllegalArgumentException("SzLowerBoundPercent must be between 0.0 and 1.0: " + d2);
            }
        }
    }

    public HashMap getAttributeInfo() {
        return new HashMap();
    }

    private RuleOutput increaseEntriesAlert(double d, long l, double d2, long l2, String string) {
        MessageWrapper[] messageWrapperArray = new MessageWrapper[1];
        MessageWrapper[] messageWrapperArray2 = new MessageWrapper[2];
        Object[] objectArray = new Object[]{new Double(l), new Double(d)};
        messageWrapperArray[0] = new MessageWrapper("perf.tuning.dynacache.entries.increaseEntries", new Object[]{string, new Double(d)});
        messageWrapperArray2[0] = new MessageWrapper("perf.tuning.dynacache.currentNewSize", objectArray);
        messageWrapperArray2[1] = new MessageWrapper("perf.tuning.dynacache.hitToMissRatio", new Double(d2));
        return new RuleOutput(this.ruleData.getName(), this.nodeServerPD, 104, messageWrapperArray[0], messageWrapperArray2, null);
    }

    private RuleOutput decreaseEntriesAlert(double d, long l, long l2, String string) {
        MessageWrapper[] messageWrapperArray = new MessageWrapper[1];
        MessageWrapper[] messageWrapperArray2 = new MessageWrapper[2];
        Object[] objectArray = new Object[]{new Double(l2), new Double(d)};
        messageWrapperArray[0] = new MessageWrapper("perf.tuning.dynacache.entries.decreaseEntries", new Object[]{string, new Double(d)});
        messageWrapperArray2[0] = new MessageWrapper("perf.tuning.dynacache.currentNewSize", objectArray);
        messageWrapperArray2[1] = new MessageWrapper("perf.tuning.dynacache.maxUsedEntries", new Double(l));
        return new RuleOutput(this.ruleData.getName(), this.nodeServerPD, 104, messageWrapperArray[0], messageWrapperArray2, null);
    }

    private RuleOutput noProblemEntries() {
        MessageWrapper messageWrapper = new MessageWrapper("perf.tuning.dynacache.entries.noProblem");
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{};
        return new RuleOutput(this.ruleData.getName(), this.nodeServerPD, 101, messageWrapper, messageWrapperArray, null);
    }
}

