/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.rule.IRule;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleDriver;
import com.ibm.ws.performance.tuning.rule.RuleLookup;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import com.ibm.ws.runtime.service.Repository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ClientRuleDriver
implements RuleDriver,
TuningConstants {
    private boolean DEBUG = false;
    private RuleLookup ruleLookup;
    private HashMap ruleSetMap = new HashMap();
    private ArrayList ruleDataList = new ArrayList();
    private String _ruleType = "thin_client";
    private static TraceComponent tc = Tr.register(ClientRuleDriver.class, "PerformanceTuningAdvisor", "com.ibm.ws.performance.tuning.properties.perftuning");

    public ClientRuleDriver() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<constructor>");
        }
        this.ruleLookup = new RuleLookup("perftuners.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<constructor>");
        }
    }

    public ClientRuleDriver(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<constructor>", string);
        }
        this.ruleLookup = new RuleLookup("perftuners.xml");
        this._ruleType = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<constructor>");
        }
    }

    public void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        try {
            EngineParameters.setCachedValuesFromRuleLookup(this.ruleLookup);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ArrayList arrayList = this.ruleLookup.getRules();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            RuleData ruleData = (RuleData)arrayList.get(i);
            if (!ruleData.getType().equalsIgnoreCase(this._ruleType) || !ruleData.getEnabled()) continue;
            this.ruleDataList.add(ruleData);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clear");
        }
        this.ruleSetMap.clear();
        CalcCreator.clearClientCalcCache();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    public ArrayList run() {
        return null;
    }

    public ArrayList run(String string, String string2, String string3, String string4, Repository repository2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run", new Object[]{string, string2, string3, string4, repository2});
        }
        if (string4 == null) {
            try {
                RepositoryCache.init(repository2, string2, string3);
                RepositoryCache.refreshAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ArrayList arrayList = this.getRulesFromCache(string, string2, string3, string4);
        ArrayList<RuleOutput> arrayList2 = new ArrayList<RuleOutput>();
        int n = arrayList.size();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Running rule, the number of rules is " + n);
        }
        for (int i = 0; i < n; ++i) {
            IRule iRule = (IRule)arrayList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Running rule, " + iRule);
                Tr.debug(tc, "isApplicable, " + iRule.isApplicable());
            }
            if (!iRule.isApplicable()) continue;
            RuleOutput[] ruleOutputArray = null;
            try {
                ruleOutputArray = iRule.runRule();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (ruleOutputArray == null || ruleOutputArray.length <= 0) continue;
            for (int j = 0; j < ruleOutputArray.length; ++j) {
                if (ruleOutputArray[j] == null || ruleOutputArray[j].getOutputType() == 101) continue;
                arrayList2.add(ruleOutputArray[j]);
            }
        }
        if (string4 == null) {
            CalcCreator.updateSharedCalcs();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run", new Object[]{arrayList2});
        }
        return arrayList2;
    }

    private ArrayList createRuleObjects(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRuleObjects", new String[]{string, string2, string3, string4});
        }
        ArrayList<IRule> arrayList = new ArrayList<IRule>();
        for (int i = 0; i < this.ruleDataList.size(); ++i) {
            RuleData ruleData = (RuleData)this.ruleDataList.get(i);
            try {
                Class<?> clazz = Class.forName(ruleData.getClassName());
                IRule iRule = (IRule)clazz.newInstance();
                iRule.setUserId(string);
                if (string4 == null) {
                    iRule.init(string2, string3, ruleData);
                } else {
                    iRule.init(string2, string3, string4, ruleData);
                }
                arrayList.add(iRule);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRuleObjects");
        }
        return arrayList;
    }

    private ArrayList getRulesFromCache(String string, String string2, String string3, String string4) {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRulesFromCache", new String[]{string, string2, string3, string4});
        }
        if ((v = this.ruleSetMap.get(this.generateKey(string, string2, string3, string4))) == null) {
            ArrayList arrayList = this.createRuleObjects(string, string2, string3, string4);
            this.putRulesInCache(string, string2, string3, string4, arrayList);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRulesFromCache - created new");
            }
            return arrayList;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRulesFromCache - returned cached");
        }
        return (ArrayList)v;
    }

    private void putRulesInCache(String string, String string2, String string3, String string4, ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putRulesInCache", new String[]{string, string2, string3, string4});
        }
        String string5 = this.generateKey(string, string2, string3, string4);
        if (this.ruleSetMap.isEmpty() || !this.ruleSetMap.containsKey(string5)) {
            this.ruleSetMap.put(string5, arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putRulesInCache");
        }
    }

    private String generateKey(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer(string).append(".");
        if (string4 == null) {
            stringBuffer.append(string2).append(".").append(string3);
        } else {
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public boolean getDebug() {
        return this.DEBUG;
    }

    public void setDebug(boolean bl) {
        this.DEBUG = bl;
    }
}

