/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.rule.DSPoolMinAndMaxSizeStateless;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.rule.RuleState;
import com.ibm.ws.performance.tuning.rule.StatefullRuleInterface;
import java.util.HashMap;

public class DSPoolMinAndMaxSizeStatefull
extends DSPoolMinAndMaxSizeStateless
implements StatefullRuleInterface {
    private final int OTHER_DATA_COUNT = 8;
    private final int MAX_CP_RECOMMENDATION_IDX = 7;
    private final int MAX_CP_ALERT_STREAK_IDX = 6;
    private final int MAX_CP_IDX = 5;
    private final int MIN_CP_RECOMMENDATION_IDX = 4;
    private final int MIN_CP_ALERT_STREAK_IDX = 3;
    private final int MIN_CP_IDX = 2;
    private final int PCT_USED_IDX = 1;
    private final int UPDATED_IDX = 0;
    private final int UPDATED = 1;
    private final int ORIG = 0;
    private HashMap ruleStateMap;
    boolean updateable = false;
    int updateThreshold = -1;

    private void printStateDetails(PerfDescriptor perfDescriptor) {
        RuleState ruleState = (RuleState)this.ruleStateMap.get(perfDescriptor.getFullName());
        System.out.println("          MAX_CP_RECOMMENDATION_IDX = " + ruleState.getData(6));
        System.out.println("          MAX_CP_ALERT_STREAK_IDX = " + ruleState.getData(6));
        System.out.println("          MAX_CP_IDX              = " + ruleState.getData(5));
        System.out.println("          MIN_CP_RECOMMENDATION_IDX = " + ruleState.getData(3));
        System.out.println("          MIN_CP_ALERT_STREAK_IDX = " + ruleState.getData(3));
        System.out.println("          MIN_CP_IDX              = " + ruleState.getData(2));
        System.out.println("          PCT_USED_IDX        = " + ruleState.getData(1));
        System.out.println("          UPDATED_IDX             = " + ruleState.getData(0));
    }

    public void setMaxAlertStreak(Integer n) {
        int n2 = n;
        this.updateable = n2 > 0;
        this.updateThreshold = n2;
    }

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
        HashMap hashMap = this.ruleData.getParamMap();
        this.updateable = true;
        this.updateThreshold = EngineParameters.getMaxAlertStreak();
        this.ruleStateMap = new HashMap();
    }

    private RuleState getRuleState(PerfDescriptor perfDescriptor) {
        RuleState ruleState = (RuleState)this.ruleStateMap.get(perfDescriptor.getFullName());
        if (ruleState == null) {
            ruleState = new RuleState(8);
            ruleState.setData(1, 0.0);
            ruleState.setData(0, 0.0);
            double d = this.config.getMinConnectionPoolSize(perfDescriptor);
            double d2 = this.config.getMaxConnectionPoolSize(perfDescriptor);
            ruleState.setData(2, d);
            ruleState.setData(4, d);
            ruleState.setData(6, 0.0);
            ruleState.setData(5, d2);
            ruleState.setData(7, d2);
            ruleState.setData(6, 0.0);
            this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        }
        return ruleState;
    }

    protected double getMaxSetting(PerfDescriptor perfDescriptor) {
        return this.getRuleState(perfDescriptor).getData(7);
    }

    protected double getMinSetting(PerfDescriptor perfDescriptor) {
        return this.getRuleState(perfDescriptor).getData(4);
    }

    protected RuleOutput lowCpu(PerfDescriptor perfDescriptor, double d, double d2) {
        RuleOutput ruleOutput = super.lowCpu(perfDescriptor, d, d2);
        this.resetAlertStreak(ruleOutput, perfDescriptor);
        this.addSymptoms(ruleOutput, this.getRuleState(perfDescriptor));
        return ruleOutput;
    }

    protected RuleOutput issueIncreaseAlert(PerfDescriptor perfDescriptor, double d, double d2, int n, int n2) {
        RuleOutput ruleOutput = super.issueIncreaseAlert(perfDescriptor, d, d2, n, n2);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(3, 0.0);
        if (this.updateable) {
            ruleState.increaseData(6);
            if ((double)n > ruleState.getData(5)) {
                ruleState.setData(5, n);
            }
            if (ruleState.getData(6) >= (double)this.updateThreshold) {
                ruleState.setData(7, ruleState.getData(5));
                ruleState.setData(6, 0.0);
                Integer n3 = new Integer(this.updateThreshold);
                ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", n3));
            }
        }
        this.addSymptoms(ruleOutput, ruleState);
        return ruleOutput;
    }

    protected RuleOutput issueAlert(PerfDescriptor perfDescriptor, double d, int n, int n2, double d2, double d3) {
        RuleOutput ruleOutput = super.issueAlert(perfDescriptor, d, n, n2, d2, d3);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(6, 0.0);
        if (this.updateable) {
            ruleState.increaseData(3);
            if ((double)n2 < ruleState.getData(2) || (double)n < ruleState.getData(5)) {
                ruleState.setData(2, n2);
                ruleState.setData(5, n);
                ruleState.setData(1, d);
            }
            if (ruleState.getData(3) >= (double)this.updateThreshold) {
                ruleState.setData(4, ruleState.getData(2));
                ruleState.setData(7, ruleState.getData(5));
                ruleState.setData(3, 0.0);
                Integer n3 = new Integer(this.updateThreshold);
                ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", n3));
            }
        }
        this.addSymptoms(ruleOutput, ruleState);
        return ruleOutput;
    }

    public RuleOutput createGeneralErrorOutput(PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.createGeneralErrorOutput(this.ruleName, perfDescriptor, d);
        if (this.updateable) {
            this.resetAlertStreak(ruleOutput, perfDescriptor);
        }
        return ruleOutput;
    }

    public RuleOutput noProblem(PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.noProblem(perfDescriptor, d);
        if (this.updateable) {
            this.resetAlertStreak(ruleOutput, perfDescriptor);
        }
        this.addSymptoms(ruleOutput, this.getRuleState(perfDescriptor));
        return ruleOutput;
    }

    public RuleOutput noProblemPoolSizeGreaterThanMin(PerfDescriptor perfDescriptor, double d, double d2) {
        RuleOutput ruleOutput = super.noProblemPoolSizeGreaterThanMin(perfDescriptor, d, d2);
        if (this.updateable) {
            this.resetAlertStreak(ruleOutput, perfDescriptor);
        }
        this.addSymptoms(ruleOutput, this.getRuleState(perfDescriptor));
        return ruleOutput;
    }

    private void resetAlertStreak(RuleOutput ruleOutput, PerfDescriptor perfDescriptor) {
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(3, 0.0);
        ruleState.setData(6, 0.0);
    }

    public RuleOutput[] runRule() {
        return super.runRule();
    }

    protected void setMinPercent(PerfDescriptor perfDescriptor, double d) {
    }

    private void addSymptoms(RuleOutput ruleOutput, RuleState ruleState) {
        Object[] objectArray = new Object[]{new Double(ruleState.getData(7)), new Double(ruleState.getData(1))};
        ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.dsMinMax.thresholdRange", objectArray));
    }

    public void clearHistory() {
        super.clearHistory();
        this.ruleStateMap = new HashMap();
    }
}

