/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointCalc;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryTimeCalc;
import com.ibm.ws.performance.tuning.calc.IModuleChildDataPointCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ICpuSharedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IDataSourceMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DSPoolMinAndMaxSizeStateless
extends AbstractRule {
    protected String ruleName;
    private String ruleType;
    private boolean initialized = false;
    private IModuleChildDataPointCalc j2CProviderPdCalc;
    private IModuleChildDataPointCalc dpCalc;
    private IModuleChildDataPointCalc connPoolProviderPdCalc;
    private ICpuSharedCalc cpuCalc;
    protected IDataSourceMBeanSharedCalc config;
    private ArrayList percentUsedCalcs = new ArrayList();
    private ArrayList sizeCalcs = new ArrayList();
    private PerfDescriptor connPoolPD;
    private PerfDescriptor j2CPoolPD;
    private ArrayList dataSourcePDs;
    private ArrayList dataSourceNames = new ArrayList();
    private static TraceComponent tc = Tr.register(DSPoolMinAndMaxSizeStateless.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    protected static final String MIN_PERCENT = new String("MinPercentOfPoolUsed");
    protected static final String INCREASE_PERCENTAGE = new String("IncreasePercentage");
    protected static final String HIGH_USAGE_THRESHOLD = new String("HighUsageThreshold");
    private static final int MIN_POOL_RANGE = 3;
    protected double defaultMinPercent = 80.0;
    protected double defaultHighUsage;
    protected double increasePercentage;
    private String node;
    private String server;
    protected int iterationCount = 1;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        Tr.entry(tc, "init");
        this.ruleData = ruleData;
        this.node = string;
        this.server = string2;
        HashMap hashMap = ruleData.getParamMap();
        this.ruleType = ruleData.getType();
        this.ruleName = ruleData.getName();
        Object v = hashMap.get(MIN_PERCENT);
        if (v != null) {
            this.defaultMinPercent = (Double)v;
        }
        if ((v = hashMap.get(HIGH_USAGE_THRESHOLD)) != null) {
            this.defaultHighUsage = ((Double)v).intValue();
        }
        if ((v = hashMap.get(INCREASE_PERCENTAGE)) != null) {
            this.increasePercentage = ((Double)v).intValue();
        }
        this.iterationCount = EngineParameters.getRefreshIteration() - 1;
        Tr.exit(tc, "init");
    }

    private void init1() {
        Tr.entry(tc, "init1");
        this.config = CalcCreator.getDataSourceMBeanSharedCalc(this.node, this.server, this.checkAppendLog(this.ruleType));
        this.getDataSourceNames();
        this.j2CProviderPdCalc = CalcCreator.createModuleChildDataPointCalc(this.checkAppendLog(this.ruleType));
        this.j2CPoolPD = new PerfDescriptorImpl(this.node, this.server, j2cDD);
        this.j2CProviderPdCalc.setUserId(this.userId);
        this.j2CProviderPdCalc.init(this.j2CPoolPD);
        this.connPoolProviderPdCalc = CalcCreator.createModuleChildDataPointCalc(this.checkAppendLog(this.ruleType));
        this.connPoolPD = new PerfDescriptorImpl(this.node, this.server, connPoolDD);
        this.connPoolProviderPdCalc.setUserId(this.userId);
        this.connPoolProviderPdCalc.init(this.connPoolPD);
        this.dpCalc = CalcCreator.createModuleChildDataPointCalc(this.checkAppendLog(this.ruleType));
        this.dpCalc.setUserId(this.userId);
        this.setDataPoints(this.connPoolProviderPdCalc);
        this.setDataPoints(this.j2CProviderPdCalc);
        Tr.exit(tc, "init1");
    }

    private void setDataPoints(IModuleChildDataPointCalc iModuleChildDataPointCalc) {
        int n;
        Serializable serializable;
        int n2;
        Tr.entry(tc, "setDataPoints");
        ArrayList arrayList = iModuleChildDataPointCalc.getDataPoints();
        Tr.debug(tc, "   number of perfDescriptors size:" + arrayList.size());
        this.dataSourcePDs = new ArrayList();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            PerfDescriptor perfDescriptor = (PerfDescriptor)arrayList.get(n2);
            this.dpCalc.init(perfDescriptor);
            serializable = this.dpCalc.getDataPoints();
            for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                Tr.debug(tc, "DSPoolMinAndMax.setDataPoints adding " + ((ArrayList)serializable).get(n).toString());
                this.dataSourcePDs.add(((ArrayList)serializable).get(n));
            }
        }
        n2 = this.dataSourcePDs.size();
        for (int i = 0; i < n2; ++i) {
            Object object;
            serializable = (PerfDescriptor)this.dataSourcePDs.get(i);
            Tr.debug(tc, "PerfDescriptor name " + serializable.getName());
            if (!this.isDataSource((PerfDescriptor)serializable)) continue;
            Tr.debug(tc, "Added PerfDescriptor " + serializable.getName());
            serializable.postInit();
            n = 1;
            for (int j = 0; j < this.percentUsedCalcs.size(); ++j) {
                object = ((IBasicDataPointHistoryTimeCalc)this.percentUsedCalcs.get(j)).getPD().getFullName();
                if (!serializable.getFullName().equals(object)) continue;
                n = 0;
                break;
            }
            if (n == 0) continue;
            IBasicDataPointHistoryTimeCalc iBasicDataPointHistoryTimeCalc = CalcCreator.createBasicDataPointHistoryTimeCalc(this.checkAppendLog(this.ruleType));
            iBasicDataPointHistoryTimeCalc.setUserId(this.userId);
            iBasicDataPointHistoryTimeCalc.init((PerfDescriptor)serializable, 9);
            this.percentUsedCalcs.add(iBasicDataPointHistoryTimeCalc);
            object = CalcCreator.createBasicDataPointCalc(this.checkAppendLog(this.ruleType));
            object.setUserId(this.userId);
            object.init((PerfDescriptor)serializable, 5);
            this.sizeCalcs.add(object);
        }
        Tr.exit(tc, "setDataPoints");
    }

    protected RuleOutput lowCpu(PerfDescriptor perfDescriptor, double d, double d2) {
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.SystemNotUnderLoad");
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.cpuUsed", new Double(d2)), new MessageWrapper("perfalert.percentUsed", new Double(d))};
        return new RuleOutput(this.ruleName, perfDescriptor, 101, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput issueAlert(PerfDescriptor perfDescriptor, double d, int n, int n2, double d2, double d3) {
        Object[] objectArray = new Object[3];
        if (n - n2 < 3) {
            n = n2 + 3;
        }
        int n3 = d3 <= (double)n && d2 <= (double)n2 ? 101 : 104;
        objectArray[0] = new String(perfDescriptor.getDataDescriptor().getName());
        objectArray[1] = new Integer(n2);
        objectArray[2] = new Integer(n);
        MessageWrapper messageWrapper = null;
        messageWrapper = d == 0.0 ? new MessageWrapper("perfalert.connPool.notInUseOrtoolarge", objectArray) : new MessageWrapper("perfalert.connPool.toolarge", objectArray);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.percentUsed", new Double(d))};
        return new RuleOutput(this.ruleName, perfDescriptor, n3, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput issueIncreaseAlert(PerfDescriptor perfDescriptor, double d, double d2, int n, int n2) {
        Object[] objectArray = new Object[]{new String(perfDescriptor.getDataDescriptor().getName()), new Integer(n2), new Integer(n)};
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.connPool.tooSmall", objectArray);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.percentUsed", new Double(d2)), new MessageWrapper("perfalert.pool.poolSize", new Double(d))};
        return new RuleOutput(this.ruleName, perfDescriptor, 104, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput noProblem(PerfDescriptor perfDescriptor, double d) {
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.connPool.usageHigh", perfDescriptor.getDataDescriptor().getName());
        MessageWrapper messageWrapper2 = new MessageWrapper("perfalert.percentUsed", new Double(d));
        RuleOutput ruleOutput = new RuleOutput(this.ruleName, perfDescriptor, 101, messageWrapper, messageWrapper2, null);
        return ruleOutput;
    }

    protected RuleOutput noProblemPoolSizeGreaterThanMin(PerfDescriptor perfDescriptor, double d, double d2) {
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.connPool.poolSizeGreaterThanMin", perfDescriptor.getDataDescriptor().getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.percentUsed", new Double(d)), new MessageWrapper("perfalert.pool.poolSize", new Double(d2))};
        RuleOutput ruleOutput = new RuleOutput(this.ruleName, perfDescriptor, 101, messageWrapper, messageWrapperArray, null);
        return ruleOutput;
    }

    public RuleOutput[] runRule() {
        Tr.entry(tc, "runRule");
        if (!this.initialized) {
            this.init1();
            this.initialized = true;
        }
        if (EngineParameters.getOS().equalsIgnoreCase("z/OS")) {
            return this.runZRule();
        }
        try {
            ++this.iterationCount;
            if (this.iterationCount == EngineParameters.getRefreshIteration()) {
                this.iterationCount = 0;
                this.setDataPoints(this.connPoolProviderPdCalc);
                this.setDataPoints(this.j2CProviderPdCalc);
            }
            this.cpuCalc = CalcCreator.getCpuCachedCalc(this.checkAppendLog(this.ruleType), this.userId, this.node, this.server);
            double d = -1.0;
            RuleOutput[] ruleOutputArray = new RuleOutput[this.percentUsedCalcs.size()];
            Tr.debug(tc, "Number of dataSources being analyzed size:" + this.percentUsedCalcs.size());
            for (int i = 0; i < this.percentUsedCalcs.size(); ++i) {
                int n;
                double d2;
                double d3;
                IBasicDataPointCalc iBasicDataPointCalc;
                double d4;
                IBasicDataPointHistoryTimeCalc iBasicDataPointHistoryTimeCalc = (IBasicDataPointHistoryTimeCalc)this.percentUsedCalcs.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Going to calculate the percentage of connections used for datasource " + iBasicDataPointHistoryTimeCalc.toString());
                }
                PerfDescriptor perfDescriptor = iBasicDataPointHistoryTimeCalc.getPD();
                if (tc.isDebugEnabled()) {
                    this.printStateDetails(perfDescriptor);
                }
                int n2 = this.config.getMaxConnectionPoolSize(perfDescriptor);
                int n3 = this.config.getMinConnectionPoolSize(perfDescriptor);
                double d5 = iBasicDataPointHistoryTimeCalc.getIntervalAverage();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pctUsed:" + d5);
                    Tr.debug(tc, "threshold:" + this.getThreshold(perfDescriptor));
                    Tr.debug(tc, "defaultHighUsage :" + this.defaultHighUsage);
                }
                double d6 = this.defaultHighUsage;
                double d7 = (double)(n2 - 1) / (double)n2 * 100.0;
                if (this.defaultHighUsage > d7) {
                    d6 = n2 == 1 ? 50.0 : d7;
                }
                if (TuningUtil.isErrorCode(d5)) {
                    ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, d5);
                } else if ((d5 = this.format(d5)) < this.getThreshold(perfDescriptor)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pctUsed less than getThreshold");
                    }
                    d4 = this.cpuCalc.getIntervalUsage();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CPU Usage:" + d4);
                    }
                    if (TuningUtil.isErrorCode(d4)) {
                        ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, d4);
                    } else if ((d4 = this.format(d4)) > (double)EngineParameters.getMinCpuUsage()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "MinConnectionPoolSize:" + n3);
                        }
                        if (TuningUtil.isErrorCode(n3)) {
                            ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, n3);
                        } else {
                            iBasicDataPointCalc = (IBasicDataPointCalc)this.sizeCalcs.get(i);
                            d3 = iBasicDataPointCalc.getDoubleValue();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "currentPoolSize:" + d3);
                            }
                            if (TuningUtil.isErrorCode(d3)) {
                                ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, d3);
                            } else if (d3 <= (double)n3) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "MaxConnectionPoolSize:" + n2);
                                }
                                if (TuningUtil.isErrorCode(n2)) {
                                    ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, n2);
                                } else {
                                    d2 = (100.0 - d5) / 100.0 * (double)n2;
                                    n = n2 - new Double(d2).intValue();
                                    int n4 = n3;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "setTo:" + n);
                                        Tr.debug(tc, "setMinTo:" + n4);
                                    }
                                    if (n <= n4) {
                                        n4 = n / 2;
                                    }
                                    if (n - n4 < 3) {
                                        n = n4 + 3;
                                    }
                                    ruleOutputArray[i] = (double)n4 < this.getMinSetting(perfDescriptor) || (double)n < this.getMaxSetting(perfDescriptor) ? this.issueAlert(perfDescriptor, d5, n, n4, n3, n2) : this.noProblem(perfDescriptor, d5);
                                }
                            } else {
                                ruleOutputArray[i] = this.noProblemPoolSizeGreaterThanMin(perfDescriptor, d5, d3);
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "lowCpu Usage");
                        }
                        ruleOutputArray[i] = this.lowCpu(perfDescriptor, d5, d4);
                        iBasicDataPointHistoryTimeCalc.clearHistory();
                    }
                } else if (d5 > d6) {
                    d4 = this.cpuCalc.getIntervalUsage();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CPU Usage:" + d4);
                        Tr.debug(tc, "EngineParameters.getCpuSaturated() :" + EngineParameters.getCpuSaturated());
                    }
                    if (TuningUtil.isErrorCode(d4)) {
                        ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, d4);
                    } else if ((d4 = this.format(d4)) < (double)EngineParameters.getCpuSaturated()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "max Config PoolSize Usage:" + n2);
                        }
                        if (TuningUtil.isErrorCode(n2)) {
                            ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, n2);
                        } else {
                            iBasicDataPointCalc = (IBasicDataPointCalc)this.sizeCalcs.get(i);
                            d3 = iBasicDataPointCalc.getDoubleValue();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "currentPoolSize:" + d3);
                            }
                            if (TuningUtil.isErrorCode(d3)) {
                                ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, d3);
                            } else if (d3 >= (double)n2) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "min Config PoolSize Usage:" + n3);
                                }
                                ruleOutputArray[i] = TuningUtil.isErrorCode(n3) ? this.createGeneralErrorOutput(this.ruleName, perfDescriptor, n3) : ((double)(n = n2 + new Double(d2 = Math.ceil(this.increasePercentage / 100.0 * (double)n2)).intValue()) > this.getMaxSetting(perfDescriptor) ? this.issueIncreaseAlert(perfDescriptor, d3, d5, n, n3) : this.noProblem(perfDescriptor, d5));
                            } else {
                                ruleOutputArray[i] = this.noProblem(perfDescriptor, d5);
                            }
                        }
                    } else {
                        ruleOutputArray[i] = this.noProblem(perfDescriptor, d5);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no problem with this connection pool");
                    }
                    ruleOutputArray[i] = this.noProblem(perfDescriptor, d5);
                }
                Tr.exit(tc, "runRule");
                iBasicDataPointHistoryTimeCalc.clear();
                if (ruleOutputArray[i] != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DSPoolMinAndMaxSize rule lost a rule output");
                }
                ruleOutputArray[i] = TuningUtil.createGeneralErrorOutput(this.ruleName, perfDescriptor, 107.0);
            }
            this.dpCalc.clear();
            Tr.exit(tc, "runRule");
            return ruleOutputArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RuleOutput[] ruleOutputArray = new RuleOutput[]{new RuleOutput(this.ruleName, this.connPoolPD, 108, new MessageWrapper("perfalert.exception.stacktrace", exception.toString()), new MessageWrapper[0], null)};
            this.setEnabled(false);
            Tr.exit(tc, "runRule");
            return ruleOutputArray;
        }
    }

    public RuleOutput[] runZRule() {
        Tr.entry(tc, "runRule");
        if (!this.initialized) {
            this.init1();
            this.initialized = true;
        }
        try {
            ++this.iterationCount;
            if (this.iterationCount == EngineParameters.getRefreshIteration()) {
                this.iterationCount = 0;
                this.setDataPoints(this.connPoolProviderPdCalc);
                this.setDataPoints(this.j2CProviderPdCalc);
            }
            double d = -1.0;
            RuleOutput[] ruleOutputArray = new RuleOutput[this.percentUsedCalcs.size()];
            Tr.debug(tc, "Number of dataSources being analyzed size:" + this.percentUsedCalcs.size());
            for (int i = 0; i < this.percentUsedCalcs.size(); ++i) {
                IBasicDataPointHistoryTimeCalc iBasicDataPointHistoryTimeCalc = (IBasicDataPointHistoryTimeCalc)this.percentUsedCalcs.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Going to calculate the percentage of connections used for datasource " + iBasicDataPointHistoryTimeCalc.toString());
                }
                PerfDescriptor perfDescriptor = iBasicDataPointHistoryTimeCalc.getPD();
                if (tc.isDebugEnabled()) {
                    this.printStateDetails(perfDescriptor);
                }
                int n = this.config.getMaxConnectionPoolSize(perfDescriptor);
                int n2 = this.config.getMinConnectionPoolSize(perfDescriptor);
                double d2 = iBasicDataPointHistoryTimeCalc.getIntervalAverage();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pctUsed:" + d2);
                    Tr.debug(tc, "threshold:" + this.getThreshold(perfDescriptor));
                    Tr.debug(tc, "defaultHighUsage :" + this.defaultHighUsage);
                }
                double d3 = this.defaultHighUsage;
                double d4 = (double)(n - 1) / (double)n * 100.0;
                if (this.defaultHighUsage > d4) {
                    d3 = n == 1 ? 50.0 : d4;
                }
                if (TuningUtil.isErrorCode(d2)) {
                    ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, d2);
                } else if (d2 > d3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "max Config PoolSize Usage:" + n);
                    }
                    if (TuningUtil.isErrorCode(n)) {
                        ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, n);
                    } else {
                        IBasicDataPointCalc iBasicDataPointCalc = (IBasicDataPointCalc)this.sizeCalcs.get(i);
                        double d5 = iBasicDataPointCalc.getDoubleValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "currentPoolSize:" + d5);
                        }
                        if (TuningUtil.isErrorCode(d5)) {
                            ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, d5);
                        } else if (d5 >= (double)n) {
                            double d6;
                            int n3;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "min Config PoolSize Usage:" + n2);
                            }
                            ruleOutputArray[i] = TuningUtil.isErrorCode(n2) ? this.createGeneralErrorOutput(this.ruleName, perfDescriptor, n2) : ((double)(n3 = n + new Double(d6 = Math.ceil(this.increasePercentage / 100.0 * (double)n)).intValue()) > this.getMaxSetting(perfDescriptor) ? this.issueIncreaseAlert(perfDescriptor, d5, d2, n3, n2) : this.noProblem(perfDescriptor, d2));
                        } else {
                            ruleOutputArray[i] = this.noProblem(perfDescriptor, d2);
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no problem with this connection pool");
                    }
                    ruleOutputArray[i] = this.noProblem(perfDescriptor, d2);
                }
                Tr.exit(tc, "runRule");
                iBasicDataPointHistoryTimeCalc.clear();
                if (ruleOutputArray[i] != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DSPoolMinAndMaxSize rule lost a rule output");
                }
                ruleOutputArray[i] = TuningUtil.createGeneralErrorOutput(this.ruleName, perfDescriptor, 107.0);
            }
            this.dpCalc.clear();
            Tr.exit(tc, "runRule");
            return ruleOutputArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RuleOutput[] ruleOutputArray = new RuleOutput[]{new RuleOutput(this.ruleName, this.connPoolPD, 108, new MessageWrapper("perfalert.exception.stacktrace", exception.toString()), new MessageWrapper[0], null)};
            this.setEnabled(false);
            Tr.exit(tc, "runRule");
            return ruleOutputArray;
        }
    }

    public static HashMap getStaticAttributeHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(MIN_PERCENT, "Des:Lower bound for utilization of a typical well-tuned connection pool#DesLookup:perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.des#OptionsLookup:perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.100~100.0$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.95~95.0$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.90~90.0$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.85~85.0$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.80~80.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName.DSPoolMinAndMaxSize.MinPercentOfPoolUsed#ParamId:" + MIN_PERCENT);
        hashMap.put(INCREASE_PERCENTAGE, "Des:Percentage increase suggested by advisor for the connection pool#DesLookup:perfTuningAdmin.attribute.rule.IncreasePercentage.des#OptionsLookup:perfTuningAdmin.attribute.rule.IncreasePercentage.option.10~10.0$perfTuningAdmin.attribute.rule.IncreasePercentage.option.15~15.0$perfTuningAdmin.attribute.rule.IncreasePercentage.option.20~20.0$perfTuningAdmin.attribute.rule.IncreasePercentage.option.25~25.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName.DSPoolMinAndMaxSize.IncreasePercentage#ParamId:" + INCREASE_PERCENTAGE);
        hashMap.put(HIGH_USAGE_THRESHOLD, "Des:Upper bound for utilization of a typical well-tuned connection pool#DesLookup:perfTuningAdmin.attribute.rule.HighUsageThreshold.des#OptionsLookup:perfTuningAdmin.attribute.rule.HighUsageThreshold.option.95~95.0$perfTuningAdmin.attribute.rule.HighUsageThreshold.option.97~97.5$perfTuningAdmin.attribute.rule.HighUsageThreshold.option.99~99.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName.DSPoolMinAndMaxSize.HighUsageThreshold#ParamId:" + HIGH_USAGE_THRESHOLD);
        return hashMap;
    }

    public HashMap getAttributeInfo() {
        HashMap hashMap = new HashMap();
        String string = this.ruleData.getRuleID();
        HashMap hashMap2 = DSPoolMinAndMaxSizeStateless.getStaticAttributeHashMap();
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            hashMap.put(k, (String)hashMap2.get(k) + ':' + "ID" + ':' + string);
        }
        return hashMap;
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        Tr.entry(tc, "setParam key : " + string + ", value : " + d);
        super.setParam(string, d);
        if (string.equals(MIN_PERCENT)) {
            this.defaultMinPercent = d;
            for (int i = 0; i < this.percentUsedCalcs.size(); ++i) {
                IBasicDataPointCalc iBasicDataPointCalc = (IBasicDataPointCalc)this.percentUsedCalcs.get(i);
                PerfDescriptor perfDescriptor = iBasicDataPointCalc.getPD();
                this.setMinPercent(perfDescriptor, d);
            }
        } else if (string.equals(HIGH_USAGE_THRESHOLD)) {
            this.defaultHighUsage = d;
        } else if (string.equals(INCREASE_PERCENTAGE)) {
            this.increasePercentage = d;
        }
        Tr.exit(tc, "setParam");
    }

    protected void setMinPercent(PerfDescriptor perfDescriptor, double d) {
    }

    protected double getMinSetting(PerfDescriptor perfDescriptor) {
        return this.config.getMinConnectionPoolSize(perfDescriptor);
    }

    protected double getMaxSetting(PerfDescriptor perfDescriptor) {
        return this.config.getMaxConnectionPoolSize(perfDescriptor);
    }

    protected double getThreshold(PerfDescriptor perfDescriptor) {
        return this.defaultMinPercent;
    }

    public void clearHistory() {
        for (int i = 0; i < this.percentUsedCalcs.size(); ++i) {
            IBasicDataPointHistoryTimeCalc iBasicDataPointHistoryTimeCalc = (IBasicDataPointHistoryTimeCalc)this.percentUsedCalcs.get(i);
            iBasicDataPointHistoryTimeCalc.clearHistory();
        }
    }

    private void getDataSourceNames() {
        Tr.entry(tc, "getDataSourceNames");
        if (this.logName == null) {
            Collection collection = RepositoryCache.getDataSources();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 instanceof DataSource) {
                    this.dataSourceNames.add(((DataSource)e2).getJndiName());
                    continue;
                }
                if (!(e2 instanceof WAS40DataSource)) continue;
                this.dataSourceNames.add(((WAS40DataSource)e2).getJndiName());
            }
        } else {
            ArrayList arrayList = this.config.getAllJndiNames();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.dataSourceNames.add(arrayList.get(i));
            }
        }
        Tr.exit(tc, "getDataSourceNames");
    }

    private boolean isDataSource(PerfDescriptor perfDescriptor) {
        String string = perfDescriptor.getName();
        return this.dataSourceNames.contains(string);
    }

    private void printStateDetails(PerfDescriptor perfDescriptor) {
    }
}

