/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.DSPrepStmtRuleStateless;
import com.ibm.ws.performance.tuning.rule.IRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.rule.RuleState;
import com.ibm.ws.performance.tuning.rule.StatefullRuleInterface;
import com.ibm.ws.performance.tuning.rule.SuggestedConfig;
import java.util.HashMap;

public class DSPrepStmtRuleStatefull
extends DSPrepStmtRuleStateless
implements IRule,
TuningConstants,
StatefullRuleInterface {
    private HashMap ruleStateMap;
    private final int OTHER_DATA_COUNT = 4;
    private final int CURRENT_DISCARD_RATE_IDX = 0;
    private final int MAX_DISCARD_RATE_IDX = 1;
    private final int ALERT_STREAK_IDX = 2;
    private final int THRESHOLD_UPDATED_IDX = 3;
    private final double UPDATED = 0.0;
    private final double ORIG = 1.0;
    boolean updateable = false;
    int updateThreshold;
    int iteration = 0;

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
        HashMap hashMap = this.ruleData.getParamMap();
        this.updateable = true;
        this.updateThreshold = EngineParameters.getMaxAlertStreak();
        this.ruleStateMap = new HashMap();
    }

    public void setMaxAlertStreak(Integer n) {
        int n2 = n;
        this.updateable = n2 >= 0;
        this.updateThreshold = n2;
    }

    private RuleState getRuleState(PerfDescriptor perfDescriptor) {
        RuleState ruleState = (RuleState)this.ruleStateMap.get(perfDescriptor.getFullName());
        if (ruleState == null) {
            ruleState = new RuleState(4);
            ruleState.setData(0, this.discardRateTh);
            ruleState.setData(1, 0.0);
            ruleState.setData(2, 0.0);
            ruleState.setData(3, 1.0);
            this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        }
        return ruleState;
    }

    public RuleOutput createExceptionOutput(String string, PerfDescriptor perfDescriptor, int n, MessageWrapper messageWrapper, MessageWrapper[] messageWrapperArray, SuggestedConfig[] suggestedConfigArray) {
        RuleOutput ruleOutput = super.createExceptionOutput(string, perfDescriptor, n, messageWrapper, messageWrapperArray, suggestedConfigArray);
        if (this.updateable) {
            RuleState ruleState = this.getRuleState(perfDescriptor);
            ruleState.setData(2, 0.0);
        }
        return ruleOutput;
    }

    public RuleOutput createGeneralErrorOutput(String string, PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.createGeneralErrorOutput(string, perfDescriptor, d);
        if (this.updateable) {
            RuleState ruleState = this.getRuleState(perfDescriptor);
            ruleState.setData(2, 0.0);
            ruleOutput.addSympton(new MessageWrapper("perfalert.updateThreshold", new Integer(this.updateThreshold)));
            if (ruleState.getData(3) == 1.0) {
                ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.currentThreshold.ratio", new Double(this.getThreshold(perfDescriptor))));
            } else {
                ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.warningUpdatedThreshold.ratio", new Double(this.getThreshold(perfDescriptor))));
            }
        }
        return ruleOutput;
    }

    public RuleOutput noProblem(String string, double d, PerfDescriptor perfDescriptor) {
        RuleOutput ruleOutput = super.noProblem(string, d, perfDescriptor);
        if (this.updateable) {
            RuleState ruleState = this.getRuleState(perfDescriptor);
            ruleState.setData(2, 0.0);
            ruleOutput.addSympton(new MessageWrapper("perfalert.updateThreshold", new Integer(this.updateThreshold)));
            if (ruleState.getData(3) == 1.0) {
                ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.currentThreshold.ratio", new Double(this.getThreshold(perfDescriptor))));
            } else {
                ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.warningUpdatedThreshold.ratio", new Double(this.getThreshold(perfDescriptor))));
            }
        }
        return ruleOutput;
    }

    public RuleOutput[] runRule() {
        RuleOutput[] ruleOutputArray = super.runRule();
        return ruleOutputArray;
    }

    public RuleOutput issueAlert(String string, double d, PerfDescriptor perfDescriptor) {
        RuleOutput ruleOutput = super.issueAlert(string, d, perfDescriptor);
        if (this.updateable) {
            RuleState ruleState = this.getRuleState(perfDescriptor);
            ruleState.increaseData(2);
            if (d > ruleState.getData(1)) {
                ruleState.setData(1, d);
            }
            if (ruleState.getData(2) == (double)this.updateThreshold) {
                ruleState.setData(0, ruleState.getData(1));
                ruleState.setData(2, 0.0);
                ruleState.setData(3, 0.0);
                Integer n = new Integer(this.updateThreshold);
                ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", n));
            }
            if (ruleState.getData(3) == 1.0) {
                ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.currentThreshold.ratio", new Double(this.getThreshold(perfDescriptor))));
            } else {
                ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.warningUpdatedThreshold.ratio", new Double(this.getThreshold(perfDescriptor))));
            }
        }
        return ruleOutput;
    }

    protected double getThreshold(PerfDescriptor perfDescriptor) {
        RuleState ruleState = this.getRuleState(perfDescriptor);
        return ruleState.getData(0);
    }

    public String[] getParamNames() {
        return this.ruleData.getParamNames();
    }

    public Double getParam(String string) {
        return this.ruleData.getParam(string);
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        this.ruleData.setParam(string, d);
        if (string.equals(DISCARD_RATE)) {
            if (d >= 0.0) {
                for (int i = 0; i < this.datapointDDs.size(); ++i) {
                    PerfDescriptor perfDescriptor = (PerfDescriptor)this.datapointDDs.get(i);
                    RuleState ruleState = this.getRuleState(perfDescriptor);
                    ruleState.setData(0, this.discardRateTh);
                    ruleState.setData(1, 0.0);
                    ruleState.setData(2, 0.0);
                    ruleState.setData(3, 1.0);
                }
            } else {
                throw new IllegalArgumentException("DataSourcePrepStmtRule, could not set discard rate as value was < 0");
            }
        }
    }

    public void clearHistory() {
        super.clearHistory();
        this.ruleStateMap = new HashMap();
    }
}

