/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IMemoryCalc;
import com.ibm.ws.performance.tuning.calc.IModuleChildDataPointCalc;
import com.ibm.ws.performance.tuning.calc.IRateIncreaseCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DSPrepStmtRuleStateless
extends AbstractRule
implements TuningConstants {
    private static TraceComponent tc = Tr.register(DSPrepStmtRuleStateless.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private String ruleName;
    private IModuleChildDataPointCalc providerDpCalc;
    private IModuleChildDataPointCalc dpCalc;
    private IMemoryCalc memCalc;
    private IRateIncreaseCalc[] rateCalcs;
    private PerfDescriptor connPoolPD;
    private PerfDescriptor jvmPD;
    private HashMap ddMap;
    protected ArrayList datapointDDs;
    protected static final String DISCARD_RATE = new String("DiscardRateThreshold");
    protected double discardRateTh = 10.0;
    private int iterationCount = 0;
    private String ruleType = null;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        this.connPoolPD = new PerfDescriptorImpl(string, string2, connPoolDD);
        this.connPoolPD.postInit();
        this.jvmPD = new PerfDescriptorImpl(string, string2, jvmDD);
        this.jvmPD.postInit();
        this.ruleData = ruleData;
        HashMap hashMap = ruleData.getParamMap();
        this.ruleName = ruleData.getName();
        Object v = hashMap.get(DISCARD_RATE);
        if (v != null) {
            this.discardRateTh = (Double)v;
        }
        this.iterationCount = EngineParameters.getRefreshIteration() - 1;
        this.ruleType = ruleData.getType();
        this.memCalc = CalcCreator.createMemoryCalc(this.checkAppendLog(this.ruleType));
        this.memCalc.setUserId(this.userId);
        this.memCalc.init(this.jvmPD);
        this.providerDpCalc = CalcCreator.createModuleChildDataPointCalc(this.checkAppendLog(this.ruleType));
        this.providerDpCalc.setUserId(this.userId);
        this.dpCalc = CalcCreator.createModuleChildDataPointCalc(this.checkAppendLog(this.ruleType));
        this.dpCalc.setUserId(this.userId);
        this.providerDpCalc.init(this.connPoolPD);
        this.rateCalcs = new IRateIncreaseCalc[0];
        this.ddMap = new HashMap();
        this.setDataPoints();
    }

    private void setDataPoints() {
        try {
            Serializable serializable;
            ArrayList arrayList = this.providerDpCalc.getDataPoints();
            this.datapointDDs = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                PerfDescriptor perfDescriptor = (PerfDescriptor)arrayList.get(i);
                this.dpCalc.init(perfDescriptor, 21);
                serializable = this.dpCalc.getDataPoints();
                for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                    this.datapointDDs.add(((ArrayList)serializable).get(j));
                }
            }
            if (this.datapointDDs.size() > 0) {
                IRateIncreaseCalc[] iRateIncreaseCalcArray = new IRateIncreaseCalc[this.datapointDDs.size()];
                for (int i = 0; i < this.datapointDDs.size(); ++i) {
                    serializable = (PerfDescriptor)this.datapointDDs.get(i);
                    serializable.postInit();
                    String[] stringArray = serializable.getPath();
                    String string = new String();
                    for (int j = 0; j < stringArray.length; ++j) {
                        string = string + "->" + stringArray[j];
                    }
                    if (this.ddMap.containsKey(string)) {
                        Integer n = (Integer)this.ddMap.get(string);
                        iRateIncreaseCalcArray[i] = this.rateCalcs[n];
                        this.ddMap.put(string, new Integer(i));
                        continue;
                    }
                    iRateIncreaseCalcArray[i] = CalcCreator.createRateIncreaseCalc(this.checkAppendLog(this.ruleType));
                    iRateIncreaseCalcArray[i].setUserId(this.userId);
                    iRateIncreaseCalcArray[i].init((PerfDescriptor)this.datapointDDs.get(i), this.discardRateTh);
                    this.ddMap.put(string, new Integer(i));
                }
                this.rateCalcs = iRateIncreaseCalcArray;
            } else {
                this.rateCalcs = new IRateIncreaseCalc[0];
            }
        }
        catch (Exception exception) {
            System.out.println("EXCeption setDatapoints " + exception.toString());
            exception.printStackTrace();
        }
    }

    public RuleOutput[] runRule() {
        Tr.entry(tc, "runRule");
        try {
            ++this.iterationCount;
            if (this.iterationCount == EngineParameters.getRefreshIteration()) {
                this.iterationCount = 0;
                this.setDataPoints();
            }
            double d = -1.0;
            RuleOutput[] ruleOutputArray = new RuleOutput[this.rateCalcs.length];
            for (int i = 0; i < this.rateCalcs.length; ++i) {
                d = this.rateCalcs[i].getIntervalRateIncrease();
                PerfDescriptor perfDescriptor = (PerfDescriptor)this.datapointDDs.get(i);
                double d2 = this.getThreshold(perfDescriptor);
                if (TuningUtil.isErrorCode(d)) {
                    ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, perfDescriptor, d);
                } else if ((d = this.format(d)) > d2) {
                    try {
                        ruleOutputArray[i] = this.issueAlert(this.ruleName, d, perfDescriptor);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        ruleOutputArray = new RuleOutput[1];
                        Object[] objectArray = new String[]{exception.toString()};
                        ruleOutputArray[i] = new RuleOutput(this.ruleName, perfDescriptor, 108, new MessageWrapper("perfalert.exception.general"), new MessageWrapper("perfalert.exception.stacktrace", objectArray), null);
                        this.setEnabled(false);
                        Tr.exit(tc, "runRule - 1");
                        return ruleOutputArray;
                    }
                } else {
                    ruleOutputArray[i] = this.noProblem(this.ruleName, d, perfDescriptor);
                }
                if (ruleOutputArray[i] == null) {
                    ruleOutputArray[i] = TuningUtil.createGeneralErrorOutput(this.ruleName, perfDescriptor, 107.0);
                }
                this.rateCalcs[i].clear();
            }
            this.memCalc.clear();
            this.dpCalc.clear();
            Tr.exit(tc, "runRule - 2");
            return ruleOutputArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            RuleOutput[] ruleOutputArray = new RuleOutput[1];
            Object[] objectArray = new String[]{exception.toString()};
            ruleOutputArray[0] = new RuleOutput(this.ruleName, this.connPoolPD, 108, new MessageWrapper("perfalert.exception.general"), new MessageWrapper("perfalert.exception.stacktrace", objectArray), null);
            this.setEnabled(false);
            Tr.exit(tc, "runRule - 3");
            return ruleOutputArray;
        }
    }

    public RuleOutput noProblem(String string, double d, PerfDescriptor perfDescriptor) {
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.prepStmt.message_correct", perfDescriptor.getDataDescriptor().getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.prepStmt.symptom_low"), new MessageWrapper("perfalert.prepStmt.rate", new Double(d))};
        return new RuleOutput("DataSourcePrepStmtRule", perfDescriptor, 101, messageWrapper, messageWrapperArray, null);
    }

    public RuleOutput issueAlert(String string, double d, PerfDescriptor perfDescriptor) {
        MessageWrapper messageWrapper;
        Object[] objectArray;
        Tr.entry(tc, "issueAlert");
        long l = this.memCalc.getFreeMemory();
        int n = 100;
        long l2 = n * 1;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "availableMemory : " + l);
            Tr.debug(tc, "reqMem : " + l2);
        }
        if (l > l2) {
            objectArray = new Object[]{new String(perfDescriptor.getDataDescriptor().getName())};
            messageWrapper = new MessageWrapper("perfalert.prepStmt.message_increase", objectArray);
        } else {
            messageWrapper = new MessageWrapper("perfalert.memory");
        }
        objectArray = new MessageWrapper[]{new MessageWrapper("perfalert.prepStmt.rate", new Double(d))};
        Tr.exit(tc, "issueAlert");
        return new RuleOutput(string, perfDescriptor, 104, messageWrapper, (MessageWrapper[])objectArray, null);
    }

    protected double getThreshold(PerfDescriptor perfDescriptor) {
        return this.discardRateTh;
    }

    public static HashMap getStaticAttributeHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(DISCARD_RATE, "Des:Maximum rate for prepared statement discards#DesLookup:perfTuningAdmin.attribute.rule.DiscardRateThreshold.des#OptionsLookup:perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.0~0.0$perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.0.025~0.025$perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.0.05~0.05$perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.0.1~0.1$perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.0.2~0.2$perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.1~1.0$perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.2~2.0$perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.5~5.0$perfTuningAdmin.attribute.rule.DiscardRateThreshold.option.10~10.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName.DSPrepStmtRule.DiscardRateThreshold#ParamId:" + DISCARD_RATE);
        return hashMap;
    }

    public HashMap getAttributeInfo() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = DSPrepStmtRuleStateless.getStaticAttributeHashMap();
        String string = this.ruleData.getRuleID();
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            hashMap.put(k, (String)hashMap2.get(k) + '#' + "ID" + ':' + string);
        }
        return hashMap;
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (string.equals(DISCARD_RATE)) {
            if (d >= 0.0) {
                this.discardRateTh = d;
            } else {
                throw new IllegalArgumentException("DataSourcePrepStmtRule, could not set discard rate as value was < 0");
            }
        }
    }
}

