/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IJvmpiCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISystemSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import java.util.HashMap;

public class JvmHeapSizeRuleStateless
extends AbstractRule {
    protected PerfDescriptor jvmPD;
    protected IJvmpiCalc jvmpiCalc;
    protected ISystemSharedCalc systemCalc;
    protected String server;
    protected String node;
    protected RuleData data;
    protected static final String GC_TIME_THRESHOLD = "GcTimeThreshold";
    protected static final String IBM = "IBM";
    protected double gcThresh;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        this.server = string2;
        this.node = string;
        this.ruleData = ruleData;
        this.jvmPD = new PerfDescriptorImpl(string, string2, jvmDD);
        this.jvmPD.postInit();
        this.jvmpiCalc = CalcCreator.createJvmpiCalc(this.checkAppendLog(this.ruleData.getType()));
        this.jvmpiCalc.setUserId(this.userId);
        this.jvmpiCalc.init(string, string2, this.jvmPD);
        this.systemCalc = CalcCreator.getSystemSharedCalc(string, string2, this.checkAppendLog(this.ruleData.getType()));
        if (this.logName == null) {
            this.systemCalc.init(string, string2);
        }
        this.gcThresh = this.ruleData.getParam(GC_TIME_THRESHOLD);
    }

    public RuleOutput[] runRule() {
        RuleOutput ruleOutput = null;
        this.jvmpiCalc.clear();
        double d = this.jvmpiCalc.getAvgGcDuration();
        double d2 = this.jvmpiCalc.getAvgTimeBetweenGCs();
        if (TuningUtil.isErrorCode(d)) {
            ruleOutput = this.createGeneralErrorOutput(this.ruleData.getName(), this.jvmPD, d);
        } else if (TuningUtil.isErrorCode(d2)) {
            ruleOutput = this.createGeneralErrorOutput(this.ruleData.getName(), this.jvmPD, d2);
        }
        if (ruleOutput != null) {
            return new RuleOutput[]{ruleOutput};
        }
        double d3 = 0.0;
        double d4 = d2 + d;
        if (d4 > 0.0) {
            d3 = 100.0 * d / d4;
        }
        if (d3 > this.gcThresh * 100.0) {
            return new RuleOutput[]{this.increaseHeapSizeAlert(this.format(d3))};
        }
        return new RuleOutput[]{this.noProblemGcTime(this.jvmPD, this.format(d3))};
    }

    public HashMap getAttributeInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GC_TIME_THRESHOLD, "Des=Maximum percent of time that CPU can be doing GC before an alert is issued.");
        return hashMap;
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (string.equals(GC_TIME_THRESHOLD)) {
            double d2 = d;
            if (d2 >= 0.0 & d2 < 1.0) {
                this.gcThresh = d2;
            } else {
                throw new IllegalArgumentException("GcTimeThreshold must be between 0.0 and 1.0: " + d2);
            }
        }
    }

    protected RuleOutput increaseHeapSizeAlert(double d) {
        MessageWrapper[] messageWrapperArray = new MessageWrapper[1];
        MessageWrapper[] messageWrapperArray2 = new MessageWrapper[1];
        messageWrapperArray[0] = new MessageWrapper("perf.tuning.jvm.tooLongInGc");
        messageWrapperArray2[0] = new MessageWrapper("perf.tuning.jvm.gc.usage", new Double(d));
        return new RuleOutput(this.ruleData.getName(), this.jvmPD, 104, messageWrapperArray[0], messageWrapperArray2, null);
    }

    protected RuleOutput noProblemGcTime(PerfDescriptor perfDescriptor, double d) {
        MessageWrapper messageWrapper = new MessageWrapper("perf.tuning.jvm.gc.noProblem");
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perf.tuning.jvm.gc.usage", new Double(d))};
        return new RuleOutput(this.ruleData.getName(), perfDescriptor, 101, messageWrapper, messageWrapperArray, null);
    }
}

