/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.IRule;
import com.ibm.ws.performance.tuning.rule.LiveSessionStateless;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.rule.RuleState;
import com.ibm.ws.performance.tuning.rule.StatefullRuleInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class LiveSessionStatefull
extends LiveSessionStateless
implements IRule,
TuningConstants,
StatefullRuleInterface {
    private HashMap ruleStateMap;
    private final int OTHER_DATA_COUNT = 3;
    private final int AVE_ACTIVE_THRESHOLD_IDX = 0;
    private final int AVE_ACTIVE_MAX_IDX = 1;
    private final int AVE_ACTIVE_ALERT_STREAK_IDX = 2;
    int updateThreshold;

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
        this.updateThreshold = EngineParameters.getMaxAlertStreak();
        this.ruleStateMap = new HashMap();
    }

    public void setMaxAlertStreak(Integer n) {
        int n2 = n;
        this.updateThreshold = n2 < 0 ? EngineParameters.getMaxAlertStreak() : n2;
        Set set = this.ruleStateMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            RuleState ruleState = (RuleState)this.ruleStateMap.get(k);
            ruleState.setData(2, 0.0);
            this.ruleStateMap.put(k, ruleState);
        }
    }

    private RuleState getRuleState(PerfDescriptor perfDescriptor) {
        RuleState ruleState = (RuleState)this.ruleStateMap.get(perfDescriptor.getFullName());
        if (ruleState == null) {
            ruleState = new RuleState(3);
            ruleState.setData(0, super.getAveActiveThreshold(perfDescriptor));
            ruleState.setData(1, 0.0);
            ruleState.setData(2, 0.0);
            this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        }
        return ruleState;
    }

    protected double getAveActiveThreshold(PerfDescriptor perfDescriptor) {
        RuleState ruleState = this.getRuleState(perfDescriptor);
        return ruleState.getData(0);
    }

    public RuleOutput noProblemLargeEnough(String string, PerfDescriptor perfDescriptor, double d, double d2, double d3) {
        RuleOutput ruleOutput = super.noProblemLargeEnough(string, perfDescriptor, d, d2, d3);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(2, 0.0);
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        return ruleOutput;
    }

    public RuleOutput issueAlertIncreaseCache(String string, PerfDescriptor perfDescriptor, double d, double d2, double d3) {
        RuleOutput ruleOutput = super.issueAlertIncreaseCache(string, perfDescriptor, d, d2, d3);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.increaseData(2);
        if (d > ruleState.getData(1)) {
            ruleState.setData(1, d);
        }
        if (ruleState.getData(2) == (double)this.updateThreshold) {
            Object[] objectArray = new Object[]{new Double(ruleState.getData(0)), new Double(ruleState.getData(1))};
            ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.updatingThreshold", objectArray));
            ruleState.setData(0, ruleState.getData(1));
            ruleState.setData(2, 0.0);
            Integer n = new Integer(this.updateThreshold);
            ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", n));
        }
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        return ruleOutput;
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
    }

    public void clearHistory() {
        super.clearHistory();
        this.ruleStateMap = new HashMap();
    }
}

