/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryTimeCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISessionMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractSessionRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import java.util.ArrayList;
import java.util.HashMap;

public class LiveSessionStateless
extends AbstractSessionRule {
    private IBasicDataPointHistoryTimeCalc[] activeCalc;
    private IBasicDataPointHistoryTimeCalc[] tmpCalc;
    private ISessionMBeanSharedCalc sessionMBeanCalc;
    private double cacheSize;
    private static TraceComponent tc = Tr.register(LiveSessionStateless.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        Tr.entry(tc, "init");
        super.init(string, string2, ruleData);
        this.activeCalc = new IBasicDataPointHistoryTimeCalc[0];
        this.sessionMBeanCalc = CalcCreator.getSessionMBeanSharedCalc(string, string2, this.checkAppendLog(this.ruleType));
        this.createTmpCalcArrays(0);
        super.checkInterval();
        Tr.exit(tc, "init");
    }

    protected void createTmpCalcArrays(int n) {
        this.tmpCalc = new IBasicDataPointHistoryTimeCalc[n];
    }

    public void setEnabled(boolean bl) {
        if (!this.isApplicable()) {
            super.setEnabled(false);
        } else {
            super.setEnabled(bl);
        }
    }

    public boolean isApplicable() {
        Tr.entry(tc, "isApplicable");
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.dds.size(); ++i) {
            PerfDescriptor perfDescriptor = (PerfDescriptor)this.dds.get(i);
            if (tc.isDebugEnabled()) {
                if (this.sessionMBeanCalc == null) {
                    Tr.debug(tc, "sessionMBeanCalc is null why ?");
                } else {
                    Tr.debug(tc, "sessionMBeanCalc is not null :-)");
                }
            }
            bl2 = this.sessionMBeanCalc.getAllowOverflow(perfDescriptor);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   checking " + perfDescriptor.getName() + " is applicable " + bl2);
            }
            if (!bl2) continue;
            bl = true;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "   applicable: " + bl);
        }
        Tr.exit(tc, "isApplicable");
        return bl;
    }

    protected void createCalcObjectsInTmpArray(PerfDescriptor perfDescriptor, int n, boolean bl, int n2) {
        if (bl) {
            this.tmpCalc[n] = CalcCreator.createBasicDataPointHistoryTimeCalc(this.checkAppendLog(this.ruleType));
            this.tmpCalc[n].setUserId(this.userId);
            this.tmpCalc[n].init(perfDescriptor, 7);
        } else {
            this.tmpCalc[n] = this.activeCalc[n2];
        }
    }

    protected void updateCalcArrayWithTmpArray() {
        this.activeCalc = this.tmpCalc;
        this.isApplicable();
    }

    public RuleOutput[] runRule() {
        super.checkInterval();
        int n = this.activeCalc.length;
        ArrayList<RuleOutput> arrayList = new ArrayList<RuleOutput>();
        for (int i = 0; i < n; ++i) {
            double d = this.activeCalc[i].getDoubleValue();
            double d2 = this.activeCalc[i].getIntervalAverage();
            PerfDescriptor perfDescriptor = (PerfDescriptor)this.dds.get(i);
            String string = perfDescriptor.getName();
            if (this.sessionMBeanCalc.getAllowOverflow(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "live session rule web app name " + string);
                }
                this.cacheSize = this.sessionMBeanCalc.getMaxInMemorySessionCount(string);
                if (TuningUtil.isErrorCode(d)) {
                    arrayList.add(this.createGeneralErrorOutput(this.ruleName, (PerfDescriptor)this.dds.get(i), d));
                } else if (TuningUtil.isErrorCode(d2)) {
                    arrayList.add(this.createGeneralErrorOutput(this.ruleName, (PerfDescriptor)this.dds.get(i), d2));
                } else {
                    d2 = this.format(d2);
                    d = this.format(d);
                    double d3 = this.getAveActiveThreshold((PerfDescriptor)this.dds.get(i));
                    if (d2 > d3) {
                        arrayList.add(this.issueAlertIncreaseCache(this.ruleName, perfDescriptor, d2, d, this.cacheSize));
                    } else {
                        arrayList.add(this.noProblemLargeEnough(this.ruleName, perfDescriptor, d2, d, this.cacheSize));
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LiveSessionRule not runnin on " + string + " as it is not applicable");
            }
            this.activeCalc[i].clear();
        }
        RuleOutput[] ruleOutputArray = new RuleOutput[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            ruleOutputArray[i] = (RuleOutput)arrayList.get(i);
        }
        return ruleOutputArray;
    }

    protected double getAveActiveThreshold(PerfDescriptor perfDescriptor) {
        return this.cacheSize;
    }

    public RuleOutput issueAlertIncreaseCache(String string, PerfDescriptor perfDescriptor, double d, double d2, double d3) {
        Object[] objectArray = new Object[]{perfDescriptor.getName(), new Double(Math.ceil(d))};
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.increaseCacheSize", objectArray);
        int n = 104;
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.cacheSize", new Double(d3)), new MessageWrapper("perfalert.session.activeSessions", new Double(d2)), new MessageWrapper("perfalert.session.activeSessions.average", new Double(d))};
        return new RuleOutput(string, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    public RuleOutput noProblemLargeEnough(String string, PerfDescriptor perfDescriptor, double d, double d2, double d3) {
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.CacheLargeEnough", perfDescriptor.getName());
        int n = 101;
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.cacheSize", new Double(d3)), new MessageWrapper("perfalert.session.activeSessions", new Double(d2)), new MessageWrapper("perfalert.session.activeSessions.average", new Double(d))};
        return new RuleOutput(string, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    public String[] getParamNames() {
        return super.getParamNames();
    }

    public Double getParam(String string) {
        return super.getParam(string);
    }

    public void setParam(String string, Double d) {
        super.setParam(string, d);
    }

    public static HashMap getStaticAttributeHashMap() {
        return new HashMap();
    }

    public HashMap getAttributeInfo() {
        return new HashMap();
    }

    public void clearHistory() {
        for (int i = 0; i < this.activeCalc.length; ++i) {
            this.activeCalc[i].clearHistory();
        }
    }
}

