/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.IRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.NoRoomForNewSessionRuleStateless;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.rule.RuleState;
import com.ibm.ws.performance.tuning.rule.StatefullRuleInterface;
import com.ibm.ws.performance.tuning.rule.SuggestedConfig;
import java.util.HashMap;

public class NoRoomForNewSessionRuleStatefull
extends NoRoomForNewSessionRuleStateless
implements IRule,
TuningConstants,
StatefullRuleInterface {
    private HashMap ruleStateMap;
    private final int OTHER_DATA_COUNT = 4;
    private final int CURRENT_THRES_IDX = 0;
    private final int MAX_RECOMMENDATION_IDX = 1;
    private final int ALERT_STREAK_IDX = 2;
    private final int THRESHOLD_UPDATED_IDX = 3;
    private final double UPDATED = 0.0;
    private final double ORIG = 1.0;
    int iteration;
    int updateThreshold;

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
        HashMap hashMap = this.ruleData.getParamMap();
        this.iteration = 0;
        this.updateThreshold = EngineParameters.getMaxAlertStreak();
        this.ruleStateMap = new HashMap();
    }

    public void setMaxAlertStreak(Integer n) {
        int n2 = n;
        this.updateThreshold = n2 < 0 ? EngineParameters.getMaxAlertStreak() : n2;
    }

    private RuleState getRuleState(PerfDescriptor perfDescriptor) {
        RuleState ruleState = (RuleState)this.ruleStateMap.get(perfDescriptor.getFullName());
        if (ruleState == null) {
            ruleState = new RuleState(4);
            ruleState.setData(0, super.getThreshold(perfDescriptor));
            ruleState.setData(1, super.getThreshold(perfDescriptor));
            ruleState.setData(2, 0.0);
            ruleState.setData(3, 1.0);
            this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        }
        return ruleState;
    }

    public RuleOutput createExceptionOutput(String string, PerfDescriptor perfDescriptor, int n, MessageWrapper messageWrapper, MessageWrapper[] messageWrapperArray, SuggestedConfig[] suggestedConfigArray) {
        RuleOutput ruleOutput = super.createExceptionOutput(string, perfDescriptor, n, messageWrapper, messageWrapperArray, suggestedConfigArray);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(2, 0.0);
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        return ruleOutput;
    }

    public RuleOutput createGeneralErrorOutput(String string, PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.createGeneralErrorOutput(string, perfDescriptor, d);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(2, 0.0);
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        return ruleOutput;
    }

    public RuleOutput noProblem(PerfDescriptor perfDescriptor, double d) throws Exception {
        RuleOutput ruleOutput = super.noProblem(perfDescriptor, d);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        Object[] objectArray = new Object[]{new Double(ruleState.getData(0))};
        ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.currentThreshold", objectArray));
        ruleState.setData(2, 0.0);
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        return ruleOutput;
    }

    public RuleOutput[] runRule() {
        RuleOutput[] ruleOutputArray = super.runRule();
        return ruleOutputArray;
    }

    public RuleOutput issueAlert(PerfDescriptor perfDescriptor, double d, double d2, int n) throws Exception {
        RuleOutput ruleOutput = super.issueAlert(perfDescriptor, d, d2, n);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.increaseData(2);
        if ((double)n > ruleState.getData(1)) {
            ruleState.setData(1, n);
        }
        if (ruleState.getData(2) == (double)this.updateThreshold) {
            Object[] objectArray = new Object[]{new Double(ruleState.getData(0)), new Double(ruleState.getData(1))};
            ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.updatingThreshold", objectArray));
            ruleState.setData(0, ruleState.getData(1));
            ruleState.setData(2, 0.0);
            ruleState.setData(3, 0.0);
            Integer n2 = new Integer(this.updateThreshold);
            ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", n2));
            this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        } else {
            Object[] objectArray = new Object[]{new Double(ruleState.getData(0))};
            ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.currentThreshold", objectArray));
        }
        return ruleOutput;
    }

    protected double getThreshold(PerfDescriptor perfDescriptor) {
        RuleState ruleState = this.getRuleState(perfDescriptor);
        return ruleState.getData(0);
    }

    public void clearHistory() {
        super.clearHistory();
        this.ruleStateMap = new HashMap();
    }
}

