/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointCalc;
import com.ibm.ws.performance.tuning.calc.IRateIncreaseCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISessionMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractSessionRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import java.util.HashMap;

public class NoRoomForNewSessionRuleStateless
extends AbstractSessionRule {
    private static TraceComponent tc = Tr.register(NoRoomForNewSessionRuleStateless.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private IRateIncreaseCalc[] noRoomCalc;
    private IRateIncreaseCalc[] noRoomCalcTmp;
    private IBasicDataPointCalc[] aveLifeTimeCalc;
    private IBasicDataPointCalc[] aveLifeTimeCalcTmp;
    private ISessionMBeanSharedCalc sessionMBeanCalc;
    private PerfDescriptor[] pdsTmp;
    private PerfDescriptor[] pds;
    private double sessionTimeout;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
        this.aveLifeTimeCalc = new IBasicDataPointCalc[0];
        this.noRoomCalc = new IRateIncreaseCalc[0];
        this.pds = new PerfDescriptor[0];
        this.sessionMBeanCalc = CalcCreator.getSessionMBeanSharedCalc(string, string2, this.checkAppendLog(this.ruleType));
        this.createTmpCalcArrays(0);
        super.checkInterval();
        if (!this.isApplicable()) {
            super.setEnabled(false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "disabling NoRoomForNewSession as it is not applicable for any web applicatoin");
            }
        }
    }

    protected void createTmpCalcArrays(int n) {
        this.aveLifeTimeCalcTmp = new IBasicDataPointCalc[n];
        this.noRoomCalcTmp = new IRateIncreaseCalc[n];
        this.pdsTmp = new PerfDescriptor[n];
    }

    protected void createCalcObjectsInTmpArray(PerfDescriptor perfDescriptor, int n, boolean bl, int n2) {
        if (perfDescriptor == null) {
            // empty if block
        }
        if (bl) {
            this.noRoomCalcTmp[n] = CalcCreator.createRateIncreaseCalc(this.checkAppendLog(this.ruleType));
            this.noRoomCalcTmp[n].setUserId(this.userId);
            this.noRoomCalcTmp[n].init(perfDescriptor, 8, 0.0);
            this.aveLifeTimeCalcTmp[n] = CalcCreator.createBasicDataPointCalc(this.checkAppendLog(this.ruleType));
            this.aveLifeTimeCalcTmp[n].setUserId(this.userId);
            this.aveLifeTimeCalcTmp[n].init(perfDescriptor, 4);
            this.pdsTmp[n] = perfDescriptor;
        } else {
            this.noRoomCalcTmp[n] = this.noRoomCalc[n2];
            this.aveLifeTimeCalcTmp[n] = this.aveLifeTimeCalc[n2];
            this.pdsTmp[n] = this.pds[n2];
        }
    }

    protected void updateCalcArrayWithTmpArray() {
        this.noRoomCalc = this.noRoomCalcTmp;
        this.aveLifeTimeCalc = this.aveLifeTimeCalcTmp;
        this.pds = this.pdsTmp;
    }

    public RuleOutput[] runRule() {
        Tr.entry(tc, "NoRoomForNewSessionRuleStateless.runRule");
        try {
            super.checkInterval();
            int n = this.noRoomCalc.length;
            RuleOutput[] ruleOutputArray = new RuleOutput[n];
            for (int i = 0; i < n; ++i) {
                String string = this.pds[i].getName();
                if (this.isApplicable(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NoRoomForNewSession running on " + string);
                    }
                    double d = this.noRoomCalc[i].getIntervalRateIncrease();
                    double d2 = this.aveLifeTimeCalc[i].getDoubleValue();
                    double d3 = this.sessionMBeanCalc.getMaxInMemorySessionCount(string);
                    this.sessionTimeout = this.sessionMBeanCalc.getSessionTimeout(string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "intervalRate " + d);
                        Tr.debug(tc, "lifeTime " + d2);
                        Tr.debug(tc, "current " + d3);
                        Tr.debug(tc, "sessionTimeout " + this.sessionTimeout);
                    }
                    if (TuningUtil.isErrorCode(d)) {
                        ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, this.pds[i], d);
                    } else if (TuningUtil.isErrorCode(d2)) {
                        ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, this.pds[i], d2);
                    } else if (TuningUtil.isErrorCode(d3)) {
                        ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, this.pds[i], d3);
                    } else {
                        d = this.format(d);
                        if ((d2 = this.format(d2 / 1000.0)) < 1.0) {
                            d2 = this.sessionTimeout;
                        }
                        int n2 = (int)Math.ceil(d * d2 + d3);
                        double d4 = this.getThreshold(this.pds[i]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "suggested " + n2);
                            Tr.debug(tc, "threshold " + d4);
                        }
                        ruleOutputArray[i] = (double)n2 > d4 ? this.issueAlert(this.pds[i], d, d2, n2) : this.noProblem(this.pds[i], d);
                    }
                    this.noRoomCalc[i].clear();
                    this.aveLifeTimeCalc[i].clear();
                    if (ruleOutputArray[i] != null) continue;
                    ruleOutputArray[i] = this.createGeneralErrorOutput(this.ruleName, this.pds[i], 107.0);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "   NoRoomForNewSession not running on " + string + " because it is not applicable");
            }
            Tr.exit(tc, "NoRoomForNewSessionRuleStateless.runRule.");
            return ruleOutputArray;
        }
        catch (Exception exception) {
            System.out.println("General Exception caught in NoRoomForNewSession_50.runRule :" + exception.toString());
            exception.printStackTrace();
            super.setEnabled(false);
            Tr.exit(tc, "NoRoomForNewSessionRuleStateless.runRule, caught an exception and disabling the rule.");
            return null;
        }
    }

    protected double getThreshold(PerfDescriptor perfDescriptor) {
        return this.sessionMBeanCalc.getMaxInMemorySessionCount(perfDescriptor.getName());
    }

    public RuleOutput noProblem(PerfDescriptor perfDescriptor, double d) throws Exception {
        int n = 101;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.alwaysRoomForSession", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.noRoom", new Double(d))};
        return new RuleOutput(this.ruleName, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    public static HashMap getStaticAttributeHashMap() {
        return new HashMap();
    }

    public HashMap getAttributeInfo() {
        return super.getAttributeInfo();
    }

    public RuleOutput issueAlert(PerfDescriptor perfDescriptor, double d, double d2, int n) throws Exception {
        int n2 = 104;
        Object[] objectArray = new Object[]{new String(perfDescriptor.getName()), new Integer(n)};
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.noRoomForNewSession", objectArray);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.unboundedGrowthWarning"), new MessageWrapper("perfalert.session.noRoom", new Double(d)), new MessageWrapper("perfalert.session.averageLifeTime", new Double(d2))};
        return new RuleOutput(this.ruleName, perfDescriptor, n2, messageWrapper, messageWrapperArray, null);
    }

    private boolean isApplicable(String string) {
        if (!this.sessionMBeanCalc.getAllowOverflow(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  " + string + " is applicable");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "  " + string + " is NOT applicable");
        }
        return false;
    }

    public boolean isApplicable() {
        Tr.entry(tc, "isApplicable");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "  " + this.pds.length + " web applications");
        }
        boolean bl = false;
        for (int i = 0; i < this.pds.length; ++i) {
            String string = this.pds[i].getName();
            if (!this.isApplicable(string)) continue;
            bl = true;
            break;
        }
        Tr.exit(tc, "isApplicable");
        return bl;
    }

    public void setEnabled(boolean bl) {
        if (bl && !this.isApplicable()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setEnabled could not enable NoRoomForNewSession because the rule is not applicable");
            }
            bl = false;
        }
        super.setEnabled(bl);
    }
}

