/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.PoolRuleStateless;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import java.util.HashMap;

public class PoolRuleStatefull
extends PoolRuleStateless
implements TuningConstants {
    private HashMap thresholdObjectMap = new HashMap();

    public PoolRuleStatefull(int n) {
        super(n);
    }

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
    }

    protected void initializeCalcs() {
        super.initializeCalcs();
        this.setDefault();
    }

    private void setDefault() {
        for (int i = 0; this.pd != null && i < this.pd.length; ++i) {
            String string = this.pd[i].getName();
            ThresholdObject thresholdObject = new ThresholdObject(string);
            this.thresholdObjectMap.put(string, thresholdObject);
        }
    }

    public void resetThresholds() {
        this.thresholdObjectMap = new HashMap();
        for (int i = 0; this.pd != null && i < this.pd.length; ++i) {
            String string = this.pd[i].getName();
            ThresholdObject thresholdObject = new ThresholdObject(string);
            this.thresholdObjectMap.put(string, thresholdObject);
        }
    }

    protected RuleOutput[] issueAlert_notEnoughThreads(double d, int n, double d2, double d3, PerfDescriptor perfDescriptor) {
        RuleOutput[] ruleOutputArray = super.issueAlert_notEnoughThreads(d, n, d2, d3, perfDescriptor);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_high++;
        thresholdObject.alertStreak_low = 0;
        thresholdObject.lowestFraction = thresholdObject.getLowFractionThreshold();
        if (d2 > thresholdObject.highestFraction) {
            thresholdObject.highestFraction = d2;
        }
        if (thresholdObject.alertStreak_high == EngineParameters.getMaxAlertStreak()) {
            this.highFractionThresMap.put(string, new Double(thresholdObject.highestFraction));
            thresholdObject.alertStreak_high = 0;
            thresholdObject.highUpdated = true;
            for (int i = 0; i < ruleOutputArray.length; ++i) {
                Integer n2 = new Integer(EngineParameters.getMaxAlertStreak());
                ruleOutputArray[i].addSympton(new MessageWrapper("perfalert.lastAlert", n2));
            }
        }
        this.thresholdObjectMap.put(string, thresholdObject);
        return new RuleOutput[]{this.addSymptoms(ruleOutputArray[0], thresholdObject)};
    }

    protected RuleOutput issueAlert_tooManyThreads(double d, int n, double d2, double d3, PerfDescriptor perfDescriptor, double d4, double d5) {
        RuleOutput ruleOutput = super.issueAlert_tooManyThreads(d, n, d2, d3, perfDescriptor, d4, d5);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_high = 0;
        thresholdObject.highestFraction = thresholdObject.getHighFractionThreshold();
        thresholdObject.alertStreak_low++;
        if (d2 < thresholdObject.lowestFraction) {
            thresholdObject.lowestFraction = d2;
        }
        if (thresholdObject.alertStreak_low == EngineParameters.getMaxAlertStreak()) {
            this.lowFractionThresMap.put(string, new Double(thresholdObject.lowestFraction));
            thresholdObject.alertStreak_low = 0;
            thresholdObject.lowUpdated = true;
            Integer n2 = new Integer(EngineParameters.getMaxAlertStreak());
            ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", n2));
        }
        this.thresholdObjectMap.put(string, thresholdObject);
        return this.addSymptoms(ruleOutput, thresholdObject);
    }

    protected RuleOutput issueAlert_stdevHigh(double d, int n, double d2, double d3, PerfDescriptor perfDescriptor, int n2, int n3) {
        RuleOutput ruleOutput = super.issueAlert_stdevHigh(d, n, d2, d3, perfDescriptor, n2, n3);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_high = 0;
        thresholdObject.alertStreak_low = 0;
        thresholdObject.alertStreak_variance++;
        if (d2 > thresholdObject.highestVariance) {
            thresholdObject.highestVariance = d2;
        }
        if (thresholdObject.alertStreak_variance == EngineParameters.getMaxAlertStreak()) {
            this.varianceThresholdMap.put(string, new Double(thresholdObject.highestVariance));
            thresholdObject.alertStreak_variance = 0;
            thresholdObject.varianceUpdated = true;
            Integer n4 = new Integer(EngineParameters.getMaxAlertStreak());
            ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", n4));
        }
        this.thresholdObjectMap.put(string, thresholdObject);
        return this.addSymptoms(ruleOutput, thresholdObject);
    }

    protected RuleOutput noProblem_notUnderLoad(double d, int n, double d2, double d3, PerfDescriptor perfDescriptor) {
        RuleOutput ruleOutput = super.noProblem_notUnderLoad(d, n, d2, d3, perfDescriptor);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_high = 0;
        thresholdObject.alertStreak_low = 0;
        thresholdObject.lowestFraction = thresholdObject.getLowFractionThreshold();
        thresholdObject.highestFraction = thresholdObject.getHighFractionThreshold();
        this.thresholdObjectMap.put(string, thresholdObject);
        return this.addSymptoms(ruleOutput, thresholdObject);
    }

    protected RuleOutput noProblem_general(double d, int n, double d2, PerfDescriptor perfDescriptor) {
        RuleOutput ruleOutput = super.noProblem_general(d, n, d2, perfDescriptor);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_high = 0;
        thresholdObject.alertStreak_low = 0;
        thresholdObject.lowestFraction = thresholdObject.getLowFractionThreshold();
        thresholdObject.highestFraction = thresholdObject.getHighFractionThreshold();
        this.thresholdObjectMap.put(string, thresholdObject);
        return this.addSymptoms(ruleOutput, thresholdObject);
    }

    protected RuleOutput noProblem_workingHard(double d, double d2, PerfDescriptor perfDescriptor) {
        RuleOutput ruleOutput = super.noProblem_workingHard(d, d2, perfDescriptor);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_high = 0;
        thresholdObject.alertStreak_low = 0;
        thresholdObject.lowestFraction = thresholdObject.getLowFractionThreshold();
        thresholdObject.highestFraction = thresholdObject.getHighFractionThreshold();
        this.thresholdObjectMap.put(string, thresholdObject);
        return this.addSymptoms(ruleOutput, thresholdObject);
    }

    private RuleOutput addSymptoms(RuleOutput ruleOutput, ThresholdObject thresholdObject) {
        if (thresholdObject.lowUpdated || thresholdObject.highUpdated) {
            Object[] objectArray = new Object[5];
            objectArray[0] = TuningUtil.getNLSString("perfalert.threshold.poolUsage", "pool usage %");
            objectArray[2] = new Double(thresholdObject.getHighFractionThreshold() * 100.0);
            objectArray[1] = new Double(thresholdObject.getLowFractionThreshold() * 100.0);
            objectArray[4] = new Double(thresholdObject.originalHighThreshold * 100.0);
            objectArray[3] = new Double(thresholdObject.originalLowThreshold * 100.0);
            ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.warningUpdatedThreshold.range", objectArray));
        } else {
            Object[] objectArray = new Object[2];
            objectArray[1] = new Double(thresholdObject.getHighFractionThreshold() * 100.0);
            objectArray[0] = new Double(thresholdObject.getLowFractionThreshold() * 100.0);
            ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.currentThreshold.range", objectArray));
        }
        ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.variance.threshold", new Double(thresholdObject.getVarianceThreshold())));
        return ruleOutput;
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
    }

    public void clearHistory() {
        super.clearHistory();
        this.resetThresholds();
        this.setDefault();
    }

    private class ThresholdObject {
        private int alertStreak_high;
        private int alertStreak_low;
        private int alertStreak_variance;
        private double highestFraction;
        private double lowestFraction;
        private double highestVariance;
        private double originalLowThreshold;
        private double originalHighThreshold;
        private double originalVarianceThreshold;
        private boolean lowUpdated;
        private boolean highUpdated;
        private boolean varianceUpdated;
        private String tPoolName = null;

        public ThresholdObject(double d, double d2, double d3) {
        }

        public ThresholdObject(String string) {
            this.tPoolName = string;
            this.setDefault();
        }

        public void setDefault() {
            this.alertStreak_high = 0;
            this.alertStreak_low = 0;
            this.alertStreak_variance = 0;
            this.highestVariance = 0.0;
            this.highestFraction = 0.0;
            this.lowestFraction = 1.0;
            this.originalVarianceThreshold = this.getVarianceThreshold();
            this.originalHighThreshold = this.getHighFractionThreshold();
            this.originalLowThreshold = this.getLowFractionThreshold();
            this.varianceUpdated = false;
            this.lowUpdated = false;
            this.highUpdated = false;
        }

        private double getLowFractionThreshold() {
            Double d = (Double)PoolRuleStatefull.this.lowFractionThresMap.get(this.tPoolName);
            if (d == null) {
                return PoolRuleStatefull.this.lowFractionThres;
            }
            return d;
        }

        private double getHighFractionThreshold() {
            Double d = (Double)PoolRuleStatefull.this.highFractionThresMap.get(this.tPoolName);
            if (d == null) {
                return PoolRuleStatefull.this.highFractionThres;
            }
            return d;
        }

        private double getVarianceThreshold() {
            Double d = (Double)PoolRuleStatefull.this.varianceThresholdMap.get(this.tPoolName);
            if (d == null) {
                return PoolRuleStatefull.this.varianceThreshold;
            }
            return d;
        }
    }
}

