/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointCalc;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryTimeCalc;
import com.ibm.ws.performance.tuning.calc.IMemoryCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ICpuSharedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IThreadPoolMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PoolRuleStateless
extends AbstractRule
implements TuningConstants {
    private String ruleName;
    private static TraceComponent tc = Tr.register(PoolRuleStateless.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private String[] module;
    private DataDescriptor[] poolDD;
    PerfDescriptor[] pd;
    PerfDescriptor jvmPD;
    private static final int activeCounter = 3;
    private static final int sizeCounter = 4;
    private int noOfThreadPools = 0;
    private static final int MIN_POOL_SIZE = 3;
    IBasicDataPointHistoryTimeCalc[] activeCalc;
    IBasicDataPointCalc[] sizeCalc;
    ICpuSharedCalc cpuCalc;
    IMemoryCalc memCalc;
    private String ruleType;
    protected double highFractionThres;
    protected double lowFractionThres;
    protected double varianceThreshold;
    private double increasePercent;
    private double decreasePercent;
    protected HashMap highFractionThresMap = new HashMap();
    protected HashMap lowFractionThresMap = new HashMap();
    protected HashMap varianceThresholdMap = new HashMap();
    private IThreadPoolMBeanSharedCalc mBeanCalc;
    private boolean SEPool;
    long bytes = 1L;
    String poolName = "ORB thread pool";
    String threadPoolName = "ORB.thread.pool";
    protected static final String LOW_FRACTION_WORKING = new String("LowFractionOfThreadsWorking");
    protected static final String HIGH_FRACTION_WORKING = new String("HighFractionOfThreadsWorking");
    protected static final String INCREASE_PERCENT = new String("SuggestedIncreaseInPercent");
    protected static final String DECREASE_PERCENT = new String("SuggestedDecreaseOfNonUsedThreadsInPercent");
    protected static final String STDEV_THRESHOLD = new String("StdevThreshold");
    private boolean initCalcs = false;
    private double calcInterval;
    private String node;
    private String server;

    public PoolRuleStateless() {
        this.setModule(50);
    }

    public PoolRuleStateless(int n) {
        this.setModule(n);
    }

    private void setModule(int n) {
        if (n == 50) {
            this.SEPool = false;
            this.bytes = 1L;
            this.poolName = "ORB thread pool";
        } else if (n == 51) {
            this.SEPool = true;
            this.bytes = 1L;
            this.poolName = "Web Container thread pool";
        } else {
            this.setModule(50);
            return;
        }
    }

    private void createConfig() {
        this.mBeanCalc = CalcCreator.getThreadPoolMBeanSharedCalc(this.node, this.server, this.checkAppendLog(this.ruleType));
    }

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        this.ruleData = ruleData;
        HashMap hashMap = ruleData.getParamMap();
        this.ruleType = ruleData.getType();
        this.ruleName = ruleData.getName();
        this.node = string;
        this.server = string2;
        Object v = hashMap.get(LOW_FRACTION_WORKING);
        if (v != null) {
            this.lowFractionThres = (Double)v;
        }
        if ((v = hashMap.get(HIGH_FRACTION_WORKING)) != null) {
            this.highFractionThres = (Double)v;
        }
        if ((v = hashMap.get(STDEV_THRESHOLD)) != null) {
            double d = (Double)v;
            this.varianceThreshold = d * d;
        }
        if ((v = hashMap.get(DECREASE_PERCENT)) != null) {
            this.decreasePercent = (Double)v;
        }
        if ((v = hashMap.get(INCREASE_PERCENT)) != null) {
            this.increasePercent = (Double)v;
        }
        if ((v = hashMap.get("calculationInterval")) != null) {
            this.calcInterval = (Double)v;
        }
    }

    protected void initializeCalcs() {
        this.mBeanCalc = CalcCreator.getThreadPoolMBeanSharedCalc(this.node, this.server, this.checkAppendLog(this.ruleType));
        if (this.poolName.equals("Web Container thread pool")) {
            String[] stringArray = this.mBeanCalc.getThreadPoolNames();
            if (stringArray == null || stringArray.length == 0) {
                this.noOfThreadPools = 1;
                this.poolDD = new DataDescriptor[this.noOfThreadPools];
                this.poolDD[0] = sePoolDD;
            } else {
                this.noOfThreadPools = stringArray.length;
                this.poolDD = new DataDescriptor[this.noOfThreadPools];
                for (int i = 0; i < this.noOfThreadPools; ++i) {
                    String[] stringArray2 = new String[]{"threadPoolModule", stringArray[i]};
                    this.poolDD[i] = new DataDescriptor(stringArray2);
                }
            }
        } else {
            this.noOfThreadPools = 1;
            this.poolDD = new DataDescriptor[this.noOfThreadPools];
            this.poolDD[0] = orbPoolDD;
        }
        this.pd = new PerfDescriptor[this.noOfThreadPools];
        this.sizeCalc = new IBasicDataPointCalc[this.noOfThreadPools];
        this.activeCalc = new IBasicDataPointHistoryTimeCalc[this.noOfThreadPools];
        for (int i = 0; i < this.noOfThreadPools; ++i) {
            this.pd[i] = new PerfDescriptorImpl(this.node, this.server, this.poolDD[i]);
            this.pd[i].postInit();
            this.sizeCalc[i] = CalcCreator.createBasicDataPointCalc(this.checkAppendLog(this.ruleType));
            this.sizeCalc[i].setUserId(this.userId);
            this.sizeCalc[i].init(this.pd[i], 4);
            this.activeCalc[i] = CalcCreator.createBasicDataPointHistoryTimeCalc(this.checkAppendLog(this.ruleType));
            this.activeCalc[i].setUserId(this.userId);
            this.activeCalc[i].init(this.pd[i], 3, this.calcInterval);
            String string = this.pd[i].getName();
            this.highFractionThresMap.put(string, new Double(this.highFractionThres));
            this.lowFractionThresMap.put(string, new Double(this.lowFractionThres));
            this.varianceThresholdMap.put(string, new Double(this.varianceThreshold));
        }
        this.jvmPD = new PerfDescriptorImpl(this.node, this.server, jvmDD);
        this.jvmPD.postInit();
        this.memCalc = CalcCreator.createMemoryCalc(this.checkAppendLog(this.ruleType));
        this.memCalc.setUserId(this.userId);
        this.memCalc.init(this.jvmPD);
        this.initCalcs = true;
    }

    public RuleOutput[] runRule() {
        Tr.entry(tc, "runRule");
        if (!this.initCalcs) {
            this.initializeCalcs();
        }
        int n = 0;
        ArrayList<RuleOutput> arrayList = new ArrayList<RuleOutput>();
        RuleOutput[] ruleOutputArray = new RuleOutput[1];
        this.cpuCalc = CalcCreator.getCpuCachedCalc(this.checkAppendLog(this.ruleType), this.userId, this.node, this.server, (int)this.calcInterval);
        double d = this.cpuCalc.getIntervalUsage();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "   cpu : " + d);
        }
        if (TuningUtil.isErrorCode(d)) {
            ruleOutputArray[0] = this.createGeneralErrorOutput(this.ruleName, this.pd[0], d);
            return ruleOutputArray;
        }
        d = this.format(d);
        try {
            while (n < this.noOfThreadPools) {
                this.threadPoolName = this.poolName + ' ' + this.pd[n].getName();
                String string = this.pd[n].getName();
                if (!this.mBeanCalc.isMBeanAvailable(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "MBean not available for ", string);
                    }
                } else {
                    RuleOutput ruleOutput;
                    double d2 = this.activeCalc[n].getIntervalAverage();
                    int n2 = new Double(this.sizeCalc[n].getLongValue()).intValue();
                    int n3 = 101;
                    Double d3 = (Double)this.lowFractionThresMap.get(string);
                    double d4 = d3 == null ? this.lowFractionThres : d3;
                    d3 = (Double)this.highFractionThresMap.get(string);
                    double d5 = d3 == null ? this.highFractionThres : d3;
                    d3 = (Double)this.varianceThresholdMap.get(string);
                    double d6 = d3 == null ? this.varianceThreshold : d3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "   aveActive : " + d2);
                        Tr.debug(tc, "   size : " + n2);
                    }
                    boolean bl = TuningUtil.isErrorCode(n2);
                    boolean bl2 = TuningUtil.isErrorCode(d2);
                    if (bl || bl2) {
                        if (bl) {
                            ruleOutput = this.createGeneralErrorOutput(this.ruleName, this.pd[n], n2);
                            arrayList.add(ruleOutput);
                        } else if (bl2) {
                            ruleOutput = this.createGeneralErrorOutput(this.ruleName, this.pd[n], d2);
                            arrayList.add(ruleOutput);
                        }
                    } else if (n2 < 0) {
                        Object[] objectArray = new Object[]{this.threadPoolName, new Integer(n2), new Double(d2)};
                        ruleOutput = this.createExceptionOutput(this.ruleName, this.pd[n], 103, new MessageWrapper("perfalert.inValidPoolSize", objectArray), new MessageWrapper[0], null);
                        arrayList.add(ruleOutput);
                    } else {
                        d2 = this.format(d2);
                        double d7 = 0.0;
                        if (n2 > 0) {
                            d7 = d2 / (double)n2;
                            this.format(d7);
                        }
                        double d8 = this.mBeanCalc.minPoolSize(string);
                        double d9 = this.mBeanCalc.maxPoolSize(string);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "   max : " + d9);
                            Tr.debug(tc, "   min : " + d8);
                            Tr.debug(tc, "   highFractionThreshold : " + d5);
                            Tr.debug(tc, "   lowFractionThres : " + d4);
                            Tr.debug(tc, "   fraction : " + d7);
                            Tr.debug(tc, "   EngineParameters.getCpuSaturated : " + EngineParameters.getCpuSaturated());
                            Tr.debug(tc, "   EngineParameters.getMinCpuUsage : " + EngineParameters.getMinCpuUsage());
                        }
                        if (TuningUtil.isErrorCode(d8)) {
                            ruleOutput = this.createGeneralErrorOutput(this.ruleName, this.pd[n], d8);
                            arrayList.add(ruleOutput);
                        } else if (TuningUtil.isErrorCode(d9)) {
                            ruleOutput = this.createGeneralErrorOutput(this.ruleName, this.pd[n], d9);
                            arrayList.add(ruleOutput);
                        } else if ((double)n2 >= d9 && d7 > d5) {
                            if (d < (double)EngineParameters.getCpuSaturated()) {
                                ruleOutputArray = this.issueAlert_notEnoughThreads(d2, n2, d7, d, this.pd[n]);
                                for (int i = 0; i < ruleOutputArray.length; ++i) {
                                    arrayList.add(ruleOutputArray[i]);
                                }
                            } else {
                                ruleOutput = this.noProblem_workingHard(d7, d, this.pd[n]);
                                arrayList.add(ruleOutput);
                            }
                        } else if (d > (double)EngineParameters.getMinCpuUsage()) {
                            if (d7 < d4 && (double)n2 <= d8) {
                                ruleOutput = this.issueAlert_tooManyThreads(d2, n2, d7, d, this.pd[n], d8, d9);
                                arrayList.add(ruleOutput);
                            } else {
                                double d10 = this.activeCalc[n].getIntervalStdDevSquared();
                                if (!TuningUtil.isErrorCode(d10)) {
                                    try {
                                        d10 = this.format(d10);
                                    }
                                    catch (Exception exception) {
                                        System.out.println("exception caught keeping " + d10 + " as the varience did not trim");
                                    }
                                    if (d10 > d6) {
                                        ruleOutput = this.issueAlert_stdevHigh(d2, n2, d10, d, this.pd[n], (int)d8, (int)d9);
                                        arrayList.add(ruleOutput);
                                    } else {
                                        ruleOutput = this.noProblem_general(d2, n2, d7, this.pd[n]);
                                        arrayList.add(ruleOutput);
                                    }
                                } else {
                                    ruleOutput = this.createGeneralErrorOutput(this.ruleName, this.pd[n], d2);
                                    arrayList.add(ruleOutput);
                                }
                            }
                        } else {
                            ruleOutput = this.noProblem_notUnderLoad(d2, n2, d7, d, this.pd[n]);
                            arrayList.add(ruleOutput);
                            this.activeCalc[n].clearHistory();
                        }
                    }
                    this.activeCalc[n].clear();
                    this.sizeCalc[n].clear();
                }
                ++n;
            }
            this.memCalc.clear();
            ruleOutputArray = new RuleOutput[arrayList.size()];
            arrayList.toArray(ruleOutputArray);
            Tr.exit(tc, "runRule");
            return ruleOutputArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ruleOutputArray = new RuleOutput[]{new RuleOutput(this.ruleName, this.pd[n], 108, new MessageWrapper("perfalert.exception", exception.toString()), new MessageWrapper[0], null)};
            this.setEnabled(false);
            Tr.exit(tc, "runRule");
            return ruleOutputArray;
        }
    }

    protected RuleOutput[] issueAlert_notEnoughThreads(double d, int n, double d2, double d3, PerfDescriptor perfDescriptor) {
        int n2 = 104;
        long l = this.memCalc.getFreeMemory();
        int n3 = (int)Math.ceil(this.increasePercent / 100.0 * (double)n);
        if (n3 < 5) {
            n3 = 5;
        }
        int n4 = n3 + n;
        double d4 = (long)n3 * this.bytes;
        MessageWrapper[] messageWrapperArray = new MessageWrapper[2];
        int n5 = (int)Math.ceil(n4 / 2);
        Object[] objectArray = new Object[]{this.threadPoolName, new Integer(n5), new Integer(n4)};
        messageWrapperArray[0] = new MessageWrapper("perfalert.pool.increase", objectArray);
        if (d4 > (double)l) {
            messageWrapperArray[1] = new MessageWrapper("perfalert.memory");
        }
        n2 = 104;
        MessageWrapper[] messageWrapperArray2 = new MessageWrapper[]{new MessageWrapper("perfalert.percentUsed", new Double(d2 * 100.0)), new MessageWrapper("perfalert.cpuUsed", new Double(d3)), new MessageWrapper("perfalert.pool.numberThreads", new Double(n)), new MessageWrapper("perfalert.pool.activeThreads", new Double(d))};
        RuleOutput[] ruleOutputArray = d4 > (double)l ? new RuleOutput[]{new RuleOutput(this.ruleName, perfDescriptor, n2, messageWrapperArray[0], messageWrapperArray2, null), new RuleOutput(this.ruleName, perfDescriptor, n2, messageWrapperArray[1], messageWrapperArray2, null)} : new RuleOutput[]{new RuleOutput(this.ruleName, perfDescriptor, n2, messageWrapperArray[0], messageWrapperArray2, null)};
        return ruleOutputArray;
    }

    protected RuleOutput issueAlert_tooManyThreads(double d, int n, double d2, double d3, PerfDescriptor perfDescriptor, double d4, double d5) {
        int n2;
        int n3 = 104;
        int n4 = (int)Math.ceil(this.decreasePercent / 100.0 * ((double)n - d));
        int n5 = n - n4;
        if (n5 - (n2 = (int)Math.ceil(n5 / 2)) < 3) {
            n5 = n2 + 3;
        }
        n3 = d4 <= (double)n2 && d5 <= (double)n5 ? 101 : 104;
        Object[] objectArray = new Object[]{this.threadPoolName, new Double(n2), new Double(n5)};
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.pool.decrease", objectArray);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.percentUsed", new Double(d2 * 100.0)), new MessageWrapper("perfalert.cpuUsed", new Double(d3)), new MessageWrapper("perfalert.pool.numberThreads", new Double(n)), new MessageWrapper("perfalert.pool.activeThreads", new Double(d))};
        return new RuleOutput(this.ruleName, perfDescriptor, n3, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput issueAlert_stdevHigh(double d, int n, double d2, double d3, PerfDescriptor perfDescriptor, int n2, int n3) {
        int n4 = 104;
        double d4 = (int)Math.floor((double)n3 - 1.0 * Math.sqrt(d2));
        if (d4 < (double)n2 || d < d4) {
            d4 = (int)d;
        }
        int n5 = d4 < (double)n2 ? new Double(Math.floor(d4 / 2.0)).intValue() : n2;
        n4 = 104;
        Object[] objectArray = new Object[]{this.threadPoolName, new Double(n5), new Double(d4)};
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.pool.decrease", objectArray);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.cpuUsed", new Double(d3))};
        return new RuleOutput(this.ruleName, perfDescriptor, n4, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput noProblem_notUnderLoad(double d, int n, double d2, double d3, PerfDescriptor perfDescriptor) {
        int n2 = 102;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.pool.threadsLowCpuLow", new Object[]{this.threadPoolName});
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.percentUsed", new Double(d2 * 100.0)), new MessageWrapper("perfalert.cpuUsed", new Double(d3)), new MessageWrapper("perfalert.pool.numberThreads", new Double(n)), new MessageWrapper("perfalert.pool.averageSize", new Double(d))};
        return new RuleOutput(this.ruleName, perfDescriptor, n2, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput noProblem_general(double d, int n, double d2, PerfDescriptor perfDescriptor) {
        int n2 = 101;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.pool.noProblem", this.threadPoolName);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.percentUsed", new Double(d2 * 100.0)), new MessageWrapper("perfalert.pool.numberThreads", new Double(n)), new MessageWrapper("perfalert.pool.activeThreads", new Double(d))};
        return new RuleOutput(this.ruleName, perfDescriptor, n2, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput noProblem_workingHard(double d, double d2, PerfDescriptor perfDescriptor) {
        int n = 101;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.pool.cpuLow", this.threadPoolName);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.percentUsed", new Double(d * 100.0)), new MessageWrapper("perfalert.cpuUsed", new Double(d2))};
        return new RuleOutput(this.ruleName, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    public Double getParam(String string) {
        return this.ruleData.getParam(string);
    }

    public String getRuleShortName() {
        return "unknownPoolRuleShortName";
    }

    public static HashMap getStaticAttributeHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(LOW_FRACTION_WORKING, "Des:The min percent of the pool that should be in use before reducing the size of MinPoolSize and MaxPoolSize.#DesLookup:perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.des#OptionsLookup:perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.100~1.0$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.90~0.9$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.80~0.8$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.70~0.7$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.60~0.6$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.50~0.5$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.40~0.4$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.30~0.3$perfTuningAdmin.attribute.rule.MinPercentOfPoolUsed.option.20~0.2#Type:advanced#ParamId:LowFractionOfThreadsWorking#GeneralAttNameLookup:perfTuning.attName.MinPercentOfPoolUsed");
        hashMap.put(INCREASE_PERCENT, "Des:How much to increase the pool if it needs to be increased#DesLookup:perfTuningAdmin.attribute.rule.IncreasePercentage.des#OptionsLookup:perfTuningAdmin.attribute.rule.IncreasePercentage.option.10~10.0$perfTuningAdmin.attribute.rule.IncreasePercentage.option.15~15.0$perfTuningAdmin.attribute.rule.IncreasePercentage.option.20~20.0$perfTuningAdmin.attribute.rule.IncreasePercentage.option.25~25.0#Type:advanced#ParamId:SuggestedIncreaseInPercent#GeneralAttNameLookup:perfTuning.attName.IncreasePercentage");
        hashMap.put(HIGH_FRACTION_WORKING, "Des:If x % of the pool is active then the pool is heavily used and may need to be increased#DesLookup:perfTuningAdmin.attribute.rule.HighUsageThreshold.des#OptionsLookup:perfTuningAdmin.attribute.rule.HighUsageThreshold.option.90~0.90$perfTuningAdmin.attribute.rule.HighUsageThreshold.option.95~0.95$perfTuningAdmin.attribute.rule.HighUsageThreshold.option.99~0.99#Type:advanced#ParamId:HighFractionOfThreadsWorking#GeneralAttNameLookup:perfTuning.attName.HighUsageThreshold");
        hashMap.put(DECREASE_PERCENT, "Des:Suggested Decrease of non used threads in the pool#DesLookup:perfTuningAdmin.attribute.rule.SuggestedDecreaseOfNonUsedThreads.des#OptionsLookup:perfTuningAdmin.attribute.rule.SuggestedDecreaseOfNonUsedThreads.option.100~100.0$perfTuningAdmin.attribute.rule.SuggestedDecreaseOfNonUsedThreads.option.90~90.0$perfTuningAdmin.attribute.rule.SuggestedDecreaseOfNonUsedThreads.option.90~80.0$perfTuningAdmin.attribute.rule.SuggestedDecreaseOfNonUsedThreads.option.70~70.0#Type:advanced#ParamId:SuggestedDecreaseOfNonUsedThreadsInPercent#GeneralAttNameLookup:perfTuning.attName.SuggestedDecreaseOfNonUsedThreads");
        hashMap.put("calculationInterval", "Des:The length of the interval (in seconds) over which calculations will be made.#DesLookup:perfTuningAdmin.attribute.rule.CalculationInterval.des#OptionsLookup:perfTuningAdmin.attribute.rule.CalculationInterval.option.60~60.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.120~120.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.180~180.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.240~240.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.300~300.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.600~600.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.1800~1800.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.3600~3600.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.28800~28800.0$perfTuningAdmin.attribute.rule.CalculationInterval.option.86400~86400.0#Type:advanced#ParamId:calculationInterval#GeneralAttNameLookup:perfTuning.attName.CalculationInterval");
        hashMap.put(STDEV_THRESHOLD, "Des:Standard Deviation#DesLookup:perfTuningAdmin.attribute.rule.stdev.des#OptionsLookup:perfTuningAdmin.attribute.rule.stdev.option.1~1.0$perfTuningAdmin.attribute.rule.stdev.option.2~2.0$perfTuningAdmin.attribute.rule.stdev.option.4~4.0$perfTuningAdmin.attribute.rule.stdev.option.6~6.0$perfTuningAdmin.attribute.rule.stdev.option.8~8.0$perfTuningAdmin.attribute.rule.stdev.option.9~9.0$perfTuningAdmin.attribute.rule.stdev.option.10~10.0$perfTuningAdmin.attribute.rule.stdev.option.15~15.0$perfTuningAdmin.attribute.rule.stdev.option.20~20.0$perfTuningAdmin.attribute.rule.stdev.option.25~25.0$perfTuningAdmin.attribute.rule.stdev.option.30~30.0#Type:advanced#ParamId:StdevThreshold#GeneralAttNameLookup:perfTuning.attName.stdev");
        return hashMap;
    }

    public HashMap getAttributeInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.ruleData.getRuleID();
        HashMap hashMap2 = PoolRuleStateless.getStaticAttributeHashMap();
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = string2.equals(LOW_FRACTION_WORKING) ? "#AttNameLookup:perfTuningAdmin.attName." + this.getRuleShortName() + ".MinPercentOfPoolUsed" : (string2.equals(INCREASE_PERCENT) ? "#AttNameLookup:perfTuningAdmin.attName." + this.getRuleShortName() + ".IncreasePercentage" : (string2.equals(HIGH_FRACTION_WORKING) ? "#AttNameLookup:perfTuningAdmin.attName." + this.getRuleShortName() + ".HighUsageThreshold" : (string2.equals(DECREASE_PERCENT) ? "#AttNameLookup:perfTuningAdmin.attName." + this.getRuleShortName() + ".SuggestedDecreaseOfNonUsedThreads" : (string2.equals("calculationInterval") ? "#AttNameLookup:perfTuningAdmin.attName." + this.getRuleShortName() + ".CalculationInterval" : (string2.equals(STDEV_THRESHOLD) ? "#AttNameLookup:perfTuningAdmin.attName." + this.getRuleShortName() + ".stdev" : "#AttNameLookup:perfTuningAdmin.attName.unknown")))));
            hashMap.put(string2, (String)hashMap2.get(string2) + '#' + "ID" + ':' + "" + string + string3);
        }
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (string.equals(HIGH_FRACTION_WORKING)) {
            this.highFractionThres = d;
            if (!(this.highFractionThres <= this.lowFractionThres)) return;
            double d2 = 0.5 * this.highFractionThres;
            d2 = Math.floor(d2 * 10.0);
            this.setParam(LOW_FRACTION_WORKING, new Double(d2 /= 10.0));
            return;
        } else if (string.equals(LOW_FRACTION_WORKING)) {
            this.lowFractionThres = d;
            if (!(this.highFractionThres <= this.lowFractionThres)) return;
            this.setParam(HIGH_FRACTION_WORKING, new Double(0.5 * (1.0 - this.lowFractionThres) + this.lowFractionThres));
            return;
        } else if (string.equals(INCREASE_PERCENT)) {
            this.increasePercent = d;
            return;
        } else if (string.equals(DECREASE_PERCENT)) {
            this.decreasePercent = d;
            return;
        } else if (string.equals("calculationInterval")) {
            double d3 = d;
            if (!(this.calcInterval > 0.0)) throw new IllegalArgumentException("Can not set calculationInterval to negative number or to zero:  " + d3);
            this.calcInterval = d3;
            for (int i = 0; i < this.noOfThreadPools; ++i) {
                this.activeCalc[i].setIntervalTime(this.calcInterval);
            }
            return;
        } else {
            if (!string.equals(STDEV_THRESHOLD)) return;
            double d4 = d;
            if (!(d4 >= 0.0)) throw new IllegalArgumentException("Can not set " + STDEV_THRESHOLD + " to negative number:  " + d4);
            this.varianceThreshold = d4 * d4;
        }
    }

    public void clearHistory() {
        if (this.activeCalc == null) {
            return;
        }
        for (int i = 0; i < this.activeCalc.length; ++i) {
            this.activeCalc[i].clearHistory();
        }
    }
}

