/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningUtil;
import java.util.HashMap;
import java.util.Set;

public class RuleData {
    private String ruleID;
    private String name;
    private String className;
    private String type;
    private String nameKey;
    private String componentKey;
    private boolean enabled;
    private boolean zos_enabled;
    private boolean transitionRule;
    private HashMap paramMap;
    private String performanceImpact = "high";

    public RuleData() {
        this.paramMap = new HashMap();
    }

    public RuleData(String string) {
        this.ruleID = string;
        this.paramMap = new HashMap();
    }

    public RuleData(String string, String string2, String string3, String string4, boolean bl, HashMap hashMap, String string5, String string6, boolean bl2, String string7) {
        this.ruleID = string;
        this.name = string2;
        this.className = string3;
        this.type = string4;
        this.enabled = bl;
        this.paramMap = hashMap;
        this.transitionRule = this.transitionRule;
        this.performanceImpact = string7;
        this.nameKey = string5 == null ? "perfTuningAdmin.ruleName.unknown" : string5;
        this.componentKey = string6 == null ? "perfTuningAdmin.componentName.unknown" : string6;
    }

    public String getPerformanceImpact() {
        return this.performanceImpact;
    }

    public void setPerformanceImpact(String string) {
        this.performanceImpact = string;
    }

    public void setTransitionRule(boolean bl) {
        this.transitionRule = bl;
    }

    public boolean isTransitionRule() {
        return this.transitionRule;
    }

    public void setNameKey(String string) {
        this.nameKey = string;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public void setComponentKey(String string) {
        this.componentKey = string;
    }

    public String getComponentKey() {
        return this.componentKey;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setZos_enabled(boolean bl) {
        this.zos_enabled = bl;
    }

    public void setParamMap(HashMap hashMap) {
        this.paramMap = hashMap;
    }

    public void addParam(String string, Double d) {
        this.paramMap.put(string, d);
    }

    public void setParam(String string, Double d) {
        if (!this.paramMap.containsKey(string)) {
            throw new IllegalArgumentException("RuleData, param map does not contain " + string);
        }
        this.paramMap.put(string, d);
    }

    public Double getParam(String string) {
        return (Double)this.paramMap.get(string);
    }

    public String[] getParamNames() {
        try {
            Set set = this.paramMap.keySet();
            String[] stringArray = new String[set.size()];
            stringArray = set.toArray(stringArray);
            return stringArray;
        }
        catch (Exception exception) {
            System.out.println("[RuleData] getParamNames() caught exception " + exception.toString());
            exception.printStackTrace();
            return new String[0];
        }
    }

    public String getRuleID() {
        return this.ruleID;
    }

    public void setRuleID(String string) {
        this.ruleID = string;
    }

    public String getName() {
        return TuningUtil.getNLSString(this.nameKey, this.name);
    }

    public String getClassName() {
        return this.className;
    }

    public String getType() {
        return this.type;
    }

    public boolean getEnabled() {
        if (EngineParameters.getOS().equalsIgnoreCase("z/OS")) {
            return this.enabled && this.zos_enabled;
        }
        return this.enabled;
    }

    public boolean getZos_enabled() {
        if (EngineParameters.getOS().equalsIgnoreCase("z/OS")) {
            return this.zos_enabled;
        }
        return true;
    }

    public HashMap getParamMap() {
        return this.paramMap;
    }
}

