/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleParser;
import com.ibm.ws.performance.tuning.rule.RulePersister;
import com.ibm.ws.performance.tuning.rule.TransitionRuleList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class RuleLookup
implements TuningConstants {
    private ArrayList list = new ArrayList();
    private RuleParser rp;
    private String _ruleXmlFile;
    private static TraceComponent tc = Tr.register(RuleLookup.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private String serverType;
    private HashMap map = new HashMap();
    private HashMap persistMap = new HashMap();
    private ArrayList paramNames = new ArrayList();
    private String id = "RuleEngine";

    public RuleLookup(String string) throws IOException {
        this._ruleXmlFile = string;
        this.rp = new RuleParser(this, this._ruleXmlFile);
    }

    public RuleLookup(InputStream inputStream) throws IOException {
        this.rp = new RuleParser(this, inputStream);
    }

    public RuleLookup(String string, String string2, String string3) throws IOException {
        this._ruleXmlFile = string;
        this.rp = new RuleParser(this, this._ruleXmlFile);
        this.addTransitionRules(string2, string3);
    }

    public RuleLookup(InputStream inputStream, String string, String string2) throws IOException {
        this.rp = new RuleParser(this, inputStream);
        this.addTransitionRules(string, string2);
    }

    private void addTransitionRules(String string, String string2) {
        block5: {
            if (string == null && string2 == null) {
                return;
            }
            try {
                TransitionRuleList transitionRuleList = new TransitionRuleList();
                transitionRuleList.init(string, string2);
                ArrayList arrayList = transitionRuleList.getServerRules();
                for (int i = 0; i < arrayList.size(); ++i) {
                    RuleData ruleData = (RuleData)arrayList.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adding transition rule : " + ruleData.getRuleID() + "," + ruleData.getClassName());
                    }
                    this.list.add(ruleData);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "could not load new transition rules : " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public void addRule(RuleData ruleData) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding new rule : " + ruleData.toString());
        }
        this.list.add(ruleData);
    }

    public ArrayList getRules() {
        return this.list;
    }

    public void persistChangesInXmlFile(String string) throws Exception {
        RulePersister rulePersister = new RulePersister();
        rulePersister.persistChanges(this, this.rp.getRootNode(), string);
    }

    public void persistChangesToOutputStream(OutputStream outputStream) throws Exception {
        RulePersister rulePersister = new RulePersister();
        rulePersister.persistChanges(this, this.rp.getRootNode(), outputStream);
    }

    public RuleData getRuleByID(String string) {
        for (int i = 0; i < this.list.size(); ++i) {
            RuleData ruleData = (RuleData)this.list.get(i);
            if (!string.equals(ruleData.getRuleID())) continue;
            return ruleData;
        }
        return null;
    }

    public boolean isNewRule(String string) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!string.equals(((RuleData)this.list.get(i)).getRuleID())) continue;
            return false;
        }
        return true;
    }

    public void dump() {
        int n;
        int n2 = this.list.size();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < n2; ++n) {
            RuleData ruleData = (RuleData)this.list.get(n);
            stringBuffer.append("ID: ").append(ruleData.getRuleID()).append("\n");
            stringBuffer.append("Name: ").append(ruleData.getName()).append("\n");
            stringBuffer.append("Enabled: ").append(ruleData.getEnabled()).append("\n");
            stringBuffer.append("Type: ").append(ruleData.getType()).append("\n");
            stringBuffer.append("Class name: ").append(ruleData.getClassName()).append("\n");
            HashMap hashMap = ruleData.getParamMap();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string).append(" = ").append(hashMap.get(string).toString()).append("\n");
            }
        }
        Tr.debug(tc, stringBuffer.toString());
        Tr.debug(tc, "dumping RuleLookup's engine parameters");
        for (n = 0; n < this.paramNames.size(); ++n) {
            Tr.debug(tc, "    " + this.paramNames.get(n) + "=" + this.map.get(this.paramNames.get(n)));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public int getMaxAlertStreak() {
        Integer n = (Integer)this.map.get("maxAlertStreak");
        if (n == null) {
            return 3;
        }
        return n;
    }

    public int getMinCpuUsage() {
        Integer n = (Integer)this.map.get("minCpuUsage");
        if (n == null) {
            return 50;
        }
        return n;
    }

    public int getCalcInterval() {
        Integer n = (Integer)this.map.get("calculationInterval");
        if (n == null) {
            return 60;
        }
        return n;
    }

    public int getCpuSaturated() {
        Integer n = (Integer)this.map.get("cpuSaturated");
        if (n == null) {
            return 90;
        }
        return n;
    }

    public int getNumProcessors() {
        Integer n = (Integer)this.map.get("numberOfProcessors");
        if (n == null) {
            System.out.println(" did not get numberOfProcessors");
            return 2;
        }
        System.out.println("got numberOfProcessors=" + n);
        return n;
    }

    public int getRefreshIteration() {
        Integer n = (Integer)this.map.get("refreshIteration");
        if (n == null) {
            return 0;
        }
        return n;
    }

    public HashMap getParamMap() {
        return this.map;
    }

    public Object getParam(String string) {
        return this.map.get(string);
    }

    public void setParam(String string, Object object) {
        if (!this.map.containsKey(string)) {
            this.paramNames.add(string);
        }
        this.map.put(string, object);
    }

    public ArrayList getParamNames() {
        return this.paramNames;
    }

    public void clearPersistMap() {
        this.persistMap = new HashMap();
    }

    public HashMap getPersistMap() {
        return this.persistMap;
    }

    public void setPersistParam(String string, Object object) {
        this.persistMap.put(string, object);
    }

    public Object getPersistParam(String string) {
        return this.persistMap.get(string);
    }

    public String getProcessType() {
        return this.serverType;
    }

    public void setProcessType(String string) throws Exception {
        if (!string.equals("ManagedProcess") && !string.equals("UnManagedProcess")) {
            throw new Exception("EngineParameters.setProcessType tried to set prcoess type to  " + string + "which is other than " + "ManagedProcess" + "or " + "UnManagedProcess");
        }
        this.serverType = string;
    }
}

