/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.SuggestedConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class RuleOutput
implements Serializable {
    private static final long serialVersionUID = 327724075383811874L;
    private Locale locale;
    private String name;
    private int outputType;
    private MessageWrapper message;
    private ArrayList symptoms;
    private ArrayList additionalInformation;
    private PerfDescriptor pd;
    private SuggestedConfig[] suggestedCfg;

    public RuleOutput(int n, MessageWrapper messageWrapper, MessageWrapper messageWrapper2, SuggestedConfig[] suggestedConfigArray) {
        this("unknown rule name", null, n, messageWrapper, messageWrapper2, suggestedConfigArray);
    }

    public RuleOutput(String string, PerfDescriptor perfDescriptor, int n, MessageWrapper messageWrapper, MessageWrapper messageWrapper2, SuggestedConfig[] suggestedConfigArray) {
        this.name = string;
        this.pd = perfDescriptor;
        this.outputType = n;
        this.message = messageWrapper;
        this.symptoms = new ArrayList();
        this.additionalInformation = new ArrayList();
        this.symptoms.add(messageWrapper2);
        this.suggestedCfg = suggestedConfigArray;
        this.locale = Locale.getDefault();
    }

    public RuleOutput(String string, PerfDescriptor perfDescriptor, int n, MessageWrapper messageWrapper, MessageWrapper[] messageWrapperArray, SuggestedConfig[] suggestedConfigArray) {
        this.name = string;
        this.pd = perfDescriptor;
        this.outputType = n;
        this.message = messageWrapper;
        this.symptoms = new ArrayList();
        this.additionalInformation = new ArrayList();
        for (int i = 0; i < messageWrapperArray.length; ++i) {
            this.symptoms.add(messageWrapperArray[i]);
        }
        this.suggestedCfg = suggestedConfigArray;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void addSympton(MessageWrapper messageWrapper) {
        this.symptoms.add(messageWrapper);
    }

    public String getName() {
        return this.name;
    }

    public PerfDescriptor getPerfDescriptor() {
        return this.pd;
    }

    public int getOutputType() {
        return this.outputType;
    }

    public void updateOutputType(int n) {
        this.outputType = n;
    }

    public String getMessage() {
        return this.message.getMessagePlusBlank(this.locale);
    }

    public String getMessageId() {
        return this.message.getId();
    }

    public Object[] getMessageArgs() {
        return this.message.getArgs();
    }

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.message.getId()).append(".desc");
        return TuningUtil.getNLSString(stringBuffer.toString(), null, this.locale);
    }

    public String getAction() {
        StringBuffer stringBuffer = new StringBuffer(this.message.getId()).append(".action");
        return TuningUtil.getNLSString(stringBuffer.toString(), null, this.locale);
    }

    public String[] getSymptoms() {
        Object[] objectArray = this.symptoms.toArray();
        if (objectArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            MessageWrapper messageWrapper = (MessageWrapper)objectArray[i];
            if (messageWrapper == null) {
                System.err.println(" message wrapper : " + i + " is null: " + objectArray.length + " available");
                stringArray[i] = "";
                continue;
            }
            stringArray[i] = ((MessageWrapper)objectArray[i]).getMessage(this.locale);
        }
        return stringArray;
    }

    public SuggestedConfig[] getSuggestedCfg() {
        return this.suggestedCfg;
    }

    public String getServerName() {
        return this.pd.getServerName();
    }

    public String getNodeName() {
        return this.pd.getNodeName();
    }

    public String[] getAdditionalInformation() {
        Object[] objectArray = this.additionalInformation.toArray();
        if (objectArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = ((MessageWrapper)objectArray[i]).getMessage(this.locale);
        }
        return stringArray;
    }

    public void addAdditionalInformation(MessageWrapper messageWrapper) {
        this.additionalInformation.add(messageWrapper);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(TuningUtil.getNLSString("perfalert.name", this.locale));
        stringBuffer.append(this.getName());
        stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.datapoint", this.locale));
        stringBuffer.append(this.getNodeName()).append(" ").append(this.getServerName()).append(" ").append(this.pd.getName());
        stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.alertType", this.locale));
        stringBuffer.append(TuningUtil.getRuleOutputType(this.outputType));
        stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.message", this.locale));
        stringBuffer.append(this.getMessage());
        String string = this.getDescription();
        if (string == null) {
            string = new String("Explaination is not duplicated for " + this.message.getId());
        }
        stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.description", this.locale)).append(string);
        String string2 = this.getAction();
        if (string2 == null) {
            string2 = new String("Action is not duplicated for " + this.message.getId());
        }
        stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.action", this.locale)).append(string2);
        stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.list", this.locale));
        String[] stringArray = this.getSymptoms();
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append("\n").append(stringArray[n]);
        }
        if (this.suggestedCfg != null) {
            stringBuffer.append(TuningUtil.getNLSString("perfalert.config", this.locale));
            for (n = 0; n < this.suggestedCfg.length; ++n) {
                stringBuffer.append("\n");
                stringBuffer.append(this.suggestedCfg[n].toString());
            }
        }
        stringBuffer.append("\n").append(TuningUtil.getNLSString("perfalert.debug", this.locale));
        String[] stringArray2 = this.getAdditionalInformation();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append("\n").append(stringArray2[i]);
        }
        return stringBuffer.toString();
    }
}

