/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleLookup;
import com.ibm.ws.xml.ParserFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RuleParser
implements TuningConstants {
    private RuleLookup rulelookup;
    private RuleData aRuleData;
    private Node rootNode = null;

    public RuleParser(RuleLookup ruleLookup, String string) throws IOException {
        this.rulelookup = ruleLookup;
        this.parse(string);
    }

    public RuleParser(RuleLookup ruleLookup, InputStream inputStream) throws IOException {
        this.rulelookup = ruleLookup;
        this.parse(inputStream);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    private void parse(String string) throws IOException {
        try {
            InputStream inputStream = RuleParser.class.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("Error opening file: " + string);
            }
            this.parse(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.toString());
        }
    }

    private void parse(InputStream inputStream) throws IOException {
        try {
            DocumentBuilder documentBuilder = ParserFactory.newDocumentBuilder(false, false);
            this.rootNode = ParserFactory.parseDocument(documentBuilder, null, null, inputStream);
            if (this.rootNode == null) {
                return;
            }
            inputStream.close();
            this.parseNode(this.rootNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.toString());
        }
    }

    private void parseNode(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                String string = node.getNodeName();
                if (string.equals("tuningRules")) {
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        this.parseNode(node2);
                    }
                } else {
                    if (string.equals("rule")) {
                        Node node3 = node.getFirstChild();
                        String string2 = null;
                        if (node3 != null && node3.getNodeType() == 3 && ((string2 = ((Element)node).getAttribute("id")) == null || string2.length() == 0)) {
                            return;
                        }
                        if (!this.rulelookup.isNewRule(string2)) {
                            return;
                        }
                        this.aRuleData = new RuleData(string2);
                        for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                            this.parseNode(node4);
                        }
                        this.rulelookup.addRule(this.aRuleData);
                        break;
                    }
                    if (string.equals("ruleEngine")) {
                        this.rulelookup.setId(((Element)node).getAttribute("id"));
                        for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                            this.parseNode(node5);
                        }
                    } else {
                        for (Node node6 = node.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                            this.parseNode(node6);
                        }
                    }
                }
                break;
            }
            case 3: {
                Node node7 = node.getParentNode();
                String string = node7.getNodeName();
                if (string.equals("name")) {
                    this.aRuleData.setName(node.getNodeValue());
                    break;
                }
                if (string.equals("type")) {
                    this.aRuleData.setType(node.getNodeValue());
                    break;
                }
                if (string.equals("class")) {
                    this.aRuleData.setClassName(node.getNodeValue());
                    break;
                }
                if (string.equals("enabled")) {
                    if (node.getNodeValue().equalsIgnoreCase("true")) {
                        this.aRuleData.setEnabled(true);
                        break;
                    }
                    this.aRuleData.setEnabled(false);
                    break;
                }
                if (string.equals("zos_enabled")) {
                    if (node.getNodeValue().equalsIgnoreCase("true")) {
                        this.aRuleData.setZos_enabled(true);
                        break;
                    }
                    this.aRuleData.setZos_enabled(false);
                    break;
                }
                if (string.equals("nlsKey_component")) {
                    this.aRuleData.setComponentKey(node.getNodeValue());
                    break;
                }
                if (string.equals("nlsKey_name")) {
                    this.aRuleData.setNameKey(node.getNodeValue());
                    break;
                }
                if (string.equals("performanceImpact")) {
                    this.aRuleData.setPerformanceImpact(node.getNodeValue());
                    break;
                }
                if (string.equals("param")) {
                    String string3 = ((Element)node7).getAttribute("name");
                    Double d = Double.valueOf(node.getNodeValue());
                    this.aRuleData.addParam(string3, d);
                    break;
                }
                if (!string.equals("generalAttribute") && !string.equals("runtimeAttribute")) break;
                String string4 = ((Element)node7).getAttribute("name");
                String string5 = ((Element)node7).getAttribute("type");
                if (string5.equals("Boolean") || string5.equals("java.lang.Boolean")) {
                    Boolean bl = Boolean.valueOf(node.getNodeValue());
                    this.rulelookup.setParam(string4, bl);
                    break;
                }
                if (string5.equals("Integer") || string5.equals("java.lang.Integer")) {
                    Integer n = Integer.valueOf(node.getNodeValue());
                    this.rulelookup.setParam(string4, n);
                    break;
                }
                if (!string5.equals("Double") && !string5.equals("java.lang.Double")) break;
                Double d = Double.valueOf(node.getNodeValue());
                this.rulelookup.setParam(string4, d);
                break;
            }
            default: {
                for (Node node8 = node.getFirstChild(); node8 != null; node8 = node8.getNextSibling()) {
                    this.parseNode(node8);
                }
            }
        }
    }

    private void isEnabled(String string) throws IOException {
        try {
            InputStream inputStream = RuleParser.class.getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("Error opening file: " + string);
            }
            RuleParser.isEnabled(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.toString());
        }
    }

    public static boolean isEnabled(InputStream inputStream) throws IOException {
        try {
            DocumentBuilder documentBuilder = ParserFactory.newDocumentBuilder(false, false);
            Document document = ParserFactory.parseDocument(documentBuilder, null, null, inputStream);
            if (document == null) {
                return false;
            }
            boolean bl = RuleParser.parseEnabled(document);
            inputStream.close();
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.toString());
        }
    }

    private static boolean parseRuleEngine(Node node) throws Exception {
        Node node2 = node.getParentNode();
        String string = node2.getNodeName();
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            NamedNodeMap namedNodeMap;
            Node node4;
            String string2 = node3.getNodeName();
            short s = node3.getNodeType();
            if (s != 1 || !node3.hasAttributes() || (node4 = (namedNodeMap = node3.getAttributes()).getNamedItem("name")) == null || !node4.getNodeValue().equals("enabled")) continue;
            String string3 = node3.getFirstChild().getNodeValue();
            return string3.equalsIgnoreCase("true");
        }
        throw new Exception("could not find named attribute enabled ");
    }

    private static boolean parseEnabled(Node node) throws Exception {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            short s = node2.getNodeType();
            if (s != 1) continue;
            if (string.equals("tuningRules")) {
                return RuleParser.parseEnabled(node2);
            }
            if (!string.equals("ruleEngine")) continue;
            return RuleParser.parseRuleEngine(node2);
        }
        throw new Exception("did not find enabled in perftuners.xml");
    }
}

