/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleLookup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RulePersister
implements TuningConstants {
    private RuleLookup ruleLookup;
    private RuleData aRuleData;

    public void persistChanges(RuleLookup ruleLookup, Node node, String string) throws Exception {
        try {
            this.ruleLookup = ruleLookup;
            this.updateNode(node);
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(new FileOutputStream(new File(string)));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            System.out.println("persistChanges caught unexpected exception when trying to persist rules " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void persistChanges(RuleLookup ruleLookup, Node node, OutputStream outputStream) throws Exception {
        try {
            this.ruleLookup = ruleLookup;
            this.updateNode(node);
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(outputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            System.out.println("persistChanges caught exception " + exception.toString());
            exception.printStackTrace();
        }
    }

    private void updateNode(Node node) {
        try {
            short s = node.getNodeType();
            switch (s) {
                case 1: {
                    String string = node.getNodeName();
                    if (string.equals("tuningRules")) {
                        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                            this.updateNode(node2);
                        }
                    } else if (string.equals("rule")) {
                        Node node3 = node.getFirstChild();
                        String string2 = null;
                        if (node3 != null && node3.getNodeType() == 3 && ((string2 = ((Element)node).getAttribute("id")) == null || string2.length() == 0)) {
                            return;
                        }
                        this.aRuleData = this.ruleLookup.getRuleByID(string2);
                        if (this.aRuleData == null) {
                            return;
                        }
                        for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                            this.updateNode(node4);
                        }
                    } else {
                        for (Node node5 = node.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                            this.updateNode(node5);
                        }
                    }
                    break;
                }
                case 3: {
                    Node node6 = node.getParentNode();
                    String string = node6.getNodeName();
                    if (string.equals("enabled")) {
                        node.setNodeValue(String.valueOf(this.aRuleData.getEnabled()));
                        break;
                    }
                    if (string.equals("param")) {
                        String string3 = ((Element)node6).getAttribute("name");
                        Double d = this.aRuleData.getParam(string3);
                        if (d != null) {
                            node.setNodeValue(String.valueOf(d));
                        }
                        break;
                    }
                    if (string.equals("nlsKey_component")) {
                        String string4 = ((Element)node6).getAttribute("nlsKey_component");
                        node.setNodeValue(this.aRuleData.getComponentKey());
                        break;
                    }
                    if (string.equals("nlsKey_name")) {
                        String string5 = ((Element)node6).getAttribute("nlsKey_name");
                        node.setNodeValue(this.aRuleData.getNameKey());
                        break;
                    }
                    if (string.equals("performanceImpact")) {
                        String string6 = ((Element)node6).getAttribute("performanceImpact");
                        node.setNodeValue(this.aRuleData.getPerformanceImpact());
                        break;
                    }
                    if (!string.equals("generalAttribute") && !string.equals("runtimeAttribute")) break;
                    String string7 = ((Element)node6).getAttribute("name");
                    String string8 = ((Element)node6).getAttribute("type");
                    if (string8.equals("java.lang.Boolean") || string8.equals("Boolean")) {
                        Boolean bl = (Boolean)this.ruleLookup.getPersistParam(string7);
                        if (bl != null) {
                            node.setNodeValue(bl.toString());
                        }
                        break;
                    }
                    if (string8.equals("java.lang.Integer") || string8.equals("Integer")) {
                        Integer n = (Integer)this.ruleLookup.getPersistParam(string7);
                        if (n != null) {
                            node.setNodeValue(n.toString());
                        }
                        break;
                    }
                    if (string8.equals("java.lang.Double") || string8.equals("Double")) {
                        Double d = (Double)this.ruleLookup.getPersistParam(string7);
                        if (d != null) {
                            node.setNodeValue(d.toString());
                        }
                        break;
                    }
                    System.out.println("error.  RulePersister does not know how to handle objects of type=" + s);
                    break;
                }
                default: {
                    for (Node node7 = node.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                        this.updateNode(node7);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("exception persisting advisors " + exception.toString());
            exception.printStackTrace();
        }
    }
}

