/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.IRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.rule.RuleState;
import com.ibm.ws.performance.tuning.rule.SessionSizeRuleStateless;
import com.ibm.ws.performance.tuning.rule.StatefullRuleInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SessionSizeRuleStatefull
extends SessionSizeRuleStateless
implements IRule,
TuningConstants,
StatefullRuleInterface {
    private HashMap ruleStateMap;
    private final int OTHER_DATA_COUNT = 8;
    private final int READ_CURRENT_IDX = 0;
    private final int READ_MAX_IDX = 1;
    private final int READ_ALERT_STREAK_IDX = 2;
    private final int READ_THRESHOLD_UPDATED_IDX = 3;
    private final int WRITE_CURRENT_IDX = 4;
    private final int WRITE_MAX_IDX = 5;
    private final int WRITE_ALERT_STREAK_IDX = 6;
    private final int WRITE_THRESHOLD_UPDATED_IDX = 7;
    private final double UPDATED = 0.0;
    private final double ORIG = 1.0;
    int iteration;
    int updateThreshold;

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
        HashMap hashMap = this.ruleData.getParamMap();
        this.iteration = 0;
        this.updateThreshold = EngineParameters.getMaxAlertStreak();
        this.ruleStateMap = new HashMap();
    }

    public void setMaxAlertStreak(Integer n) {
        int n2 = n;
        this.updateThreshold = n2 < 0 ? EngineParameters.getMaxAlertStreak() : n2;
        Set set = this.ruleStateMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RuleState ruleState = (RuleState)iterator.next();
            ruleState.setData(2, 0.0);
            ruleState.setData(6, 0.0);
        }
    }

    private RuleState getRuleState(PerfDescriptor perfDescriptor) {
        RuleState ruleState = (RuleState)this.ruleStateMap.get(perfDescriptor.getFullName());
        if (ruleState == null) {
            ruleState = new RuleState(8);
            ruleState.setData(0, this.readSizeTooLargeInK);
            ruleState.setData(1, this.readSizeTooLargeInK);
            ruleState.setData(2, 0.0);
            ruleState.setData(3, 1.0);
            ruleState.setData(4, this.writeSizeTooLargeInK);
            ruleState.setData(5, this.writeSizeTooLargeInK);
            ruleState.setData(6, 0.0);
            ruleState.setData(7, 1.0);
            this.ruleStateMap.put(this.pd, ruleState);
        }
        return ruleState;
    }

    protected RuleOutput createWriteError(PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.createWriteError(perfDescriptor, d);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(2, 0.0);
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        return ruleOutput;
    }

    protected RuleOutput createReadError(PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.createReadError(perfDescriptor, d);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(2, 0.0);
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        return ruleOutput;
    }

    protected RuleOutput createWriteAlert(PerfDescriptor perfDescriptor, double d) {
        Object object;
        RuleOutput ruleOutput = super.createWriteAlert(perfDescriptor, d);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.increaseData(6);
        if (d > ruleState.getData(5)) {
            ruleState.setData(5, d);
        }
        if (ruleState.getData(6) == (double)this.updateThreshold) {
            ruleState.setData(4, ruleState.getData(5));
            ruleState.setData(6, 0.0);
            ruleState.setData(7, 0.0);
            this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
            object = new Integer(this.updateThreshold);
            ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", object));
        }
        object = new String(ruleState.getData(4) + " (K)");
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.currentThreshold", object);
        ruleOutput.addAdditionalInformation(messageWrapper);
        return ruleOutput;
    }

    protected RuleOutput createWriteNoProblem(PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.createWriteNoProblem(perfDescriptor, d);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(6, 0.0);
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        String string = new String(ruleState.getData(4) + " (K)");
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.currentThreshold", string);
        ruleOutput.addAdditionalInformation(messageWrapper);
        return ruleOutput;
    }

    protected RuleOutput createReadAlert(PerfDescriptor perfDescriptor, double d) {
        Object object;
        RuleOutput ruleOutput = super.createReadAlert(perfDescriptor, d);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.increaseData(2);
        if (d > ruleState.getData(1)) {
            ruleState.setData(1, d);
        }
        if (ruleState.getData(2) == (double)this.updateThreshold) {
            ruleState.setData(0, ruleState.getData(1));
            ruleState.setData(2, 0.0);
            ruleState.setData(3, 0.0);
            this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
            object = new Integer(this.updateThreshold);
            ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", object));
        }
        object = new String(ruleState.getData(0) + " (K)");
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.currentThreshold", object);
        ruleOutput.addAdditionalInformation(messageWrapper);
        return ruleOutput;
    }

    protected RuleOutput createReadNoProblem(PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.createReadNoProblem(perfDescriptor, d);
        RuleState ruleState = this.getRuleState(perfDescriptor);
        ruleState.setData(2, 0.0);
        this.ruleStateMap.put(perfDescriptor.getFullName(), ruleState);
        String string = new String(ruleState.getData(0) + " (K)");
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.currentThreshold", string);
        ruleOutput.addAdditionalInformation(messageWrapper);
        return ruleOutput;
    }

    public RuleOutput[] runRule() {
        RuleOutput[] ruleOutputArray = super.runRule();
        return ruleOutputArray;
    }

    protected double getReadThreshold(PerfDescriptor perfDescriptor) {
        RuleState ruleState = this.getRuleState(perfDescriptor);
        return ruleState.getData(0);
    }

    protected double getWriteThreshold(PerfDescriptor perfDescriptor) {
        RuleState ruleState = this.getRuleState(perfDescriptor);
        return ruleState.getData(4);
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        this.ruleStateMap = new HashMap();
    }

    public void clearHistory() {
        super.clearHistory();
        this.ruleStateMap = new HashMap();
    }
}

