/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISessionMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractSessionRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SessionSizeRuleStateless
extends AbstractSessionRule {
    private static TraceComponent tc = Tr.register(SessionSizeRuleStateless.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private IBasicDataPointHistoryCalc[] readCalc;
    private IBasicDataPointHistoryCalc[] readCalcTmp;
    private IBasicDataPointHistoryCalc[] writeCalc;
    private IBasicDataPointHistoryCalc[] writeCalcTmp;
    private ISessionMBeanSharedCalc sessionMBeanCalc;
    private static final String READ_MAX = "MaximinReadSessionSizeInK";
    private static final String WRITE_MAX = "MaximinWriteSessionSizeInK";
    protected double readSizeTooLargeInK;
    protected double writeSizeTooLargeInK;
    private String ruleNameRead;
    private String ruleNameWrite;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
        Object v = this.map.get(READ_MAX);
        if (v != null) {
            this.readSizeTooLargeInK = (Double)v;
        }
        if ((v = this.map.get(WRITE_MAX)) != null) {
            this.writeSizeTooLargeInK = (Double)v;
        }
        this.readCalc = new IBasicDataPointHistoryCalc[0];
        this.writeCalc = new IBasicDataPointHistoryCalc[0];
        this.createTmpCalcArrays(0);
        this.sessionMBeanCalc = CalcCreator.getSessionMBeanSharedCalc(string, string2, this.checkAppendLog(this.ruleType));
        super.checkInterval();
        this.setEnabled(this.isEnabled());
        this.ruleNameRead = this.ruleName;
        this.ruleNameWrite = this.ruleName;
    }

    protected void createTmpCalcArrays(int n) {
        this.readCalcTmp = new IBasicDataPointHistoryCalc[n];
        this.writeCalcTmp = new IBasicDataPointHistoryCalc[n];
    }

    protected void createCalcObjectsInTmpArray(PerfDescriptor perfDescriptor, int n, boolean bl, int n2) {
        if (bl) {
            this.readCalcTmp[n] = CalcCreator.createBasicDataPointHistoryCalc(this.checkAppendLog(this.ruleType));
            this.readCalcTmp[n].setUserId(this.userId);
            this.readCalcTmp[n].init(perfDescriptor, 11);
            this.writeCalcTmp[n] = CalcCreator.createBasicDataPointHistoryCalc(this.checkAppendLog(this.ruleType));
            this.writeCalcTmp[n].setUserId(this.userId);
            this.writeCalcTmp[n].init(perfDescriptor, 13);
        } else {
            this.readCalcTmp[n] = this.readCalc[n2];
            this.writeCalcTmp[n] = this.writeCalc[n2];
        }
    }

    protected void updateCalcArrayWithTmpArray() {
        this.readCalc = this.readCalcTmp;
        this.writeCalc = this.writeCalcTmp;
    }

    public RuleOutput[] runRule() {
        this.checkInterval();
        int n = this.readCalc.length;
        RuleOutput[] ruleOutputArray = new RuleOutput[2 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            PerfDescriptor perfDescriptor = (PerfDescriptor)this.dds.get(i);
            if (this.isApplicable(perfDescriptor)) {
                double d;
                double d2;
                n2 = 2 * i;
                double d3 = this.readCalc[i].getDoubleValue();
                ruleOutputArray[n2] = TuningUtil.isErrorCode(d3) ? this.createReadError((PerfDescriptor)this.dds.get(i), d3) : ((d3 = this.format(new Double(this.sigDigits(d3 / 1024.0, 4)))) > (d2 = this.getReadThreshold(perfDescriptor)) ? this.createReadAlert(perfDescriptor, d3) : this.createReadNoProblem(perfDescriptor, d3));
                d2 = this.writeCalc[i].getDoubleValue();
                ruleOutputArray[n2 + 1] = TuningUtil.isErrorCode(d2) ? this.createWriteError(perfDescriptor, d2) : ((d2 = this.format(new Double(this.sigDigits(d2 / 1024.0, 4)))) > (d = this.getWriteThreshold(perfDescriptor)) ? this.createWriteAlert(perfDescriptor, d2) : this.createWriteNoProblem(perfDescriptor, d2));
                this.readCalc[i].clear();
                this.writeCalc[i].clear();
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "not running SessionSizeRuleStateless on " + perfDescriptor.getName() + " because it is not applicable");
        }
        return ruleOutputArray;
    }

    protected RuleOutput createWriteError(PerfDescriptor perfDescriptor, double d) {
        return TuningUtil.createGeneralErrorOutput(this.ruleNameWrite, perfDescriptor, d);
    }

    protected RuleOutput createReadError(PerfDescriptor perfDescriptor, double d) {
        return TuningUtil.createGeneralErrorOutput(this.ruleNameRead, perfDescriptor, d);
    }

    protected RuleOutput createWriteAlert(PerfDescriptor perfDescriptor, double d) {
        int n = 104;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.writeSizeTooLarge", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.writeSize", new Double(d))};
        return new RuleOutput(this.ruleNameWrite, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput createWriteNoProblem(PerfDescriptor perfDescriptor, double d) {
        int n = 101;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.writeSizeOk", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.writeSize", new Double(d))};
        return new RuleOutput(this.ruleNameWrite, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput createReadAlert(PerfDescriptor perfDescriptor, double d) {
        int n = 104;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.readSizeTooLarge", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.readSize", new Double(d))};
        return new RuleOutput(this.ruleNameRead, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput createReadNoProblem(PerfDescriptor perfDescriptor, double d) {
        int n = 101;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.readSizeOk", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.readSize", new Double(d))};
        return new RuleOutput(this.ruleNameRead, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    public String[] getParamNames() {
        return super.getParamNames();
    }

    public String getRuleNameLookup() {
        return "perfTuningAdmin.ruleName.SessionSizeRule";
    }

    public static HashMap getStaticAttributeHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(READ_MAX, "Des:Maximum size of sessions being read from the persistent store.#DesLookup:perfTuningAdmin.attribute.rule.MaximinReadSessionSizeInK.des#OptionsLookup:perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.0.5~0.5$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.1~1.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.8~8.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.16~16.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.32~32.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.48~48.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.64~64.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.128~128.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName.MaximinReadSessionSizeInK#ParamId:MaximinReadSessionSizeInK");
        hashMap.put(WRITE_MAX, "Des:Maximum size of sessions being written to the persistent store.#DesLookup:perfTuningAdmin.attribute.rule.MaximinWriteSessionSizeInK.des#OptionsLookup:perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.0.5~0.5$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.1~1.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.8~8.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.16~16.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.32~32.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.48~48.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.64~64.0$perfTuningAdmin.attribute.rule.MaximinSessionSizeInK.option.128~128.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName.MaximinWriteSessionSizeInK#ParamId:MaximinWriteSessionSizeInK");
        return hashMap;
    }

    public HashMap getAttributeInfo() {
        HashMap hashMap = new HashMap();
        String string = this.ruleData.getRuleID();
        HashMap hashMap2 = SessionSizeRuleStateless.getStaticAttributeHashMap();
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            hashMap.put(k, (String)hashMap2.get(k) + '#' + "ID" + ':' + string);
        }
        return hashMap;
    }

    public Double getParam(String string) {
        return super.getParam(string);
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (string.equals(READ_MAX)) {
            this.readSizeTooLargeInK = d;
        } else if (string.equals(WRITE_MAX)) {
            this.writeSizeTooLargeInK = d;
        }
    }

    public boolean isApplicable(PerfDescriptor perfDescriptor) {
        if (this.sessionMBeanCalc.isSetPersistentSessions(perfDescriptor)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, perfDescriptor.getName() + " is applicable");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, perfDescriptor.getName() + " is NOT applicable");
        }
        return false;
    }

    public boolean isApplicable() {
        boolean bl = false;
        for (int i = 0; i < this.dds.size(); ++i) {
            if (!this.isApplicable((PerfDescriptor)this.dds.get(i))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            if (!this.isApplicable()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can not enable SessionSizeRule as it is not applicable");
                }
                super.setEnabled(false);
            } else {
                super.setEnabled(true);
            }
        } else {
            super.setEnabled(false);
        }
    }

    protected double getReadThreshold(PerfDescriptor perfDescriptor) {
        return this.readSizeTooLargeInK;
    }

    protected double getWriteThreshold(PerfDescriptor perfDescriptor) {
        return this.writeSizeTooLargeInK;
    }
}

