/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryCalc;
import com.ibm.ws.performance.tuning.calc.cachedCalc.ISessionConfigCachedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractSessionRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SessionSizeTimeRuleStateless
extends AbstractSessionRule {
    private IBasicDataPointHistoryCalc[] readCalc;
    private IBasicDataPointHistoryCalc[] readCalcTmp;
    private IBasicDataPointHistoryCalc[] writeCalc;
    private IBasicDataPointHistoryCalc[] writeCalcTmp;
    private ISessionConfigCachedCalc sessionConfig = null;
    private String ruleNameRead;
    private String ruleNameWrite;
    private static final String MAX_READ = "MaxSessionReadTimeInMs";
    private static final String MAX_WRITE = "MaxSessionWriteTimeInMs";
    protected double maxWrite = 5000.0;
    protected double maxRead = 1000.0;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
        Object v = this.map.get(MAX_READ);
        if (v != null) {
            this.maxRead = (Double)v;
        }
        if ((v = this.map.get(MAX_WRITE)) != null) {
            this.maxWrite = (Double)v;
        }
        this.readCalc = new IBasicDataPointHistoryCalc[0];
        this.writeCalc = new IBasicDataPointHistoryCalc[0];
        this.createTmpCalcArrays(0);
        this.ruleNameRead = this.ruleName;
        this.ruleNameWrite = this.ruleName;
        this.sessionConfig = CalcCreator.getSessionConfigCachedCalc(this.checkAppendLog(this.ruleType), this.node, this.server);
        super.checkInterval();
        this.setEnabled(this.isEnabled());
    }

    protected void createTmpCalcArrays(int n) {
        this.readCalcTmp = new IBasicDataPointHistoryCalc[n];
        this.writeCalcTmp = new IBasicDataPointHistoryCalc[n];
    }

    protected void createCalcObjectsInTmpArray(PerfDescriptor perfDescriptor, int n, boolean bl, int n2) {
        if (bl) {
            this.readCalcTmp[n] = CalcCreator.createBasicDataPointHistoryCalc(this.checkAppendLog(this.ruleType));
            this.readCalcTmp[n].setUserId(this.userId);
            this.readCalcTmp[n].init(perfDescriptor, 10);
            this.writeCalcTmp[n] = CalcCreator.createBasicDataPointHistoryCalc(this.checkAppendLog(this.ruleType));
            this.writeCalcTmp[n].setUserId(this.userId);
            this.writeCalcTmp[n].init(perfDescriptor, 12);
        } else {
            this.readCalcTmp[n] = this.readCalc[n2];
            this.writeCalcTmp[n] = this.writeCalc[n2];
        }
    }

    protected void updateCalcArrayWithTmpArray() {
        this.readCalc = this.readCalcTmp;
        this.writeCalc = this.writeCalcTmp;
    }

    public RuleOutput[] runRule() {
        this.checkInterval();
        int n = this.readCalc.length;
        RuleOutput[] ruleOutputArray = new RuleOutput[2 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = 2 * i;
            double d = new Double(this.sigDigits(this.readCalc[i].getDifferenceOverCount(), 4));
            PerfDescriptor perfDescriptor = (PerfDescriptor)this.dds.get(i);
            ruleOutputArray[n2] = TuningUtil.isErrorCode(d) ? this.createReadError(perfDescriptor, d) : ((d = this.format(d)) > this.getReadThreshold(perfDescriptor) ? this.createReadAlert(perfDescriptor, d) : this.createReadNoProblem(perfDescriptor, d));
            double d2 = new Double(this.sigDigits(this.writeCalc[i].getDifferenceOverCount(), 4));
            ruleOutputArray[n2 + 1] = TuningUtil.isErrorCode(d2) ? this.createWriteError(perfDescriptor, d2) : ((d2 = this.format(d2)) > this.getWriteThreshold(perfDescriptor) ? this.createWriteAlert(perfDescriptor, d2) : this.createWriteNoProblem(perfDescriptor, d2));
            this.readCalc[i].clear();
            this.writeCalc[i].clear();
        }
        return ruleOutputArray;
    }

    protected RuleOutput createWriteError(PerfDescriptor perfDescriptor, double d) {
        return TuningUtil.createGeneralErrorOutput(this.ruleName, perfDescriptor, d);
    }

    protected RuleOutput createReadError(PerfDescriptor perfDescriptor, double d) {
        return TuningUtil.createGeneralErrorOutput(this.ruleName, perfDescriptor, d);
    }

    protected RuleOutput createWriteAlert(PerfDescriptor perfDescriptor, double d) {
        int n = 104;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.writeTimeTooLarge", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.writeTime", new Double(d))};
        return new RuleOutput(this.ruleNameWrite, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput createWriteNoProblem(PerfDescriptor perfDescriptor, double d) {
        int n = 101;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.writeSizeOk", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.writeTime", new Double(d))};
        return new RuleOutput(this.ruleNameWrite, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput createReadAlert(PerfDescriptor perfDescriptor, double d) {
        int n = 104;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.readTimeTooLarge", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.readTime", new Double(d))};
        return new RuleOutput(this.ruleNameRead, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput createReadNoProblem(PerfDescriptor perfDescriptor, double d) {
        int n = 101;
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.session.readTimeOk", perfDescriptor.getName());
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.session.readTime", new Double(d))};
        return new RuleOutput(this.ruleNameRead, perfDescriptor, n, messageWrapper, messageWrapperArray, null);
    }

    public String[] getParamNames() {
        return super.getParamNames();
    }

    public static HashMap getStaticAttributeHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(MAX_READ, "Des:Maximum time taken for sessions being read from the persistent store.#DesLookup:perfTuningAdmin.attribute.rule.MaxSessionReadTimeInMs.des#OptionsLookup:perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.1~1.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.5~5.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.10~10.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.50~50.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.500~500.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.1000~1000.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName.MaxSessionReadTimeInMs#ParamId:MaxSessionReadTimeInMs");
        hashMap.put(MAX_WRITE, "Des:Maximum time taken for session being written to persistent store#DesLookup:perfTuningAdmin.attribute.rule.MaxSessionWriteTimeInMs.des#OptionsLookup:perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.1~1.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.5~5.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.10~10.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.50~50.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.500~500.0$perfTuningAdmin.attribute.rule.SessionSizeTimeRule.option.1000~1000.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName.MaxSessionWriteTimeInMs#ParamId:MaxSessionWriteTimeInMs");
        return hashMap;
    }

    public HashMap getAttributeInfo() {
        HashMap hashMap = new HashMap();
        String string = this.ruleData.getRuleID();
        HashMap hashMap2 = SessionSizeTimeRuleStateless.getStaticAttributeHashMap();
        Set set = hashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            hashMap.put(k, (String)hashMap2.get(k) + '#' + "ID" + ':' + string);
        }
        return hashMap;
    }

    public Double getParam(String string) {
        return super.getParam(string);
    }

    public boolean isApplicable() {
        return this.sessionConfig.isSetPersistentSessions();
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (string.equals(MAX_READ)) {
            this.maxRead = d;
        } else if (string.equals(MAX_WRITE)) {
            this.maxWrite = d;
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            if (!this.isApplicable()) {
                super.setEnabled(false);
            } else {
                super.setEnabled(true);
            }
        } else {
            super.setEnabled(false);
        }
    }

    protected double getReadThreshold(PerfDescriptor perfDescriptor) {
        return this.maxRead;
    }

    protected double getWriteThreshold(PerfDescriptor perfDescriptor) {
        return this.maxWrite;
    }
}

