/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.ISessionCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISessionMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import java.util.LinkedList;

public class SessionSizeUnpersistedRuleStateless
extends AbstractRule {
    private PerfDescriptor nodeServerPD;
    private ISessionCalc sessionCalc;
    private ISessionMBeanSharedCalc sessionMBeanCalc;
    protected String server;
    protected String node;
    protected RuleData data;
    protected static String AVG_SESSION_SIZE_BOUND = "AvgSessionSizeBoundK";
    protected static String MAX_SESSION_SIZE_BOUND = "MaxSessionSizeBoundK";
    protected double avgSessionSizeBound;
    protected double maxSessionSizeBound;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        this.server = string2;
        this.node = string;
        this.nodeServerPD = new PerfDescriptorImpl(string, string2, null);
        this.ruleData = ruleData;
        this.sessionCalc = CalcCreator.createSessionCalc(this.checkAppendLog(this.ruleData.getType()));
        this.sessionCalc.setUserId(this.userId);
        this.sessionCalc.init(string, string2);
        this.sessionMBeanCalc = CalcCreator.getSessionMBeanSharedCalc(string, string2, this.checkAppendLog(this.ruleData.getType()));
        this.avgSessionSizeBound = ruleData.getParam(AVG_SESSION_SIZE_BOUND);
        this.maxSessionSizeBound = ruleData.getParam(MAX_SESSION_SIZE_BOUND);
    }

    public RuleOutput[] runRule() {
        int n;
        PerfDescriptor[] perfDescriptorArray = this.sessionCalc.getWebApps();
        if (perfDescriptorArray == null) {
            return new RuleOutput[]{this.createGeneralErrorOutput(this.ruleData.getName(), this.sessionCalc.getSessionPD(), -102.0)};
        }
        long l = 0L;
        LinkedList<RuleOutput> linkedList = new LinkedList<RuleOutput>();
        LinkedList<PerfDescriptor> linkedList2 = new LinkedList<PerfDescriptor>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        long l2 = (long)this.maxSessionSizeBound << 10;
        long l3 = (long)this.avgSessionSizeBound << 10;
        for (n = 0; n < perfDescriptorArray.length; ++n) {
            long l4;
            long l5;
            long l6;
            long l7;
            if (!this.isApplicable(perfDescriptorArray[n])) continue;
            boolean bl = false;
            String string = perfDescriptorArray[n].getName();
            string = string.substring(0, string.indexOf(35));
            long l8 = this.sessionCalc.getLiveSessions(perfDescriptorArray[n], (short)12);
            if (TuningUtil.isErrorCode(l8)) {
                bl = true;
                l = l8;
            }
            if (TuningUtil.isErrorCode(l7 = this.sessionCalc.getSerializableSessObjSize(perfDescriptorArray[n], (short)1))) {
                bl = true;
                l = l7;
            }
            if (TuningUtil.isErrorCode(l6 = this.sessionCalc.getSerializableSessObjSize(perfDescriptorArray[n], (short)4))) {
                bl = true;
                l = l6;
            }
            if (TuningUtil.isErrorCode(l5 = this.sessionCalc.getSerializableSessObjSize(perfDescriptorArray[n], (short)0))) {
                bl = true;
                l = l5;
            }
            if (TuningUtil.isErrorCode(l4 = this.sessionCalc.getCreatedSessions(perfDescriptorArray[n]))) {
                bl = true;
                l = l4;
            }
            if (bl) {
                if (l == -102L) {
                    if (l8 == 0L) continue;
                    linkedList2.add(perfDescriptorArray[n]);
                    continue;
                }
                linkedList.add(this.createGeneralErrorOutput(this.ruleData.getName(), perfDescriptorArray[n], l));
                continue;
            }
            if (l5 != 0L) {
                if (l6 > l3) {
                    linkedList.add(this.avgSessionSizeTooBig(string, l6 >> 10));
                }
                if (l7 <= l2) continue;
                linkedList.add(this.maxSessionSizeTooBig(string, l7 >> 10));
                continue;
            }
            if (l4 != 0L) continue;
            linkedList3.add(perfDescriptorArray[n].getName());
        }
        if (linkedList2.size() != 0) {
            for (n = linkedList2.size() - 1; n >= 0; --n) {
                PerfDescriptor perfDescriptor = (PerfDescriptor)linkedList2.get(n);
                if (perfDescriptor.getName().lastIndexOf("isclite") <= -1) continue;
                linkedList2.remove(n);
            }
            if (linkedList2.size() != 0) {
                linkedList.add(this.noDataErrorOutput(linkedList2));
            }
        }
        if (linkedList3.size() != 0) {
            linkedList.add(this.noProblemNotNeeded(linkedList3));
        }
        if (linkedList.size() == 0) {
            return new RuleOutput[]{this.noProblemSessionSize()};
        }
        RuleOutput[] ruleOutputArray = new RuleOutput[linkedList.size()];
        linkedList.toArray(ruleOutputArray);
        return ruleOutputArray;
    }

    private RuleOutput noDataErrorOutput(LinkedList linkedList) {
        MessageWrapper messageWrapper = new MessageWrapper("perf.tuning.session.unpersisted.webapp.noData", null);
        StringBuffer stringBuffer = new StringBuffer("\n\n");
        for (int i = 0; i < linkedList.size(); ++i) {
            stringBuffer.append("    ").append(((PerfDescriptor)linkedList.get(i)).getName()).append("\n");
        }
        MessageWrapper messageWrapper2 = new MessageWrapper("perf.tuning.session.unpersisted.webapp.noData.app", stringBuffer.toString());
        return new RuleOutput(this.ruleData.getName(), this.nodeServerPD, 104, messageWrapper, messageWrapper2, null);
    }

    private RuleOutput avgSessionSizeTooBig(String string, double d) {
        MessageWrapper[] messageWrapperArray = new MessageWrapper[1];
        Object[] objectArray = new Object[]{string, new Double(d)};
        MessageWrapper messageWrapper = new MessageWrapper("perf.tuning.session.size.avgTooBig", objectArray);
        messageWrapperArray[0] = new MessageWrapper("perf.tuning.session.size.avgUpperBound", new Double(this.avgSessionSizeBound));
        return new RuleOutput(this.ruleData.getName(), this.nodeServerPD, 104, messageWrapper, messageWrapperArray, null);
    }

    private RuleOutput maxSessionSizeTooBig(String string, double d) {
        MessageWrapper[] messageWrapperArray = new MessageWrapper[1];
        Object[] objectArray = new Object[]{string, new Double(d)};
        MessageWrapper messageWrapper = new MessageWrapper("perf.tuning.session.size.maxTooBig", objectArray);
        messageWrapperArray[0] = new MessageWrapper("perf.tuning.session.size.maxUpperBound", new Double(this.maxSessionSizeBound));
        return new RuleOutput(this.ruleData.getName(), this.nodeServerPD, 104, messageWrapper, messageWrapperArray, null);
    }

    private RuleOutput noProblemSessionSize() {
        MessageWrapper messageWrapper = new MessageWrapper("perf.tuning.session.size.noProblem");
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{};
        return new RuleOutput(this.ruleData.getName(), this.nodeServerPD, 101, messageWrapper, messageWrapperArray, null);
    }

    private RuleOutput noProblemNotNeeded(LinkedList linkedList) {
        MessageWrapper messageWrapper = new MessageWrapper("perf.tuning.session.size.notNeeded", null);
        StringBuffer stringBuffer = new StringBuffer("\n\n");
        for (int i = 0; i < linkedList.size(); ++i) {
            stringBuffer.append("    ").append(linkedList.get(i)).append("\n");
        }
        MessageWrapper messageWrapper2 = new MessageWrapper("perf.tuning.session.size.notNeeded.appModule", stringBuffer.toString());
        return new RuleOutput(this.ruleData.getName(), this.nodeServerPD, 104, messageWrapper, messageWrapper2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (string.equals(AVG_SESSION_SIZE_BOUND)) {
            double d2 = d;
            if (!(d2 > 0.0) || !(d2 < this.maxSessionSizeBound)) throw new IllegalArgumentException(AVG_SESSION_SIZE_BOUND + " must be between 0 and " + MAX_SESSION_SIZE_BOUND + ": " + d2);
            this.avgSessionSizeBound = d2;
            return;
        } else {
            if (!string.equals(MAX_SESSION_SIZE_BOUND)) return;
            double d3 = d;
            if (!(d3 > this.avgSessionSizeBound)) throw new IllegalArgumentException(MAX_SESSION_SIZE_BOUND + " must be greater than " + AVG_SESSION_SIZE_BOUND + ": " + d3);
            this.maxSessionSizeBound = d3;
        }
    }

    private boolean isApplicable(PerfDescriptor perfDescriptor) {
        return !this.sessionMBeanCalc.isSetPersistentSessions(perfDescriptor);
    }

    public boolean isApplicable() {
        PerfDescriptor[] perfDescriptorArray = this.sessionCalc.getWebApps();
        if (perfDescriptorArray == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < perfDescriptorArray.length; ++i) {
            if (!this.isApplicable(perfDescriptorArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

