/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISystemSharedCalc;
import com.ibm.ws.performance.tuning.rule.RuleData;
import java.util.ArrayList;

public class TransitionRuleList {
    private ArrayList serverRuleList;
    private static TraceComponent tc = Tr.register(TransitionRuleList.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    public static final String CONN_ERROR_ALERT = "connErrorAlert";
    public static final String CONN_ERROR_ALERT_WINDOW_MINUTES = "connErrorAlertWindowMinutes";
    public static final String CONN_ERROR_ALERT_MAX_THRESHOLD = "connErrorAlertMaxThreshold";
    public static final String CONN_LOW_EFF_ALERT = "connLowEffAlert";
    public static final String CONN_LOW_EFF_LOW_EFFICIENCY_THRESHOLD = "connLowEfficiencyThreshold";
    public static final String POOL_LOW_EFF_ALERT = "poolLowEffAlert";
    public static final String POOL_LOW_EFF_LOW_EFFICIENCY_THRESHOLD = "poolLowEffAlertWindowMinutes";
    public static final String POOL_LOW_EFF_ALERT_WINDOWS_MINUTES = "poolLowEfficiencyThreshold";
    public static final String SURGE_MODE_ALERT = "surgeModeAlert";
    public static final String HUNG_CONNECTION_ALERT = "hungConnModeAlert";
    public static final String LTC_NESTING_ALERT = "LTCNestingAlert";
    public static final String LTC_NESTING_DEPTH_THRESHOLD = "LTCNestingDepthThreshold";
    public static final String LTC_CONN_PER_THREAD_ALERT = "LTCConnPerThreadLimitAlert";
    public static final String LTC_CONN_PER_THREAD_MAX_CONN_THRESHOLD = "LTCThreadMaxConnLimitThreshold";
    public static final String LTC_SERIAL_REUSE_ALERT = "LTCSerialReuseViolationAlert";
    private ISystemSharedCalc systemCalc;

    public void init(String string, String string2) {
        Tr.entry(tc, "init");
        this.serverRuleList = new ArrayList();
        this.loadNewRules();
        Tr.exit(tc, "init");
    }

    public void init() {
        Tr.entry(tc, "init");
        this.serverRuleList = new ArrayList();
        this.loadNewRules();
        Tr.exit(tc, "init");
    }

    private void loadNewRules() {
        Tr.entry(tc, "loadNewRules");
        RuleData ruleData = new RuleData();
        ruleData.setRuleID(CONN_ERROR_ALERT);
        ruleData.setName("Connection Error Alert Rule");
        ruleData.setNameKey("perfTuningAdmin.immediateAlertName.connErrorAlert");
        ruleData.setComponentKey("perfTuningAdmin.componentName.J2C.ConnectionManager");
        ruleData.setPerformanceImpact("high");
        ruleData.setType("immediateAlert");
        ruleData.setTransitionRule(true);
        ruleData.setEnabled(false);
        ruleData.setZos_enabled(true);
        ruleData.addParam(CONN_ERROR_ALERT_WINDOW_MINUTES, new Double(5.0));
        ruleData.addParam(CONN_ERROR_ALERT_MAX_THRESHOLD, new Double(2.0));
        this.serverRuleList.add(ruleData);
        ruleData = new RuleData();
        ruleData.setRuleID(CONN_LOW_EFF_ALERT);
        ruleData.setName("Connection Low Percent Efficiency Rule");
        ruleData.setNameKey("perfTuningAdmin.immediateAlertName.connLowEffAlert");
        ruleData.setComponentKey("perfTuningAdmin.componentName.J2C.ConnectionManager");
        ruleData.setPerformanceImpact("high");
        ruleData.setType("immediateAlert");
        ruleData.setTransitionRule(true);
        ruleData.setEnabled(false);
        ruleData.setZos_enabled(true);
        ruleData.addParam(CONN_LOW_EFF_LOW_EFFICIENCY_THRESHOLD, new Double(50.0));
        this.serverRuleList.add(ruleData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "added low eff alert : " + ruleData.toString());
        }
        ruleData = new RuleData();
        ruleData.setRuleID(POOL_LOW_EFF_ALERT);
        ruleData.setName("Pool Low Percent Efficiency Rule");
        ruleData.setNameKey("perfTuningAdmin.immediateAlertName.poolLowEffAlert");
        ruleData.setComponentKey("perfTuningAdmin.componentName.J2C.ConnectionManager");
        ruleData.setPerformanceImpact("high");
        ruleData.setType("immediateAlert");
        ruleData.setTransitionRule(true);
        ruleData.setEnabled(false);
        ruleData.setZos_enabled(true);
        ruleData.addParam(POOL_LOW_EFF_LOW_EFFICIENCY_THRESHOLD, new Double(50.0));
        ruleData.addParam(POOL_LOW_EFF_ALERT_WINDOWS_MINUTES, new Double(5.0));
        this.serverRuleList.add(ruleData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adding surge mode alert");
        }
        ruleData = new RuleData();
        ruleData.setRuleID(SURGE_MODE_ALERT);
        ruleData.setName("Surge Mode Rule");
        ruleData.setNameKey("perfTuningAdmin.immediateAlertName.surgeModeAlert");
        ruleData.setComponentKey("perfTuningAdmin.componentName.J2C.ConnectionManager");
        ruleData.setPerformanceImpact("high");
        ruleData.setType("immediateAlert");
        ruleData.setTransitionRule(true);
        ruleData.setEnabled(false);
        ruleData.setZos_enabled(true);
        this.serverRuleList.add(ruleData);
        ruleData = new RuleData();
        ruleData.setRuleID(HUNG_CONNECTION_ALERT);
        ruleData.setName("Hung Connection Alert Rule");
        ruleData.setNameKey("perfTuningAdmin.immediateAlertName.hungConnModeAlert");
        ruleData.setComponentKey("perfTuningAdmin.componentName.J2C.ConnectionManager");
        ruleData.setPerformanceImpact("high");
        ruleData.setType("immediateAlert");
        ruleData.setTransitionRule(true);
        ruleData.setEnabled(false);
        ruleData.setZos_enabled(true);
        this.serverRuleList.add(ruleData);
        ruleData = new RuleData();
        ruleData.setRuleID(LTC_NESTING_ALERT);
        ruleData.setName("LTC Nesting Rule");
        ruleData.setNameKey("perfTuningAdmin.immediateAlertName.LTCNestingAlert");
        ruleData.setComponentKey("perfTuningAdmin.componentName.J2C.ConnectionManager");
        ruleData.setPerformanceImpact("high");
        ruleData.setType("immediateAlert");
        ruleData.setTransitionRule(true);
        ruleData.setEnabled(false);
        ruleData.setZos_enabled(true);
        ruleData.addParam(LTC_NESTING_DEPTH_THRESHOLD, new Double(3.0));
        this.serverRuleList.add(ruleData);
        ruleData = new RuleData();
        ruleData.setRuleID(LTC_CONN_PER_THREAD_ALERT);
        ruleData.setName("LTC Connection per Thread Limit Rule");
        ruleData.setNameKey("perfTuningAdmin.immediateAlertName.LTCConnPerThreadLimitAlert");
        ruleData.setComponentKey("perfTuningAdmin.componentName.J2C.ConnectionManager");
        ruleData.setPerformanceImpact("high");
        ruleData.setType("immediateAlert");
        ruleData.setTransitionRule(true);
        ruleData.setEnabled(false);
        ruleData.setZos_enabled(true);
        ruleData.addParam(LTC_CONN_PER_THREAD_MAX_CONN_THRESHOLD, new Double(2.0));
        ruleData.addParam(POOL_LOW_EFF_ALERT_WINDOWS_MINUTES, new Double(5.0));
        this.serverRuleList.add(ruleData);
        ruleData = new RuleData();
        ruleData.setRuleID(LTC_SERIAL_REUSE_ALERT);
        ruleData.setName("LTC Serial Reuse Violation Alert Rule");
        ruleData.setNameKey("perfTuningAdmin.immediateAlertName.LTCSerialReuseViolationAlert");
        ruleData.setComponentKey("perfTuningAdmin.componentName.J2C.ConnectionManager");
        ruleData.setPerformanceImpact("high");
        ruleData.setType("immediateAlert");
        ruleData.setTransitionRule(true);
        ruleData.setEnabled(false);
        ruleData.setZos_enabled(true);
        this.serverRuleList.add(ruleData);
        Tr.exit(tc, "loadNewRules");
    }

    private void addParam(String string, RuleData ruleData, String string2, Double d) {
        Tr.entry(tc, "addParam");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no longer looking for WAS variable override for " + string);
        }
        ruleData.addParam(string2, d);
        Tr.exit(tc, "addParam");
    }

    public ArrayList getServerRules() {
        return this.serverRuleList;
    }
}

