/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.rule.StatefullRuleInterface;
import com.ibm.ws.performance.tuning.rule.UnboundedPoolRuleStateless;
import java.util.HashMap;

public class UnboundedPoolRuleStatefull
extends UnboundedPoolRuleStateless
implements TuningConstants,
StatefullRuleInterface {
    private int updateThreshold;
    private HashMap thresholdObjectMap = new HashMap();

    public UnboundedPoolRuleStatefull(int n) {
        super(n);
    }

    public void init(String string, String string2, RuleData ruleData) {
        super.init(string, string2, ruleData);
    }

    protected void initializeCalcs() {
        super.initializeCalcs();
        this.setDefault();
    }

    public void resetThresholds() {
        for (int i = 0; i < this.pd.length; ++i) {
            String string = this.pd[i].getName();
            ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
            if (thresholdObject == null) {
                double d = this.getAverageSizeThres(string);
                double d2 = this.getTotalSizeThres(string);
                thresholdObject = new ThresholdObject(d, d2);
                this.thresholdObjectMap.put(string, thresholdObject);
            }
            this.averageSizeThresMap.put(string, new Double(thresholdObject.origAveThres));
            this.totalSizeThresMap.put(string, new Double(thresholdObject.origNumberThres));
        }
    }

    private void setDefault() {
        this.updateThreshold = EngineParameters.getMaxAlertStreak();
        for (int i = 0; i < this.pd.length; ++i) {
            String string = this.pd[i].getName();
            double d = this.getAverageSizeThres(string);
            double d2 = this.getTotalSizeThres(string);
            ThresholdObject thresholdObject = new ThresholdObject(d, d2);
            this.thresholdObjectMap.put(string, thresholdObject);
        }
    }

    public void setMaxAlertStreak(Integer n) {
        int n2 = n;
        this.updateThreshold = n2 < 0 ? EngineParameters.getMaxAlertStreak() : n2;
    }

    protected RuleOutput issueAlert_tooManyThreads(PerfDescriptor perfDescriptor, double d, int n) {
        RuleOutput ruleOutput = super.issueAlert_tooManyThreads(perfDescriptor, d, n);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_tooMany++;
        if (d > thresholdObject.highestNumber) {
            thresholdObject.highestNumber = d;
        }
        if (thresholdObject.alertStreak_tooMany == this.updateThreshold) {
            this.addSymptoms(ruleOutput, this.total, thresholdObject.highestNumber);
            this.total = (int)Math.ceil(thresholdObject.highestNumber);
            thresholdObject.alertStreak_tooMany = 0;
            thresholdObject.numUpdated = true;
        }
        this.thresholdObjectMap.put(string, thresholdObject);
        return ruleOutput;
    }

    protected RuleOutput issueAlert_increaseMax(PerfDescriptor perfDescriptor, double d, double d2) {
        RuleOutput ruleOutput = super.issueAlert_increaseMax(perfDescriptor, d, d2);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_ave++;
        if (d > thresholdObject.highestAve) {
            thresholdObject.highestAve = d;
        }
        if (thresholdObject.alertStreak_ave == this.updateThreshold) {
            this.addSymptoms(ruleOutput, d2, thresholdObject.highestAve);
            this.averageSizeThresMap.put(string, new Double(thresholdObject.highestAve));
            thresholdObject.alertStreak_ave = 0;
            thresholdObject.aveUpdated = true;
        }
        this.thresholdObjectMap.put(string, thresholdObject);
        return ruleOutput;
    }

    protected RuleOutput noProblem_initialMax(PerfDescriptor perfDescriptor, double d, double d2) {
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        RuleOutput ruleOutput = super.noProblem_initialMax(perfDescriptor, d, d2);
        thresholdObject.alertStreak_ave = 0;
        thresholdObject.highestAve = d2;
        this.thresholdObjectMap.put(string, thresholdObject);
        return ruleOutput;
    }

    protected RuleOutput noProblem_numberThreads(PerfDescriptor perfDescriptor, double d) {
        RuleOutput ruleOutput = super.noProblem_numberThreads(perfDescriptor, d);
        String string = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string);
        }
        thresholdObject.alertStreak_tooMany = 0;
        thresholdObject.highestNumber = d;
        this.thresholdObjectMap.put(string, thresholdObject);
        return ruleOutput;
    }

    public RuleOutput createGeneralErrorOutput(String string, PerfDescriptor perfDescriptor, double d) {
        String string2 = perfDescriptor.getName();
        ThresholdObject thresholdObject = (ThresholdObject)this.thresholdObjectMap.get(string2);
        if (thresholdObject == null) {
            thresholdObject = new ThresholdObject(string2);
        }
        thresholdObject.alertStreak_tooMany = 0;
        thresholdObject.highestNumber = thresholdObject.origNumberThres;
        thresholdObject.alertStreak_ave = 0;
        thresholdObject.highestAve = thresholdObject.origAveThres;
        this.thresholdObjectMap.put(string2, thresholdObject);
        return super.createGeneralErrorOutput(string, perfDescriptor, d);
    }

    private RuleOutput addSymptoms(RuleOutput ruleOutput, double d, double d2) {
        Object[] objectArray = new Object[]{new Double(d), new Double(d2)};
        ruleOutput.addAdditionalInformation(new MessageWrapper("perfalert.updatingThreshold", objectArray));
        Integer n = new Integer(this.updateThreshold);
        ruleOutput.addSympton(new MessageWrapper("perfalert.lastAlert", n));
        return ruleOutput;
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
    }

    private class ThresholdObject {
        private int alertStreak_ave;
        private int alertStreak_tooMany;
        private double highestAve;
        private double highestNumber;
        private double origAveThres;
        private double origNumberThres;
        private boolean aveUpdated;
        private boolean numUpdated;

        public ThresholdObject(double d, double d2) {
            this.origAveThres = d;
            this.origNumberThres = d2;
        }

        public ThresholdObject(String string) {
            this.origAveThres = UnboundedPoolRuleStatefull.this.getAverageSizeThres(string);
            this.origNumberThres = UnboundedPoolRuleStatefull.this.getTotalSizeThres(string);
        }

        public void setDefault(double d, double d2) {
            this.alertStreak_ave = 0;
            this.alertStreak_tooMany = 0;
            this.highestAve = 0.0;
            this.highestNumber = 0.0;
            this.origAveThres = d;
            this.origNumberThres = UnboundedPoolRuleStatefull.this.total;
            this.aveUpdated = false;
            this.numUpdated = false;
        }
    }
}

