/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.IBasicDataPointHistoryTimeCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.ISystemSharedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IThreadPoolMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import java.util.ArrayList;
import java.util.HashMap;

public class UnboundedPoolRuleStateless
extends AbstractRule {
    protected String ruleName;
    private static TraceComponent tc = Tr.register(UnboundedPoolRuleStateless.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    protected String node;
    protected String server;
    private DataDescriptor[] poolDD;
    PerfDescriptor[] pd;
    protected int noOfThreadPools = 0;
    private static final int sizeCounter = 4;
    private IBasicDataPointHistoryTimeCalc[] sizeCalc;
    private ISystemSharedCalc systemCalc;
    private IThreadPoolMBeanSharedCalc threadPoolMBeanCalc;
    protected String ruleType;
    private boolean SEPool;
    protected int tooManyThreads;
    protected double total;
    protected HashMap averageSizeThresMap = new HashMap();
    protected HashMap totalSizeThresMap = new HashMap();
    private double averageSizeThres;
    private double maxPoolSize;
    long bytes;
    String poolName = "ORB thread pool";
    String threadPoolName = "ORB.thread.pool";
    protected String[] threadPoolNames;
    public static final String TOO_MANY_THREADS = "tooManyThreadsPerProcessor";
    private boolean initCalcs = false;
    private String AVE_RULE;
    private String TOTAL_RULE;

    public UnboundedPoolRuleStateless() {
        this.setModule(50);
    }

    public UnboundedPoolRuleStateless(int n) {
        this.setModule(n);
    }

    private void setModule(int n) {
        if (n == 50) {
            this.poolName = "ORB thread pool";
            this.SEPool = false;
        } else if (n == 51) {
            this.SEPool = true;
            this.poolName = "Web Container thread pool";
        } else {
            this.setModule(50);
            return;
        }
    }

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        Tr.entry(tc, "init");
        this.ruleData = ruleData;
        this.node = string;
        this.server = string2;
        HashMap hashMap = ruleData.getParamMap();
        this.ruleType = ruleData.getType();
        this.ruleName = ruleData.getName();
        this.systemCalc = CalcCreator.getSystemSharedCalc(string, string2, this.checkAppendLog(this.ruleType));
        String string3 = this.systemCalc.getOperatingSystem();
        this.tooManyThreads = string3.startsWith("Windows") ? 50 : (string3.startsWith("Linux") ? 25 : 100);
        this.total = EngineParameters.getNumProcessors() * this.tooManyThreads;
        this.threadPoolMBeanCalc = CalcCreator.getThreadPoolMBeanSharedCalc(string, string2, this.checkAppendLog(this.ruleType));
        this.AVE_RULE = this.ruleName + TuningUtil.getNLSString("perfTuningAdmin.additional.ruleName.unbounded.ave", new Object[]{this.ruleName}, "{0}, testing if average > initial maximum ");
        this.TOTAL_RULE = this.ruleName + TuningUtil.getNLSString("perfTuningAdmin.additional.ruleName.unbounded.numP", new Object[]{this.ruleName, new Integer(this.tooManyThreads)}, "{0}, testing if current size > (numProcessors * {1})");
        this.setEnabled(ruleData.getEnabled());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OS Name :" + string3);
            Tr.debug(tc, "tooManyThreads :" + this.tooManyThreads);
            Tr.debug(tc, "isRuleEnabled :" + ruleData.getEnabled());
        }
        Tr.exit(tc, "init");
    }

    protected void initializeCalcs() {
        int n;
        Tr.entry(tc, "initializeCalcs");
        if (this.poolName.equals("Web Container thread pool")) {
            this.threadPoolNames = this.threadPoolMBeanCalc.getThreadPoolNames();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.ruleName + " threadPoolNames = " + this.threadPoolNames);
            }
            if (this.threadPoolNames == null || this.threadPoolNames.length == 0) {
                this.noOfThreadPools = 1;
                this.threadPoolNames = new String[1];
                this.threadPoolNames[0] = "Servlet.Engine.Transports";
                this.poolDD = new DataDescriptor[this.noOfThreadPools];
                this.poolDD[0] = sePoolDD;
            } else {
                this.noOfThreadPools = this.threadPoolNames.length;
                this.poolDD = new DataDescriptor[this.noOfThreadPools];
                for (n = 0; n < this.noOfThreadPools; ++n) {
                    String[] stringArray = new String[]{"threadPoolModule", this.threadPoolNames[n]};
                    this.poolDD[n] = new DataDescriptor(stringArray);
                }
            }
        } else {
            this.noOfThreadPools = 1;
            this.threadPoolNames = new String[1];
            this.threadPoolNames[0] = "ORB.thread.pool";
            this.poolDD = new DataDescriptor[this.noOfThreadPools];
            this.poolDD[0] = orbPoolDD;
        }
        this.pd = new PerfDescriptor[this.noOfThreadPools];
        this.sizeCalc = new IBasicDataPointHistoryTimeCalc[this.noOfThreadPools];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.ruleName + " noOfThreadPools = " + this.noOfThreadPools);
        }
        for (n = 0; n < this.noOfThreadPools; ++n) {
            this.pd[n] = new PerfDescriptorImpl(this.node, this.server, this.poolDD[n]);
            this.pd[n].postInit();
            this.sizeCalc[n] = CalcCreator.createBasicDataPointHistoryTimeCalc(this.checkAppendLog(this.ruleType));
            this.sizeCalc[n].setUserId(this.userId);
            this.sizeCalc[n].init(this.pd[n], 4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.ruleName + " threadPoolNames[" + n + "] : " + this.threadPoolNames[n]);
            }
            this.averageSizeThres = this.threadPoolMBeanCalc.maxPoolSize(this.threadPoolNames[n]);
            this.averageSizeThresMap.put(this.pd[n].getName(), new Double(this.averageSizeThres));
            this.totalSizeThresMap.put(this.pd[n].getName(), new Double(this.total));
        }
        this.initCalcs = true;
        Tr.exit(tc, "initializeCalcs");
    }

    protected RuleOutput issueAlert_tooManyThreads(PerfDescriptor perfDescriptor, double d, int n) {
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.pool.tooManyThreads", this.threadPoolName);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.pool.numberThreads", new Double(d)), new MessageWrapper("perfalert.pool.numProcessors", new Double(n)), new MessageWrapper("perfalert.pool.disclaimer")};
        return new RuleOutput(this.TOTAL_RULE, perfDescriptor, 104, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput issueAlert_increaseMax(PerfDescriptor perfDescriptor, double d, double d2) {
        Object[] objectArray = new Object[]{this.threadPoolName, d <= this.total ? new Double(d) : new Double(this.total)};
        MessageWrapper messageWrapper = new MessageWrapper("perfalert.pool.initialMaxSmall", objectArray);
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.pool.averageSize", new Double(d)), new MessageWrapper("perfalert.pool.initialMax", new Double(this.maxPoolSize))};
        return new RuleOutput(this.AVE_RULE, perfDescriptor, 104, messageWrapper, messageWrapperArray, null);
    }

    protected RuleOutput noProblem_initialMax(PerfDescriptor perfDescriptor, double d, double d2) {
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.pool.initialMax", new Double(this.maxPoolSize))};
        return new RuleOutput(this.AVE_RULE, perfDescriptor, 101, new MessageWrapper("perfalert.pool.initialMaxOk", new Double(d)), messageWrapperArray, null);
    }

    protected RuleOutput noProblem_numberThreads(PerfDescriptor perfDescriptor, double d) {
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("perfalert.pool.numberThreads", new Double(d))};
        return new RuleOutput(this.TOTAL_RULE, perfDescriptor, 101, new MessageWrapper("perfalert.noProblem"), messageWrapperArray, null);
    }

    public RuleOutput[] runRule() {
        Tr.entry(tc, "runRule");
        if (!this.initCalcs) {
            this.initializeCalcs();
        }
        int n = 0;
        ArrayList<RuleOutput> arrayList = new ArrayList<RuleOutput>();
        RuleOutput[] ruleOutputArray = new RuleOutput[1];
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "# of ThreadPools monitored : " + this.noOfThreadPools);
            }
            while (n < this.noOfThreadPools) {
                this.threadPoolName = this.pd[n].getName();
                if (!this.threadPoolMBeanCalc.isMBeanAvailable(this.threadPoolName) || !this.threadPoolMBeanCalc.isGrowable(this.threadPoolName)) {
                    if (tc.isDetailEnabled()) {
                        Tr.debug(tc, this.threadPoolName + " isGrowable : " + false);
                    }
                } else {
                    RuleOutput ruleOutput;
                    this.averageSizeThres = (Double)this.averageSizeThresMap.get(this.threadPoolName);
                    this.total = (Double)this.totalSizeThresMap.get(this.threadPoolName);
                    this.maxPoolSize = this.threadPoolMBeanCalc.maxPoolSize(this.threadPoolName);
                    double d = this.sizeCalc[n].getLongValue();
                    int n2 = 101;
                    try {
                        double d2 = this.sizeCalc[n].getIntervalAverage();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, this.ruleName + " averageSize = " + d2 + " averageSizeThres = " + this.averageSizeThres);
                            Tr.debug(tc, this.ruleName + " size = " + d + " total = " + this.total);
                        }
                        if (TuningUtil.isErrorCode(d2)) {
                            ruleOutput = this.createGeneralErrorOutput(this.AVE_RULE, this.pd[n], d2);
                            arrayList.add(ruleOutput);
                        } else if ((d2 = this.format(d2)) > this.averageSizeThres) {
                            ruleOutput = this.issueAlert_increaseMax(this.pd[n], d2, this.averageSizeThres);
                            arrayList.add(ruleOutput);
                        } else if (d2 < 0.0) {
                            ruleOutput = this.createGeneralErrorOutput(this.ruleName, this.pd[n], d2);
                            arrayList.add(ruleOutput);
                        } else {
                            ruleOutput = this.noProblem_initialMax(this.pd[n], d2, this.averageSizeThres);
                            arrayList.add(ruleOutput);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.out.println("Exception seeing if average size great then initialSize: " + exception.toString());
                    }
                    if (TuningUtil.isErrorCode(d)) {
                        ruleOutput = this.createGeneralErrorOutput(this.TOTAL_RULE, this.pd[n], d);
                        arrayList.add(ruleOutput);
                    } else if ((d = this.format(d)) > this.total) {
                        ruleOutput = this.issueAlert_tooManyThreads(this.pd[n], d, EngineParameters.getNumProcessors());
                        arrayList.add(ruleOutput);
                    } else {
                        ruleOutput = this.noProblem_numberThreads(this.pd[n], d);
                        arrayList.add(ruleOutput);
                    }
                    this.sizeCalc[n].clear();
                }
                ++n;
            }
            Tr.exit(tc, "runRule");
            ruleOutputArray = new RuleOutput[arrayList.size()];
            arrayList.toArray(ruleOutputArray);
            return ruleOutputArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ruleOutputArray[0] = new RuleOutput(this.TOTAL_RULE, this.pd[n], 108, new MessageWrapper("perfalert.exception.stacktrace", exception.toString()), new MessageWrapper[0], null);
            this.setEnabled(false);
            Tr.debug(tc, "Disabling the rule due to an Exception");
            Tr.exit(tc, "runRule");
            return ruleOutputArray;
        }
    }

    public String getRuleShortName() {
        return "unknownPoolRuleShortName";
    }

    public static HashMap getStaticAttributeHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TOO_MANY_THREADS, "Des:Maximum number of threads per processor#DesLookup:perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.des#OptionsLookup:perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.10$10.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.20$20.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.40$40.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.50$50.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.80$80.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.160$160.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.240$240.0#Type:advanced#GeneralAttNameLookup:perfTuning.attName.tooManyThreadsPerProcessor#ParamId:tooManyThreadsPerProcessor");
        return hashMap;
    }

    public HashMap getAttributeInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TOO_MANY_THREADS, "Des:Maximum number of threads per processor#DesLookup:perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.des#OptionsLookup:perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.10$10.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.20$20.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.40$40.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.50$50.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.80$80.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.160$160.0$perfTuningAdmin.attribute.rule.tooManyThreadsPerProcessor.option.240$240.0#Type:advanced#AttNameLookup:perfTuningAdmin.attName." + this.getRuleShortName() + ".tooManyThreadsPerProcessor" + '#' + "ParamId" + ':' + TOO_MANY_THREADS + '#' + "ID" + ':' + this.ruleData.getRuleID());
        return hashMap;
    }

    public void setParam(String string, Double d) throws IllegalArgumentException {
        super.setParam(string, d);
        if (string.equals(TOO_MANY_THREADS)) {
            this.tooManyThreads = d.intValue();
            this.total = this.tooManyThreads * EngineParameters.getNumProcessors();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            if (!this.isApplicable()) {
                super.setEnabled(false);
            } else {
                super.setEnabled(true);
            }
        } else {
            super.setEnabled(false);
        }
    }

    public boolean isApplicable() {
        if (!this.initCalcs) {
            this.initializeCalcs();
        }
        for (int i = 0; i < this.noOfThreadPools; ++i) {
            this.threadPoolName = this.pd[i].getName();
            if (!this.threadPoolMBeanCalc.isGrowable(this.threadPoolName)) continue;
            return true;
        }
        return false;
    }

    public void clearHistory() {
        if (this.sizeCalc == null) {
            return;
        }
        for (int i = 0; i < this.sizeCalc.length; ++i) {
            this.sizeCalc[i].clearHistory();
        }
    }

    protected double getAverageSizeThres(String string) {
        Double d = (Double)this.averageSizeThresMap.get(string);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    protected double getTotalSizeThres(String string) {
        Double d = (Double)this.totalSizeThresMap.get(string);
        if (d != null) {
            return d;
        }
        return 0.0;
    }
}

