/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule.configValidator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IDataSourceMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import java.util.ArrayList;

public class ConnectionPoolConfigRule
extends AbstractRule
implements TuningConstants {
    protected IDataSourceMBeanSharedCalc dsConfig;
    public static final String SUGGESTED_MIN_POOL_SIZE = "SuggestedMinPoolSize";
    public static final String SUGGESTED_MAX_POOL_SIZE = "SuggestedMaxPoolSize";
    public static final String SUGGESTED_PREPSTMT_CACHE_SIZE = "SuggestedPrepStmtCacheSize";
    private static TraceComponent tc = Tr.register(ConnectionPoolConfigRule.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private int sugMinPoolSize;
    private int sugMaxPoolSize;
    private int sugPrepStmtCacheSize;
    private PerfDescriptor pd;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        Tr.entry(tc, "init");
        this.ruleData = ruleData;
        this.pd = new PerfDescriptorImpl(string, string2, null);
        Double d = this.ruleData.getParam(SUGGESTED_MIN_POOL_SIZE);
        this.sugMinPoolSize = d != null ? d.intValue() : 10;
        d = this.ruleData.getParam(SUGGESTED_MAX_POOL_SIZE);
        this.sugMaxPoolSize = d != null ? d.intValue() : 25;
        d = this.ruleData.getParam(SUGGESTED_PREPSTMT_CACHE_SIZE);
        this.sugPrepStmtCacheSize = d != null ? d.intValue() : 40;
        this.dsConfig = CalcCreator.getDataSourceMBeanSharedCalc(string, string2, this.checkAppendLog(this.ruleData.getType()));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sugMinPoolSize:" + this.sugMinPoolSize);
            Tr.debug(tc, "sugMaxPoolSize:" + this.sugMaxPoolSize);
            Tr.debug(tc, "sugPrepStmtCacheSize :" + this.sugPrepStmtCacheSize);
            Tr.debug(tc, "dsConfig :" + this.dsConfig);
        }
        Tr.exit(tc, "init");
    }

    public RuleOutput[] runRule() {
        Object object;
        String string;
        Tr.entry(tc, "runRule");
        ArrayList arrayList = this.dsConfig.getAllJndiNames();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList == null || arrayList.size() == 0) {
            Tr.exit(tc, "runRule (null)");
            return null;
        }
        ArrayList<RuleOutput> arrayList3 = new ArrayList<RuleOutput>(3);
        for (int i = 0; i < arrayList.size(); ++i) {
            MessageWrapper[] messageWrapperArray;
            Object object2;
            string = (String)arrayList.get(i);
            object = this.dsConfig.getDatasourceHelperClassName(string);
            int n = this.dsConfig.getPrepStmtCacheSize(string);
            int n2 = this.dsConfig.getMinConnectionPoolSize(string);
            int n3 = this.dsConfig.getMaxConnectionPoolSize(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "aJndiName:" + string);
                Tr.debug(tc, "dsClassName:" + (String)object);
                Tr.debug(tc, "prepCacheSz:" + n);
                Tr.debug(tc, "minPoolSize:" + n2);
                Tr.debug(tc, "maxPoolSize :" + n3);
            }
            if (n == -102 || n2 == -102 || n3 == -102) {
                object2 = new StringBuffer(TuningUtil.getNLSString("cfgAlert.dataSource")).append(" - ").append(string);
                messageWrapperArray = new MessageWrapper("cfgAlert.configRule.errorReadingConfig", new Object[]{((StringBuffer)object2).toString()});
                arrayList3.add(new RuleOutput(this.ruleData.getName(), this.pd, 103, (MessageWrapper)messageWrapperArray, new MessageWrapper[0], null));
                continue;
            }
            object2 = new MessageWrapper[]{new MessageWrapper("cfgAlert.connPoolConfig.currentPoolCfg", new Object[]{new Integer(n2), new Integer(n3)})};
            if (n3 > 0 && n2 > n3) {
                messageWrapperArray = new MessageWrapper("cfgAlert.connPoolConfig.minGreaterThanMax", new Object[]{string});
                arrayList3.add(new RuleOutput(this.ruleData.getName(), this.pd, 105, (MessageWrapper)messageWrapperArray, (MessageWrapper[])object2, null));
            }
            if (n2 > this.sugMinPoolSize) {
                messageWrapperArray = new MessageWrapper("cfgAlert.connPoolConfig.minPoolSizeTooBig", new Object[]{string, new Integer(this.sugMinPoolSize)});
                arrayList3.add(new RuleOutput(this.ruleData.getName(), this.pd, 105, (MessageWrapper)messageWrapperArray, (MessageWrapper[])object2, null));
            }
            if (n3 > this.sugMaxPoolSize) {
                messageWrapperArray = new MessageWrapper("cfgAlert.connPoolConfig.maxPoolSizeTooBig", new Object[]{string, new Integer(this.sugMaxPoolSize)});
                arrayList3.add(new RuleOutput(this.ruleData.getName(), this.pd, 105, (MessageWrapper)messageWrapperArray, (MessageWrapper[])object2, null));
            }
            messageWrapperArray = new MessageWrapper[]{new MessageWrapper("cfgAlert.connPoolConfig.currentPrepStmt", new Object[]{new Integer(n)})};
            if (n != 0 && n > this.sugPrepStmtCacheSize) {
                MessageWrapper messageWrapper = new MessageWrapper("cfgAlert.connPoolConfig.prepStmtCacheTooBig", new Object[]{string, new Integer(this.sugPrepStmtCacheSize)});
                arrayList3.add(new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null));
            }
            if (object == null || !((String)object).equals("com.ibm.websphere.rsadapter.DB2DataStoreHelper") && !((String)object).equals("com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper")) continue;
            arrayList2.add(string);
        }
        if (arrayList2.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("\n\n");
            string = null;
            for (int i = 0; i < arrayList2.size(); ++i) {
                string = (String)arrayList2.get(i);
                stringBuffer.append("    " + this.dsConfig.getDatasourcePath(string) + "\n");
            }
            object = new MessageWrapper("cfgAlert.connPoolConfig.db2DatasourceDetected", new Object[]{stringBuffer.toString()});
            MessageWrapper messageWrapper = new MessageWrapper("cfgAlert.connPoolConfig.useDB2TuningWizard", null);
            arrayList3.add(new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, (MessageWrapper)object, null));
        }
        RuleOutput[] ruleOutputArray = new RuleOutput[arrayList3.size()];
        for (int i = 0; i < ruleOutputArray.length; ++i) {
            ruleOutputArray[i] = (RuleOutput)arrayList3.get(i);
        }
        Tr.exit(tc, "runRule");
        return ruleOutputArray;
    }
}

