/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule.configValidator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IJvmConfigCachedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;

public class JvmHeapConfigRule
extends AbstractRule
implements TuningConstants {
    private IJvmConfigCachedCalc jvmConfig;
    private PerfDescriptor pd;
    private static TraceComponent tc = Tr.register(JvmHeapConfigRule.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    public static final String MIN_MS = "MinMS";
    public static final String MAX_MS = "MaxMS";
    public static final String MIN_MX = "MinMX";
    public static final String MAX_MX = "MaxMX";
    private double minMs;
    private double maxMs;
    private double minMx;
    private double maxMx;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        Tr.entry(tc, "init");
        this.ruleData = ruleData;
        this.pd = new PerfDescriptorImpl(string, string2, null);
        Double d = this.ruleData.getParam(MIN_MS);
        if (EngineParameters.getOS().equalsIgnoreCase("z/OS")) {
            this.minMs = 256.0;
            this.maxMs = 512.0;
            this.minMx = 512.0;
            this.maxMx = 1024.0;
        } else {
            this.minMs = d != null ? d : 35.0;
            d = this.ruleData.getParam(MAX_MS);
            this.maxMs = d != null ? d : 256.0;
            d = this.ruleData.getParam(MIN_MX);
            this.minMx = d != null ? d : 512.0;
            d = this.ruleData.getParam(MAX_MX);
            this.maxMx = d != null ? d : 1024.0;
        }
        this.jvmConfig = CalcCreator.createJvmConfigCalc(this.checkAppendLog(this.ruleData.getType()));
        this.jvmConfig.init(string, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "minMs:" + this.minMs);
            Tr.debug(tc, "maxMs:" + this.maxMs);
            Tr.debug(tc, "minMx :" + this.minMx);
            Tr.debug(tc, "maxMx :" + this.maxMx);
        }
        Tr.exit(tc, "init");
    }

    public RuleOutput[] runRule() {
        MessageWrapper messageWrapper;
        double d;
        Tr.entry(tc, "runRule");
        double d2 = this.jvmConfig.getInitialHeapSize();
        if (d2 == 0.0) {
            d2 = 50.0;
        }
        if ((d = this.jvmConfig.getMaxHeapSize()) == 0.0) {
            d = 256.0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialSize:" + d2);
            Tr.debug(tc, "maxSize:" + d);
        }
        RuleOutput[] ruleOutputArray = new RuleOutput[2];
        if (d2 == -102.0 || d == -102.0) {
            MessageWrapper messageWrapper2 = new MessageWrapper("cfgAlert.configRule.errorReadingConfig", new Object[]{TuningUtil.getNLSString("cfgAlert.jvmHeap")});
            ruleOutputArray[0] = new RuleOutput(this.ruleData.getName(), this.pd, 103, messageWrapper2, new MessageWrapper[0], null);
            return ruleOutputArray;
        }
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("cfgAlert.jvmConfig.currentHeapConfig", new Object[]{new Double(d2), new Double(d)})};
        if (d2 > d && d != 0.0) {
            MessageWrapper messageWrapper3 = new MessageWrapper("cfgAlert.jvmConfig.initialGreaterThanMax");
            ruleOutputArray[0] = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper3, messageWrapperArray, null);
            return ruleOutputArray;
        }
        if (d2 < this.minMs) {
            messageWrapper = new MessageWrapper("cfgAlert.jvmConfig.initialHeapTooSmall", new Object[]{new Double(this.minMs)});
            ruleOutputArray[0] = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
        } else if (d2 > this.maxMs) {
            messageWrapper = new MessageWrapper("cfgAlert.jvmConfig.initialHeapTooBig", new Object[]{new Double(this.maxMs)});
            ruleOutputArray[0] = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
        }
        if (d < this.minMx && d != 0.0) {
            messageWrapper = new MessageWrapper("cfgAlert.jvmConfig.maxHeapTooSmall", new Object[]{new Double(this.minMx)});
            ruleOutputArray[1] = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
        } else if (d > this.maxMx) {
            messageWrapper = new MessageWrapper("cfgAlert.jvmConfig.maxHeapTooBig", new Object[]{new Double(this.maxMx)});
            ruleOutputArray[1] = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
        }
        Tr.entry(tc, "runRule");
        return ruleOutputArray;
    }
}

