/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule.configValidator;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IOrbThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;

public class ORBPoolConfigRule
extends AbstractRule
implements TuningConstants {
    private IOrbThreadPoolConfigCachedCalc orbConfig;
    private PerfDescriptor pd;
    public static final String SUGGESTED_MAX_THREADPOOL_SIZE = "SuggestedMaxThreadPoolSize";
    public static final String SUGGESTED_MIN_THREADPOOL_SIZE = "SuggestedMinThreadPoolSize";
    private int sugMaxPoolSize;
    private int sugMinPoolSize;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        this.ruleData = ruleData;
        this.pd = new PerfDescriptorImpl(string, string2, null);
        Double d = this.ruleData.getParam(SUGGESTED_MAX_THREADPOOL_SIZE);
        this.sugMaxPoolSize = d != null ? d.intValue() : 30;
        d = this.ruleData.getParam(SUGGESTED_MIN_THREADPOOL_SIZE);
        this.sugMinPoolSize = d != null ? d.intValue() : 10;
        this.orbConfig = CalcCreator.getOrbThreadPoolConfigCachedCalc(this.checkAppendLog(this.ruleData.getType()), string, string2);
    }

    public RuleOutput[] runRule() {
        MessageWrapper messageWrapper;
        int n = this.orbConfig.minPoolSize();
        int n2 = this.orbConfig.maxPoolSize();
        RuleOutput[] ruleOutputArray = new RuleOutput[2];
        if (n2 == -102 || n == -102) {
            MessageWrapper messageWrapper2 = new MessageWrapper("cfgAlert.configRule.errorReadingConfig", new Object[]{TuningUtil.getNLSString("cfgAlert.orb")});
            ruleOutputArray[0] = new RuleOutput(this.ruleData.getName(), this.pd, 103, messageWrapper2, new MessageWrapper[0], null);
            return ruleOutputArray;
        }
        MessageWrapper[] messageWrapperArray = new MessageWrapper[]{new MessageWrapper("cfgAlert.orb.currentPoolConfig", new Object[]{new Integer(n), new Integer(n2)})};
        if (n > n2) {
            MessageWrapper messageWrapper3 = new MessageWrapper("cfgAlert.orb.minGreaterThanMax");
            ruleOutputArray[0] = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper3, messageWrapperArray, null);
            return ruleOutputArray;
        }
        if (n > this.sugMinPoolSize) {
            messageWrapper = new MessageWrapper("cfgAlert.orb.minSizeTooBig", new Object[]{new Integer(this.sugMinPoolSize)});
            ruleOutputArray[0] = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
        }
        if (n2 > this.sugMaxPoolSize) {
            messageWrapper = new MessageWrapper("cfgAlert.orb.maxSizeTooBig", new Object[]{new Integer(this.sugMaxPoolSize)});
            ruleOutputArray[1] = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
        }
        return ruleOutputArray;
    }
}

