/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.rule.configValidator;

import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.calc.cachedCalc.IServletEngineThreadPoolConfigCachedCalc;
import com.ibm.ws.performance.tuning.calc.sharedCalc.IThreadPoolMBeanSharedCalc;
import com.ibm.ws.performance.tuning.rule.AbstractRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.pmi.client.PerfDescriptorImpl;
import java.util.ArrayList;

public class WebContainerConfigRule
extends AbstractRule
implements TuningConstants {
    private IServletEngineThreadPoolConfigCachedCalc webContainerConfig;
    private PerfDescriptor pd;
    public static final String SUGGESTED_MAX_THREADPOOL_SIZE = "SuggestedMaxThreadPoolSize";
    public static final String SUGGESTED_MIN_THREADPOOL_SIZE = "SuggestedMinThreadPoolSize";
    private IThreadPoolMBeanSharedCalc mBeanCalc;
    private int sugMaxPoolSize;
    private int sugMinPoolSize;
    private String[] threadPoolNames;
    private String node;
    private String server;
    private String ruleType;
    private boolean initCalcs = false;
    private int noOfThreadPools = 0;

    public void init(String string, String string2, String string3, RuleData ruleData) {
        this.logName = string3;
        this.init(string, string2, ruleData);
    }

    public void init(String string, String string2, RuleData ruleData) {
        this.ruleData = ruleData;
        this.pd = new PerfDescriptorImpl(string, string2, null);
        Double d = this.ruleData.getParam(SUGGESTED_MAX_THREADPOOL_SIZE);
        this.node = string;
        this.server = string2;
        this.ruleType = this.ruleData.getType();
        this.sugMaxPoolSize = d != null ? d.intValue() : 50;
        d = this.ruleData.getParam(SUGGESTED_MIN_THREADPOOL_SIZE);
        this.sugMinPoolSize = d != null ? d.intValue() : 25;
        this.webContainerConfig = CalcCreator.getServletEngineThreadPoolConfigCachedCalc(this.checkAppendLog(this.ruleData.getType()), string, string2);
    }

    public void initializeCalcs() {
        this.mBeanCalc = CalcCreator.getThreadPoolMBeanSharedCalc(this.node, this.server, this.checkAppendLog(this.ruleType));
        this.threadPoolNames = this.mBeanCalc.getThreadPoolNames();
        if (this.threadPoolNames == null || this.threadPoolNames.length == 0) {
            this.threadPoolNames = new String[1];
            this.threadPoolNames[0] = new String("Servlet.Engine.Tranports");
        }
        this.noOfThreadPools = this.threadPoolNames.length;
        this.initCalcs = true;
    }

    public RuleOutput[] runRule() {
        if (!this.initCalcs) {
            this.initializeCalcs();
        }
        ArrayList<RuleOutput> arrayList = new ArrayList<RuleOutput>();
        RuleOutput[] ruleOutputArray = null;
        for (int i = 0; i < this.noOfThreadPools; ++i) {
            MessageWrapper messageWrapper;
            RuleOutput ruleOutput;
            MessageWrapper[] messageWrapperArray;
            int n = this.mBeanCalc.minPoolSize(this.threadPoolNames[i]);
            int n2 = this.mBeanCalc.maxPoolSize(this.threadPoolNames[i]);
            if (n2 == -102 || n == -102) {
                messageWrapperArray = new MessageWrapper("cfgAlert.configRule.errorReadingConfig", new Object[]{TuningUtil.getNLSString("cfgAlert.webContainer")});
                ruleOutput = new RuleOutput(this.ruleData.getName(), this.pd, 103, (MessageWrapper)messageWrapperArray, new MessageWrapper[0], null);
                arrayList.add(ruleOutput);
                continue;
            }
            messageWrapperArray = new MessageWrapper[]{new MessageWrapper("cfgAlert.webContainer.currentPoolConfig", new Object[]{new Integer(n), new Integer(n2)})};
            if (n > n2) {
                messageWrapper = new MessageWrapper("cfgAlert.webContainer.minGreaterThanMax");
                ruleOutput = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
                arrayList.add(ruleOutput);
                continue;
            }
            if (n > this.sugMinPoolSize) {
                messageWrapper = new MessageWrapper("cfgAlert.webContainer.minSizeTooBig", new Object[]{new Integer(this.sugMinPoolSize)});
                ruleOutput = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
                arrayList.add(ruleOutput);
            }
            if (n2 <= this.sugMaxPoolSize) continue;
            messageWrapper = new MessageWrapper("cfgAlert.webContainer.maxSizeTooBig", new Object[]{new Integer(this.sugMaxPoolSize)});
            ruleOutput = new RuleOutput(this.ruleData.getName(), this.pd, 105, messageWrapper, messageWrapperArray, null);
            arrayList.add(ruleOutput);
        }
        ruleOutputArray = new RuleOutput[arrayList.size()];
        arrayList.toArray(ruleOutputArray);
        return ruleOutputArray;
    }
}

