/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.serverAlert.ResponseInterface;
import java.util.ArrayList;

public abstract class AbstractOutputHandler
implements ResponseInterface,
TuningConstants {
    protected int notificationLevel = 104;
    protected boolean verbose = false;
    protected boolean enabled = false;
    protected boolean ruleFiltersEnabled = false;
    protected String[] ruleFilters = null;
    private static TraceComponent tc = Tr.register(AbstractOutputHandler.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) throws Exception {
        Tr.entry(tc, "setEnabled");
        this.enabled = bl;
        Tr.exit(tc, "setEnabled");
    }

    protected boolean shouldHandle(RuleOutput ruleOutput) {
        return this.passAlertLevelTest(ruleOutput) && this.passFilterTest(ruleOutput);
    }

    protected boolean passAlertLevelTest(RuleOutput ruleOutput) {
        int n = ruleOutput.getOutputType();
        return this.enabled && this.notificationLevel <= n;
    }

    protected boolean passFilterTest(RuleOutput ruleOutput) {
        if (this.ruleFiltersEnabled) {
            String string = ruleOutput.getName();
            for (int i = 0; i < this.ruleFilters.length; ++i) {
                if (string.equals(this.ruleFilters[i])) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Passing filter test as " + string + " mached filters");
                    }
                    return true;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "did not match : " + this.ruleFilters[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NOT passing filter test as " + string + " did not match filters");
            }
            return false;
        }
        return true;
    }

    protected String getTypeAsString(int n) {
        if (n == 101) {
            return "INFORMATIONAL";
        }
        if (n == 102) {
            return "WARNING";
        }
        if (n == 103) {
            return "PROBLEM";
        }
        if (n == 104) {
            return "ALERT:";
        }
        if (n == 108) {
            return "FATAL";
        }
        return "UNKNOWN OUTPUT TYPE";
    }

    public int getNotificationLevel() {
        return this.notificationLevel;
    }

    public void setNotificationLevel(int n) {
        if (n == 101 || n == 104 || n == 109) {
            this.notificationLevel = n;
            if (this.notificationLevel == 101) {
                Tr.audit(tc, "UPDATE:  set notification level to ALL");
            }
        } else {
            Tr.warning(tc, "attempt to set notification level to illegal value: " + n);
        }
    }

    public abstract void handleOutput(RuleOutput var1);

    public void handleOutput(ArrayList arrayList) {
        if (this.enabled) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.handleOutput((RuleOutput)arrayList.get(i));
            }
        } else {
            Tr.debug(tc, "TraceResponse is not enabled");
        }
    }

    public void handleOutput(RuleOutput[] ruleOutputArray) {
        if (this.enabled) {
            for (int i = 0; i < ruleOutputArray.length; ++i) {
                this.handleOutput(ruleOutputArray[i]);
            }
        }
    }

    public void setRuleFilter(String string) {
        if (string != null) {
            this.setRuleFilters(new String[]{string});
        } else {
            this.setRuleFilters(new String[0]);
        }
    }

    public void setRuleFilters(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.ruleFiltersEnabled = false;
            this.ruleFilters = new String[0];
            return;
        }
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < stringArray.length; ++i) {
                Tr.debug(tc, "Adding filter for " + stringArray[i]);
            }
        }
        this.ruleFiltersEnabled = true;
        this.ruleFilters = stringArray;
    }

    public void setRuleFiltersEnabled(boolean bl) {
        this.ruleFiltersEnabled = bl;
    }
}

