/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.serverAlert.MBeanNotificationResponseMBean;
import com.ibm.ws.performance.tuning.serverAlert.ResponseInterface;
import java.util.ArrayList;
import java.util.Date;
import javax.management.Notification;

public class MBeanNotificationResponse
extends RuntimeCollaborator
implements ResponseInterface,
MBeanNotificationResponseMBean {
    private static int sequence;
    private static int refreshSequence;
    private static int heapDumpSequence;
    private boolean enabled;
    private int outputLevel = 101;
    private static TraceComponent tc;
    public static final String MBEAN_TYPE = "AdvisorNotificationMBean";
    public static final String MBEAN_ID = "AdvisorNotificationMBean";
    public static final String NO_PROBLEM_TYPE;
    public static final String WARNING_TYPE;
    public static final String PROBLEM_TYPE;
    public static final String ALERT_TYPE;
    public static final String CANCEL_ALERT_TYPE;
    public static final String FATAL_TYPE;
    public static final String UNKNOWN_TYPE;
    public static final String UPDATE_CACHED_CALCS_TYPE = "UpdateAdvisorCachedCalcsNotificationType";

    public MBeanNotificationResponse() {
        sequence = 0;
        refreshSequence = 0;
        heapDumpSequence = 0;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) throws Exception {
        this.enabled = bl;
    }

    public void setNotificationLevel(int n) {
        if (n <= 109 && n >= 101) {
            this.outputLevel = n;
        } else {
            Tr.error(tc, "perfalert.illegalNotificationLevel", new Integer(n));
        }
    }

    public void setVerbose(boolean bl) {
    }

    public int getNotificationLevel() {
        return this.outputLevel;
    }

    public void handleOutput(RuleOutput ruleOutput) {
        Tr.entry(tc, "handleOutput");
        if (this.enabled) {
            int n = ruleOutput.getOutputType();
            if (this.outputLevel <= n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pass output level test");
                }
                String string = this.getClass().getName();
                long l = new Date().getTime();
                String string2 = n == 101 ? NO_PROBLEM_TYPE : (n == 102 ? WARNING_TYPE : (n == 103 ? PROBLEM_TYPE : (n == 104 ? ALERT_TYPE : (n == 108 ? FATAL_TYPE : (n == 106 ? CANCEL_ALERT_TYPE : UNKNOWN_TYPE)))));
                Notification notification = new Notification(string2, string, sequence++, l, ruleOutput.getMessage());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending notification to super class : " + notification.toString());
                }
                try {
                    super.sendNotification(notification);
                }
                catch (Exception exception) {
                    Tr.debug(tc, "exception caught sending notification to super class : " + this.toString());
                    exception.printStackTrace();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "notification sent");
                }
            }
        } else {
            Tr.debug(tc, "MBeanResponse is not enabled");
        }
        Tr.exit(tc, "handleOutput");
    }

    public void handleOutput(RuleOutput[] ruleOutputArray) {
        if (this.enabled) {
            for (int i = 0; i < ruleOutputArray.length; ++i) {
                this.handleOutput(ruleOutputArray[i]);
            }
        } else {
            Tr.debug(tc, "MBeanResponse is not enabled");
        }
    }

    public void handleOutput(ArrayList arrayList) {
        if (this.enabled) {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    this.handleOutput((RuleOutput)arrayList.get(i));
                    continue;
                }
                catch (ClassCastException classCastException) {
                    Tr.error(tc, "MBeanNotificationResponse.handleOutput(ArrayList): ClassCastException: " + classCastException.toString());
                    classCastException.printStackTrace();
                }
            }
        } else {
            Tr.debug(tc, "MBeanResponse is not enabled");
        }
    }

    public void sendRefreshNotification() {
        Tr.entry(tc, "sendRefreshNotification");
        String string = this.getClass().getName();
        long l = new Date().getTime();
        Notification notification = new Notification(UPDATE_CACHED_CALCS_TYPE, string, refreshSequence++, l, "Refresh Cached Calcs");
        try {
            super.sendNotification(notification);
        }
        catch (Exception exception) {
            Tr.debug(tc, "exception caught sending notification to super class : " + this.toString());
            exception.printStackTrace();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notification sent : " + notification);
        }
        Tr.exit(tc, "sendRefreshNotification");
    }

    public void sendHeapDumpProcessNotification(boolean bl) {
        Tr.entry(tc, "sendHeapDumpProcessNotification");
        String string = this.getClass().getName();
        Notification notification = bl ? new Notification("websphere.advisor.heapdump.automatedHeapDumpProcessStarted", (Object)string, (long)refreshSequence++, TuningUtil.getNLSString("perfTuning.heapDumpOutputHandler.processStarted")) : new Notification("websphere.advisor.heapdump.AutomatedHeapDumpProcessFinished", (Object)string, (long)refreshSequence++, TuningUtil.getNLSString("perfTuning.heapDumpOutputHandler.processFinished"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sending heap dump notification : " + notification.toString());
        }
        try {
            super.sendNotification(notification);
        }
        catch (Exception exception) {
            Tr.debug(tc, "exception caught sending notification to super class : " + this.toString());
            exception.printStackTrace();
        }
        Tr.exit(tc, "sendHeapDumpProcessNotification");
    }

    public void finialize() {
    }

    static {
        tc = Tr.register(MBeanNotificationResponse.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
        NO_PROBLEM_TYPE = new String("websphere.performanceAlert.NO_PROBLEM");
        WARNING_TYPE = new String("websphere.performanceAlert.WARNING");
        PROBLEM_TYPE = new String("websphere.performanceAlert.PROBLEM");
        ALERT_TYPE = new String("websphere.performanceAlert.ALERT");
        CANCEL_ALERT_TYPE = new String("websphere.performanceAlert.CANCEL_ALERT");
        FATAL_TYPE = new String("websphere.performanceAlert.FATAL");
        UNKNOWN_TYPE = new String("websphere.performanceAlert.UNKNOWN");
    }
}

