/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.ws.management.discovery.ServerInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class NodeAgentUtil {
    private static TraceComponent tc = Tr.register(NodeAgentUtil.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private static HashMap perfObjectCache = new HashMap();
    private static HashMap nodeAdminClientCache = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdminClient getNodeAdminClient(String string, String string2) throws Exception {
        AdminClient adminClient = (AdminClient)nodeAdminClientCache.get(string + "-" + string2);
        if (adminClient == null || adminClient.isAlive() == null) {
            Tr.debug(tc, "creating new admin client");
            ObjectName objectName = null;
            AdminService adminService = null;
            try {
                MBeanOperationInfo[] mBeanOperationInfoArray;
                Object object;
                adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) throw new Exception("NodeAgentUtil: AdminClient was null");
                Object[] objectArray = adminService.getDomainName();
                String[] stringArray = (String)objectArray + ":mbeanIdentifier=Discovery" + ",node=" + string + ",process=" + string2 + ",*";
                Serializable serializable = new ObjectName((String)stringArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "querying for " + serializable);
                }
                if ((object = adminService.queryNames((ObjectName)serializable, null)) == null) throw new Exception("NodeAgentUtil:  Set of Object Names returned from query was null: " + ((ObjectName)serializable).toString());
                if (object.size() != 1 && tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgentUtil:  set contained " + object.size() + " mbeans expected one");
                }
                if (!(mBeanOperationInfoArray = object.iterator()).hasNext()) {
                    if (!tc.isDebugEnabled()) throw new Exception("NodeAgentUtil:  set did not have any ObjectNames, query for Discovery");
                    Tr.debug(tc, "printing out all mbeans cause I could not find Discovery");
                    stringArray = (String)objectArray + ":node=" + string + ",*";
                    serializable = new ObjectName((String)stringArray);
                    object = adminService.queryNames((ObjectName)serializable, null);
                    mBeanOperationInfoArray = object.iterator();
                    while (mBeanOperationInfoArray.hasNext()) {
                        System.out.println("        objectName = " + mBeanOperationInfoArray.next());
                    }
                    throw new Exception("NodeAgentUtil:  set did not have any ObjectNames, query for Discovery");
                }
                objectName = (ObjectName)mBeanOperationInfoArray.next();
                if (objectName == null) {
                    throw new Exception("NodeAgentUtil:  Object name was null " + objectName);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgentUtil: got object name for discovery mbean");
                }
                objectArray = new String[]{};
                stringArray = new String[]{};
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeAgentUtil: calling invoke on getParent");
                }
                serializable = (ServerInfo)adminService.invoke(objectName, "getParent", objectArray, stringArray);
                if (tc.isDebugEnabled()) {
                    if (serializable == null) {
                        Tr.debug(tc, "NodeAgentUtil: called invoke on getParent and serverInfo is null");
                        object = adminService.getMBeanInfo(objectName);
                        mBeanOperationInfoArray = ((MBeanInfo)object).getOperations();
                        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
                            MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfoArray[i].getSignature();
                            String string3 = new String();
                            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                                string3 = string3 + "param: " + mBeanParameterInfoArray[j].getName() + ",type=" + mBeanParameterInfoArray[j].getType();
                            }
                            Tr.debug(tc, "name=" + mBeanOperationInfoArray[i].getName() + ",des=" + mBeanOperationInfoArray[i].getDescription() + ",returnType=" + mBeanOperationInfoArray[i].getReturnType() + ",sig=" + string3);
                        }
                    } else {
                        Tr.debug(tc, "NodeAgentUtil: called invoke on getParent and serverInfo is NOT null " + ((ServerInfo)serializable).toString());
                    }
                }
                adminClient = ((ServerInfo)serializable).getAdminClient();
                nodeAdminClientCache.put(string + "-" + string2, adminClient);
                if (!tc.isDebugEnabled()) return adminClient;
                if (adminClient == null) {
                    Tr.debug(tc, "NodeAgentUtil: nodeAdminClient was not gotten");
                }
                Tr.debug(tc, "NodeAgentUtil: got AdminClient");
                return adminClient;
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) throw exception;
                Tr.debug(tc, "NodeAgentUtil:  Exception caught finding and getting the object name Discovery, rethrowing " + exception.toString());
                throw exception;
            }
        } else {
            if (!tc.isDebugEnabled()) return adminClient;
            Tr.debug(tc, "using cached admin client");
        }
        return adminClient;
    }

    public static void setInstrumentationLevel(String string, String string2, ObjectName objectName) throws Exception {
        try {
            Tr.entry(tc, "setInstrumentationLevel");
            AdminClient adminClient = NodeAgentUtil.getNodeAdminClient(string, string2);
            ObjectName objectName2 = NodeAgentUtil.getPmiMBeanFromNodeAgent(string, string2);
            MBeanLevelSpec mBeanLevelSpec = new MBeanLevelSpec(objectName, null, 7);
            String[] stringArray = new String[]{new String("com.ibm.websphere.pmi.stat.MBeanLevelSpec"), new String("java.lang.Boolean")};
            Object[] objectArray = new Object[]{mBeanLevelSpec, new Boolean(false)};
            adminClient.invoke(objectName2, "setInstrumentationLevel", objectArray, stringArray);
            if (tc.isDebugEnabled()) {
                stringArray = new String[]{new String("javax.management.ObjectName"), new String("java.lang.Boolean")};
                objectArray = new Object[]{objectName, new Boolean(false)};
                Tr.debug(tc, "testing printing out getInstrumentation level");
                Object[] objectArray2 = (Object[])adminClient.invoke(objectName2, "getInstrumentationLevel", objectArray, stringArray);
                for (int i = 0; i < objectArray2.length; ++i) {
                    mBeanLevelSpec = (MBeanLevelSpec)objectArray2[i];
                    Tr.debug(tc, "      " + mBeanLevelSpec.getObjectName() + " is " + mBeanLevelSpec.getLevel());
                }
                Tr.debug(tc, "done with getInstrumentation level");
            }
            Tr.exit(tc, "setInstrumentationLevel");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setInstrumentationLevel caught unexpected exception, rethrowing " + exception.toString());
            }
            Tr.exit(tc, "setInstrumentationLevel");
            throw exception;
        }
    }

    public static ObjectName getPmiMBeanFromNodeAgent(String string, String string2) throws Exception {
        ObjectName objectName = (ObjectName)perfObjectCache.get(string + "-" + string2);
        if (objectName == null) {
            String string3;
            String string4;
            ObjectName objectName2;
            AdminClient adminClient = NodeAgentUtil.getNodeAdminClient(string, string2);
            Set set = adminClient.queryNames(objectName2 = new ObjectName(string4 = (string3 = adminClient.getDomainName()) + ":mbeanIdentifier=PerfMBean" + ",node=" + string + ",process=nodeagent" + ",*"), null);
            if (set != null) {
                Iterator iterator;
                if (tc.isDebugEnabled()) {
                    if (set.size() != 1) {
                        Tr.debug(tc, "NodeAgentUtil: looking for PerfMBean on nodeagent set contained " + set.size() + " mbeans expected one");
                    } else {
                        Tr.debug(tc, "NodeAgentUtil: looking for PerfMBean on nodeagent, set contained just one mbean - good");
                    }
                }
                if ((iterator = set.iterator()).hasNext()) {
                    objectName = (ObjectName)iterator.next();
                    perfObjectCache.put(string + "-" + string2, objectName);
                } else if (tc.isDebugEnabled()) {
                    string4 = string3 + ":node=" + string + ",*";
                    objectName2 = new ObjectName(string4);
                    set = adminClient.queryNames(objectName2, null);
                    Tr.debug(tc, "printing out all object names cause I did not find PerfMBean");
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("        objectName = " + iterator.next());
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not find PerfMBean, set of object names is null");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "using cached PerfMBean object name ");
        }
        return objectName;
    }
}

