/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert;

import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.serverAlert.ResponseInterface;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;

public class OutputFileResponse
implements TuningConstants,
ResponseInterface {
    PrintStream out = System.out;
    private int outputLevel = 101;
    private boolean enabled;
    private String fileName;
    private boolean streamSet;

    public OutputFileResponse() {
        this.fileName = null;
        this.streamSet = false;
    }

    public OutputFileResponse(String string) {
        this.fileName = string;
        this.streamSet = false;
    }

    private void initStream() {
        if (this.fileName == null) {
            try {
                this.out = System.out;
                this.out.println("-----------------------------------------------------------------");
                Date date = new Date();
                this.out.println("Output File created at " + date.toString());
                this.out.println("-----------------------------------------------------------------");
                this.enabled = true;
                this.streamSet = true;
            }
            catch (Exception exception) {
                System.out.println("Runtime Performance Advisor, debug file : " + exception.toString());
                exception.printStackTrace();
            }
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.fileName);
                this.out = new PrintStream(fileOutputStream);
                this.enabled = true;
                this.streamSet = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.out = System.out;
                this.out.println("COULD NOT OPEN FILE TO " + this.fileName + ":" + exception.toString());
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) throws Exception {
        this.enabled = bl;
    }

    public void setVerbose(boolean bl) {
    }

    public void setNotificationLevel(int n) {
        if (n <= 109 && n >= 101) {
            this.outputLevel = n;
        } else {
            this.out.println("Exception caught setting notificationLevel to illegal value: " + n);
        }
    }

    public int getNotificationLevel() {
        return this.outputLevel;
    }

    public void handleOutput(RuleOutput ruleOutput) {
        int n;
        if (!this.streamSet) {
            this.initStream();
        }
        if (this.enabled && this.outputLevel <= (n = ruleOutput.getOutputType())) {
            if (n == 101) {
                this.out.println("INFORMATIONAL:" + ruleOutput.toString());
            } else if (n == 102) {
                this.out.println("WARNING: " + ruleOutput.toString());
            } else if (n == 103) {
                this.out.println("PROBLEM: " + ruleOutput.toString());
            } else if (n == 104) {
                this.out.println("ALERT:" + ruleOutput.toString());
            } else if (n == 108) {
                this.out.println("FATAL: " + ruleOutput.toString());
            } else {
                this.out.println("UNKNOWN OUTPUT TYPE: " + ruleOutput.toString());
            }
            this.out.println("_____________________________________________");
        }
    }

    public void handleOutput(RuleOutput[] ruleOutputArray) {
        if (this.enabled) {
            for (int i = 0; i < ruleOutputArray.length; ++i) {
                this.handleOutput(ruleOutputArray[i]);
            }
        }
    }

    public void handleOutput(ArrayList arrayList) {
        if (this.enabled) {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    this.handleOutput((RuleOutput)arrayList.get(i));
                    continue;
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                    this.out.println("class cast exception: " + classCastException.toString());
                }
            }
        }
    }

    public void finialize() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            System.out.println("RuleResponse EXception " + exception.toString());
            exception.printStackTrace();
        }
    }
}

