/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;

public class ParsedMbeanAttribute
implements Serializable {
    private static final long serialVersionUID = 3310261666496602333L;
    String type;
    String level;
    String basicDescription;
    String desLookup;
    String name;
    String nameLookup;
    String id;
    String paramId;
    boolean hasOptions;
    HashMap options;
    boolean advice;
    boolean adviceApplicable;
    boolean isPeriodicAlert = true;
    private boolean initialized;
    private String advancedDescription;
    private static TraceComponent tc = Tr.register(ParsedMbeanAttribute.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    public static final char MBEAN_DES_SEP = '#';
    public static final char MBEAN_DES_NV_SEP = ':';
    public static final char MBEAN_DES_OPTION_SEP = '$';
    public static final char MBEAN_DES_OPTION_NV_SEP = '~';

    public ParsedMbeanAttribute(String string, String string2, String string3) {
        this.setDefaults();
        this.name = string;
        this.type = string2;
        this.advancedDescription = string3;
        this.initialized = false;
    }

    public ParsedMbeanAttribute(MBeanAttributeInfo mBeanAttributeInfo, String string) {
        this(mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType(), string);
    }

    public ParsedMbeanAttribute(String string) {
        this.setDefaults();
        this.name = string;
        this.initialized = true;
    }

    private void setup() {
        this.setDefaults();
        this.parsedes(this.advancedDescription);
        this.advancedDescription = null;
        this.initialized = true;
    }

    private void setDefaults() {
        this.level = new String("normal");
        this.basicDescription = "unknown description";
        this.desLookup = new String("perfTuningAdmin.operation.des.unknown");
        this.nameLookup = new String("perfTuningAdmin.attribute.unknown");
        this.hasOptions = false;
        this.options = new HashMap();
        this.id = "noId";
        this.paramId = "noParamId";
        this.adviceApplicable = false;
        this.advice = false;
        this.isPeriodicAlert = true;
    }

    public boolean isPeriodicAlert() {
        if (!this.initialized) {
            this.setup();
        }
        return this.isPeriodicAlert;
    }

    public void setIsPeriodicAlert(boolean bl) {
        this.isPeriodicAlert = bl;
    }

    public String getType() {
        if (!this.initialized) {
            this.setup();
        }
        return this.type;
    }

    public String getLevel() {
        if (!this.initialized) {
            this.setup();
        }
        return this.level;
    }

    public String getBasicDescription() {
        if (!this.initialized) {
            this.setup();
        }
        return this.basicDescription;
    }

    public String getDesLookup() {
        if (!this.initialized) {
            this.setup();
        }
        return this.desLookup;
    }

    public String getName() {
        if (!this.initialized) {
            this.setup();
        }
        return this.name;
    }

    public String getNameLookup() {
        if (!this.initialized) {
            this.setup();
        }
        return this.nameLookup;
    }

    public boolean isAdvice() {
        if (!this.initialized) {
            this.setup();
        }
        return this.advice;
    }

    public boolean isAdviceApplicable() {
        if (!this.initialized) {
            this.setup();
        }
        return this.adviceApplicable;
    }

    public boolean hasOptions() {
        if (!this.initialized) {
            this.setup();
        }
        return this.hasOptions;
    }

    public HashMap getOptions() {
        if (!this.initialized) {
            this.setup();
        }
        return this.options;
    }

    public String getId() {
        if (!this.initialized) {
            this.setup();
        }
        return this.id;
    }

    public String getParamId() {
        if (!this.initialized) {
            this.setup();
        }
        return this.paramId;
    }

    public String getAdvancedDescription() {
        if (!this.initialized) {
            return this.advancedDescription;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Set set = this.options.keySet();
        Object object = set.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            String string2 = (String)this.options.get(string);
            stringBuffer.append(string).append('~').append(string2);
            if (!object.hasNext()) continue;
            stringBuffer.append('$');
        }
        object = "Des" + ':' + this.basicDescription + '#' + "DesLookup" + ':' + this.desLookup + '#' + "OptionsLookup" + ':' + stringBuffer.toString() + '#' + "Type" + ':' + this.level + '#' + "AttNameLookup" + ':' + this.nameLookup + '#' + "ID" + ':' + this.id + '#' + "ParamId" + ':' + this.paramId + '#' + "isAdvice" + ':' + this.advice + '#' + "isPeriodicAlert" + ':' + this.isPeriodicAlert + '#' + "isAdviceApplicable" + ':' + this.adviceApplicable;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "generating advanced description string " + (String)object);
        }
        return object;
    }

    public void setOptions(HashMap hashMap) {
        this.options = hashMap;
        this.hasOptions = !this.options.isEmpty();
    }

    public void setParamId(String string) {
        this.paramId = string;
    }

    private void setOptions(String string) {
        try {
            this.options = new HashMap();
            StringTokenizer stringTokenizer = new StringTokenizer(string, new String(new char[]{'$', '~'}));
            if (stringTokenizer.countTokens() >= 2) {
                while (stringTokenizer.hasMoreTokens()) {
                    this.options.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                }
            }
            this.hasOptions = !this.options.isEmpty();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception could not parse:" + string + " :" + exception.toString());
            }
            exception.printStackTrace();
        }
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setLevel(String string) {
        this.level = string;
    }

    public void setBasicDescription(String string) {
        this.basicDescription = string;
    }

    public void setDesLookup(String string) {
        this.desLookup = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNameLookup(String string) {
        this.nameLookup = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setIsApplicable(boolean bl) {
        this.adviceApplicable = bl;
    }

    public void setIsAdvice(boolean bl) {
        this.advice = bl;
    }

    private HashMap parseAdvancedDescription(String string) {
        if (string.startsWith("\"")) {
            string = ObjectName.unquote(string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, new String(new char[]{'#', ':'}));
            if (stringTokenizer.countTokens() >= 2) {
                while (stringTokenizer.hasMoreTokens()) {
                    hashMap.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception could not parse:" + string + ":" + exception.toString());
            }
            exception.printStackTrace();
        }
        return hashMap;
    }

    private void parsedes(String string) {
        boolean bl;
        String string2;
        Object object;
        Object object2;
        if (string == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        boolean bl2 = true;
        HashMap hashMap2 = this.parseAdvancedDescription(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "printing out parsed mbean attribute key value map");
            Set set = hashMap2.keySet();
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string2 = (String)hashMap2.get(object);
                Tr.debug(tc, "   " + (String)object + " = " + string2);
            }
        }
        boolean bl3 = bl = !hashMap2.isEmpty();
        if (bl) {
            object2 = hashMap2.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                String string3 = (String)hashMap2.get(string2);
            }
            if (hashMap2.containsKey("Des")) {
                this.basicDescription = (String)hashMap2.get("Des");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "did not have Des");
            }
            if (hashMap2.containsKey("DesLookup")) {
                this.desLookup = (String)hashMap2.get("DesLookup");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "did not have DesLookup");
            }
            if (hashMap2.containsKey("isPeriodicAlert")) {
                this.isPeriodicAlert = Boolean.valueOf((String)hashMap2.get("isAdvice"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + "did not have isPeriodicAlert");
            }
            if (hashMap2.containsKey("OptionsLookup")) {
                this.setOptions((String)hashMap2.get("OptionsLookup"));
            } else if (tc.isDebugEnabled() && !this.type.equals("java.lang.Boolean")) {
                Tr.debug(tc, this.name + " did not have OptionsLookup and type is not a boolean: " + string);
            }
            if (hashMap2.containsKey("Type")) {
                this.level = (String)hashMap2.get("Type");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " did not have Type");
            }
            if (hashMap2.containsKey("AttNameLookup")) {
                this.nameLookup = (String)hashMap2.get("AttNameLookup");
            } else if (hashMap2.containsKey("GeneralAttNameLookup")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.name + " had no AttnameLookup using GeneralAttNameLookup");
                }
                this.nameLookup = (String)hashMap2.get("GeneralAttNameLookup");
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.name + "had no AttNameLookup or general name lookup, will use name=" + this.name + ", Description=" + string);
                }
                this.nameLookup = this.name;
            }
            if (hashMap2.containsKey("ID")) {
                this.id = (String)hashMap2.get("ID");
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.name + " did not have an id ");
                }
                this.id = new String("unknown ruleId");
            }
            if (hashMap2.containsKey("ParamId")) {
                this.paramId = (String)hashMap2.get("ParamId");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.name + " did not have an paramId ");
            }
            if (hashMap2.containsKey("isAdvice")) {
                this.advice = Boolean.valueOf((String)hashMap2.get("isAdvice"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.name + " did not have isAdvice ");
            }
            if (hashMap2.containsKey("isAdviceApplicable")) {
                this.adviceApplicable = Boolean.valueOf((String)hashMap2.get("isAdviceApplicable"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.name + " did not have a isAdviceApplicable ");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, string + " is not an advanced description");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        block5: {
            Tr.entry(tc, "writeObject");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "printing out parsed MBean Attribute : " + this.toString());
            }
            try {
                objectOutputStream.writeObject(this.type);
                objectOutputStream.writeObject(this.level);
                objectOutputStream.writeObject(this.basicDescription);
                objectOutputStream.writeObject(this.desLookup);
                objectOutputStream.writeObject(this.name);
                objectOutputStream.writeObject(this.nameLookup);
                objectOutputStream.writeObject(this.id);
                objectOutputStream.writeObject(this.paramId);
                objectOutputStream.writeBoolean(this.hasOptions);
                if (this.hasOptions) {
                    objectOutputStream.writeObject(this.options);
                }
                objectOutputStream.writeBoolean(this.advice);
                objectOutputStream.writeBoolean(this.adviceApplicable);
                objectOutputStream.writeBoolean(this.initialized);
                objectOutputStream.writeBoolean(this.isPeriodicAlert);
                if (!this.initialized) {
                    objectOutputStream.writeObject(this.advancedDescription);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "could not write ParsedMBeanAttribute : " + exception.toString());
            }
        }
        Tr.exit(tc, "writeObject");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block5: {
            Tr.entry(tc, "readObject");
            try {
                this.setDefaults();
                this.type = (String)objectInputStream.readObject();
                this.level = (String)objectInputStream.readObject();
                this.basicDescription = (String)objectInputStream.readObject();
                this.desLookup = (String)objectInputStream.readObject();
                this.name = (String)objectInputStream.readObject();
                this.nameLookup = (String)objectInputStream.readObject();
                this.id = (String)objectInputStream.readObject();
                this.paramId = (String)objectInputStream.readObject();
                this.hasOptions = objectInputStream.readBoolean();
                if (this.hasOptions) {
                    this.options = (HashMap)objectInputStream.readObject();
                }
                this.advice = objectInputStream.readBoolean();
                this.adviceApplicable = objectInputStream.readBoolean();
                this.initialized = objectInputStream.readBoolean();
                this.isPeriodicAlert = objectInputStream.readBoolean();
                if (!this.initialized) {
                    this.advancedDescription = (String)objectInputStream.readObject();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "printing out parsed MBean Attribute : " + this.toString());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "could not read ParsedMBeanAttribute : " + exception.toString());
            }
        }
        Tr.exit(tc, "readObject");
    }

    public String toString() {
        if (!this.initialized) {
            this.setup();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TYPE:").append(this.type);
        stringBuffer.append(" - LEVEL:").append(this.level);
        stringBuffer.append(" - DES:").append(this.basicDescription);
        stringBuffer.append(" - ndesLookup:").append(this.desLookup);
        stringBuffer.append(" - name:").append(this.name);
        stringBuffer.append(" - nameLookup:").append(this.nameLookup);
        stringBuffer.append(" - id:").append(this.id);
        stringBuffer.append(" - paramId:").append(this.paramId);
        stringBuffer.append(" - hasOptions:").append(this.hasOptions);
        if (this.hasOptions) {
            stringBuffer.append(" - Options:");
            Set set = this.options.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.options.get(string);
                stringBuffer.append(string + "=" + string2 + ",");
            }
        }
        stringBuffer.append(" - advice:").append(this.advice);
        stringBuffer.append(" - isPeriodicAlert:").append(this.isPeriodicAlert);
        stringBuffer.append(" - applicable: ").append(this.adviceApplicable);
        stringBuffer.append(" - initialized:").append(this.initialized);
        if (this.initialized) {
            stringBuffer.append(" - advanced des should be null as we are initialized : " + this.advancedDescription);
        } else {
            stringBuffer.append(" - advanced des should be set " + this.advancedDescription);
        }
        return stringBuffer.toString();
    }
}

