/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.performance.tuning.serverAlert;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.HeapDumpNotSupportedException;
import com.ibm.websphere.management.exception.HeapDumpOnDiskLimitReachedException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.TuningConstants;
import com.ibm.ws.performance.tuning.TuningUtil;
import com.ibm.ws.performance.tuning.calc.CalcCreator;
import com.ibm.ws.performance.tuning.leakProtoType_1.HeapDumpOutputHandler;
import com.ibm.ws.performance.tuning.rule.IRule;
import com.ibm.ws.performance.tuning.rule.MessageWrapper;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.rule.RuleLookup;
import com.ibm.ws.performance.tuning.rule.RuleOutput;
import com.ibm.ws.performance.tuning.rule.RuleParser;
import com.ibm.ws.performance.tuning.rule.StatefullRuleInterface;
import com.ibm.ws.performance.tuning.serverAlert.NodeAgentUtil;
import com.ibm.ws.performance.tuning.serverAlert.ResponseInterface;
import com.ibm.ws.performance.tuning.serverAlert.ServerResponseCreator;
import com.ibm.ws.performance.tuning.serverAlert.calc.config.RepositoryCache;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.rasdiag.ImmediateAlertBridge;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public abstract class ServerRuleDriver
extends ComponentImpl
implements AlarmListener,
TuningConstants,
NotificationListener {
    private int count = 0;
    private boolean updateDuration = false;
    protected boolean enabled;
    public static final int WARNING_KEY_DEFAULT = 0;
    public static final int WARNING_KEY_TITLE = 2;
    public static final int WARNING_KEY_HEAPDUMP = 4;
    private static final Integer DISCOVERY_HANDBACK = new Integer(0);
    private static final Integer SERVER_HANDBACK = new Integer(1);
    private static TraceComponent tc = Tr.register(ServerRuleDriver.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private Alarm _alarm = null;
    protected int duration = 10000;
    protected Integer maxAlertStreak;
    protected String nodeName;
    protected String serverName;
    protected String processType;
    private boolean serverStarted = false;
    private boolean nodeAgentDiscovered = false;
    protected boolean pmiEnabled = false;
    protected boolean serverPmiEnabled = false;
    protected boolean nodeAgentPmiEnabled = false;
    private static Object lockObject = new Object();
    private ArrayList warningsList;
    protected ArrayList rules = new ArrayList();
    protected ImmediateAlertBridge immediateAlertBridge;
    protected Boolean beenInitialized;
    protected boolean initializationCompleted = false;
    protected HashMap ruleDataMap = null;
    protected ResponseInterface fileResponse;
    protected ResponseInterface traceResponse;
    protected HeapDumpOutputHandler heapDumpResponse;
    private String[] threadPoolNames;
    private String state;
    private String name;
    private static ChannelFrameworkService channelFrameworkService = null;
    private ObjectName discoveryObjectName = null;
    static /* synthetic */ Class class$com$ibm$wsspi$channel$framework$ChannelFrameworkService;

    public String getName() {
        Tr.entry(tc, "getName");
        Tr.exit(tc, "getName");
        return this.name;
    }

    public String getState() {
        Tr.entry(tc, "getState");
        Tr.exit(tc, "getState");
        return this.state;
    }

    protected void addWarning(MessageWrapper messageWrapper) {
        this.addWarning(messageWrapper, 0);
    }

    protected void addWarning(MessageWrapper messageWrapper, int n) {
        if (this.warningsList == null) {
            this.warningsList = new ArrayList();
        }
        MyWarning myWarning = new MyWarning(n, messageWrapper);
        this.warningsList.add(myWarning);
    }

    protected void clearWarnings() {
        this.warningsList = new ArrayList();
    }

    protected void clearWarnings(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clearing warningsList with key : " + n);
        }
        Iterator iterator = this.warningsList.iterator();
        while (iterator.hasNext()) {
            MyWarning myWarning = (MyWarning)iterator.next();
            if (myWarning.getKey() != n) continue;
            iterator.remove();
        }
    }

    protected String getWarnings() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.warningsList != null) {
            for (int i = 0; i < this.warningsList.size(); ++i) {
                MyWarning myWarning = (MyWarning)this.warningsList.get(i);
                MessageWrapper messageWrapper = myWarning.getMessage();
                stringBuffer.append(messageWrapper.getMessage());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    protected ArrayList getWarningWrappers() {
        if (this.warningsList == null) {
            return new ArrayList();
        }
        ArrayList<MessageWrapper> arrayList = new ArrayList<MessageWrapper>();
        for (int i = 0; i < this.warningsList.size(); ++i) {
            arrayList.add(((MyWarning)this.warningsList.get(i)).getMessage());
        }
        return arrayList;
    }

    public void takeMultipleHeapDumpsForMemoryLeakAnalysis() throws HeapDumpOnDiskLimitReachedException, HeapDumpNotSupportedException {
        Tr.entry(tc, "takeMultipleHeapDumpsForMemoryLeakAnalysis");
        try {
            if (this.heapDumpResponse == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not take heap dump as output handler was null");
                }
                Tr.exit(tc, "takeMultipleHeapDumpsForMemoryLeakAnalysis");
                return;
            }
            Tr.exit(tc, "takeMultipleHeapDumpsForMemoryLeakAnalysis");
            this.heapDumpResponse.takeHeapDumps();
        }
        catch (HeapDumpOnDiskLimitReachedException heapDumpOnDiskLimitReachedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not take heap dump on disk limit reached, rethrowing exception :  " + heapDumpOnDiskLimitReachedException.toString());
                heapDumpOnDiskLimitReachedException.printStackTrace();
            }
            Tr.exit(tc, "takeMultipleHeapDumpsForMemoryLeakAnalysis");
            throw heapDumpOnDiskLimitReachedException;
        }
        catch (HeapDumpNotSupportedException heapDumpNotSupportedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not take heap dump platform not supported, rethrowing exception :  " + heapDumpNotSupportedException.toString());
                heapDumpNotSupportedException.printStackTrace();
            }
            Tr.exit(tc, "takeMultipleHeapDumpsForMemoryLeakAnalysis");
            throw heapDumpNotSupportedException;
        }
    }

    public ArrayList getHeapDumpFileNames() {
        Tr.entry(tc, "getHeapDumpFileNames");
        try {
            if (this.heapDumpResponse == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not get heap dump file names as output handler was null");
                }
                Tr.exit(tc, "getHeapDumpFileNames");
                return new ArrayList();
            }
            Tr.exit(tc, "getHeapDumpFileNames");
            return this.heapDumpResponse.getHeapDumpFiles();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get file names, exception :  " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "getHeapDumpFileNames");
            return new ArrayList();
        }
    }

    public String[] getHeapDumpStatus() {
        Tr.entry(tc, "getHeapDumpStatus");
        try {
            if (this.heapDumpResponse == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not get status as output handler was null");
                }
                Tr.exit(tc, "getHeapDumpStatus");
                return new String[0];
            }
            MessageWrapper[] messageWrapperArray = this.heapDumpResponse.getCurrentStatus(true);
            String[] stringArray = new String[messageWrapperArray.length];
            for (int i = 0; i < messageWrapperArray.length; ++i) {
                stringArray[i] = messageWrapperArray[i].getMessage();
            }
            Tr.exit(tc, "getHeapDumpStatus");
            return stringArray;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not get file names, exception :  " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "getHeapDumpStatus");
            return new String[0];
        }
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        Tr.entry(tc, "initialize");
        this.state = "INITIALIZING";
        this.name = this.getClass().getName();
        this.beenInitialized = new Boolean(false);
        this.state = "INITIALIZED";
        Tr.exit(tc, "initialize");
    }

    public void destroy() {
        Tr.entry(tc, "destroy");
        this.state = "DESTROYING";
        this.state = "DESTROYED";
        Tr.exit(tc, "destroy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start() throws RuntimeError, RuntimeWarning {
        block39: {
            block40: {
                block38: {
                    var1_1 = null;
                    var2_2 = null;
                    Tr.entry(ServerRuleDriver.tc, "start");
                    this.state = "STARTING";
                    var2_2 = SecurityHelper.getServerSubject();
                    if (ServerRuleDriver.tc.isDebugEnabled()) {
                        Tr.debug(ServerRuleDriver.tc, "subject", var2_2);
                    }
                    if (var2_2 != null) {
                        var1_1 = SecurityHelper.pushInvocationSubject(var2_2);
                    }
                    if (ServerRuleDriver.tc.isDebugEnabled()) {
                        Tr.debug(ServerRuleDriver.tc, "pushedSubject", var1_1);
                    }
                    try {
                        var3_3 = AdminServiceFactory.getAdminService();
                        this.processType = var3_3.getProcessType();
                        this.nodeName = var3_3.getNodeName();
                        this.serverName = var3_3.getProcessName();
                        var4_7 = var3_3.getLocalServer();
                        if (ServerRuleDriver.tc.isDebugEnabled()) {
                            Tr.debug(ServerRuleDriver.tc, "serverName :" + this.serverName);
                            Tr.debug(ServerRuleDriver.tc, "nodeName :" + this.nodeName);
                        }
                    }
                    catch (Exception var3_4) {
                        if (!ServerRuleDriver.tc.isDebugEnabled()) break block38;
                        Tr.debug(ServerRuleDriver.tc, "exception settting processName, nodeName or proecess Type from admin service " + var3_4.toString());
                        var3_4.printStackTrace();
                    }
                }
                var3_5 = this.processType.equals("UnManagedProcess") != false || this.processType.equals("ManagedProcess") != false;
                v0 = var4_8 = Util.isProxy() == false;
                if (var3_5 && var4_8) {
                    if (ServerRuleDriver.tc.isDebugEnabled()) {
                        Tr.debug(ServerRuleDriver.tc, "   executing in standalone or managed process will continue");
                    }
                    break block39;
                }
                if (ServerRuleDriver.tc.isDebugEnabled()) {
                    Tr.debug(ServerRuleDriver.tc, "   not executing in a standalone or managed process ");
                }
                this.stop();
                if (var2_2 == null) break block40;
                SecurityHelper.popInvocationSubject(var1_1);
            }
            return;
        }
        try {
            block41: {
                try {
                    var5_9 = AdminServiceFactory.getAdminService();
                    if (this.processType.equals("ManagedProcess")) {
                        var6_11 = "WebSphere:type=Discovery,process=" + this.serverName + ",*";
                        var7_12 = new ObjectName(var6_11);
                        var8_13 = var5_9.queryNames(var7_12, null);
                        if (var8_13 != null) {
                            var9_14 = var8_13.iterator();
                            this.discoveryObjectName = (ObjectName)var9_14.next();
                        } else if (ServerRuleDriver.tc.isDebugEnabled()) {
                            Tr.debug(ServerRuleDriver.tc, "was unable to get the discovery mbean");
                        }
                        if (this.discoveryObjectName != null) {
                            try {
                                this.nodeAgentDiscovered = this.discoveryFoundNodeAgent(var5_9, this.discoveryObjectName);
                                if (ServerRuleDriver.tc.isDebugEnabled()) {
                                    Tr.debug(ServerRuleDriver.tc, "Node agent discovered : " + this.nodeAgentDiscovered);
                                }
                            }
                            catch (Exception var9_15) {
                                if (ServerRuleDriver.tc.isDebugEnabled()) {
                                    Tr.debug(ServerRuleDriver.tc, "Exception caught when checking for node agent discovery : " + var9_15.toString());
                                    var9_15.printStackTrace();
                                }
                                this.nodeAgentDiscovered = false;
                            }
                        }
                        if (!this.nodeAgentDiscovered && this.discoveryObjectName != null) {
                            if (ServerRuleDriver.tc.isDebugEnabled()) {
                                Tr.debug(ServerRuleDriver.tc, "Node agent not discovered will listen for notification ");
                            }
                            this.listenForDiscoveryMBeanNotifications(var5_9, var7_12);
                            try {
                                if (ServerRuleDriver.tc.isDebugEnabled()) {
                                    Tr.debug(ServerRuleDriver.tc, "Checking timing window Node agent discovered : " + this.nodeAgentDiscovered);
                                }
                                this.nodeAgentDiscovered = this.discoveryFoundNodeAgent(var5_9, this.discoveryObjectName);
                            }
                            catch (Exception var9_16) {
                                if (ServerRuleDriver.tc.isDebugEnabled()) {
                                    Tr.debug(ServerRuleDriver.tc, "Exception caught when checking for node agent discovery : " + var9_16.toString());
                                    var9_16.printStackTrace();
                                }
                                this.nodeAgentDiscovered = false;
                            }
                        }
                    }
                    this.serverStarted = this.isServerStated(var5_9);
                    if (ServerRuleDriver.tc.isDebugEnabled()) {
                        Tr.debug(ServerRuleDriver.tc, "serverStarted : " + this.serverStarted);
                    }
                    if (!this.serverStarted) {
                        if (ServerRuleDriver.tc.isDebugEnabled()) {
                            Tr.debug(ServerRuleDriver.tc, "server not started listening for not");
                        }
                        this.listenForServerMBeanNotifications(var5_9);
                        if (ServerRuleDriver.tc.isDebugEnabled()) {
                            Tr.debug(ServerRuleDriver.tc, "checking timing window serverStarted  : " + this.serverStarted);
                        }
                        this.serverStarted = this.isServerStated(var5_9);
                    }
                    this.startRPA();
                }
                catch (Exception var5_10) {
                    if (!ServerRuleDriver.tc.isDebugEnabled()) break block41;
                    Tr.debug(ServerRuleDriver.tc, "exception registering for notifications " + var5_10.toString());
                    var5_10.printStackTrace();
                }
            }
            this.state = "STARTED";
            ** if (var2_2 == null) goto lbl-1000
        }
        catch (Exception var3_6) {
            try {
                Tr.error(ServerRuleDriver.tc, "perflaert.error" + var3_6.toString(), new String("General Exception caught in ServerRuleDriverMBean.start: "));
                var3_6.printStackTrace();
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var10_17) {
                if (var2_2 != null) {
                    SecurityHelper.popInvocationSubject(var1_1);
                }
                throw var10_17;
            }
lbl-1000:
            // 1 sources

            {
                SecurityHelper.popInvocationSubject(var1_1);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            SecurityHelper.popInvocationSubject(var1_1);
        }
lbl-1000:
        // 2 sources

        {
        }
        Tr.exit(ServerRuleDriver.tc, "start");
    }

    public void stop() {
        Tr.entry(tc, "stop");
        this.state = "STOPPING";
        this.state = "STOPPED";
        Tr.exit(tc, "stop");
    }

    protected synchronized void registerAlarm() {
        this.registerAlarm(this.duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void registerAlarm(int n) {
        Date date = new Date();
        Object object = lockObject;
        synchronized (object) {
            if (this._alarm == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerRuleDriver.registerAlarm registering with alarm at " + date.toString() + " for " + n);
                }
                try {
                    this._alarm = AlarmManager.create(n, this);
                }
                catch (Exception exception) {
                    Tr.error(tc, "perfalert.couldNotRegister");
                    exception.printStackTrace();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "alarm is already registered, will not register again");
            }
        }
    }

    public ArrayList getRules() {
        return this.rules;
    }

    public Integer getMaxAlertStreak() {
        return this.maxAlertStreak;
    }

    public void setMaxAlertStreak(Integer n) {
        if (n != null) {
            this.maxAlertStreak = n;
            for (int i = 0; i < this.rules.size(); ++i) {
                if (!(this.rules.get(i) instanceof StatefullRuleInterface)) continue;
                ((StatefullRuleInterface)this.rules.get(i)).setMaxAlertStreak(n);
            }
        } else {
            throw new NullPointerException("Can not set MaxAlertStreak to null");
        }
    }

    protected void setMyDuration(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setMyDuration setting from " + this.duration + " to " + n + " *1000");
        }
        this.duration = n * 1000;
    }

    public RuleData readImmediateAlertConfig(String string) throws Exception {
        Tr.entry(tc, "readImmediateAlertConfig");
        try {
            if (this.ruleDataMap.containsKey(string)) {
                Tr.exit(tc, "readImmediateAlertConfig");
                return (RuleData)this.ruleDataMap.get(string);
            }
            throw new Exception("Invalid AlertID : " + string);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception, possibly bad AlertID : " + string + " -> " + exception.toString());
                exception.printStackTrace();
            }
            Tr.exit(tc, "readImmediateAlertConfig - exception");
            throw exception;
        }
    }

    protected int getMyDuration() {
        return this.duration / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        Tr.entry(tc, "alarm");
        Object object2 = lockObject;
        synchronized (object2) {
            this._alarm = null;
        }
        Tr.debug(tc, "   alarm: , duration is " + this.duration);
        if (this.processType.equals("ManagedProcess") && !this.nodeAgentDiscovered) {
            object2 = null;
            Subject subject = null;
            try {
                subject = SecurityHelper.getServerSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "subject", subject);
                }
                if (subject != null) {
                    object2 = SecurityHelper.pushInvocationSubject(subject);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking to see if node agent is discovered");
                }
                if (this.discoveryObjectName != null) {
                    try {
                        AdminService adminService = AdminServiceFactory.getAdminService();
                        this.nodeAgentPollingSuccessfull(this.discoveryFoundNodeAgent(adminService, this.discoveryObjectName));
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception caught when checking for node agent discovery : " + exception.toString());
                            exception.printStackTrace();
                        }
                        this.discoveryObjectName = null;
                        this.nodeAgentPollingSuccessfull(false);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "discovery object name was null");
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    // empty if block
                }
            }
            finally {
                if (subject != null) {
                    SecurityHelper.popInvocationSubject((Subject)object2);
                }
            }
            return;
        }
        if (EngineParameters.getRefreshIteration() != 0) {
            ++this.count;
        }
        if (this.enabled && this.pmiEnabled) {
            Tr.debug(tc, "   Running rules");
            object2 = this.run();
            if (tc.isDebugEnabled()) {
                if (object2 != null) {
                    Tr.debug(tc, "   Ran rules have " + ((ArrayList)object2).size() + " ruleoutputs in list");
                } else {
                    Tr.debug(tc, "   just ran rules and list is null");
                }
            }
            this.handleResponse((ArrayList)object2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   count : " + this.count + " refresh iteration : " + EngineParameters.getRefreshIteration());
            }
            if (this.count >= EngineParameters.getRefreshIteration()) {
                this.refreshCachedData();
                this.count = EngineParameters.getRefreshIteration() == 0 ? -1 : 0;
            }
            this.registerAlarm();
        } else {
            Tr.debug(tc, "   Rule Engine doing nothing because it is not enabled, or pmi is disabled - not registering as alarm");
        }
        Tr.exit(tc, "alarm");
    }

    private void nodeAgentPollingSuccessfull(boolean bl) {
        Tr.entry(tc, "nodeAgentPollingSuccessfull - " + bl);
        if (bl) {
            this.nodeAgentDiscovered = true;
            this.startRPA();
        } else {
            this.nodeAgentDiscovered = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node agent still not discovered.  Poll again");
            }
            this.registerAlarm(30000);
        }
        Tr.entry(tc, "nodeAgentPollingSuccessfull - " + bl);
    }

    protected abstract void refreshCachedData();

    protected void initResponse() {
        block25: {
            block24: {
                Tr.entry(tc, "initResponse");
                try {
                    Integer n = null;
                    Boolean bl = null;
                    n = (Integer)EngineParameters.getParam("traceResponseLevel");
                    bl = (Boolean)EngineParameters.getParam("traceResponseEnabled");
                    this.traceResponse = ServerResponseCreator.createResponse(202);
                    if (n != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setting trace response notification level to " + n);
                        }
                        this.traceResponse.setNotificationLevel(n);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "did not get traceresponseLevel from EngineParameters");
                        }
                        this.traceResponse.setNotificationLevel(104);
                    }
                    if (bl != null) {
                        this.traceResponse.setVerbose(false);
                        this.traceResponse.setEnabled(bl);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "did not get traceResponseEnabled from EngineParameters");
                        }
                        this.traceResponse.setVerbose(false);
                        this.traceResponse.setEnabled(true);
                    }
                    this.fileResponse = ServerResponseCreator.createResponse(201);
                    n = (Integer)EngineParameters.getParam("fileResponseLevel");
                    bl = (Boolean)EngineParameters.getParam("fileResponseEnabled");
                    if (n != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setting trace response notification level to " + n);
                        }
                        this.fileResponse.setNotificationLevel(n);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "did not get fileResponseLevel from EngineParameters");
                        }
                        this.fileResponse.setNotificationLevel(104);
                    }
                    if (bl != null) {
                        this.fileResponse.setVerbose(false);
                        this.fileResponse.setEnabled(bl);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "did not get fileResponseEnabled from EngineParameters");
                        }
                        this.fileResponse.setVerbose(false);
                        this.fileResponse.setEnabled(false);
                    }
                }
                catch (Exception exception) {
                    block23: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "initResponse caught unexpected exception : " + exception.toString());
                            exception.printStackTrace();
                        }
                        this.fileResponse = ServerResponseCreator.createResponse(201);
                        this.fileResponse.setNotificationLevel(101);
                        this.fileResponse.setVerbose(false);
                        try {
                            this.fileResponse.setEnabled(false);
                        }
                        catch (Exception exception2) {
                            if (!tc.isDebugEnabled()) break block23;
                            Tr.debug(tc, "could not enable file response : " + exception2.toString());
                        }
                    }
                    this.traceResponse = ServerResponseCreator.createResponse(202);
                    this.traceResponse.setNotificationLevel(104);
                    this.traceResponse.setVerbose(false);
                    try {
                        this.traceResponse.setEnabled(true);
                    }
                    catch (Exception exception3) {
                        if (!tc.isDebugEnabled()) break block24;
                        Tr.debug(tc, "could not enable trace response : " + exception3.toString());
                    }
                }
            }
            try {
                this.setupHeapDumpResponse();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block25;
                Tr.debug(tc, "could not set up the heap dump response : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "initResponse");
    }

    private void setupHeapDumpResponse() {
        block2: {
            Tr.entry(tc, "setupHeapDumpReponse");
            this.heapDumpResponse = new HeapDumpOutputHandler(this.nodeName, this.serverName);
            try {
                this.heapDumpResponse.setVerbose(false);
                this.heapDumpResponse.setRuleFilter("Memory Leak Rule");
                this.heapDumpResponse.setDelayTime(30000);
                this.heapDumpResponse.setNotificationLevel(104);
                this.heapDumpResponse.setEnabled(false);
                this.heapDumpResponse.setNumberOfDumps(2);
                this.heapDumpResponse.setPolicy(2);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "exception setting policy on heap dump response : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "setupHeapDumpReponse");
    }

    protected void handleResponse(ArrayList arrayList) {
        Tr.entry(tc, "handleResponse");
        this.fileResponse.handleOutput(arrayList);
        this.traceResponse.handleOutput(arrayList);
        this.heapDumpResponse.handleOutput(arrayList);
        Tr.exit(tc, "handleResponse");
    }

    public void initStartup() throws Exception {
        Tr.entry(tc, "initStartup");
        try {
            block11: {
                this.serverPmiEnabled = !PmiRegistry.isDisabled();
                if (this.processType.equals("ManagedProcess") && !EngineParameters.getOS().equalsIgnoreCase("z/OS")) {
                    try {
                        if (NodeAgentUtil.getPmiMBeanFromNodeAgent(this.nodeName, this.serverName) == null) {
                            this.nodeAgentPmiEnabled = false;
                            break block11;
                        }
                        this.nodeAgentPmiEnabled = true;
                    }
                    catch (ConnectorException connectorException) {
                        Tr.warning(tc, "Error getting nodeAgent PMI status. Please check soap security settings.");
                    }
                } else {
                    this.nodeAgentPmiEnabled = true;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverPmiOk=" + this.serverPmiEnabled + ",nodeAgentPmiOk=" + this.nodeAgentPmiEnabled);
            }
            this.pmiEnabled = this.nodeAgentPmiEnabled && this.serverPmiEnabled;
            this.warningsList = new ArrayList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getting bridge instance");
            }
            this.immediateAlertBridge = ImmediateAlertBridge.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got bridge instance");
            }
            this.immediateAlertBridge.setImmediateAlertBridge(this, this.nodeName, this.serverName);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerRuleDriver.initStartup: caught exception when checking pmi enablement, rethrowing " + exception.toString());
            }
            Tr.exit(tc, "initStartup");
            throw exception;
        }
        Tr.exit(tc, "initStartup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeInit() {
        Tr.entry(tc, "completeInit");
        Object object = lockObject;
        synchronized (object) {
            block6: {
                try {
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ServerRuleDriver.this.privateCompleteInit();
                            return null;
                        }
                    };
                    SecurityContext.runAsSystem(privilegedExceptionAction);
                    this.initializationCompleted = true;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Tr.error(tc, "perfalert.Exception.error" + privilegedActionException.toString(), new String("Runtime Performance Advisor:completeInit caught security exception : "));
                    privilegedActionException.printStackTrace();
                    this.initializationCompleted = false;
                }
                catch (Exception exception) {
                    this.initializationCompleted = false;
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Caught exception in completeInit, " + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        Tr.exit(tc, "completeInit");
    }

    protected void privateCompleteInit() throws Exception {
        Object object;
        Tr.entry(tc, "privateCompleteInit");
        Tr.debug(tc, "getting Repository");
        Repository repository2 = (Repository)this.getService(Repository.class);
        RepositoryCache.init(repository2);
        RepositoryCache.refreshAll();
        Tr.debug(tc, "done gettting and refresh repository");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "about to load rules");
        }
        RuleLookup ruleLookup = this.loadRuleLookup();
        ArrayList arrayList = new ArrayList();
        this.ruleDataMap = new HashMap();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loaded rules");
        }
        arrayList = ruleLookup.getRules();
        ruleLookup.setProcessType(this.processType);
        EngineParameters.setCachedValuesFromRuleLookup(ruleLookup);
        this.count = EngineParameters.getRefreshIteration();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "set engine parameters from ruleLookup");
            Tr.debug(tc, "dumping ruleLookup ");
            ruleLookup.dump();
            Tr.debug(tc, "dumping engine parameters");
            EngineParameters.dump();
        }
        this.setMaxAlertStreak(new Integer(EngineParameters.getMaxAlertStreak()));
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (RuleData)arrayList.get(i);
            if (((RuleData)object).getType().equalsIgnoreCase("server") && ((RuleData)object).getZos_enabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding " + ((RuleData)object).getName() + ",  className:" + ((RuleData)object).getClassName());
                }
                try {
                    Class<?> clazz = Class.forName(((RuleData)object).getClassName());
                    IRule iRule = (IRule)clazz.newInstance();
                    this.rules.add(iRule);
                    this.ruleDataMap.put(iRule, object);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "perfalert.Exception.error" + exception.toString(), new String("ServerRuleDriver could not init rule "));
                    exception.printStackTrace();
                }
                continue;
            }
            if (((RuleData)object).getType().equalsIgnoreCase("immediateAlert") && ((RuleData)object).getZos_enabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding PD Rule " + ((RuleData)object).getName() + ",  className:" + ((RuleData)object).getClassName());
                }
                try {
                    this.immediateAlertBridge.setAlertEnabled(((RuleData)object).getRuleID(), ((RuleData)object).getEnabled());
                    this.ruleDataMap.put(((RuleData)object).getRuleID(), object);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "perfalert.Exception.error" + exception.toString(), new String("ServerRuleDriver could not init PD rule "));
                    exception.printStackTrace();
                }
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "not adding " + ((RuleData)object).getClassName() + " because it is a client rule");
            }
            arrayList.remove(i);
            --i;
        }
        Integer n = (Integer)EngineParameters.getParam("duration");
        if (n != null) {
            this.setMyDuration(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read in duration from EngineParameters " + this.duration);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "did not read in duration from EngineParameters " + this.duration);
            }
            this.duration = 10000;
        }
        if ((object = (Boolean)EngineParameters.getParam("enabled")) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "read enabled from the EngineParameters " + object);
            }
            this.enabled = (Boolean)object;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "was not able to get enabled from the EngineParameters setting enabled to false");
            }
            this.enabled = false;
        }
        this.immediateAlertBridge.setEnabled(this.enabled);
        this.initRules();
        this.initResponse();
        if (!this.pmiEnabled) {
            Tr.debug(tc, "did not perform startup init as PMI is not enabled");
        }
        Tr.exit(tc, "privateCompleteInit");
    }

    protected void initRules() {
        Tr.entry(tc, "initRules");
        for (int i = 0; i < this.rules.size(); ++i) {
            try {
                IRule iRule = (IRule)this.rules.get(i);
                RuleData ruleData = (RuleData)this.ruleDataMap.get(iRule);
                if (ruleData != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "calling init on : " + ruleData.getName());
                    }
                    iRule.init(this.nodeName, this.serverName, ruleData);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Could not find rule in ruleDataMap");
                continue;
            }
            catch (Exception exception) {
                Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("ServerRuleDriver could not init rule "));
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "initRules");
    }

    protected RuleLookup loadRuleLookup() throws Exception {
        Tr.entry(tc, "loadRuleLookup");
        AdminService adminService = null;
        adminService = AdminServiceFactory.getAdminService();
        Tr.debug(tc, "getting Repository");
        Repository repository2 = (Repository)this.getService(Repository.class);
        RepositoryCache.init(repository2);
        RepositoryCache.refreshAll();
        Tr.debug(tc, "done gettting and refresh repository");
        WorkSpaceManager workSpaceManager = WorkSpaceManagerFactory.getManager();
        String string = AdminHelper.getPlatformHelper().getUniqueId();
        String string2 = "Advisor_" + this.nodeName + "_" + this.serverName + "_" + string;
        WorkSpace workSpace = workSpaceManager.getWorkSpace(string2);
        if (workSpace == null) {
            throw new Exception("ServerRuleDriver could not get workspace");
        }
        InputStream inputStream = this.getInputStreamFromWorkSpace(workSpace, adminService.getCellName(), this.nodeName);
        RuleLookup ruleLookup = null;
        if (inputStream != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got perftuners.xml");
            }
            ruleLookup = new RuleLookup(inputStream, this.nodeName, this.serverName);
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing workspace");
            }
            workSpaceManager.removeWorkSpace(string2);
            Tr.exit(tc, "loadRuleLookup");
            return ruleLookup;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Runtime Performance Advisor could not find perftuners.xml in config/.../servers/ directory, throwing exception");
        }
        Tr.exit(tc, "loadRuleLookup - Exception");
        throw new Exception("Runtime Performance Advisor could not find perftuners.xml in config/.../servers/ directory");
    }

    protected boolean readIfEnabled() throws Exception {
        boolean bl;
        block11: {
            String string;
            WorkSpaceManager workSpaceManager;
            block10: {
                InputStream inputStream;
                block9: {
                    Tr.entry(tc, "readIfEnabled");
                    AdminService adminService = null;
                    adminService = AdminServiceFactory.getAdminService();
                    workSpaceManager = WorkSpaceManagerFactory.getManager();
                    String string2 = AdminHelper.getPlatformHelper().getUniqueId();
                    string = "Advisor_" + this.nodeName + "_" + this.serverName + "_" + string2;
                    WorkSpace workSpace = workSpaceManager.getWorkSpace(string);
                    if (workSpace == null) {
                        throw new Exception("ServerRuleDriver could not get workspace");
                    }
                    inputStream = this.getInputStreamFromWorkSpace(workSpace, adminService.getCellName(), this.nodeName);
                    bl = true;
                    try {
                        bl = RuleParser.isEnabled(inputStream);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Reading if enabled: " + bl);
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "error reading if enabled : " + exception.toString());
                        exception.printStackTrace();
                    }
                }
                try {
                    inputStream.close();
                    workSpaceManager.removeWorkSpace(string);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "could not close the input stream " + exception.toString());
                    exception.printStackTrace();
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing workspace");
                }
                workSpaceManager.removeWorkSpace(string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "could not close the workspace " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.entry(tc, "readIfEnabled");
        return bl;
    }

    private InputStream getInputStreamFromWorkSpace(WorkSpace workSpace, String string, String string2) throws Exception {
        Tr.entry(tc, "getInputStreamFromWorkSpace");
        InputStream inputStream = null;
        String string3 = "cells/" + string + "/nodes/" + string2;
        String string4 = string3 + "/servers/" + this.serverName;
        RepositoryContext repositoryContext = workSpace.findContext(string4);
        if (repositoryContext == null) {
            throw new Exception("ServerRuleDriver repositoryContext " + string4 + " is null");
        }
        if (repositoryContext.isAvailable("perftuners.xml")) {
            inputStream = repositoryContext.getInputStream("perftuners.xml");
        } else {
            RepositoryContext repositoryContext2 = workSpace.findContext(string3);
            if (repositoryContext2 != null) {
                inputStream = repositoryContext2.getInputStream("perftuners.xml");
            } else {
                Tr.exit(tc, "getInputStreamFromWorkSpace - exception");
                throw new Exception("ServerRuleDriver repositoryContext " + string3 + " is null");
            }
        }
        Tr.exit(tc, "getInputStreamFromWorkSpace");
        return inputStream;
    }

    public ArrayList run() {
        Tr.entry(tc, "run");
        try {
            if (!this.initializationCompleted) {
                this.completeInit();
            }
            ArrayList<RuleOutput> arrayList = new ArrayList<RuleOutput>();
            if (this.pmiEnabled) {
                int n = this.rules.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Running rule, the number of rules is " + n);
                }
                for (int i = 0; i < n; ++i) {
                    IRule iRule = (IRule)this.rules.get(i);
                    if (iRule.isEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Running rule" + i + " : " + iRule.getClass().getName());
                        }
                        RuleOutput[] ruleOutputArray = iRule.runRule();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Ran " + i);
                            Tr.debug(tc, "Length of rule output is " + ruleOutputArray.length);
                        }
                        for (int j = 0; j < ruleOutputArray.length; ++j) {
                            if (ruleOutputArray[j] == null) {
                                Tr.debug(tc, "rule Result is null");
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "perfalert.RanRule", ruleOutputArray[j].toString());
                            }
                            arrayList.add(ruleOutputArray[j]);
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "not running " + iRule.getClass().getName() + " because it is disabled");
                }
                CalcCreator.updateRPASharedCalcs();
            } else {
                Tr.debug(tc, "did run rules as PMI is not enabled");
            }
            Tr.exit(tc, "run");
            return arrayList;
        }
        catch (Exception exception) {
            Tr.error(tc, "perfalert.Exception.error" + exception.toString(), new String("General Exception caught  in ServerRuleDriver.runRule "));
            exception.printStackTrace();
            return new ArrayList(0);
        }
    }

    private void listenForServerMBeanNotifications(AdminService adminService) {
        block2: {
            try {
                ObjectName objectName = new ObjectName("WebSphere:type=Server,j2eeType=J2EEServer,process=" + this.serverName + ",*");
                adminService.addNotificationListenerExtended(objectName, this, null, SERVER_HANDBACK);
                Tr.debug(tc, "registered for " + objectName + " notifications");
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "can not register as a listener to ServerMBean", exception);
                exception.printStackTrace();
            }
        }
    }

    private boolean isServerStated(AdminService adminService) {
        try {
            ObjectName objectName = adminService.getLocalServer();
            if (objectName == null) {
                return false;
            }
            String string = (String)adminService.getAttribute(objectName, "state");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server state = " + string);
            }
            return string.equals("STARTED");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "could not check to see if the server is started :" + exception.toString());
                exception.printStackTrace();
            }
            return false;
        }
    }

    private ObjectName findDiscoveryMBean(AdminService adminService) {
        try {
            Tr.entry(tc, "findDiscoveryMBean");
            String string = "WebSphere:type=Discovery,process=" + this.serverName + ",*";
            ObjectName objectName = new ObjectName(string);
            Set set = adminService.queryNames(objectName, null);
            Iterator iterator = set.iterator();
            objectName = (ObjectName)iterator.next();
            Tr.exit(tc, "findDiscoveryMBean");
            return objectName;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception: could not find discovery mbean :" + exception.toString());
            }
            Tr.exit(tc, "findDiscoveryMBean");
            return null;
        }
    }

    private void listenForDiscoveryMBeanNotifications(AdminService adminService, ObjectName objectName) {
        block3: {
            try {
                adminService.addNotificationListenerExtended(objectName, this, null, DISCOVERY_HANDBACK);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "registered for " + objectName + " notifications");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "can not register as a listener to DiscoveryMBean", exception);
            }
        }
    }

    private boolean discoveryFoundNodeAgent(AdminService adminService, ObjectName objectName) {
        try {
            Object[] objectArray = new Object[]{};
            String[] stringArray = new String[]{};
            Object object = adminService.invoke(objectName, "getParent", objectArray, stringArray);
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "   discovery found node agent");
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   discovery NOT found node agent");
            }
            return false;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "could not invokde getAgent on the discovery mbean : " + exception.toString());
                exception.printStackTrace();
            }
            return false;
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        String string = notification.getType();
        Tr.debug(tc, "   received notification type " + string);
        if (object.equals(DISCOVERY_HANDBACK)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   notification from discovery");
            }
            if (string.equals("websphere.discovery.agent.found")) {
                this.nodeAgentPollingSuccessfull(true);
            }
        } else if (object.equals(SERVER_HANDBACK)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "   notification from server");
            }
            if (string.equals("j2ee.state.running")) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getting Channel Framework Service");
                            }
                            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "setting CCL = " + this.getClass().getClassLoader());
                            }
                            if (channelFrameworkService == null) {
                                ServerRuleDriver.channelFrameworkService = (ChannelFrameworkService)ServerRuleDriver.this.getService(class$com$ibm$wsspi$channel$framework$ChannelFrameworkService == null ? (class$com$ibm$wsspi$channel$framework$ChannelFrameworkService = ServerRuleDriver.class$("com.ibm.wsspi.channel.framework.ChannelFrameworkService")) : class$com$ibm$wsspi$channel$framework$ChannelFrameworkService);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "sucessfully got Channel Framework Service");
                            }
                            Thread.currentThread().setContextClassLoader(classLoader);
                            ServerRuleDriver.this.serverStarted = true;
                            ServerRuleDriver.this.startRPA();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception in doPriv() " + privilegedActionException + " cause  = " + privilegedActionException.getCause());
                    }
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.performance.tuning.serverAlert.ServerRuleDriver", "1427", this);
                }
            } else if (string.equals("j2ee.state.stopping")) {
                this.stop();
                if (this._alarm != null) {
                    this._alarm.cancel();
                    this._alarm = null;
                }
                this.beenInitialized = new Boolean(false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private synchronized void startRPA() {
        Tr.entry(tc, "startRPA");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " serverStarted :" + this.serverStarted);
            Tr.debug(tc, " beenInitialized :" + this.beenInitialized);
            Tr.debug(tc, " nodeAgentDiscovered :" + this.nodeAgentDiscovered);
        }
        if (!this.beenInitialized.booleanValue()) {
            if (this.processType.equals("UnManagedProcess")) {
                if (this.serverStarted) {
                    Tr.debug(tc, "   calling initAndRegister");
                    this.initAndRegister();
                    if (this.beenInitialized.booleanValue()) {
                        this.registerAlarm();
                    } else {
                        Tr.error(tc, "perfalert.Exception.error", new String("could not start up, please enable com.ibm.ws.performance.tuning.serverAlert.*=all=enabled"));
                    }
                }
            } else if (this.serverStarted && this.nodeAgentDiscovered) {
                Tr.debug(tc, "   calling initAndRegister");
                this.initAndRegister();
                if (this.beenInitialized.booleanValue()) {
                    this.registerAlarm();
                } else {
                    Tr.error(tc, "perfalert.Exception.error", new String("could not start up, please enable com.ibm.ws.performance.tuning.serverAlert.*=all=enabled"));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "register for an alarm to check on node agent status");
                }
                this.registerAlarm(30000);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "     not initializing because already initialized");
        }
        Tr.exit(tc, "startRPA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAndRegister() {
        Tr.entry(tc, "initAndRegister");
        Object object = lockObject;
        synchronized (object) {
            block6: {
                try {
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ServerRuleDriver.this.initStartup();
                            if (ServerRuleDriver.this.readIfEnabled()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "completing initialization since engine is enabled");
                                }
                                ServerRuleDriver.this.privateCompleteInit();
                            }
                            return null;
                        }
                    };
                    SecurityContext.runAsSystem(privilegedExceptionAction);
                    this.beenInitialized = new Boolean(true);
                    this.initializationCompleted = false;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Tr.error(tc, "perfalert.Exception.error" + privilegedActionException.toString(), new String("Runtime Performance Advisor:initAndRegister caught security exception : "));
                    privilegedActionException.printStackTrace();
                    this.beenInitialized = new Boolean(false);
                }
                catch (Exception exception) {
                    this.beenInitialized = new Boolean(false);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Caught exception in initAndRegister, " + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        Tr.exit(tc, "initAndRegister");
    }

    public Boolean getEnabled() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getEnabled");
            Tr.debug(tc, "getEnabled called returning " + this.enabled);
            Tr.debug(tc, "EngineParameters is " + EngineParameters.getParam("enabled"));
            Tr.exit(tc, "getEnabled");
        }
        return new Boolean(this.enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEnabled(Boolean bl) {
        block14: {
            Tr.entry(tc, "setEnabled");
            if (this.enabled && bl.booleanValue() || !this.enabled && !bl.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setEnabled called with " + bl + " which is the current value - not doing anything");
                }
                return;
            }
            if (bl == null) {
                throw new NullPointerException("setEnabled can not be called with null");
            }
            EngineParameters.setParam("enabled", bl);
            this.enabled = bl;
            this.immediateAlertBridge.setEnabled(this.enabled);
            if (this.enabled) {
                TuningUtil.preloadNLS();
                this.registerAlarm();
            } else {
                Object object = lockObject;
                synchronized (object) {
                    if (this._alarm != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "canceling alarm");
                        }
                        this._alarm.cancel();
                        this._alarm = null;
                    }
                }
                for (int i = 0; i < this.rules.size(); ++i) {
                    try {
                        ((IRule)this.rules.get(i)).clearHistory();
                        continue;
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "could not clear history of : " + ((IRule)this.rules.get(i)).getRuleNameLookup() + ":" + exception.toString());
                        exception.printStackTrace();
                    }
                }
                try {
                    CalcCreator.sharedCalcsClearHistory();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug(tc, "could not clear history of shared calcs :" + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        Tr.exit(tc, "setEnabled");
    }

    public Integer getDuration() {
        Integer n = new Integer(this.getMyDuration());
        return n;
    }

    public void setDuration(Integer n) {
        if (n == null) {
            throw new NullPointerException();
        }
        this.setMyDuration(n);
    }

    public static ChannelFrameworkService getChannelFrameworkService() {
        return channelFrameworkService;
    }

    public String[] getThreadPoolNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPoolNames");
        }
        if (this.threadPoolNames == null) {
            int n;
            ChannelData[] channelDataArray = channelFrameworkService.getAllChannels();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < channelDataArray.length; ++n) {
                String string;
                if (!channelDataArray[n].getFactoryType().getName().equals("com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "channelData PropertyBag" + channelDataArray[n].getPropertyBag());
                }
                if ((string = (String)channelDataArray[n].getPropertyBag().get("threadPoolName")) == null || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "threadPoolList :" + arrayList);
            }
            this.threadPoolNames = new String[arrayList.size()];
            for (n = 0; n < this.threadPoolNames.length; ++n) {
                this.threadPoolNames[n] = (String)arrayList.get(n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPoolNames");
        }
        return this.threadPoolNames;
    }

    public class MyWarning {
        private int key;
        private MessageWrapper message;

        public MyWarning(int n, MessageWrapper messageWrapper) {
            this.key = n;
            this.message = messageWrapper;
        }

        public MessageWrapper getMessage() {
            return this.message;
        }

        public int getKey() {
            return this.key;
        }
    }
}

